/*
 * Decompiled with CFR 0.152.
 */
package radixcore.modules.updates;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.net.URL;
import java.util.Scanner;
import radixcore.core.ModMetadataEx;
import radixcore.core.RadixCore;
import radixcore.modules.updates.IUpdateProtocol;
import radixcore.modules.updates.UpdateData;

public class CurseUpdateProtocol
implements IUpdateProtocol {
    @Override
    public UpdateData getUpdateData(ModMetadataEx modData) {
        try {
            URL url = new URL("http://widget.mcf.li/mc-mods/minecraft/" + modData.curseId + ".json");
            Scanner scanner = new Scanner(url.openStream());
            JsonObject file = ((JsonObject)new GsonBuilder().create().fromJson(scanner.nextLine(), JsonObject.class)).get("download").getAsJsonObject();
            UpdateData returnData = new UpdateData();
            returnData.minecraftVersion = file.get("version").getAsString();
            returnData.modVersion = file.get("name").getAsString();
            returnData.modVersion = returnData.modVersion.replace(returnData.minecraftVersion, "").replace(".jar", "").replaceAll("[^0-9.]", "");
            scanner.close();
            return returnData;
        }
        catch (Exception e) {
            RadixCore.getLogger().error("Unable to check for updates for " + modData.modId + ".", (Throwable)e);
            return null;
        }
    }

    @Override
    public void cleanUp() {
    }
}

