/*
 * Decompiled with CFR 0.152.
 */
package mca.actions;

import mca.actions.AbstractToggleAction;
import mca.api.CookableFood;
import mca.api.RegistryMCA;
import mca.entity.EntityVillagerMCA;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFurnace;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import radixcore.math.Point3D;
import radixcore.modules.RadixBlocks;
import radixcore.modules.RadixLogic;
import radixcore.modules.RadixMath;

public class ActionCook
extends AbstractToggleAction {
    private Point3D furnacePos = Point3D.ZERO;
    private int fuelUsesRemaining;
    private boolean hasFurnace;
    private boolean hasFuel;
    private boolean hasCookableFood;
    private boolean isCooking;
    private int indexOfCookingFood;
    private int cookingTicks;
    private int cookingInterval;

    public ActionCook(EntityVillagerMCA actor) {
        super(actor);
    }

    @Override
    public void onUpdateServer() {
        if (this.hasFurnace) {
            if (this.hasFuel) {
                if (this.isReadyToCook()) {
                    this.setPathToFurnace();
                    this.doCookFood();
                } else if (!this.hasCookableFood) {
                    EntityPlayer player = this.getAssigningPlayer();
                    if (player != null) {
                        this.actor.say("cooking.nofood", player);
                    }
                    this.reset();
                }
            } else if (!this.getFuelFromInventory()) {
                this.reset();
                EntityPlayer player = this.getAssigningPlayer();
                if (player != null) {
                    this.actor.say("cooking.nofuel", player);
                }
            }
        } else if (!this.isFurnaceNearby()) {
            this.reset();
            EntityPlayer player = this.getAssigningPlayer();
            if (player != null) {
                this.actor.say("cooking.nofurnace", player);
            }
        }
    }

    @Override
    public void reset() {
        this.hasFurnace = false;
        this.setIsActive(false);
    }

    public void startCooking(EntityPlayer player) {
        this.assigningPlayer = player.func_110124_au();
        this.setIsActive(true);
        this.furnacePos = Point3D.ZERO;
        this.cookingInterval = 160;
    }

    private boolean getFuelFromInventory() {
        for (int i = 0; i < this.actor.attributes.getInventory().func_70302_i_(); ++i) {
            ItemStack stack = this.actor.attributes.getInventory().func_70301_a(i);
            if (stack == null) continue;
            try {
                boolean isFuel = TileEntityFurnace.func_145954_b((ItemStack)stack);
                int fuelValue = TileEntityFurnace.func_145952_a((ItemStack)stack) == 0 ? GameRegistry.getFuelValue((ItemStack)stack) : TileEntityFurnace.func_145952_a((ItemStack)stack);
                fuelValue = fuelValue / 20 / 10;
                if (fuelValue == 0 && isFuel) {
                    fuelValue = 1;
                }
                if (fuelValue <= 0) continue;
                this.hasFuel = true;
                this.fuelUsesRemaining = fuelValue;
                this.actor.attributes.getInventory().func_70298_a(this.actor.attributes.getInventory().getFirstSlotContainingItem(stack.func_77973_b()), 1);
                continue;
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        return this.hasFuel;
    }

    private boolean isFurnaceNearby() {
        Point3D nearbyFurnace = RadixLogic.getNearestBlock((Entity)this.actor, (int)10, (Block)Blocks.field_150460_al);
        this.hasFurnace = nearbyFurnace != null;
        this.furnacePos = this.hasFurnace ? nearbyFurnace : this.furnacePos;
        return this.hasFurnace;
    }

    private boolean isReadyToCook() {
        if (this.hasCookableFood) {
            if (this.isFurnaceStillPresent()) {
                return true;
            }
            this.reset();
            EntityPlayer player = this.getAssigningPlayer();
            if (player != null) {
                this.actor.say("cooking.nofurnace", player);
            }
        } else {
            this.getCookableFoodFromInventory();
        }
        return false;
    }

    private void getCookableFoodFromInventory() {
        for (int i = 0; i < this.actor.attributes.getInventory().func_70302_i_(); ++i) {
            ItemStack stack = this.actor.attributes.getInventory().func_70301_a(i);
            for (CookableFood entry : RegistryMCA.getCookableFoodList()) {
                if (stack == null || stack.func_77973_b() != entry.getFoodRaw()) continue;
                this.indexOfCookingFood = RegistryMCA.getCookableFoodList().indexOf(entry);
                this.hasCookableFood = true;
            }
        }
    }

    private void setPathToFurnace() {
        double distanceToFurnace = RadixMath.getDistanceToXYZ((Entity)this.actor, (Point3D)this.furnacePos);
        if (this.actor.func_70661_as().func_75500_f() && distanceToFurnace >= 2.5) {
            this.actor.func_70661_as().func_75484_a(this.actor.func_70661_as().func_75488_a((double)this.furnacePos.iX(), (double)this.furnacePos.iY(), (double)this.furnacePos.iZ()), (double)this.actor.attributes.getSpeed());
        }
    }

    private boolean isFurnaceStillPresent() {
        return RadixBlocks.getBlock((World)this.actor.field_70170_p, (int)this.furnacePos.iX(), (int)this.furnacePos.iY(), (int)this.furnacePos.iZ()) == Blocks.field_150460_al || RadixBlocks.getBlock((World)this.actor.field_70170_p, (int)this.furnacePos.iX(), (int)this.furnacePos.iY(), (int)this.furnacePos.iZ()) == Blocks.field_150470_am;
    }

    private void doCookFood() {
        double distanceToFurnace = RadixMath.getDistanceToXYZ((Entity)this.actor, (Point3D)this.furnacePos);
        if (distanceToFurnace <= 2.5) {
            if (this.isCooking) {
                if (this.cookingTicks <= this.cookingInterval) {
                    if (RadixBlocks.getBlock((World)this.actor.field_70170_p, (Point3D)this.furnacePos) != Blocks.field_150470_am) {
                        BlockFurnace.func_176446_a((boolean)true, (World)this.actor.field_70170_p, (BlockPos)this.furnacePos.toBlockPos());
                    }
                    ++this.cookingTicks;
                } else {
                    CookableFood foodObj = RegistryMCA.getCookableFoodList().get(this.indexOfCookingFood);
                    int rawFoodSlot = this.actor.attributes.getInventory().getFirstSlotContainingItem(foodObj.getFoodRaw());
                    if (rawFoodSlot > -1) {
                        this.actor.attributes.getInventory().func_70298_a(rawFoodSlot, 1);
                        this.addItemStackToInventory(new ItemStack(foodObj.getFoodCooked(), 1, 0));
                        this.actor.swingItem();
                    } else {
                        EntityPlayer player = this.getAssigningPlayer();
                        if (player != null) {
                            this.actor.say("cooking.nofood", player);
                        }
                        this.reset();
                    }
                    this.isCooking = false;
                    this.hasCookableFood = false;
                    this.cookingTicks = 0;
                    --this.fuelUsesRemaining;
                    BlockFurnace.func_176446_a((boolean)false, (World)this.actor.field_70170_p, (BlockPos)this.furnacePos.toBlockPos());
                    if (this.fuelUsesRemaining <= 0) {
                        this.hasFuel = false;
                    }
                }
            } else {
                this.actor.swingItem();
                this.isCooking = true;
            }
        }
    }

    @Override
    public String getName() {
        return "Cooking";
    }
}

