/*
 * Decompiled with CFR 0.152.
 */
package mca.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.UUID;
import mca.actions.AbstractToggleAction;
import mca.actions.ActionBuild;
import mca.api.CropEntry;
import mca.api.RegistryMCA;
import mca.api.enums.EnumCropCategory;
import mca.api.exception.MappingNotFoundException;
import mca.core.MCA;
import mca.entity.EntityVillagerMCA;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import radixcore.math.Point3D;
import radixcore.modules.RadixBlocks;
import radixcore.modules.RadixLogic;
import radixcore.modules.RadixMath;
import radixcore.modules.schematics.BlockObj;
import radixcore.modules.schematics.RadixSchematics;

public class ActionFarm
extends AbstractToggleAction {
    private static final int FARM_INTERVAL = 20;
    private Point3D farmCenterPoint = Point3D.ZERO;
    private Point3D harvestTargetPoint = Point3D.ZERO;
    private int apiId;
    private int radius;
    private int seedsRequired;
    private int activityInterval;
    private boolean doCreate;
    private boolean isBuildingFarm;
    private boolean farmCreatedFlag;
    private String schematic = "none";

    public ActionFarm(EntityVillagerMCA actor) {
        super(actor);
    }

    @Override
    public void onUpdateServer() {
        try {
            if (!MCA.getConfig().allowFarmingChore) {
                this.notifyAssigningPlayer("\u00a7CThis chore is disabled.");
                this.reset();
                return;
            }
            if (this.activityInterval <= 0) {
                this.activityInterval = 20;
                if (this.doCreate) {
                    if (!this.isBuildingFarm) {
                        boolean canStart;
                        CropEntry entry = RegistryMCA.getCropEntryById(this.apiId);
                        int y = RadixLogic.getSpawnSafeTopLevel((World)this.actor.field_70170_p, (int)((int)this.actor.field_70165_t), (int)((int)this.actor.field_70161_v));
                        Block groundBlock = RadixBlocks.getBlock((World)this.actor.field_70170_p, (int)((int)this.actor.field_70165_t), (int)(y - 1), (int)((int)this.actor.field_70161_v));
                        if (groundBlock != Blocks.field_150349_c || groundBlock != Blocks.field_150354_m || groundBlock != Blocks.field_150346_d) {
                            groundBlock = Blocks.field_150349_c;
                        }
                        if (!(canStart = this.actor.getBehavior(ActionBuild.class).startBuilding(this.schematic, true, groundBlock, entry))) {
                            EntityPlayer assigningPlayerInst = this.getAssigningPlayer();
                            if (assigningPlayerInst != null) {
                                this.actor.say("build.fail.tooclose", assigningPlayerInst);
                            }
                            this.reset();
                            return;
                        }
                        this.actor.attributes.getInventory().removeCountOfItem(entry.getSeedItem(), this.seedsRequired);
                        this.isBuildingFarm = true;
                    } else if (this.isBuildingFarm && !this.actor.getBehavior(ActionBuild.class).getIsActive()) {
                        this.actor.damageHeldItem(30);
                        this.isBuildingFarm = false;
                        this.reset();
                    }
                } else {
                    double delta = RadixMath.getDistanceToXYZ((double)this.actor.field_70165_t, (double)this.actor.field_70163_u, (double)this.actor.field_70161_v, (double)this.harvestTargetPoint.dX(), (double)this.harvestTargetPoint.dY(), (double)this.harvestTargetPoint.dZ());
                    if (this.harvestTargetPoint.iX() == 0 && this.harvestTargetPoint.iY() == 0 && this.harvestTargetPoint.iZ() == 0) {
                        for (int id : RegistryMCA.getCropEntryIDs()) {
                            Point3D modHarvestPoint;
                            CropEntry entry = RegistryMCA.getCropEntryById(id);
                            if (entry.getCategory() == EnumCropCategory.SUGARCANE) {
                                Point3D nearestHarvest = RadixLogic.getFirstNearestBlockWithMeta((Entity)this.actor, (Block)entry.getHarvestBlock(), (int)entry.getHarvestBlockMeta(), (int)this.radius);
                                if (nearestHarvest == null) {
                                    this.harvestTargetPoint = Point3D.ZERO;
                                    continue;
                                }
                                int yMod = 0;
                                while (RadixBlocks.getBlock((World)this.actor.field_70170_p, (int)nearestHarvest.iX(), (int)(nearestHarvest.iY() + yMod), (int)nearestHarvest.iZ()) != Blocks.field_150349_c && RadixBlocks.getBlock((World)this.actor.field_70170_p, (int)nearestHarvest.iX(), (int)(nearestHarvest.iY() + yMod), (int)nearestHarvest.iZ()) != Blocks.field_150346_d) {
                                    if (--yMod >= -10) continue;
                                    this.reset();
                                    break;
                                }
                                if (RadixBlocks.getBlock((World)this.actor.field_70170_p, (int)(modHarvestPoint = new Point3D(nearestHarvest.iX(), nearestHarvest.iY() + yMod + 2, nearestHarvest.iZ())).iX(), (int)modHarvestPoint.iY(), (int)modHarvestPoint.iZ()) == entry.getHarvestBlock()) {
                                    this.harvestTargetPoint = modHarvestPoint;
                                    this.apiId = id;
                                    break;
                                }
                                this.harvestTargetPoint = Point3D.ZERO;
                                continue;
                            }
                            List nearbyBlocks = RadixLogic.getNearbyBlocks((Entity)this.actor, (Block)entry.getHarvestBlock(), (int)this.radius);
                            ArrayList<Point3D> validMetaBlocks = new ArrayList<Point3D>();
                            modHarvestPoint = nearbyBlocks.iterator();
                            while (modHarvestPoint.hasNext()) {
                                Point3D point = (Point3D)modHarvestPoint.next();
                                IBlockState state = this.actor.field_70170_p.func_180495_p(new BlockPos(point.iX(), point.iY(), point.iZ()));
                                int meta = state.func_177230_c().func_176201_c(state);
                                if (meta != entry.getHarvestBlockMeta()) continue;
                                validMetaBlocks.add(point);
                            }
                            double distance = 100.0;
                            for (Point3D point : validMetaBlocks) {
                                double distanceToPoint = RadixMath.getDistanceToXYZ((Entity)this.actor, (Point3D)point);
                                if (!(distanceToPoint < distance)) continue;
                                distance = distanceToPoint;
                                this.harvestTargetPoint = point;
                            }
                            if (this.harvestTargetPoint == null || this.harvestTargetPoint == Point3D.ZERO) {
                                this.harvestTargetPoint = Point3D.ZERO;
                                continue;
                            }
                            this.apiId = id;
                            break;
                        }
                    }
                    if (delta >= 2.0 && this.actor.func_70661_as().func_75500_f()) {
                        this.actor.func_70661_as().func_75492_a(this.harvestTargetPoint.dX(), this.harvestTargetPoint.dY(), this.harvestTargetPoint.dZ(), (double)this.actor.attributes.getSpeed());
                    }
                    if (delta < 2.5) {
                        CropEntry entry = RegistryMCA.getCropEntryById(this.apiId);
                        this.actor.swingItem();
                        this.actor.damageHeldItem(2);
                        if (entry.getCategory() == EnumCropCategory.WHEAT) {
                            RadixBlocks.setBlock((World)this.actor.field_70170_p, (int)this.harvestTargetPoint.iX(), (int)(this.harvestTargetPoint.iY() - 1), (int)this.harvestTargetPoint.iZ(), (Block)Blocks.field_150458_ak);
                            RadixBlocks.setBlock((World)this.actor.field_70170_p, (int)this.harvestTargetPoint.iX(), (int)this.harvestTargetPoint.iY(), (int)this.harvestTargetPoint.iZ(), (Block)entry.getCropBlock());
                        } else {
                            RadixBlocks.setBlock((World)this.actor.field_70170_p, (int)this.harvestTargetPoint.iX(), (int)this.harvestTargetPoint.iY(), (int)this.harvestTargetPoint.iZ(), (Block)Blocks.field_150350_a);
                        }
                        for (ItemStack stack : entry.getStacksOnHarvest()) {
                            if (stack == null) continue;
                            this.addItemStackToInventory(stack);
                        }
                        this.harvestTargetPoint = Point3D.ZERO;
                    }
                }
            }
            --this.activityInterval;
        }
        catch (MappingNotFoundException e) {
            this.reset();
        }
    }

    @Override
    public void reset() {
        this.setIsActive(false);
        this.seedsRequired = 0;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("isFarmingActive", this.getIsActive());
        this.farmCenterPoint.writeToNBT("farmCenterPoint", nbt);
        this.harvestTargetPoint.writeToNBT("harvestTargetPoint", nbt);
        nbt.func_74768_a("apiId", this.apiId);
        nbt.func_74768_a("farmingActivityInterval", this.activityInterval);
        nbt.func_74757_a("farmCreatedFlag", this.farmCreatedFlag);
        nbt.func_74768_a("radius", this.radius);
        nbt.func_74757_a("doCreate", this.doCreate);
        nbt.func_74778_a("schematic", this.schematic);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.setIsActive(nbt.func_74767_n("isFarmingActive"));
        this.farmCenterPoint = Point3D.readFromNBT((String)"farmCenterPoint", (NBTTagCompound)nbt);
        this.harvestTargetPoint = Point3D.readFromNBT((String)"harvestTargetPoint", (NBTTagCompound)nbt);
        this.apiId = nbt.func_74762_e("apiId");
        this.activityInterval = nbt.func_74762_e("farmingActivityInterval");
        this.farmCreatedFlag = nbt.func_74767_n("farmCreatedFlag");
        this.radius = nbt.func_74762_e("radius");
        this.doCreate = nbt.func_74767_n("doCreate");
        this.schematic = nbt.func_74779_i("schematic");
    }

    public void startFarming(EntityPlayer player, int apiId1, int radius1, boolean doCreate1) {
        try {
            CropEntry entry = RegistryMCA.getCropEntryById(apiId1);
            switch (entry.getCategory()) {
                case WHEAT: {
                    this.schematic = "/assets/mca/schematic/wheat1.schematic";
                    break;
                }
                case MELON: {
                    this.schematic = "/assets/mca/schematic/melon1.schematic";
                    break;
                }
                case SUGARCANE: {
                    this.schematic = "/assets/mca/schematic/sugarcane1.schematic";
                }
            }
            SortedMap schematicData = RadixSchematics.readSchematic((String)this.schematic);
            this.seedsRequired = RadixSchematics.countOccurencesOfBlockObj((Map)schematicData, (BlockObj)new BlockObj(Blocks.field_150325_L, entry.getCategory().getReferenceMeta()));
            if (doCreate1 && !this.actor.attributes.getInventory().containsCountOf(entry.getSeedItem(), this.seedsRequired)) {
                this.actor.say("farming.noseeds", player, entry.getCropName().toLowerCase(), this.seedsRequired);
                return;
            }
            if (player != null && !this.actor.attributes.getInventory().contains(ItemHoe.class)) {
                this.actor.say("farming.nohoe", player);
                return;
            }
            this.assigningPlayer = player != null ? player.func_110124_au() : new UUID(0L, 0L);
            this.activityInterval = 0;
            this.apiId = apiId1;
            this.radius = radius1;
            this.doCreate = doCreate1;
            this.farmCenterPoint = new Point3D(this.actor.field_70165_t, this.actor.field_70163_u, this.actor.field_70161_v);
            this.harvestTargetPoint = Point3D.ZERO;
            this.farmCreatedFlag = false;
            this.isBuildingFarm = false;
            this.setIsActive(true);
            this.actor.setHeldItem(this.actor.attributes.getInventory().getBestItemOfType(ItemHoe.class).func_77973_b());
        }
        catch (MappingNotFoundException e) {
            this.reset();
        }
    }

    @Override
    public String getName() {
        return "Farming";
    }
}

