/*
 * Decompiled with CFR 0.152.
 */
package mca.actions;

import mca.actions.AbstractAction;
import mca.core.MCA;
import mca.entity.EntityVillagerMCA;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import radixcore.modules.RadixMath;

public class ActionGrow
extends AbstractAction {
    private int timeUntilTickUpdate;
    private int freeTickUpdates;

    public ActionGrow(EntityVillagerMCA entityHuman) {
        super(entityHuman);
    }

    @Override
    public void onUpdateCommon() {
        if (this.actor.attributes.getIsChild()) {
            if (this.timeUntilTickUpdate <= 0 || this.freeTickUpdates != 0) {
                if (this.actor.attributes.getAge() >= MCA.getConfig().childGrowUpTime && !this.actor.field_70170_p.field_72995_K) {
                    this.actor.getBehaviors().disableAllToggleActions();
                    this.actor.attributes.setIsChild(false);
                    for (Object obj : this.actor.field_70170_p.field_73010_i) {
                        EntityPlayer player = (EntityPlayer)obj;
                        if (!this.actor.attributes.isPlayerAParent(player)) continue;
                    }
                } else {
                    if (!this.actor.field_70170_p.field_72995_K) {
                        this.actor.attributes.setAge(this.actor.attributes.getAge() + 1);
                    }
                    float newHeight = 0.69f + (float)this.actor.attributes.getAge() * 1.1099999f / (float)MCA.getConfig().childGrowUpTime;
                    this.actor.attributes.setSize(this.actor.field_70130_N, newHeight);
                }
                this.timeUntilTickUpdate = 1200;
                if (this.freeTickUpdates > 0) {
                    --this.freeTickUpdates;
                }
            } else {
                --this.timeUntilTickUpdate;
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("timeUntilTickUpdate", this.timeUntilTickUpdate);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.timeUntilTickUpdate = nbt.func_74762_e("timeUntilTickUpdate");
    }

    public void accelerate() {
        this.freeTickUpdates = RadixMath.getNumberInRange((int)30, (int)60);
    }
}

