/*
 * Decompiled with CFR 0.152.
 */
package mca.actions;

import java.util.List;
import mca.actions.AbstractToggleAction;
import mca.api.RegistryMCA;
import mca.core.MCA;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumMovementState;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import radixcore.math.Point3D;
import radixcore.modules.RadixLogic;
import radixcore.modules.RadixMath;

public class ActionHunt
extends AbstractToggleAction {
    private Point3D standPoint = Point3D.ZERO;
    private boolean isTaming;
    private int ticksActive;

    public ActionHunt(EntityVillagerMCA actor) {
        super(actor);
    }

    @Override
    public void onUpdateServer() {
        if (!MCA.getConfig().allowHuntingChore) {
            this.notifyAssigningPlayer("\u00a7CThis chore is disabled.");
            this.reset();
            return;
        }
        if (this.standPoint.iX() == 0 && this.standPoint.iY() == 0 && this.standPoint.iZ() == 0) {
            List grassBlocks = RadixLogic.getNearbyBlocks((Entity)this.actor, (Block)Blocks.field_150349_c, (int)15);
            if (grassBlocks.size() > 0) {
                this.standPoint = (Point3D)grassBlocks.get(RadixMath.getNumberInRange((int)0, (int)(grassBlocks.size() - 1)));
            } else {
                this.actor.say("hunting.badspot", this.getAssigningPlayer());
                this.reset();
            }
            return;
        }
        if (RadixMath.getDistanceToXYZ((Entity)this.actor, (Point3D)this.standPoint) >= 5.0 && this.actor.func_70661_as().func_75500_f()) {
            boolean successful = this.actor.func_70661_as().func_75492_a(this.standPoint.dX(), this.standPoint.dY(), this.standPoint.dZ(), (double)this.actor.attributes.getSpeed());
            if (!successful) {
                this.actor.say("hunting.badspot", this.getAssigningPlayer());
                this.reset();
            }
        } else if (RadixMath.getDistanceToXYZ((Entity)this.actor, (Point3D)this.standPoint) < 5.0) {
            ++this.ticksActive;
            if (this.ticksActive >= 400) {
                List nearbyItems;
                boolean doSpawn = this.actor.field_70170_p.field_73012_v.nextBoolean();
                if (doSpawn) {
                    try {
                        Class entityClass = RegistryMCA.getRandomHuntingEntity(this.isTaming);
                        EntityLiving entity = (EntityLiving)entityClass.getDeclaredConstructor(World.class).newInstance(this.actor.field_70170_p);
                        List nearbyGrass = RadixLogic.getNearbyBlocks((Entity)this.actor, (Block)Blocks.field_150349_c, (int)3);
                        Point3D spawnPoint = (Point3D)nearbyGrass.get(this.actor.field_70170_p.field_73012_v.nextInt(nearbyGrass.size()));
                        if (spawnPoint != null) {
                            entity.func_70107_b((double)spawnPoint.iX(), (double)(spawnPoint.iY() + 1), (double)spawnPoint.iZ());
                        }
                        this.actor.field_70170_p.func_72838_d((Entity)entity);
                        if (!this.isTaming) {
                            entity.func_70097_a(DamageSource.field_76377_j, 100.0f);
                            this.actor.swingItem();
                        }
                    }
                    catch (Exception entityClass) {
                        // empty catch block
                    }
                }
                if ((nearbyItems = RadixLogic.getEntitiesWithinDistance(EntityItem.class, (Entity)this.actor, (int)5)).size() != 0) {
                    for (Entity entity : nearbyItems) {
                        EntityItem item = (EntityItem)entity;
                        ItemStack stack = item.func_92059_d();
                        this.addItemStackToInventory(stack);
                        item.func_70106_y();
                    }
                }
                this.ticksActive = 0;
            }
        }
    }

    @Override
    public void reset() {
        this.setIsActive(false);
        this.ticksActive = 0;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("isHuntingActive", this.getIsActive());
        nbt.func_74757_a("isTaming", this.isTaming);
        this.standPoint.writeToNBT("standPoint", nbt);
        nbt.func_74768_a("ticksActive", this.ticksActive);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.setIsActive(nbt.func_74767_n("isHuntingActive"));
        this.isTaming = nbt.func_74767_n("isTaming");
        this.standPoint = Point3D.readFromNBT((String)"standPoint", (NBTTagCompound)nbt);
        this.ticksActive = nbt.func_74762_e("ticksActive");
    }

    public void startTaming(EntityPlayer player) {
        this.assigningPlayer = player.func_110124_au();
        this.standPoint = Point3D.ZERO;
        this.isTaming = true;
        this.setIsActive(true);
        this.actor.attributes.setMovementState(EnumMovementState.MOVE);
    }

    public void startKilling(EntityPlayer player) {
        this.assigningPlayer = player.func_110124_au();
        this.standPoint = Point3D.ZERO;
        this.isTaming = false;
        this.setIsActive(true);
        this.actor.attributes.setMovementState(EnumMovementState.MOVE);
    }

    @Override
    public String getName() {
        return "Hunting";
    }
}

