/*
 * Decompiled with CFR 0.152.
 */
package mca.actions;

import java.util.List;
import java.util.Map;
import mca.actions.AbstractToggleAction;
import mca.actions.ActionBuild;
import mca.api.MiningEntry;
import mca.api.RegistryMCA;
import mca.api.exception.MappingNotFoundException;
import mca.core.MCA;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumMovementState;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import radixcore.math.Point3D;
import radixcore.modules.RadixBlocks;
import radixcore.modules.RadixLogic;
import radixcore.modules.RadixMath;

public class ActionMine
extends AbstractToggleAction {
    private static final int SEARCH_INTERVAL = 200;
    private static final int MINE_INTERVAL = 20;
    private int idOfNotifyBlock;
    private int activityInterval;
    private boolean isGathering;
    private boolean isBuildingMine;

    public ActionMine(EntityVillagerMCA actor) {
        super(actor);
        this.setIsActive(false);
    }

    @Override
    public void onUpdateServer() {
        if (!MCA.getConfig().allowMiningChore) {
            this.notifyAssigningPlayer("\u00a7CThis chore is disabled.");
            this.reset();
            return;
        }
        if (this.isGathering) {
            this.runGather();
        } else {
            this.runSearch();
        }
    }

    private void runGather() {
        if (this.activityInterval <= 0) {
            this.activityInterval = 20;
            if (!this.isBuildingMine && RadixLogic.getNearbyBlocks((Entity)this.actor, (Block)Blocks.field_180407_aO, (int)8).size() == 0) {
                int y = RadixLogic.getSpawnSafeTopLevel((World)this.actor.field_70170_p, (int)((int)this.actor.field_70165_t), (int)((int)this.actor.field_70161_v));
                Block groundBlock = RadixBlocks.getBlock((World)this.actor.field_70170_p, (int)((int)this.actor.field_70165_t), (int)(y - 1), (int)((int)this.actor.field_70161_v));
                this.actor.getBehavior(ActionBuild.class).startBuilding("/assets/mca/schematic/mine1.schematic", true, groundBlock);
                this.isBuildingMine = true;
            } else if (this.isBuildingMine) {
                if (!this.actor.getBehavior(ActionBuild.class).getIsActive()) {
                    List nearbyFence = RadixLogic.getNearbyBlocks((Entity)this.actor, (Block)Blocks.field_180390_bo, (int)8);
                    if (nearbyFence.size() >= 1) {
                        this.isBuildingMine = false;
                    } else {
                        this.reset();
                    }
                }
            } else {
                this.actor.attributes.setMovementState(EnumMovementState.STAY);
                this.actor.swingItem();
                ItemStack addStack = this.getHarvestStack();
                if (addStack != ItemStack.field_190927_a) {
                    this.actor.attributes.getInventory().func_174894_a(addStack);
                    boolean pickBroken = this.actor.damageHeldItem(2);
                    if (pickBroken && !this.getPickFromInventory()) {
                        this.actor.say("interaction.mining.fail.broken", this.getAssigningPlayer());
                        this.reset();
                    }
                }
            }
        }
        --this.activityInterval;
    }

    private void runSearch() {
        try {
            if (this.activityInterval <= 0) {
                boolean pickBroken;
                String phraseId;
                this.activityInterval = 200;
                Block notifyBlock = RegistryMCA.getMiningEntryById(this.idOfNotifyBlock).getBlock();
                Point3D ownerPos = new Point3D(this.actor.field_70165_t, this.actor.field_70163_u, this.actor.field_70161_v);
                int distanceToBlock = -1;
                for (Point3D point : RadixLogic.getNearbyBlocks((Entity)this.actor, (Block)notifyBlock, (int)20)) {
                    if (distanceToBlock == -1) {
                        distanceToBlock = (int)RadixMath.getDistanceToXYZ((double)point.iX(), (double)point.iY(), (double)point.iZ(), (double)ownerPos.iX(), (double)ownerPos.iY(), (double)ownerPos.iZ());
                        continue;
                    }
                    double distanceToPoint = RadixMath.getDistanceToXYZ((double)point.iX(), (double)point.iY(), (double)point.iZ(), (double)ownerPos.iX(), (double)ownerPos.iY(), (double)ownerPos.iZ());
                    if (!(distanceToPoint < (double)distanceToBlock)) continue;
                    distanceToBlock = (int)distanceToPoint;
                }
                Object[] arguments = new Object[2];
                if (distanceToBlock == -1) {
                    phraseId = "mining.search.none";
                    arguments[0] = notifyBlock.func_149732_F().toLowerCase();
                } else if (distanceToBlock <= 5) {
                    phraseId = "mining.search.nearby";
                    arguments[0] = notifyBlock.func_149732_F().toLowerCase();
                } else {
                    phraseId = "mining.search.value";
                    arguments[0] = notifyBlock.func_149732_F().toLowerCase();
                    arguments[1] = distanceToBlock;
                }
                EntityPlayer player = this.actor.field_70170_p.func_152378_a(this.assigningPlayer);
                if (player != null) {
                    this.actor.say(phraseId, player, arguments);
                }
                if ((pickBroken = this.actor.damageHeldItem(5)) && !this.getPickFromInventory()) {
                    this.actor.say("interaction.mining.fail.broken", player);
                    this.reset();
                }
            }
            --this.activityInterval;
        }
        catch (MappingNotFoundException e) {
            this.reset();
        }
    }

    private boolean getPickFromInventory() {
        ItemStack pickaxe = this.actor.attributes.getInventory().getBestItemOfType(ItemPickaxe.class);
        if (pickaxe != ItemStack.field_190927_a) {
            this.actor.setHeldItem(pickaxe.func_77973_b());
            return true;
        }
        return false;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("isMiningActive", this.getIsActive());
        nbt.func_74768_a("idOfNotifyBlock", this.idOfNotifyBlock);
        nbt.func_74768_a("activityInterval", this.activityInterval);
        nbt.func_186854_a("assigningPlayer", this.assigningPlayer);
        nbt.func_74757_a("isGathering", this.isGathering);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.setIsActive(nbt.func_74767_n("isMiningActive"));
        this.idOfNotifyBlock = nbt.func_74762_e("idOfNotifyBlock");
        this.activityInterval = nbt.func_74762_e("activityInterval");
        this.assigningPlayer = nbt.func_186857_a("assigningPlayer");
        this.isGathering = nbt.func_74767_n("isGathering");
    }

    public void startSearching(EntityPlayer player, int notifyBlockId) {
        this.assigningPlayer = player.getPersistentID();
        this.idOfNotifyBlock = notifyBlockId;
        this.isGathering = false;
        this.setIsActive(true);
        this.activityInterval = 200;
        boolean hasPick = this.getPickFromInventory();
        if (!hasPick) {
            this.actor.say("interaction.mining.fail.nopickaxe", player);
            this.reset();
        }
    }

    @Override
    public void reset() {
        this.setIsActive(false);
        this.activityInterval = 0;
        this.assigningPlayer = null;
        this.isGathering = false;
        this.isBuildingMine = false;
    }

    public void startGathering(EntityPlayer player) {
        if (this.actor.field_70163_u <= 12.0) {
            this.actor.say("interaction.mining.fail.toolow", player);
            return;
        }
        this.assigningPlayer = player.getPersistentID();
        this.isGathering = true;
        this.setIsActive(true);
        this.activityInterval = 0;
        boolean hasPick = this.getPickFromInventory();
        if (!hasPick) {
            this.actor.say("interaction.mining.fail.nopickaxe", player);
            this.reset();
        }
    }

    @Override
    public String getName() {
        return "Mining";
    }

    public ItemStack getHarvestStack() {
        boolean doHarvest = RadixLogic.getBooleanWithProbability((int)25);
        if (doHarvest) {
            ItemStack addStack = null;
            boolean getSpecialOre = RadixLogic.getBooleanWithProbability((int)3);
            if (getSpecialOre) {
                Map<Integer, MiningEntry> entries = RegistryMCA.getMiningEntryMap();
                float totalWeight = 0.0f;
                int index = -1;
                for (MiningEntry entry : entries.values()) {
                    totalWeight += entry.getWeight();
                }
                float random = (float)(Math.random() * (double)totalWeight);
                for (Map.Entry<Integer, MiningEntry> entry : entries.entrySet()) {
                    if (!((random -= entry.getValue().getWeight()) <= 0.0f)) continue;
                    index = entry.getKey();
                    break;
                }
                addStack = entries.get(index).getMinedItemStack();
            } else {
                addStack = new ItemStack(Blocks.field_150347_e, 1);
            }
            return addStack;
        }
        return ItemStack.field_190927_a;
    }
}

