/*
 * Decompiled with CFR 0.152.
 */
package mca.actions;

import java.util.ArrayList;
import java.util.List;
import mca.actions.AbstractAction;
import mca.core.Constants;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumMovementState;
import mca.enums.EnumProfessionSkinGroup;
import mca.enums.EnumSleepingState;
import mca.util.Utilities;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntityBed;
import net.minecraft.util.math.BlockPos;
import radixcore.math.Point3D;
import radixcore.modules.RadixLogic;

public class ActionSleep
extends AbstractAction {
    private static final DataParameter<Integer> SLEEPING_STATE = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IS_IN_BED = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> BED_META = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187192_b);
    private boolean hasBed;
    private double homePosX;
    private double homePosY;
    private double homePosZ;
    private int bedPosX;
    private int bedPosY;
    private int bedPosZ;

    public ActionSleep(EntityVillagerMCA actor) {
        super(actor);
        this.setSleepingState(EnumSleepingState.AWAKE);
        this.homePosY = -1.0;
    }

    @Override
    public void onUpdateServer() {
        boolean isDaytime = this.actor.field_70170_p.func_72935_r();
        if (this.actor.getBehaviors().isToggleActionActive() || this.actor.attributes.getMovementState() == EnumMovementState.FOLLOW || this.actor.func_184187_bx() != null || this.actor.attributes.getProfessionSkinGroup() == EnumProfessionSkinGroup.Guard && !this.actor.attributes.getIsMarried()) {
            if (!isDaytime && this.getSleepingState() != EnumSleepingState.INTERRUPTED) {
                this.setSleepingState(EnumSleepingState.INTERRUPTED);
            }
            return;
        }
        switch (this.getSleepingState()) {
            case AWAKE: {
                if (!isDaytime && this.hasHomePoint() && this.isHomePointValid()) {
                    if (!this.hasHomePoint() || !this.isHomePointValid()) break;
                    this.actor.func_70107_b(this.homePosX, this.homePosY, this.homePosZ);
                    this.trySleepInBed();
                    this.setSleepingState(EnumSleepingState.SLEEPING);
                    break;
                }
                if (this.hasHomePoint() && this.isHomePointValid()) break;
                String phrase = !this.hasHomePoint() ? "sleep.nohome" : "sleep.invalid";
                EntityPlayer influentialPlayer = this.getInfluentialPlayer();
                if (influentialPlayer != null) {
                    this.actor.say(phrase, influentialPlayer);
                    this.setSleepingState(EnumSleepingState.NO_HOME);
                    break;
                }
                this.setHomePoint(this.actor.field_70165_t, this.actor.field_70163_u, this.actor.field_70161_v);
                break;
            }
            case SLEEPING: {
                if (!isDaytime) break;
                this.setSleepingState(EnumSleepingState.AWAKE);
                break;
            }
            case INTERRUPTED: {
                if (!isDaytime) break;
                this.setSleepingState(EnumSleepingState.AWAKE);
                break;
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("sleepingState", this.getSleepingState().getId());
        nbt.func_74757_a("isInBed", this.getIsInBed());
        nbt.func_74768_a("bedMeta", this.getBedMeta());
        nbt.func_74757_a("hasBed", this.hasBed);
        nbt.func_74780_a("homePosX", this.homePosX);
        nbt.func_74780_a("homePosY", this.homePosY);
        nbt.func_74780_a("homePosZ", this.homePosZ);
        nbt.func_74768_a("bedPosX", this.bedPosX);
        nbt.func_74768_a("bedPosY", this.bedPosY);
        nbt.func_74768_a("bedPosZ", this.bedPosZ);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.setSleepingState(EnumSleepingState.fromId(nbt.func_74762_e("sleepingState")));
        this.setIsInBed(nbt.func_74767_n("isInBed"));
        this.setBedMeta(nbt.func_74762_e("bedMeta"));
        this.hasBed = nbt.func_74767_n("hasBed");
        this.bedPosX = nbt.func_74762_e("bedPosX");
        this.bedPosY = nbt.func_74762_e("bedPosY");
        this.bedPosZ = nbt.func_74762_e("bedPosZ");
        this.homePosX = nbt.func_74769_h("homePosX");
        this.homePosY = nbt.func_74769_h("homePosY");
        this.homePosZ = nbt.func_74769_h("homePosZ");
    }

    private EntityPlayer getInfluentialPlayer() {
        if (this.actor.attributes.isMarriedToAPlayer()) {
            return this.actor.attributes.getPlayerSpouseInstance();
        }
        if (!this.actor.attributes.getMotherUUID().equals(Constants.EMPTY_UUID) || !this.actor.attributes.getFatherUUID().equals(Constants.EMPTY_UUID)) {
            for (Object obj : this.actor.field_70170_p.field_73010_i) {
                EntityPlayer player = (EntityPlayer)obj;
                if (!this.actor.attributes.isPlayerAParent(player)) continue;
                return player;
            }
        }
        return null;
    }

    public boolean getIsSleeping() {
        return this.getSleepingState() == EnumSleepingState.SLEEPING;
    }

    public void setSleepingState(EnumSleepingState state) {
        this.actor.func_184212_Q().func_187227_b(SLEEPING_STATE, (Object)state.getId());
        if (state == EnumSleepingState.SLEEPING) {
            this.transitionSkinState(true);
        } else {
            this.transitionSkinState(false);
            this.setIsInBed(false);
            try {
                TileEntityBed villagerBed = (TileEntityBed)this.actor.field_70170_p.func_175625_s(this.getBedPos());
                NBTTagCompound villagerBedNBT = villagerBed.getTileData();
                villagerBedNBT.func_186854_a("sleepingVillagerUUID", Constants.EMPTY_UUID);
                villagerBedNBT.func_74757_a("villagerIsSleepingIn", false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public EnumSleepingState getSleepingState() {
        return EnumSleepingState.fromId((Integer)this.actor.func_184212_Q().func_187225_a(SLEEPING_STATE));
    }

    public boolean isHomePointValid() {
        if (this.homePosY == -1.0) {
            return false;
        }
        Point3D point = new Point3D(this.homePosX, this.homePosY, this.homePosZ);
        return Utilities.isPointClear(this.actor.field_70170_p, point.iX(), point.iY(), point.iZ()) && Utilities.isPointClear(this.actor.field_70170_p, point.iX(), point.iY() + 1, point.iZ());
    }

    public boolean hasHomePoint() {
        return this.homePosY != -1.0;
    }

    public void invalidateHomePoint() {
        this.homePosY = -1.0;
    }

    public boolean setHomePoint(double posX, double posY, double posZ) {
        Point3D point = new Point3D(posX, posY, posZ);
        if (Utilities.isPointClear(this.actor.field_70170_p, point.iX(), point.iY(), point.iZ()) && Utilities.isPointClear(this.actor.field_70170_p, point.iX(), point.iY() + 1, point.iZ())) {
            this.homePosX = posX;
            this.homePosY = posY;
            this.homePosZ = posZ;
            this.bedPosX = 0;
            this.bedPosY = 0;
            this.bedPosZ = 0;
            return true;
        }
        return false;
    }

    public Point3D getHomePoint() {
        return new Point3D(this.homePosX, this.homePosY, this.homePosZ);
    }

    public void transitionSkinState(boolean toSleeping) {
        String skinValue = this.actor.attributes.getHeadTexture();
        if (toSleeping && !skinValue.contains("sleeping")) {
            this.actor.attributes.setHeadTexture(skinValue.replace("/skins/", "/skins/sleeping/"));
        } else if (!toSleeping && skinValue.contains("sleeping")) {
            this.actor.attributes.setHeadTexture(skinValue.replace("/skins/sleeping/", "/skins/"));
        }
    }

    private void trySleepInBed() {
        if (this.hasBed) {
            Block blockAtBed = this.actor.field_70170_p.func_180495_p(this.getBedPos()).func_177230_c();
            if (blockAtBed instanceof BlockBed) {
                try {
                    TileEntityBed villagerBed = (TileEntityBed)this.actor.field_70170_p.func_175625_s(this.getBedPos());
                    NBTTagCompound villagerBedNBT = villagerBed.getTileData();
                    if (!villagerBedNBT.func_74767_n("villagerIsSleepingIn")) {
                        villagerBedNBT.func_186854_a("sleepingVillagerUUID", this.actor.getPersistentID());
                        villagerBedNBT.func_74757_a("villagerIsSleepingIn", true);
                        this.setIsInBed(true);
                        this.actor.halt();
                        this.actor.func_70107_b(this.bedPosX, this.bedPosY, this.bedPosZ);
                    }
                }
                catch (ClassCastException e) {
                    this.hasBed = false;
                }
                catch (NullPointerException e) {
                    this.hasBed = false;
                }
            } else {
                this.hasBed = false;
            }
        } else {
            List bedsNearby = RadixLogic.getNearbyBlocks((Entity)this.actor, BlockBed.class, (int)8);
            ArrayList<Point3D> bedFeetNearby = new ArrayList<Point3D>();
            for (Point3D point : bedsNearby) {
                BlockBed.EnumPartType part;
                IBlockState state = this.actor.field_70170_p.func_180495_p(new BlockPos(point.iX(), point.iY(), point.iZ()));
                if (!(state.func_177230_c() instanceof BlockBed) || (part = (BlockBed.EnumPartType)state.func_177229_b((IProperty)BlockBed.field_176472_a)) != BlockBed.EnumPartType.FOOT) continue;
                bedFeetNearby.add(point);
            }
            if (bedFeetNearby.size() > 0) {
                Point3D nearestBed = Point3D.getNearestPointInList((Point3D)new Point3D(this.actor.field_70165_t, this.actor.field_70163_u, this.actor.field_70161_v), bedFeetNearby);
                TileEntityBed villagerBed = (TileEntityBed)this.actor.field_70170_p.func_175625_s(nearestBed.toBlockPos());
                NBTTagCompound villagerBedNBT = villagerBed.getTileData();
                if (villagerBed != null && !villagerBedNBT.func_74767_n("villagerIsSleepingIn")) {
                    try {
                        IBlockState state = this.actor.field_70170_p.func_180495_p(nearestBed.toBlockPos());
                        BlockBed bed = (BlockBed)state.func_177230_c();
                        villagerBedNBT.func_186854_a("sleepingVillagerUUID", this.actor.getPersistentID());
                        villagerBedNBT.func_74757_a("villagerIsSleepingIn", true);
                        this.bedPosX = nearestBed.iX();
                        this.bedPosY = nearestBed.iY();
                        this.bedPosZ = nearestBed.iZ();
                        this.hasBed = true;
                        this.setBedMeta(bed.func_176201_c(state));
                        this.setIsInBed(true);
                        this.actor.halt();
                        this.actor.func_70107_b(this.bedPosX, this.bedPosY, this.bedPosZ);
                    }
                    catch (ClassCastException e) {
                        this.hasBed = false;
                    }
                }
            }
        }
    }

    private BlockPos getBedPos() {
        return new BlockPos(this.bedPosX, this.bedPosY, this.bedPosZ);
    }

    @Override
    protected void registerDataParameters() {
        this.actor.func_184212_Q().func_187214_a(SLEEPING_STATE, (Object)EnumSleepingState.AWAKE.getId());
        this.actor.func_184212_Q().func_187214_a(IS_IN_BED, (Object)false);
        this.actor.func_184212_Q().func_187214_a(BED_META, (Object)0);
    }

    public boolean getIsInBed() {
        return (Boolean)this.actor.func_184212_Q().func_187225_a(IS_IN_BED);
    }

    public void setIsInBed(boolean value) {
        this.actor.func_184212_Q().func_187227_b(IS_IN_BED, (Object)value);
    }

    public int getBedMeta() {
        return (Integer)this.actor.func_184212_Q().func_187225_a(BED_META);
    }

    public void setBedMeta(int value) {
        this.actor.func_184212_Q().func_187227_b(BED_META, (Object)value);
    }

    public void onDamage() {
        if (this.getIsSleeping()) {
            this.setSleepingState(EnumSleepingState.INTERRUPTED);
        }
    }
}

