/*
 * Decompiled with CFR 0.152.
 */
package mca.actions;

import java.util.Iterator;
import mca.actions.AbstractToggleAction;
import mca.api.RegistryMCA;
import mca.api.WoodcuttingEntry;
import mca.api.exception.MappingNotFoundException;
import mca.core.MCA;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumPersonality;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import radixcore.math.Point3D;
import radixcore.modules.RadixBlocks;
import radixcore.modules.RadixLogic;
import radixcore.modules.RadixMath;

public class ActionWoodcut
extends AbstractToggleAction {
    private Point3D treeBasePoint = Point3D.ZERO;
    private int apiId;
    private int yLevel;
    private int cutInterval;
    private int cutTimeLeft;
    private boolean doReplant;

    public ActionWoodcut(EntityVillagerMCA actor) {
        super(actor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onUpdateServer() {
        try {
            if (!MCA.getConfig().allowWoodcuttingChore) {
                this.notifyAssigningPlayer("\u00a7CThis chore is disabled.");
                this.reset();
                return;
            }
            if (this.treeBasePoint.iX() == 0 && this.treeBasePoint.iY() == 0 && this.treeBasePoint.iZ() == 0) {
                Point3D modifiedPoint;
                WoodcuttingEntry apiEntry = RegistryMCA.getWoodcuttingEntryById(this.apiId);
                if (apiEntry.getLogBlock() == null) {
                    this.setIsActive(false);
                    return;
                }
                Point3D point = RadixLogic.getNearestBlock((Entity)this.actor, (int)15, (Block)apiEntry.getLogBlock());
                if (point == null) {
                    this.notifyAssigningPlayer("There are no logs nearby.");
                    this.setIsActive(false);
                    return;
                }
                while (RadixBlocks.getBlock((World)this.actor.field_70170_p, (int)point.iX(), (int)point.iY(), (int)point.iZ()) == apiEntry.getLogBlock()) {
                    point.set(point.iX(), point.iY() - 1, point.iZ());
                    if (point.iY() > 0) continue;
                }
                while (RadixBlocks.getBlock((World)this.actor.field_70170_p, (int)point.iX(), (int)point.iY(), (int)point.iZ()) != apiEntry.getLogBlock()) {
                    point.set(point.iX(), point.iY() + 1, point.iZ());
                    if (point.iY() < 255) continue;
                }
                this.treeBasePoint = modifiedPoint = new Point3D(point.iX(), point.iY(), point.iZ());
                return;
            }
            if (RadixMath.getDistanceToXYZ((double)this.treeBasePoint.dX(), (double)this.treeBasePoint.dY(), (double)this.treeBasePoint.dZ(), (double)this.actor.field_70165_t, (double)this.actor.field_70163_u, (double)this.actor.field_70161_v) <= 2.5 || this.yLevel > 0) {
                --this.cutTimeLeft;
                this.actor.swingItem();
                if (this.cutTimeLeft > 0) return;
                this.cutTimeLeft = this.cutInterval;
                WoodcuttingEntry apiEntry = RegistryMCA.getWoodcuttingEntryById(this.apiId);
                Block block = apiEntry.getLogBlock();
                RadixBlocks.setBlock((World)this.actor.field_70170_p, (int)this.treeBasePoint.iX(), (int)(this.treeBasePoint.iY() + this.yLevel), (int)this.treeBasePoint.iZ(), (Block)Blocks.field_150350_a);
                boolean addedToInventory = this.addItemStackToInventory(new ItemStack(block, 1, apiEntry.getLogMeta()));
                boolean toolBroken = this.actor.damageHeldItem(2);
                if (addedToInventory || this.actor.attributes.getPersonality() != EnumPersonality.GREEDY) {
                    if (!addedToInventory) {
                        this.notifyAssigningPlayer("My inventory is full.");
                        this.setIsActive(false);
                        return;
                    }
                    if (toolBroken) {
                        this.notifyAssigningPlayer("My axe has broken.");
                        this.setIsActive(false);
                        return;
                    }
                }
                ++this.yLevel;
                Block nextBlock = RadixBlocks.getBlock((World)this.actor.field_70170_p, (int)this.treeBasePoint.iX(), (int)(this.treeBasePoint.iY() + this.yLevel), (int)this.treeBasePoint.iZ());
                if (nextBlock == apiEntry.getLogBlock()) return;
                if (apiEntry.hasSapling() && this.doReplant) {
                    RadixBlocks.setBlock((World)this.actor.field_70170_p, (int)this.treeBasePoint.iX(), (int)(this.treeBasePoint.iY() - 1), (int)this.treeBasePoint.iZ(), (Block)Blocks.field_150346_d);
                    RadixBlocks.setBlock((World)this.actor.field_70170_p, (int)this.treeBasePoint.iX(), (int)this.treeBasePoint.iY(), (int)this.treeBasePoint.iZ(), (Block)apiEntry.getSaplingBlock());
                }
                this.yLevel = 0;
                this.treeBasePoint = Point3D.ZERO;
                return;
            }
            for (Point3D point : RadixLogic.getNearbyBlocks((Entity)this.actor, (Block)Blocks.field_150362_t, (int)1)) {
                RadixBlocks.setBlock((World)this.actor.field_70170_p, (int)point.iX(), (int)point.iY(), (int)point.iZ(), (Block)Blocks.field_150350_a);
            }
            Iterator apiEntry = RadixLogic.getNearbyBlocks((Entity)this.actor, (Block)Blocks.field_150361_u, (int)1).iterator();
            while (true) {
                Point3D point;
                if (!apiEntry.hasNext()) {
                    if (!this.actor.func_70661_as().func_75500_f()) return;
                    this.actor.func_70661_as().func_75492_a(this.treeBasePoint.dX(), this.treeBasePoint.dY(), this.treeBasePoint.dZ(), (double)this.actor.attributes.getSpeed());
                    return;
                }
                point = (Point3D)apiEntry.next();
                RadixBlocks.setBlock((World)this.actor.field_70170_p, (int)point.iX(), (int)point.iY(), (int)point.iZ(), (Block)Blocks.field_150350_a);
            }
        }
        catch (MappingNotFoundException e) {
            this.reset();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("isWoodcuttingActive", this.getIsActive());
        this.treeBasePoint.writeToNBT("treeBasePoint", nbt);
        nbt.func_74768_a("apiId", this.apiId);
        nbt.func_74768_a("yLevel", this.yLevel);
        nbt.func_74768_a("cutInterval", this.cutInterval);
        nbt.func_74768_a("cutTimeLeft", this.cutTimeLeft);
        nbt.func_74757_a("doReplant", this.doReplant);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.setIsActive(nbt.func_74767_n("isWoodcuttingActive"));
        this.treeBasePoint = Point3D.readFromNBT((String)"treeBasePoint", (NBTTagCompound)nbt);
        this.apiId = nbt.func_74762_e("apiId");
        this.yLevel = nbt.func_74762_e("yLevel");
        this.cutInterval = nbt.func_74762_e("cutInterval");
        this.cutTimeLeft = nbt.func_74762_e("cutTimeLeft");
        this.doReplant = nbt.func_74767_n("doReplant");
    }

    public void startWoodcutting(EntityPlayer player, int apiIdIn, boolean doReplantIn) {
        this.apiId = apiIdIn;
        this.assigningPlayer = player.func_110124_au();
        this.yLevel = 0;
        this.doReplant = doReplantIn;
        this.cutTimeLeft = this.cutInterval = this.calculateCutInterval();
        this.setIsActive(true);
    }

    private int calculateCutInterval() {
        ItemStack bestAxe = this.actor.attributes.getInventory().getBestItemOfType(ItemAxe.class);
        int returnAmount = -1;
        if (bestAxe != ItemStack.field_190927_a) {
            Item item = bestAxe.func_77973_b();
            Item.ToolMaterial material = Item.ToolMaterial.valueOf((String)((ItemAxe)bestAxe.func_77973_b()).func_77861_e());
            switch (material) {
                case WOOD: {
                    returnAmount = 40;
                    break;
                }
                case STONE: {
                    returnAmount = 30;
                    break;
                }
                case IRON: {
                    returnAmount = 25;
                    break;
                }
                case DIAMOND: {
                    returnAmount = 10;
                    break;
                }
                case GOLD: {
                    returnAmount = 5;
                    break;
                }
                default: {
                    returnAmount = 25;
                }
            }
            this.actor.setHeldItem(item);
        } else {
            returnAmount = 60;
            this.actor.setHeldItem(null);
        }
        return returnAmount;
    }

    @Override
    public String getName() {
        return "Woodcutting";
    }
}

