/*
 * Decompiled with CFR 0.152.
 */
package mca.api;

import javax.annotation.Nullable;
import mca.api.RegistryMCA;
import mca.api.enums.EnumCropCategory;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class CropEntry {
    private final EnumCropCategory category;
    private final Block blockCrop;
    private final Item itemSeed;
    private final Block harvestBlock;
    private final int harvestBlockMeta;
    private final Item altHarvestItem;
    private final int minYield;
    private final int maxYield;

    public CropEntry(EnumCropCategory category, Block blockCrop, Item itemSeed, Block harvestBlock, int harvestBlockMeta, @Nullable Item altHarvestItem, int minYield, int maxYield) {
        this.category = category;
        this.blockCrop = blockCrop;
        this.itemSeed = itemSeed;
        this.harvestBlock = harvestBlock;
        this.harvestBlockMeta = harvestBlockMeta;
        this.altHarvestItem = altHarvestItem;
        this.minYield = minYield;
        this.maxYield = maxYield;
    }

    public ItemStack[] getStacksOnHarvest() {
        ItemStack[] returnArray = new ItemStack[2];
        int seedAmount = RegistryMCA.rand.nextInt(2) + 1;
        int cropAmount = RegistryMCA.rand.nextInt(this.maxYield) + this.minYield;
        if (this.altHarvestItem != null) {
            returnArray[0] = new ItemStack(this.altHarvestItem, cropAmount, 0);
            if (this.itemSeed != this.altHarvestItem) {
                returnArray[1] = new ItemStack(this.itemSeed, seedAmount, 0);
            }
        } else {
            returnArray[0] = new ItemStack(this.harvestBlock, cropAmount, this.harvestBlockMeta);
            returnArray[1] = new ItemStack(this.itemSeed, seedAmount, 0);
        }
        return returnArray;
    }

    @SideOnly(value=Side.CLIENT)
    public String getCropName() {
        return I18n.func_135052_a((String)(this.itemSeed.func_77658_a() + ".name"), (Object[])new Object[0]);
    }

    public EnumCropCategory getCategory() {
        return this.category;
    }

    public Item getSeedItem() {
        return this.itemSeed;
    }

    public Block getCropBlock() {
        return this.blockCrop;
    }

    public Block getHarvestBlock() {
        return this.harvestBlock;
    }

    public int getHarvestBlockMeta() {
        return this.harvestBlockMeta;
    }
}

