/*
 * Decompiled with CFR 0.152.
 */
package mca.client.gui;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import mca.actions.ActionSleep;
import mca.core.MCA;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumEditAction;
import mca.enums.EnumSleepingState;
import mca.packets.PacketEditVillager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiVillagerEditor
extends GuiScreen {
    private final EntityVillagerMCA villager;
    private final EntityPlayer player;
    private GuiButton familyTreeButton;
    private GuiTextField nameTextField;
    private GuiTextField dummyTextField;
    private GuiButton randomButton;
    private GuiButton genderButton;
    private GuiButton shiftTextureIndexUpButton;
    private GuiButton shiftTextureIndexDownButton;
    private GuiButton professionButton;
    private GuiButton shiftProfessionUpButton;
    private GuiButton shiftProfessionDownButton;
    private GuiButton shiftTraitUpButton;
    private GuiButton shiftTraitDownButton;
    private GuiButton heightButton;
    private GuiButton shiftHeightUpButton;
    private GuiButton shiftHeightDownButton;
    private GuiButton girthButton;
    private GuiButton shiftGirthUpButton;
    private GuiButton shiftGirthDownButton;
    private GuiButton isInfectedButton;
    private GuiButton backButton;
    private GuiButton nextButton;
    private GuiButton doneButton;
    private GuiButton textureButton;
    private GuiButton personalityButton;
    private int moodListIndex = 0;
    private int currentPage = 1;

    public GuiVillagerEditor(EntityVillagerMCA EntityHuman, EntityPlayer player) {
        this.player = player;
        this.villager = EntityHuman;
        this.villager.getBehavior(ActionSleep.class).setSleepingState(EnumSleepingState.INTERRUPTED);
    }

    public void func_73876_c() {
        super.func_73876_c();
        try {
            this.nameTextField.func_146178_a();
            this.doneButton.field_146124_l = !this.nameTextField.func_146179_b().isEmpty();
            if (this.currentPage == 1) {
                if (!this.nameTextField.func_146179_b().equals(this.villager.attributes.getName())) {
                    this.nameTextField.func_146180_a(this.villager.attributes.getName());
                }
                this.genderButton.field_146126_j = MCA.getLocalizer().getString("gui.button.setup.gender." + this.villager.attributes.getIsMale());
                this.textureButton.field_146126_j = "Texture: " + this.villager.attributes.getHeadTexture().replace("mca:textures/skins/", "").replace("sleeping/", "").replace(".png", "");
                this.professionButton.field_146126_j = "Job: " + this.villager.attributes.getProfessionEnum().getUserFriendlyForm(this.villager);
                this.personalityButton.field_146126_j = "Personality: " + this.villager.attributes.getPersonality().getFriendlyName();
            }
            if (this.currentPage == 2) {
                int displayHeight = Math.round(this.villager.attributes.getScaleHeight() * 100.0f);
                int displayGirth = Math.round(this.villager.attributes.getScaleWidth() * 100.0f);
                this.heightButton.field_146126_j = "Height Factor: " + displayHeight;
                this.girthButton.field_146126_j = "Girth Factor: " + displayGirth;
                this.isInfectedButton.field_146126_j = "Is Infected: " + (this.villager.attributes.getIsInfected() ? "Yes" : "No");
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.drawEditorGuiPage1();
        this.nameTextField = new GuiTextField(1, this.field_146289_q, this.field_146294_l / 2 - 205, this.field_146295_m / 2 - 95, 150, 20);
        this.nameTextField.func_146203_f(32);
        this.nameTextField.func_146180_a(this.villager.attributes.getName());
        this.dummyTextField = new GuiTextField(2, this.field_146289_q, this.field_146294_l / 2 + 90, this.field_146295_m / 2 - 100, 100, 200);
        this.dummyTextField.func_146203_f(0);
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        this.villager.isInteractionGuiOpen = false;
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (!guibutton.field_146124_l) {
            return;
        }
        if (guibutton == this.doneButton) {
            Minecraft.func_71410_x().func_147108_a(null);
        } else if (guibutton == this.randomButton) {
            MCA.getPacketHandler().sendPacketToServer((IMessage)new PacketEditVillager(this.villager.func_145782_y(), EnumEditAction.RANDOM_NAME));
            this.nameTextField.func_146192_a(5, 5, 5);
            this.drawEditorGuiPage1();
        } else if (guibutton == this.genderButton) {
            MCA.getPacketHandler().sendPacketToServer((IMessage)new PacketEditVillager(this.villager.func_145782_y(), EnumEditAction.SWAP_GENDER));
            this.drawEditorGuiPage1();
        } else if (guibutton == this.shiftTextureIndexUpButton) {
            MCA.getPacketHandler().sendPacketToServer((IMessage)new PacketEditVillager(this.villager.func_145782_y(), EnumEditAction.TEXTURE_UP));
            this.drawEditorGuiPage1();
        } else if (guibutton == this.shiftTextureIndexDownButton) {
            MCA.getPacketHandler().sendPacketToServer((IMessage)new PacketEditVillager(this.villager.func_145782_y(), EnumEditAction.TEXTURE_DOWN));
            this.drawEditorGuiPage1();
        } else if (guibutton == this.shiftProfessionUpButton) {
            MCA.getPacketHandler().sendPacketToServer((IMessage)new PacketEditVillager(this.villager.func_145782_y(), EnumEditAction.PROFESSION_UP));
            this.drawEditorGuiPage1();
        } else if (guibutton == this.shiftProfessionDownButton) {
            MCA.getPacketHandler().sendPacketToServer((IMessage)new PacketEditVillager(this.villager.func_145782_y(), EnumEditAction.PROFESSION_DOWN));
            this.drawEditorGuiPage1();
        } else if (guibutton == this.shiftTraitUpButton) {
            MCA.getPacketHandler().sendPacketToServer((IMessage)new PacketEditVillager(this.villager.func_145782_y(), EnumEditAction.TRAIT_UP));
            this.drawEditorGuiPage1();
        } else if (guibutton == this.shiftTraitDownButton) {
            MCA.getPacketHandler().sendPacketToServer((IMessage)new PacketEditVillager(this.villager.func_145782_y(), EnumEditAction.TRAIT_DOWN));
            this.drawEditorGuiPage1();
        } else if (guibutton == this.nextButton) {
            switch (this.currentPage) {
                case 1: {
                    this.drawEditorGuiPage2();
                    break;
                }
                case 2: {
                    this.drawEditorGuiPage2();
                }
            }
        } else if (guibutton == this.backButton) {
            switch (this.currentPage) {
                case 1: {
                    this.drawEditorGuiPage1();
                    break;
                }
                case 2: {
                    this.drawEditorGuiPage1();
                }
            }
        } else if (guibutton == this.shiftHeightUpButton) {
            MCA.getPacketHandler().sendPacketToServer((IMessage)new PacketEditVillager(this.villager.func_145782_y(), EnumEditAction.HEIGHT_UP));
            this.drawEditorGuiPage2();
        } else if (guibutton == this.shiftHeightDownButton) {
            MCA.getPacketHandler().sendPacketToServer((IMessage)new PacketEditVillager(this.villager.func_145782_y(), EnumEditAction.HEIGHT_DOWN));
            this.drawEditorGuiPage2();
        } else if (guibutton == this.shiftGirthUpButton) {
            MCA.getPacketHandler().sendPacketToServer((IMessage)new PacketEditVillager(this.villager.func_145782_y(), EnumEditAction.GIRTH_UP));
            this.drawEditorGuiPage2();
        } else if (guibutton == this.shiftGirthDownButton) {
            MCA.getPacketHandler().sendPacketToServer((IMessage)new PacketEditVillager(this.villager.func_145782_y(), EnumEditAction.GIRTH_DOWN));
            this.drawEditorGuiPage2();
        } else if (guibutton == this.isInfectedButton) {
            MCA.getPacketHandler().sendPacketToServer((IMessage)new PacketEditVillager(this.villager.func_145782_y(), EnumEditAction.TOGGLE_INFECTED));
            this.drawEditorGuiPage2();
        }
    }

    protected void func_73869_a(char c, int i) throws IOException {
        if (i == 1) {
            Minecraft.func_71410_x().func_147108_a(null);
        } else if (this.currentPage == 1) {
            this.nameTextField.func_146201_a(c, i);
            String text = this.nameTextField.func_146179_b().trim();
            MCA.getPacketHandler().sendPacketToServer((IMessage)new PacketEditVillager(this.villager.func_145782_y(), EnumEditAction.SET_NAME, text));
            this.villager.attributes.setName(text);
            this.drawEditorGuiPage1();
        } else {
            super.func_73869_a(c, i);
        }
    }

    protected void func_73864_a(int clickX, int clickY, int clicked) throws IOException {
        super.func_73864_a(clickX, clickY, clicked);
        if (this.currentPage == 1) {
            this.nameTextField.func_146192_a(clickX, clickY, clicked);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    private void drawEditorGuiPage1() {
        this.currentPage = 1;
        this.field_146292_n.clear();
        this.randomButton = new GuiButton(1, this.field_146294_l / 2 - 50, this.field_146295_m / 2 - 95, 60, 20, MCA.getLocalizer().getString("gui.button.random"));
        this.field_146292_n.add(this.randomButton);
        this.genderButton = new GuiButton(2, this.field_146294_l / 2 - 190, this.field_146295_m / 2 - 60, 175, 20, MCA.getLocalizer().getString("gui.button.setup.gender." + this.villager.attributes.getIsMale()));
        this.field_146292_n.add(this.genderButton);
        this.textureButton = new GuiButton(3, this.field_146294_l / 2 - 190, this.field_146295_m / 2 - 40, 175, 20, "Texture: " + this.villager.attributes.getHeadTexture().replace("mca:textures/skins/", "").replace(".png", ""));
        this.field_146292_n.add(this.textureButton);
        this.shiftTextureIndexUpButton = new GuiButton(4, this.field_146294_l / 2 - 15, this.field_146295_m / 2 - 40, 20, 20, ">>");
        this.field_146292_n.add(this.shiftTextureIndexUpButton);
        this.shiftTextureIndexDownButton = new GuiButton(5, this.field_146294_l / 2 - 210, this.field_146295_m / 2 - 40, 20, 20, "<<");
        this.field_146292_n.add(this.shiftTextureIndexDownButton);
        this.professionButton = new GuiButton(6, this.field_146294_l / 2 - 190, this.field_146295_m / 2 - 20, 175, 20, "Job: " + this.villager.attributes.getProfessionEnum().getUserFriendlyForm(this.villager));
        this.field_146292_n.add(this.professionButton);
        this.shiftProfessionUpButton = new GuiButton(7, this.field_146294_l / 2 - 15, this.field_146295_m / 2 - 20, 20, 20, ">>");
        this.field_146292_n.add(this.shiftProfessionUpButton);
        this.shiftProfessionDownButton = new GuiButton(8, this.field_146294_l / 2 - 210, this.field_146295_m / 2 - 20, 20, 20, "<<");
        this.field_146292_n.add(this.shiftProfessionDownButton);
        this.personalityButton = new GuiButton(12, this.field_146294_l / 2 - 190, this.field_146295_m / 2 + 0, 175, 20, MCA.getLocalizer().getString("gui.info.personality", this.villager.attributes.getPersonality().getFriendlyName()));
        this.field_146292_n.add(this.personalityButton);
        this.shiftTraitUpButton = new GuiButton(13, this.field_146294_l / 2 - 15, this.field_146295_m / 2 + 0, 20, 20, ">>");
        this.field_146292_n.add(this.shiftTraitUpButton);
        this.shiftTraitDownButton = new GuiButton(14, this.field_146294_l / 2 - 210, this.field_146295_m / 2 + 0, 20, 20, "<<");
        this.field_146292_n.add(this.shiftTraitDownButton);
        this.doneButton = new GuiButton(17, this.field_146294_l / 2 - 50, this.field_146295_m / 2 + 85, 75, 20, MCA.getLocalizer().getString("gui.button.done"));
        this.field_146292_n.add(this.doneButton);
        this.nextButton = new GuiButton(18, this.field_146294_l / 2 + 25, this.field_146295_m / 2 + 85, 50, 20, MCA.getLocalizer().getString("gui.button.next"));
        this.field_146292_n.add(this.nextButton);
        this.backButton = new GuiButton(19, this.field_146294_l / 2 - 101, this.field_146295_m / 2 + 85, 50, 20, MCA.getLocalizer().getString("gui.button.back"));
        this.field_146292_n.add(this.backButton);
        this.backButton.field_146124_l = false;
    }

    private void drawEditorGuiPage2() {
        int displayHeight = Math.round(this.villager.attributes.getScaleHeight() * 100.0f);
        int displayGirth = Math.round(this.villager.attributes.getScaleWidth() * 100.0f);
        this.currentPage = 2;
        this.field_146292_n.clear();
        this.heightButton = new GuiButton(1, this.field_146294_l / 2 - 190, this.field_146295_m / 2 - 40, 175, 20, "Height Factor: " + displayHeight);
        this.field_146292_n.add(this.heightButton);
        this.shiftHeightUpButton = new GuiButton(2, this.field_146294_l / 2 - 15, this.field_146295_m / 2 - 40, 20, 20, ">>");
        this.field_146292_n.add(this.shiftHeightUpButton);
        this.shiftHeightDownButton = new GuiButton(3, this.field_146294_l / 2 - 210, this.field_146295_m / 2 - 40, 20, 20, "<<");
        this.field_146292_n.add(this.shiftHeightDownButton);
        this.girthButton = new GuiButton(4, this.field_146294_l / 2 - 190, this.field_146295_m / 2 - 20, 175, 20, "Girth Factor: " + displayGirth);
        this.field_146292_n.add(this.girthButton);
        this.shiftGirthUpButton = new GuiButton(5, this.field_146294_l / 2 - 15, this.field_146295_m / 2 - 20, 20, 20, ">>");
        this.field_146292_n.add(this.shiftGirthUpButton);
        this.shiftGirthDownButton = new GuiButton(6, this.field_146294_l / 2 - 210, this.field_146295_m / 2 - 20, 20, 20, "<<");
        this.field_146292_n.add(this.shiftGirthDownButton);
        this.isInfectedButton = new GuiButton(7, this.field_146294_l / 2 - 190, this.field_146295_m / 2 - 0, 175, 20, "Is Infected: " + this.villager.attributes.getIsInfected());
        this.field_146292_n.add(this.isInfectedButton);
        this.doneButton = new GuiButton(16, this.field_146294_l / 2 - 50, this.field_146295_m / 2 + 85, 75, 20, MCA.getLocalizer().getString("gui.button.done"));
        this.field_146292_n.add(this.doneButton);
        this.nextButton = new GuiButton(17, this.field_146294_l / 2 + 25, this.field_146295_m / 2 + 85, 50, 20, MCA.getLocalizer().getString("gui.button.next"));
        this.field_146292_n.add(this.nextButton);
        this.backButton = new GuiButton(18, this.field_146294_l / 2 - 101, this.field_146295_m / 2 + 85, 50, 20, MCA.getLocalizer().getString("gui.button.back"));
        this.field_146292_n.add(this.backButton);
        this.nextButton.field_146124_l = false;
    }

    public void func_73863_a(int sizeX, int sizeY, float offset) {
        this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, -1072689136, -804253680);
        if (this.currentPage != -1) {
            int posX = this.field_146294_l / 2 + 140;
            int posY = this.field_146295_m / 2 + 95;
            int scale = 80;
            if (!this.villager.getBehavior(ActionSleep.class).getIsSleeping()) {
                posY = this.field_146295_m / 2 + 80;
            }
            GuiInventory.func_147046_a((int)posX, (int)posY, (int)75, (float)0.0f, (float)0.0f, (EntityLivingBase)this.villager);
            this.dummyTextField.func_146194_f();
        }
        if (this.currentPage == 1) {
            this.func_73731_b(this.field_146289_q, "Name:", this.field_146294_l / 2 - 205, this.field_146295_m / 2 - 110, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, MCA.getLocalizer().getString("gui.title.editor"), this.field_146294_l / 2 - 205, this.field_146295_m / 2 - 87, 0xA0A0A0);
            this.nameTextField.func_146194_f();
        }
        GL11.glPushMatrix();
        GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
        this.func_73732_a(this.field_146289_q, MCA.getLocalizer().getString("gui.title.editor"), this.field_146294_l / 2 - 75, this.field_146295_m / 2 - 125, 0xFFFFFF);
        GL11.glPopMatrix();
        super.func_73863_a(sizeX, sizeY, offset);
    }

    private void sortTextureList(List<String> listToSort) {
        Collections.sort(listToSort, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int skinNumber2;
                int skinNumber1 = Integer.parseInt(o1.replaceAll("[^0-9]+", " ").trim());
                if (skinNumber1 == (skinNumber2 = Integer.parseInt(o2.replaceAll("[^0-9]+", " ").trim()))) {
                    return 0;
                }
                if (skinNumber1 < skinNumber2) {
                    return -1;
                }
                return 1;
            }
        });
    }
}

