/*
 * Decompiled with CFR 0.152.
 */
package mca.client.render;

import mca.client.model.ModelMemorial;
import mca.tile.TileMemorial;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderMemorial
extends TileEntitySpecialRenderer<TileMemorial> {
    private static final ResourceLocation RING_TEXTURE = new ResourceLocation("mca:textures/brokenringentity.png");
    private static final ResourceLocation TRAIN_TEXTURE = new ResourceLocation("mca:textures/trainentity.png");
    private static final ResourceLocation DOLL_TEXTURE = new ResourceLocation("mca:textures/skins/FarmerF12.png");
    private final ModelMemorial memorialModel = new ModelMemorial();

    public void renderMemorialAt(TileMemorial memorialEntity, double posX, double posY, double posZ, float partialTickTime) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(posX + 0.5), (double)(posY + 1.5), (double)(posZ + (double)0.53f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glScalef((float)0.7f, (float)1.0f, (float)0.7f);
        try {
            switch (memorialEntity.getType()) {
                case BROKEN_RING: {
                    this.bindResource(RING_TEXTURE);
                    this.memorialModel.renderRing();
                    break;
                }
                case TRAIN: {
                    this.bindResource(TRAIN_TEXTURE);
                    this.memorialModel.renderTrain();
                    break;
                }
                case DOLL: {
                    this.bindResource(DOLL_TEXTURE);
                    this.memorialModel.renderDoll();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        GL11.glPopMatrix();
    }

    public void render(TileMemorial te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        this.renderMemorialAt(te, x, y, z, partialTicks);
    }

    protected void bindResource(ResourceLocation resourceLocation) {
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        if (textureManager != null) {
            textureManager.func_110577_a(resourceLocation);
        }
    }
}

