/*
 * Decompiled with CFR 0.152.
 */
package mca.client.render;

import java.util.ArrayList;
import mca.actions.ActionSleep;
import mca.client.gui.GuiInteraction;
import mca.client.gui.GuiVillagerEditor;
import mca.client.model.ModelHuman;
import mca.core.MCA;
import mca.data.PlayerMemory;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumGender;
import mca.util.UVPoint;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerHeldItem;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;
import radixcore.modules.RadixMath;
import radixcore.modules.client.RadixRender;

public class RenderVillagerMCA<T extends EntityVillagerMCA>
extends RenderBiped<EntityVillagerMCA> {
    private static final ResourceLocation gui = new ResourceLocation("mca:textures/gui.png");
    private static final UVPoint exMark = new UVPoint(55, 18, 3, 13);
    private static final UVPoint minus = new UVPoint(69, 23, 7, 3);
    private static final UVPoint plus = new UVPoint(85, 21, 7, 7);
    private static final float LABEL_SCALE = 0.027f;

    public RenderVillagerMCA(RenderManager manager) {
        super(manager, (ModelBiped)new ModelHuman(), 0.5f);
        this.func_177094_a((LayerRenderer)new LayerHeldItem((RenderLivingBase)this));
        this.func_177094_a((LayerRenderer)new LayerBipedArmor((RenderLivingBase)this));
    }

    protected void preRenderCallback(EntityVillagerMCA entityLivingBase, float partialTickTime) {
        float scale;
        EntityVillagerMCA entity = entityLivingBase;
        ActionSleep sleepAI = entity.getBehavior(ActionSleep.class);
        float f = scale = entity.attributes.getGender() == EnumGender.MALE ? 0.9375f : 0.915f;
        if (entity.attributes.getIsChild()) {
            boolean doGradualGrowth = MCA.getConfig().isAgingEnabled;
            float growthFactor = (entity.attributes.getGender() == EnumGender.MALE ? 0.39f : 0.37f) / (float)MCA.getConfig().childGrowUpTime * (float)entity.attributes.getAge();
            scale = 0.55f + growthFactor;
            if (entityLivingBase.func_184187_bx() != null) {
                if (entityLivingBase.func_184187_bx() instanceof EntityHorse) {
                    GL11.glTranslated((double)0.0, (double)((double)growthFactor - 0.3), (double)0.2);
                } else {
                    GL11.glTranslated((double)0.0, (double)((double)growthFactor + 0.1), (double)0.4);
                }
            }
        }
        GL11.glScalef((float)scale, (float)(scale + entity.attributes.getScaleHeight()), (float)scale);
        GL11.glScalef((float)(scale + entity.attributes.getScaleWidth()), (float)scale, (float)(scale + entity.attributes.getScaleWidth()));
        if (sleepAI.getIsInBed()) {
            this.renderHumanSleeping(entity, partialTickTime);
        }
        if (entityLivingBase.func_184187_bx() != null && entityLivingBase.func_184187_bx() instanceof EntityHorse) {
            GL11.glTranslated((double)0.0, (double)0.55, (double)0.1);
        }
    }

    private void doRenderEntity(EntityVillagerMCA entity, double x, double y, double z, float entityYaw, float partialTicks) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        PlayerMemory memory = entity.attributes.getPlayerMemoryWithoutCreating((EntityPlayer)player);
        if (RadixMath.getDistanceToEntity((Entity)entity, (Entity)player) <= 5.0 && !entity.getBehavior(ActionSleep.class).getIsSleeping() && !entity.isInteractionGuiOpen && memory != null) {
            UVPoint uvp;
            UVPoint uVPoint = memory.doDisplayFeedback() ? (memory.getLastInteractionSuccess() ? plus : minus) : (uvp = memory.getHasQuest() ? exMark : null);
            if (uvp != null) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)((float)x), (float)((float)y + entity.field_70131_O + 0.25f + 0.5f), (float)((float)z));
                GL11.glRotatef((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)this.field_76990_c.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glScalef((float)-0.027f, (float)-0.027f, (float)0.027f);
                GL11.glDisable((int)2896);
                GL11.glTranslatef((float)0.0f, (float)9.259259f, (float)0.0f);
                RadixRender.drawTexturedRectangle((ResourceLocation)gui, (int)((int)x), (int)((int)y + 12), (int)uvp.getU(), (int)uvp.getV(), (int)uvp.getWidth(), (int)uvp.getHeight());
                GL11.glPopMatrix();
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)2896);
            }
        }
        double posYCorrection = y - entity.func_70033_W();
        if (entity.func_70093_af()) {
            posYCorrection -= 0.125;
        }
        super.func_76986_a((EntityLiving)entity, x, posYCorrection, z, entityYaw, partialTicks);
    }

    private void doRenderEffects(EntityVillagerMCA entity, double x, double y, double z, float entityYaw, float partialTicks) {
        int currentHealth = (int)entity.func_110143_aJ();
        int maxHealth = (int)entity.func_110138_aP();
        double distanceFromPlayer = RadixMath.getDistanceToEntity((Entity)entity, (Entity)Minecraft.func_71410_x().field_71439_g);
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiVillagerEditor) {
            return;
        }
        if (currentHealth < maxHealth && distanceFromPlayer <= 8.0) {
            this.renderLabel(entity, x, y + 0.1, z, MCA.getLocalizer().getString("label.health"));
            this.renderHealth(entity, x, y, z, currentHealth, maxHealth);
        } else if (this.canRenderNameTag((EntityLivingBase)entity) && MCA.getConfig().showNameTagOnHover) {
            this.renderLabel(entity, x, y, z, entity.attributes.getTitle((EntityPlayer)Minecraft.func_71410_x().field_71439_g));
        } else if (entity.isInteractionGuiOpen) {
            this.renderLabel(entity, x, y + 0.1, z, entity.attributes.getTitle((EntityPlayer)Minecraft.func_71410_x().field_71439_g));
            this.renderHearts(entity, x, y + 0.1, z, entity.attributes.getPlayerMemory((EntityPlayer)Minecraft.func_71410_x().field_71439_g).getHearts());
        } else if (entity.getBehaviors().isToggleActionActive()) {
            this.renderLabel(entity, x, y + 0.1, z, entity.getBehaviors().getActiveActionName());
        }
    }

    private void renderHealth(EntityVillagerMCA human, double posX, double posY, double posZ, int currentHealth, int maxHealth) {
        int i;
        int redHeartU = 5;
        int darkHeartU = 21;
        int heartsDrawn = 0;
        maxHealth = Math.round((float)maxHealth / 2.0f);
        currentHealth = Math.round((float)currentHealth / 2.0f);
        int depletedHealth = maxHealth - currentHealth;
        int mid = maxHealth == 10 ? 45 : 90;
        for (i = 0; i < currentHealth; ++i) {
            ++heartsDrawn;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)posX + 0.0f), (float)((float)posY + human.field_70131_O + 0.25f), (float)((float)posZ));
            GL11.glRotatef((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)this.field_76990_c.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)-0.027f, (float)-0.027f, (float)0.027f);
            GL11.glDisable((int)2896);
            GL11.glTranslatef((float)0.0f, (float)9.259259f, (float)0.0f);
            RadixRender.drawTexturedRectangle((ResourceLocation)gui, (int)((int)posX + heartsDrawn * 8 - mid), (int)((int)posY - 4), (int)5, (int)20, (int)9, (int)9);
            GL11.glPopMatrix();
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2896);
        }
        for (i = 0; i < depletedHealth; ++i) {
            ++heartsDrawn;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)posX + 0.0f), (float)((float)posY + human.field_70131_O + 0.25f), (float)((float)posZ));
            GL11.glRotatef((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)this.field_76990_c.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)-0.027f, (float)-0.027f, (float)0.027f);
            GL11.glDisable((int)2896);
            GL11.glTranslatef((float)0.0f, (float)9.259259f, (float)0.0f);
            RadixRender.drawTexturedRectangle((ResourceLocation)gui, (int)((int)posX + heartsDrawn * 8 - mid), (int)((int)posY - 4), (int)21, (int)20, (int)9, (int)9);
            GL11.glPopMatrix();
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2896);
        }
    }

    private void renderHearts(EntityVillagerMCA human, double posX, double posY, double posZ, int heartsLevel) {
        try {
            int clampedHearts = RadixMath.clamp((int)((Math.abs(heartsLevel) + 5) / 10), (int)0, (int)10);
            boolean isNegative = heartsLevel < 0;
            int goldHearts = isNegative ? 0 : clampedHearts - 5;
            int heartU = 5;
            int goldHeartU = 37;
            int negHeartU = 21;
            clampedHearts = RadixMath.clamp((int)clampedHearts, (int)0, (int)5);
            ArrayList<Integer> heartsToDraw = new ArrayList<Integer>();
            while (goldHearts > 0) {
                heartsToDraw.add(37);
                --goldHearts;
            }
            while (heartsToDraw.size() < clampedHearts) {
                if (isNegative) {
                    heartsToDraw.add(21);
                    continue;
                }
                heartsToDraw.add(5);
            }
            if (!heartsToDraw.isEmpty()) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)((float)posX + 0.0f), (float)((float)posY + human.field_70131_O + 0.25f), (float)((float)posZ));
                GL11.glRotatef((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)this.field_76990_c.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glScalef((float)-0.027f, (float)-0.027f, (float)0.027f);
                GL11.glDisable((int)2896);
                GL11.glTranslatef((float)0.0f, (float)9.259259f, (float)0.0f);
                switch (heartsToDraw.size()) {
                    case 1: {
                        RadixRender.drawTexturedRectangle((ResourceLocation)gui, (int)((int)posX + 20 - 22), (int)((int)posY - 4), (int)((Integer)heartsToDraw.get(0)), (int)20, (int)9, (int)9);
                        break;
                    }
                    case 2: {
                        for (int i = 0; i < 2; ++i) {
                            RadixRender.drawTexturedRectangle((ResourceLocation)gui, (int)((int)posX + 10 * i - 9), (int)((int)posY - 4), (int)((Integer)heartsToDraw.get(i)), (int)20, (int)9, (int)9);
                        }
                        break;
                    }
                    case 3: {
                        for (int i = 0; i < 3; ++i) {
                            RadixRender.drawTexturedRectangle((ResourceLocation)gui, (int)((int)posX + 10 * i - 14), (int)((int)posY - 4), (int)((Integer)heartsToDraw.get(i)), (int)20, (int)9, (int)9);
                        }
                        break;
                    }
                    case 4: {
                        for (int i = 0; i < 4; ++i) {
                            RadixRender.drawTexturedRectangle((ResourceLocation)gui, (int)((int)posX + 10 * i - 19), (int)((int)posY - 4), (int)((Integer)heartsToDraw.get(i)), (int)20, (int)9, (int)9);
                        }
                        break;
                    }
                    case 5: {
                        for (int i = 0; i < 5; ++i) {
                            RadixRender.drawTexturedRectangle((ResourceLocation)gui, (int)((int)posX + 10 * i - 23), (int)((int)posY - 4), (int)((Integer)heartsToDraw.get(i)), (int)20, (int)9, (int)9);
                        }
                        break;
                    }
                }
                GL11.glPopMatrix();
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)2896);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void renderLabel(EntityVillagerMCA human, double posX, double posY, double posZ, String labelText) {
        this.func_147906_a((Entity)human, labelText, posX, posY, posZ, 64);
    }

    private boolean canRenderNameTag(EntityLivingBase entityRendering) {
        EntityPlayerSP entityPlayer = Minecraft.func_71410_x().field_71439_g;
        Vec3d entityLookVector = new Vec3d(entityRendering.field_70165_t - entityPlayer.field_70165_t, entityRendering.func_174813_aQ().field_72338_b - 3.0 + (double)entityRendering.field_70131_O / 2.0 - entityPlayer.field_70163_u + (double)entityPlayer.func_70047_e(), entityRendering.field_70161_v - entityPlayer.field_70161_v).func_72432_b();
        double dotProduct = entityPlayer.func_70676_i(1.0f).func_72432_b().func_72430_b(entityLookVector);
        boolean isPlayerLookingAt = dotProduct > 1.0 - 0.025 / entityLookVector.func_72433_c() ? entityPlayer.func_70685_l((Entity)entityRendering) : false;
        double distance = entityRendering.func_70032_d((Entity)Minecraft.func_71410_x().field_71439_g);
        return !(Minecraft.func_71410_x().field_71462_r instanceof GuiInteraction) && distance < 5.0 && isPlayerLookingAt && Minecraft.func_71382_s() && entityRendering != Minecraft.func_71410_x().field_71439_g && !entityRendering.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g) && !entityRendering.func_184207_aI();
    }

    protected void renderHumanSleeping(EntityVillagerMCA entity, double partialTickTime) {
        ActionSleep sleepAI = entity.getBehavior(ActionSleep.class);
        int meta = sleepAI.getBedMeta();
        if (meta == 0) {
            entity.field_70759_as = 180.0f;
            GL11.glTranslated((double)-0.5, (double)0.0, (double)0.0);
            GL11.glRotated((double)90.0, (double)-1.0, (double)0.0, (double)0.0);
            GL11.glTranslated((double)0.0, (double)0.0, (double)-0.75);
        } else if (meta == 3) {
            entity.field_70759_as = 90.0f;
            GL11.glTranslated((double)0.5, (double)0.0, (double)0.0);
            GL11.glRotated((double)90.0, (double)-1.0, (double)0.0, (double)0.0);
            GL11.glTranslated((double)0.0, (double)0.0, (double)-0.75);
        } else if (meta == 2) {
            entity.field_70759_as = 0.0f;
            GL11.glTranslated((double)0.5, (double)0.0, (double)-1.0);
            GL11.glRotated((double)90.0, (double)-1.0, (double)0.0, (double)0.0);
            GL11.glTranslated((double)0.0, (double)0.0, (double)-0.75);
        } else if (meta == 1) {
            entity.field_70759_as = -90.0f;
            GL11.glTranslated((double)-0.5, (double)0.0, (double)-1.0);
            GL11.glRotated((double)90.0, (double)-1.0, (double)0.0, (double)0.0);
            GL11.glTranslated((double)0.0, (double)0.0, (double)-0.75);
        }
    }

    public void doRender(EntityVillagerMCA entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.doRenderEntity(entity, x, y, z, entityYaw, partialTicks);
        this.doRenderEffects(entity, x, y, z, entityYaw, partialTicks);
    }

    protected ResourceLocation getEntityTexture(EntityVillagerMCA entity) {
        EntityVillagerMCA human = entity;
        String skinName = human.attributes.getHeadTexture();
        if (skinName.isEmpty()) {
            return new ResourceLocation("minecraft:textures/entity/steve.png");
        }
        return new ResourceLocation(entity.attributes.getHeadTexture());
    }
}

