/*
 * Decompiled with CFR 0.152.
 */
package mca.core;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mca.core.MCA;
import mca.core.radix.LanguageParser;
import net.minecraft.client.Minecraft;
import net.minecraft.util.StringUtils;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import radixcore.modules.RadixMath;
import radixcore.modules.lang.AbstractLanguageParser;

public class Localizer {
    private AbstractLanguageParser parser = new LanguageParser();
    private Map<String, String> translationsMap = new HashMap<String, String>();

    public Localizer(FMLPreInitializationEvent event) {
        boolean loadedLanguage = false;
        for (StackTraceElement element : new Throwable().getStackTrace()) {
            if (!element.getClassName().equals("net.minecraft.server.dedicated.DedicatedServer")) continue;
            MCA.getLog().warn("MCA is running on a dedicated server and will default to using English as its language.");
            MCA.getLog().warn("This may cause issues with some phrases being translated while others are not.");
            MCA.getLog().warn("**** To change your server's language in MCA, change the `serverLanguageId` option in MCA's configuration. ****");
            this.loadLanguage(MCA.getConfig().serverLanguageId);
            loadedLanguage = true;
        }
        if (!loadedLanguage) {
            this.loadLanguage(this.getGameLanguageID());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public String getGameLanguageID() {
        String languageID = "en_us";
        try {
            languageID = Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
        }
        catch (Exception e) {
            MCA.getLog().error("Unable to get current language code. Defaulting to English.");
        }
        return languageID;
    }

    public String getString(String id) {
        return this.getString(id, new Object[]{null});
    }

    public String getString(String id, Object ... arguments) {
        if (this.translationsMap.containsKey(id)) {
            if (this.parser != null) {
                return this.parser.parsePhrase(this.translationsMap.get(id), arguments);
            }
            return this.translationsMap.get(id);
        }
        ArrayList<String> containingKeys = new ArrayList<String>();
        for (String key : this.translationsMap.keySet()) {
            if (!key.contains(id)) continue;
            containingKeys.add(key);
        }
        if (containingKeys.size() > 0) {
            String key = (String)containingKeys.get(RadixMath.getNumberInRange((int)0, (int)(containingKeys.size() - 1)));
            if (this.parser != null) {
                return this.parser.parsePhrase(this.translationsMap.get(key), arguments);
            }
            return this.translationsMap.get(key);
        }
        MCA.getLog().error("No translation mapping found for requested phrase ID: " + id);
        return id;
    }

    public void onLanguageChange() {
        this.loadLanguage(this.getGameLanguageID());
    }

    private void loadLanguage(String languageId) {
        languageId = languageId.toLowerCase();
        this.translationsMap.clear();
        if (languageId.startsWith("en_") && !languageId.equals("en_us")) {
            this.loadLanguage("en_us");
            return;
        }
        if (languageId.startsWith("es_") && !languageId.equals("es_es")) {
            this.loadLanguage("es_es");
            return;
        }
        InputStream inStream = StringUtils.class.getResourceAsStream("/assets/mca/lang/" + languageId + ".lang");
        if (inStream == null) {
            if (languageId.equals("en_us")) {
                throw new RuntimeException("Unable to load English language files. Loading cannot continue.");
            }
            MCA.getLog().error("Cannot load language " + languageId + ". Defaulting to English.");
            this.loadLanguage("en_us");
        } else {
            try {
                List lines = IOUtils.readLines((InputStream)inStream, (Charset)Charsets.UTF_8);
                int lineNumber = 0;
                for (String line : lines) {
                    String value;
                    ++lineNumber;
                    if (line.startsWith("#") || line.isEmpty()) continue;
                    String[] split = line.split("\\=");
                    String key = split[0];
                    String string = value = split.length == 2 ? split[1].replace("\\", "") : "";
                    if (key.isEmpty()) {
                        throw new IOException("Empty phrase key on line " + lineNumber);
                    }
                    if (value.isEmpty()) {
                        MCA.getLog().warn("Empty phrase value on line " + lineNumber + ". Key value: " + key);
                    }
                    this.translationsMap.put(key, value);
                }
                MCA.getLog().info("Loaded language " + languageId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

