/*
 * Decompiled with CFR 0.152.
 */
package mca.core.forge;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mca.core.Constants;
import mca.core.MCA;
import mca.core.minecraft.ItemsMCA;
import mca.core.minecraft.SoundsMCA;
import mca.data.NBTPlayerData;
import mca.data.PlayerDataCollection;
import mca.entity.EntityGrimReaper;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumBabyState;
import mca.enums.EnumProfession;
import mca.enums.EnumProfessionSkinGroup;
import mca.packets.PacketPlayerDataLogin;
import mca.packets.PacketSpawnLightning;
import mca.packets.PacketSyncConfig;
import mca.util.Utilities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiLanguage;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import radixcore.math.Point3D;
import radixcore.modules.RadixLogic;
import radixcore.modules.RadixMath;
import radixcore.modules.schematics.RadixSchematics;

public class EventHooksFML {
    public static boolean playPortalAnimation;
    private static int summonCounter;
    private static Point3D summonPos;
    private static World summonWorld;
    private int clientTickCounter;
    private int serverTickCounter;

    @SubscribeEvent
    public void onConfigChanges(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.getModID().equals("mca")) {
            MCA.getConfig().getInstance().save();
            MCA.getConfig().syncConfiguration();
        }
    }

    @SubscribeEvent
    public void playerLoggedInEventHandler(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        PlayerDataCollection dataCollection = PlayerDataCollection.get();
        boolean setPermanentId = false;
        NBTPlayerData nbtData = null;
        if (dataCollection.getPlayerData(player.func_110124_au()) == null) {
            NBTPlayerData nbtPlayerData = new NBTPlayerData();
            dataCollection.putPlayerData(player.func_110124_au(), nbtPlayerData);
            nbtData = nbtPlayerData;
            setPermanentId = true;
        } else {
            nbtData = dataCollection.getPlayerData(player.func_110124_au());
        }
        MCA.getPacketHandler().sendPacketToPlayer((IMessage)new PacketSyncConfig(MCA.getConfig()), (EntityPlayer)((EntityPlayerMP)event.player));
        if (nbtData != null) {
            MCA.getPacketHandler().sendPacketToPlayer((IMessage)new PacketPlayerDataLogin(nbtData), (EntityPlayer)((EntityPlayerMP)player));
            if (setPermanentId) {
                nbtData.setUUID(player.func_110124_au());
            }
            if (!nbtData.getHasChosenDestiny() && !player.field_71071_by.func_70431_c(new ItemStack((Item)ItemsMCA.CRYSTAL_BALL)) && MCA.getConfig().giveCrystalBall) {
                player.field_71071_by.func_70441_a(new ItemStack((Item)ItemsMCA.CRYSTAL_BALL));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void clientTickEventHandler(TickEvent.ClientTickEvent event) {
        MCA.getPacketHandler().processPackets(Side.CLIENT);
        Minecraft mc = Minecraft.func_71410_x();
        GuiScreen currentScreen = mc.field_71462_r;
        if (currentScreen instanceof GuiMainMenu && MCA.myPlayerData != null) {
            playPortalAnimation = false;
            MCA.destinyCenterPoint = null;
            MCA.destinySpawnFlag = false;
            MCA.myPlayerData = null;
            MCA.resetConfig();
        }
        if (currentScreen instanceof GuiLanguage) {
            MCA.reloadLanguage = true;
        } else if (MCA.reloadLanguage) {
            MCA.reloadLanguage = false;
            MCA.getLocalizer().onLanguageChange();
        }
        if (playPortalAnimation) {
            EntityPlayerSP player = mc.field_71439_g;
            if (player == null) {
                return;
            }
            player.field_71080_cy = player.field_71086_bY;
            player.field_71086_bY -= 0.0125f;
            if (player.field_71086_bY <= 0.0f) {
                playPortalAnimation = false;
            }
        }
        if (this.clientTickCounter <= 0) {
            this.clientTickCounter = 10;
            if (MCA.destinySpawnFlag) {
                RadixSchematics.spawnStructureRelativeToPoint((String)"/assets/mca/schematic/destiny-test.schematic", (Point3D)MCA.destinyCenterPoint, (World)mc.field_71441_e);
            }
        } else {
            --this.clientTickCounter;
        }
    }

    @SubscribeEvent
    public void serverTickEventHandler(TickEvent.ServerTickEvent event) {
        MCA.getPacketHandler().processPackets(Side.SERVER);
        if (this.serverTickCounter % 40 == 0) {
            for (WorldServer world : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
                for (int i = 0; i < world.field_72996_f.size(); ++i) {
                    Object obj = world.field_72996_f.get(i);
                    if (!(obj instanceof EntityVillager)) continue;
                    EntityVillager villager = (EntityVillager)obj;
                    try {
                        if ((Integer)villager.func_184212_Q().func_187225_a(Constants.OVERWRITE_KEY) != 3577) continue;
                        this.doOverwriteVillager(villager);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        if (summonCounter > 0) {
            Utilities.spawnParticlesAroundPointS(EnumParticleTypes.PORTAL, summonWorld, summonPos.iX(), summonPos.iY(), summonPos.iZ(), 2);
            if (--summonCounter % 40 == 0) {
                double dX = summonPos.iX() + EventHooksFML.summonWorld.field_73012_v.nextInt(6) * (RadixLogic.getBooleanWithProbability((int)50) ? 1 : -1);
                double dZ = summonPos.iZ() + EventHooksFML.summonWorld.field_73012_v.nextInt(6) * (RadixLogic.getBooleanWithProbability((int)50) ? 1 : -1);
                double y = RadixLogic.getSpawnSafeTopLevel((World)summonWorld, (int)((int)dX), (int)((int)dZ));
                NetworkRegistry.TargetPoint lightningTarget = new NetworkRegistry.TargetPoint(EventHooksFML.summonWorld.field_73011_w.getDimension(), dX, y, dZ, 64.0);
                EntityLightningBolt lightning = new EntityLightningBolt(summonWorld, dX, y, dZ, false);
                summonWorld.func_72838_d((Entity)lightning);
                MCA.getPacketHandler().sendPacketToAllAround((IMessage)new PacketSpawnLightning(new Point3D(dX, y, dZ)), lightningTarget);
                if (summonCounter == 80) {
                    NetworkRegistry.TargetPoint summonTarget = new NetworkRegistry.TargetPoint(EventHooksFML.summonWorld.field_73011_w.getDimension(), (double)summonPos.iX(), (double)summonPos.iY(), (double)summonPos.iZ(), 32.0);
                    summonWorld.func_184133_a(null, new BlockPos(dX, y, dZ), SoundsMCA.reaper_summon, SoundCategory.HOSTILE, 1.0f, 1.0f);
                }
            }
            if (summonCounter == 0) {
                EntityGrimReaper reaper = new EntityGrimReaper(summonWorld);
                reaper.func_70107_b(summonPos.iX(), summonPos.iY(), summonPos.iZ());
                summonWorld.func_72838_d((Entity)reaper);
                summonPos = null;
                summonWorld = null;
            }
        }
        if (this.serverTickCounter <= 0 && MCA.getConfig().guardSpawnRate > 0) {
            ArrayList<EntityVillagerMCA> humans = new ArrayList<EntityVillagerMCA>();
            for (WorldServer world : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
                for (Object obj : world.field_72996_f) {
                    if (!(obj instanceof EntityVillagerMCA)) continue;
                    humans.add((EntityVillagerMCA)((Object)obj));
                }
            }
            if (!humans.isEmpty()) {
                for (int i = 0; i < 3; ++i) {
                    Point3D posAsPoint;
                    int numberOfVillagersAroundMe;
                    int neededNumberOfGuards;
                    EntityVillagerMCA human = (EntityVillagerMCA)((Object)humans.get(RadixMath.getNumberInRange((int)0, (int)(humans.size() - 1))));
                    List villagersAroundMe = RadixLogic.getEntitiesWithinDistance(EntityVillagerMCA.class, (Entity)human, (int)50);
                    int numberOfGuardsAroundMe = this.getNumberOfGuardsFromEntityList(villagersAroundMe);
                    if (numberOfGuardsAroundMe >= (neededNumberOfGuards = (numberOfVillagersAroundMe = villagersAroundMe.size() - numberOfGuardsAroundMe) / MCA.getConfig().guardSpawnRate)) continue;
                    EntityVillagerMCA guard = new EntityVillagerMCA(human.field_70170_p);
                    guard.attributes.assignRandomName();
                    guard.attributes.assignRandomGender();
                    guard.attributes.assignRandomPersonality();
                    guard.attributes.setProfession(EnumProfession.Guard);
                    guard.attributes.assignRandomSkin();
                    Vec3d pos = RandomPositionGenerator.func_75463_a((EntityCreature)human, (int)10, (int)1);
                    if (pos == null || !human.field_70170_p.func_175710_j((posAsPoint = new Point3D(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c)).toBlockPos())) continue;
                    guard.func_70107_b(pos.field_72450_a, (int)human.field_70163_u, pos.field_72449_c);
                    human.field_70170_p.func_72838_d((Entity)guard);
                }
            }
            this.serverTickCounter = 1200;
        }
        if (this.serverTickCounter <= 0 && MCA.getConfig().replenishEmptyVillages && RadixLogic.getBooleanWithProbability((int)25)) {
            for (WorldServer world : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
                block8: for (Object obj : world.field_72982_D.func_75540_b()) {
                    Village village = (Village)obj;
                    int populationCapacity = village.func_75567_c();
                    int population = 0;
                    double posX = village.func_180608_a().func_177958_n();
                    double posY = village.func_180608_a().func_177956_o();
                    double posZ = village.func_180608_a().func_177952_p();
                    Iterator iterator = RadixLogic.getEntitiesWithinDistance(EntityVillagerMCA.class, (World)world, (double)posX, (double)posY, (double)posZ, (int)village.func_75568_b()).iterator();
                    while (iterator.hasNext()) {
                        EntityVillagerMCA entity;
                        EntityVillagerMCA human = entity = (EntityVillagerMCA)((Object)iterator.next());
                        if (human.attributes.getProfessionSkinGroup() != EnumProfessionSkinGroup.Guard) {
                            ++population;
                        }
                        if (human.attributes.getBabyState() == EnumBabyState.NONE) continue;
                        ++population;
                    }
                    if (population >= populationCapacity) continue;
                    for (int tries = 0; tries < 3; ++tries) {
                        posX += (double)(world.field_73012_v.nextInt(village.func_75568_b()) * (RadixLogic.getBooleanWithProbability((int)50) ? 1 : -1));
                        posZ += (double)(world.field_73012_v.nextInt(village.func_75568_b()) * (RadixLogic.getBooleanWithProbability((int)50) ? 1 : -1));
                        double dY = RadixLogic.getSpawnSafeTopLevel((World)world, (int)((int)(posX += 0.5)), (int)((int)(posZ += 0.5)));
                        if (!(dY - posY <= 4.0)) continue;
                        Point3D pointOfSpawn = new Point3D(posX, dY, posZ);
                        MCA.naturallySpawnVillagers(pointOfSpawn, (World)world, -1);
                        continue block8;
                    }
                }
            }
        }
        --this.serverTickCounter;
    }

    @SubscribeEvent
    public void itemCraftedEventHandler(PlayerEvent.ItemCraftedEvent event) {
        block1: {
            ItemStack stack;
            int i = 0;
            if (i >= event.craftMatrix.func_70302_i_() || (stack = event.craftMatrix.func_70301_a(i)) == null || stack.func_77973_b() != ItemsMCA.NEEDLE_AND_STRING) break block1;
            stack.func_77972_a(1, (EntityLivingBase)event.player);
            if (stack.func_77952_i() < stack.func_77958_k()) {
                event.player.field_71071_by.func_70441_a(stack);
            }
        }
    }

    private void doOverwriteVillager(EntityVillager entity) {
        entity.func_70106_y();
        MCA.naturallySpawnVillagers(new Point3D(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v), entity.field_70170_p, entity.func_70946_n());
    }

    public static void setReaperSummonPoint(World world, Point3D point) {
        summonWorld = world;
        summonPos = point;
        summonCounter = 120;
    }

    private int getNumberOfGuardsFromEntityList(List<EntityVillagerMCA> entityList) {
        int returnValue = 0;
        for (EntityVillagerMCA entity : entityList) {
            if (entity.attributes.getProfessionSkinGroup() != EnumProfessionSkinGroup.Guard) continue;
            ++returnValue;
        }
        return returnValue;
    }
}

