/*
 * Decompiled with CFR 0.152.
 */
package mca.data;

import java.io.Serializable;
import java.util.UUID;
import javax.annotation.Nullable;
import mca.core.Constants;
import mca.core.MCA;
import mca.data.PlayerDataCollection;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumGender;
import mca.enums.EnumMarriageState;
import mca.packets.PacketPlayerDataC;
import mca.packets.PacketPlayerDataS;
import mca.util.Either;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class NBTPlayerData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private UUID uuid;
    private String mcaName;
    private int gender;
    private int genderPreference;
    private String spouseName;
    private UUID spouseUUID;
    private int spouseGender;
    private int marriageState;
    private boolean ownsBaby;
    private boolean isNobility;
    private boolean hasChosenDestiny;
    private boolean isSuperUser;
    private boolean happinessThresholdMet;
    public boolean ignoreBroadcast;

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_186854_a("uuid", this.uuid);
        nbt.func_74778_a("mcaName", this.mcaName == null || this.mcaName.isEmpty() ? "none" : this.mcaName);
        nbt.func_74768_a("gender", this.gender);
        nbt.func_74768_a("genderPreference", this.genderPreference);
        nbt.func_74778_a("spouseName", this.spouseName == null || this.spouseName.isEmpty() ? "none" : this.spouseName);
        nbt.func_186854_a("spouseUUID", this.spouseUUID == null ? Constants.EMPTY_UUID : this.spouseUUID);
        nbt.func_74768_a("marriageState", this.marriageState);
        nbt.func_74757_a("ownsBaby", this.ownsBaby);
        nbt.func_74757_a("isNobility", this.isNobility);
        nbt.func_74757_a("hasChosenDestiny", this.hasChosenDestiny);
        nbt.func_74757_a("isSuperUser", this.isSuperUser);
        nbt.func_74757_a("happinessThresholdMet", this.happinessThresholdMet);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.uuid = nbt.func_186857_a("uuid");
        this.mcaName = nbt.func_74779_i("mcaName");
        this.gender = nbt.func_74762_e("gender");
        this.genderPreference = nbt.func_74762_e("genderPreference");
        this.spouseName = nbt.func_74779_i("spouseName");
        this.spouseUUID = nbt.func_186857_a("spouseUUID");
        this.marriageState = nbt.func_74762_e("marriageState");
        this.ownsBaby = nbt.func_74767_n("ownsBaby");
        this.isNobility = nbt.func_74767_n("isNobility");
        this.hasChosenDestiny = nbt.func_74767_n("hasChosenDestiny");
        this.isSuperUser = nbt.func_74767_n("isSuperUser");
        this.happinessThresholdMet = nbt.func_74767_n("happinessThresholdMet");
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void setUUID(UUID value) {
        this.uuid = value;
        this.broadcastValueChange(FieldUpdateObj.get(FieldID.UUID, TypeID.UUID, value));
    }

    public UUID getSpouseUUID() {
        return this.spouseUUID;
    }

    public EnumGender getGenderPreference() {
        return EnumGender.byId(this.genderPreference);
    }

    public void setGenderPreference(EnumGender value) {
        this.genderPreference = value.getId();
        this.broadcastValueChange(FieldUpdateObj.get(FieldID.GENDER_PREFERENCE, TypeID.INT, value.getId()));
    }

    public EnumGender getGender() {
        return EnumGender.byId(this.gender);
    }

    public EnumGender getSpouseGender() {
        return EnumGender.byId(this.spouseGender);
    }

    public void setGender(EnumGender value) {
        this.gender = value.getId();
        this.broadcastValueChange(FieldUpdateObj.get(FieldID.GENDER, TypeID.INT, value.getId()));
    }

    public void setSpouseGender(EnumGender value) {
        this.spouseGender = value.getId();
        this.broadcastValueChange(FieldUpdateObj.get(FieldID.SPOUSE_GENDER, TypeID.INT, value.getId()));
    }

    public boolean getOwnsBaby() {
        return this.ownsBaby;
    }

    public void setOwnsBaby(boolean value) {
        this.ownsBaby = value;
        this.broadcastValueChange(FieldUpdateObj.get(FieldID.OWNS_BABY, TypeID.BOOLEAN, value));
    }

    public void setSpouseUUID(UUID value) {
        this.spouseUUID = value;
        this.broadcastValueChange(FieldUpdateObj.get(FieldID.SPOUSE_UUID, TypeID.UUID, value));
    }

    public EnumMarriageState getMarriageState() {
        return EnumMarriageState.byId(this.marriageState);
    }

    public void setMarriageState(EnumMarriageState value) {
        this.marriageState = value.getId();
        this.broadcastValueChange(FieldUpdateObj.get(FieldID.MARRIAGE_STATE, TypeID.INT, value.getId()));
    }

    public void setSpouse(@Nullable Either<EntityVillagerMCA, EntityPlayer> either) {
        if (either == null) {
            this.setSpouseName("");
            this.setSpouseUUID(Constants.EMPTY_UUID);
            this.setSpouseGender(EnumGender.UNASSIGNED);
            this.setMarriageState(EnumMarriageState.NOT_MARRIED);
        } else if (either.getLeft() != null) {
            EntityVillagerMCA spouse = either.getLeft();
            EntityPlayer player = spouse.field_70170_p.func_152378_a(this.uuid);
            spouse.startMarriage(Either.withR(player));
        } else if (either.getRight() != null) {
            EntityPlayer targetPlayer = either.getRight();
            EntityPlayer thisPlayer = targetPlayer.field_70170_p.func_152378_a(this.getUUID());
            NBTPlayerData targetPlayerData = MCA.getPlayerData(targetPlayer);
            this.setSpouseName(targetPlayer.func_70005_c_());
            this.setSpouseUUID(targetPlayerData.getUUID());
            this.setSpouseGender(targetPlayerData.getGender());
            this.setMarriageState(EnumMarriageState.MARRIED_TO_PLAYER);
            targetPlayerData.setSpouseName(thisPlayer.func_70005_c_());
            targetPlayerData.setSpouseUUID(this.getUUID());
            targetPlayerData.setSpouseGender(this.getGender());
            targetPlayerData.setMarriageState(EnumMarriageState.MARRIED_TO_PLAYER);
        }
    }

    public boolean getHasChosenDestiny() {
        return this.hasChosenDestiny;
    }

    public void setHasChosenDestiny(boolean value) {
        this.hasChosenDestiny = value;
        this.broadcastValueChange(FieldUpdateObj.get(FieldID.HAS_CHOSEN_DESTINY, TypeID.BOOLEAN, value));
    }

    public String getMcaName() {
        return this.mcaName;
    }

    public void setMcaName(String value) {
        this.mcaName = value;
        this.broadcastValueChange(FieldUpdateObj.get(FieldID.MCA_NAME, TypeID.STRING, value));
    }

    public String getSpouseName() {
        return this.spouseName;
    }

    public void setSpouseName(String value) {
        this.spouseName = value;
        this.broadcastValueChange(FieldUpdateObj.get(FieldID.SPOUSE_NAME, TypeID.STRING, value));
    }

    public boolean getIsSuperUser() {
        return this.isSuperUser;
    }

    public void setIsSuperUser(boolean value) {
        this.isSuperUser = value;
        this.broadcastValueChange(FieldUpdateObj.get(FieldID.IS_SUPER_USER, TypeID.BOOLEAN, value));
    }

    public boolean getIsNobility() {
        return this.isNobility;
    }

    public void setIsNobility(boolean value) {
        this.isNobility = value;
        this.broadcastValueChange(FieldUpdateObj.get(FieldID.IS_NOBILITY, TypeID.BOOLEAN, value));
    }

    public boolean getHappinessThresholdMet() {
        return this.happinessThresholdMet;
    }

    public void setHappinessThresholdMet(boolean value) {
        this.happinessThresholdMet = value;
        this.broadcastValueChange(FieldUpdateObj.get(FieldID.HAPPINESS_THRESHOLD_MET, TypeID.BOOLEAN, value));
    }

    private void broadcastValueChange(FieldUpdateObj fieldUpdate) {
        if (this.ignoreBroadcast) {
            this.ignoreBroadcast = false;
            return;
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            MCA.getPacketHandler().sendPacketToServer((IMessage)new PacketPlayerDataS(fieldUpdate));
        } else {
            PlayerDataCollection.get().func_76185_a();
            UUID ownerUUID = PlayerDataCollection.get().getUUIDByReference(this);
            if (ownerUUID != null) {
                EntityPlayer player = null;
                for (WorldServer server : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
                    EntityPlayer foundPlayer = server.func_152378_a(ownerUUID);
                    if (foundPlayer == null) continue;
                    player = foundPlayer;
                    break;
                }
                if (player != null) {
                    MCA.getPacketHandler().sendPacketToPlayer((IMessage)new PacketPlayerDataC(fieldUpdate), (EntityPlayer)((EntityPlayerMP)player));
                } else {
                    MCA.getLog().error("Error getting player instance by UUID");
                }
            } else {
                MCA.getLog().error("Error looking up player by UUID");
            }
        }
    }

    public void setByFieldUpdateObj(FieldUpdateObj obj) {
        this.ignoreBroadcast = true;
        switch (obj.fieldId) {
            case UUID: {
                this.setUUID((UUID)obj.value);
                break;
            }
            case SPOUSE_UUID: {
                this.setSpouseUUID((UUID)obj.value);
                break;
            }
            case GENDER: {
                this.setGender(EnumGender.byId((Integer)obj.value));
                break;
            }
            case SPOUSE_GENDER: {
                this.setSpouseGender(EnumGender.byId((Integer)obj.value));
                break;
            }
            case OWNS_BABY: {
                this.setOwnsBaby((Boolean)obj.value);
                break;
            }
            case MARRIAGE_STATE: {
                this.setMarriageState(EnumMarriageState.byId((Integer)obj.value));
                break;
            }
            case IS_NOBILITY: {
                this.setIsNobility((Boolean)obj.value);
                break;
            }
            case MCA_NAME: {
                this.setMcaName((String)obj.value);
                break;
            }
            case HAS_CHOSEN_DESTINY: {
                this.setHasChosenDestiny((Boolean)obj.value);
                break;
            }
            case GENDER_PREFERENCE: {
                this.setGenderPreference(EnumGender.byId((Integer)obj.value));
                break;
            }
            case IS_SUPER_USER: {
                this.setIsSuperUser((Boolean)obj.value);
                break;
            }
            case SPOUSE_NAME: {
                this.setSpouseName((String)obj.value);
                break;
            }
            case HAPPINESS_THRESHOLD_MET: {
                this.setHappinessThresholdMet((Boolean)obj.value);
            }
        }
        this.ignoreBroadcast = false;
    }

    public static class FieldUpdateObj {
        private static FieldUpdateObj instance;
        public TypeID typeId;
        public FieldID fieldId;
        public Object value;

        private FieldUpdateObj() {
        }

        public static FieldUpdateObj get(FieldID fieldId, TypeID typeId, Object value) {
            if (instance == null) {
                instance = new FieldUpdateObj();
            }
            FieldUpdateObj.instance.fieldId = fieldId;
            FieldUpdateObj.instance.typeId = typeId;
            FieldUpdateObj.instance.value = value;
            return instance;
        }
    }

    public static enum TypeID {
        STRING(1),
        BOOLEAN(2),
        INT(3),
        UUID(4);

        private int id;

        private TypeID(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static TypeID fromId(int id) {
            for (TypeID value : TypeID.values()) {
                if (value.id != id) continue;
                return value;
            }
            return null;
        }
    }

    public static enum FieldID {
        UUID(1),
        MCA_NAME(2),
        GENDER(3),
        GENDER_PREFERENCE(4),
        SPOUSE_NAME(5),
        SPOUSE_UUID(6),
        SPOUSE_GENDER(7),
        MARRIAGE_STATE(8),
        OWNS_BABY(9),
        IS_NOBILITY(10),
        HAS_CHOSEN_DESTINY(11),
        IS_SUPER_USER(12),
        HAPPINESS_THRESHOLD_MET(13);

        private int id;

        private FieldID(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static FieldID fromId(int id) {
            for (FieldID value : FieldID.values()) {
                if (value.id != id) continue;
                return value;
            }
            return null;
        }
    }
}

