/*
 * Decompiled with CFR 0.152.
 */
package mca.entity;

import java.util.ArrayList;
import java.util.List;
import mca.actions.AbstractAction;
import mca.actions.AbstractToggleAction;
import mca.actions.ActionAttackResponse;
import mca.actions.ActionBlink;
import mca.actions.ActionBuild;
import mca.actions.ActionCombat;
import mca.actions.ActionCook;
import mca.actions.ActionDefend;
import mca.actions.ActionFarm;
import mca.actions.ActionFish;
import mca.actions.ActionFollow;
import mca.actions.ActionGreet;
import mca.actions.ActionGrow;
import mca.actions.ActionHunt;
import mca.actions.ActionIdle;
import mca.actions.ActionMine;
import mca.actions.ActionPatrol;
import mca.actions.ActionProcreate;
import mca.actions.ActionRegenerate;
import mca.actions.ActionSleep;
import mca.actions.ActionStoryProgression;
import mca.actions.ActionUpdateMood;
import mca.actions.ActionWander;
import mca.actions.ActionWoodcut;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumGender;
import mca.enums.EnumProgressionStep;
import mca.enums.EnumSleepingState;
import net.minecraft.nbt.NBTTagCompound;

public class VillagerBehaviors {
    private EntityVillagerMCA actor;
    private List<AbstractAction> actions;

    public VillagerBehaviors(EntityVillagerMCA actor) {
        this.actor = actor;
        this.actions = new ArrayList<AbstractAction>();
        this.addAction(new ActionIdle(actor));
        this.addAction(new ActionRegenerate(actor));
        this.addAction(new ActionSleep(actor));
        this.addAction(new ActionFollow(actor));
        this.addAction(new ActionGreet(actor));
        this.addAction(new ActionStoryProgression(actor));
        this.addAction(new ActionProcreate(actor));
        this.addAction(new ActionAttackResponse(actor));
        this.addAction(new ActionPatrol(actor));
        this.addAction(new ActionGrow(actor));
        this.addAction(new ActionUpdateMood(actor));
        this.addAction(new ActionBlink(actor));
        this.addAction(new ActionBuild(actor));
        this.addAction(new ActionMine(actor));
        this.addAction(new ActionWoodcut(actor));
        this.addAction(new ActionHunt(actor));
        this.addAction(new ActionCook(actor));
        this.addAction(new ActionFarm(actor));
        this.addAction(new ActionFish(actor));
        this.addAction(new ActionDefend(actor));
        this.addAction(new ActionWander(actor));
        this.addAction(new ActionCombat(actor));
    }

    public void addAction(AbstractAction AI) {
        this.actions.add(AI);
    }

    public void onUpdate() {
        this.actor.getProfiler().func_76320_a("MCA Villager Behaviors");
        for (AbstractAction action : this.actions) {
            boolean doRun = action instanceof AbstractToggleAction ? ((AbstractToggleAction)action).getIsActive() : true;
            if (!doRun) continue;
            action.onUpdateCommon();
            if (this.actor.field_70170_p.field_72995_K) {
                action.onUpdateClient();
                continue;
            }
            action.onUpdateServer();
        }
        this.actor.getProfiler().func_76319_b();
    }

    public void writeToNBT(NBTTagCompound nbt) {
        for (AbstractAction action : this.actions) {
            action.writeToNBT(nbt);
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        for (AbstractAction action : this.actions) {
            action.readFromNBT(nbt);
        }
    }

    public <T extends AbstractAction> T getAction(Class<T> clazz) {
        for (AbstractAction action : this.actions) {
            if (action.getClass() != clazz) continue;
            return (T)action;
        }
        return null;
    }

    public boolean isToggleActionActive() {
        for (AbstractAction action : this.actions) {
            AbstractToggleAction tAction;
            if (!(action instanceof AbstractToggleAction) || !(tAction = (AbstractToggleAction)action).getIsActive()) continue;
            return true;
        }
        return false;
    }

    public String getActiveActionName() {
        for (AbstractAction action : this.actions) {
            AbstractToggleAction tAction;
            if (!(action instanceof AbstractToggleAction) || !(tAction = (AbstractToggleAction)action).getIsActive()) continue;
            return tAction.getName();
        }
        return "";
    }

    public void disableAllToggleActions() {
        for (AbstractAction action : this.actions) {
            if (!(action instanceof AbstractToggleAction)) continue;
            AbstractToggleAction tAction = (AbstractToggleAction)action;
            tAction.setIsActive(false);
        }
    }

    public final void onMarriageToVillager() {
        EntityVillagerMCA spouse = this.actor.attributes.getVillagerSpouseInstance();
        this.getAction(ActionStoryProgression.class).setProgressionStep(EnumProgressionStep.TRY_FOR_BABY);
        spouse.getBehavior(ActionStoryProgression.class).setProgressionStep(EnumProgressionStep.TRY_FOR_BABY);
        ActionStoryProgression story = this.actor.getBehavior(ActionStoryProgression.class);
        story.setProgressionStep(EnumProgressionStep.TRY_FOR_BABY);
        if (this.actor.attributes.getGender() == spouse.attributes.getGender()) {
            if (spouse.getBehavior(ActionStoryProgression.class).getIsDominant()) {
                this.actor.getBehavior(ActionStoryProgression.class).setDominant(false);
            }
        } else if (this.actor.attributes.getGender() == EnumGender.MALE) {
            this.actor.getBehavior(ActionStoryProgression.class).setDominant(true);
            spouse.getBehavior(ActionStoryProgression.class).setDominant(false);
        } else {
            this.actor.getBehavior(ActionStoryProgression.class).setDominant(false);
            spouse.getBehavior(ActionStoryProgression.class).setDominant(true);
        }
    }

    public final void onMarriageToPlayer() {
        this.getAction(ActionStoryProgression.class).setProgressionStep(EnumProgressionStep.FINISHED);
    }

    public final void onSay() {
        this.getAction(ActionIdle.class).reset();
        this.getAction(ActionSleep.class).setSleepingState(EnumSleepingState.INTERRUPTED);
    }

    public void onMarriageEnded() {
        this.getAction(ActionStoryProgression.class).reset();
    }
}

