/*
 * Decompiled with CFR 0.152.
 */
package mca.enums;

import mca.core.MCA;
import mca.enums.EnumInteraction;
import mca.enums.EnumMoodGroup;

public enum EnumMood {
    DEPRESSED(-3, EnumMoodGroup.GENERAL),
    SAD(-2, EnumMoodGroup.GENERAL),
    UNHAPPY(-1, EnumMoodGroup.GENERAL),
    PASSIVE(0, EnumMoodGroup.UNASSIGNED),
    FINE(1, EnumMoodGroup.GENERAL),
    HAPPY(2, EnumMoodGroup.GENERAL),
    OVERJOYED(3, EnumMoodGroup.GENERAL),
    BORED_TO_TEARS(-3, EnumMoodGroup.PLAYFUL),
    BORED(-2, EnumMoodGroup.PLAYFUL),
    UNINTERESTED(-1, EnumMoodGroup.PLAYFUL),
    SILLY(1, EnumMoodGroup.PLAYFUL),
    GIGGLY(2, EnumMoodGroup.PLAYFUL),
    ENTERTAINED(3, EnumMoodGroup.PLAYFUL),
    INFURIATED(-3, EnumMoodGroup.SERIOUS),
    ANGRY(-2, EnumMoodGroup.SERIOUS),
    ANNOYED(-1, EnumMoodGroup.SERIOUS),
    INTERESTED(1, EnumMoodGroup.SERIOUS),
    TALKATIVE(2, EnumMoodGroup.SERIOUS),
    PLEASED(3, EnumMoodGroup.SERIOUS);

    private int level;
    private EnumMoodGroup moodGroup;

    private EnumMood(int level, EnumMoodGroup moodGroup) {
        this.level = level;
        this.moodGroup = moodGroup;
    }

    public EnumMoodGroup getMoodGroup() {
        return this.moodGroup;
    }

    public int getLevel() {
        return this.level;
    }

    public String getFriendlyName() {
        String name = "mood." + this.name().toLowerCase();
        return MCA.getLocalizer().getString(name);
    }

    public int getSuccessModifierForInteraction(EnumInteraction interaction) {
        int base = 0;
        switch (interaction) {
            case CHAT: {
                base = this.moodGroup == EnumMoodGroup.GENERAL ? 5 : (this.moodGroup == EnumMoodGroup.PLAYFUL ? 0 : (this.moodGroup == EnumMoodGroup.SERIOUS ? 2 : 0));
                break;
            }
            case JOKE: {
                base = this.moodGroup == EnumMoodGroup.GENERAL ? 0 : (this.moodGroup == EnumMoodGroup.PLAYFUL ? 5 : (this.moodGroup == EnumMoodGroup.SERIOUS ? -3 : 0));
                break;
            }
            case SHAKE_HAND: {
                base = this.moodGroup == EnumMoodGroup.GENERAL ? 0 : (this.moodGroup == EnumMoodGroup.PLAYFUL ? 0 : (this.moodGroup == EnumMoodGroup.SERIOUS ? 5 : 0));
                break;
            }
            case TELL_STORY: {
                base = this.moodGroup == EnumMoodGroup.GENERAL ? 3 : (this.moodGroup == EnumMoodGroup.PLAYFUL ? 0 : (this.moodGroup == EnumMoodGroup.SERIOUS ? 3 : 0));
                break;
            }
            case FLIRT: {
                base = this.moodGroup == EnumMoodGroup.GENERAL ? 0 : (this.moodGroup == EnumMoodGroup.PLAYFUL ? 3 : (this.moodGroup == EnumMoodGroup.SERIOUS ? -2 : 0));
                break;
            }
            case HUG: {
                base = this.moodGroup == EnumMoodGroup.GENERAL ? 0 : (this.moodGroup == EnumMoodGroup.PLAYFUL ? 3 : (this.moodGroup == EnumMoodGroup.SERIOUS ? -2 : 0));
                break;
            }
            case KISS: {
                base = this.moodGroup == EnumMoodGroup.GENERAL ? 0 : (this.moodGroup == EnumMoodGroup.PLAYFUL ? 3 : (this.moodGroup == EnumMoodGroup.SERIOUS ? -2 : 0));
                break;
            }
        }
        return base * this.level;
    }

    public int getPointsModifierForInteraction(EnumInteraction interaction) {
        int base = 0;
        switch (interaction) {
            case CHAT: {
                base = this.moodGroup == EnumMoodGroup.GENERAL ? 3 : (this.moodGroup == EnumMoodGroup.PLAYFUL ? 0 : (this.moodGroup == EnumMoodGroup.SERIOUS ? 1 : 0));
                break;
            }
            case JOKE: {
                base = this.moodGroup == EnumMoodGroup.GENERAL ? 0 : (this.moodGroup == EnumMoodGroup.PLAYFUL ? 3 : (this.moodGroup == EnumMoodGroup.SERIOUS ? -2 : 0));
                break;
            }
            case SHAKE_HAND: {
                base = this.moodGroup == EnumMoodGroup.GENERAL ? 0 : (this.moodGroup == EnumMoodGroup.PLAYFUL ? 0 : (this.moodGroup == EnumMoodGroup.SERIOUS ? 3 : 0));
                break;
            }
            case TELL_STORY: {
                base = this.moodGroup == EnumMoodGroup.GENERAL ? 2 : (this.moodGroup == EnumMoodGroup.PLAYFUL ? 0 : (this.moodGroup == EnumMoodGroup.SERIOUS ? 2 : 0));
                break;
            }
            case FLIRT: {
                base = this.moodGroup == EnumMoodGroup.GENERAL ? 0 : (this.moodGroup == EnumMoodGroup.PLAYFUL ? 2 : (this.moodGroup == EnumMoodGroup.SERIOUS ? -1 : 0));
                break;
            }
            case HUG: {
                base = this.moodGroup == EnumMoodGroup.GENERAL ? 0 : (this.moodGroup == EnumMoodGroup.PLAYFUL ? 2 : (this.moodGroup == EnumMoodGroup.SERIOUS ? -1 : 0));
                break;
            }
            case KISS: {
                base = this.moodGroup == EnumMoodGroup.GENERAL ? 0 : (this.moodGroup == EnumMoodGroup.PLAYFUL ? 2 : (this.moodGroup == EnumMoodGroup.SERIOUS ? -1 : 0));
                break;
            }
        }
        return base * this.level;
    }
}

