/*
 * Decompiled with CFR 0.152.
 */
package mca.packets;

import io.netty.buffer.ByteBuf;
import java.util.List;
import mca.actions.ActionGrow;
import mca.actions.ActionStoryProgression;
import mca.actions.ActionUpdateMood;
import mca.api.IGiftableItem;
import mca.api.RegistryMCA;
import mca.core.Constants;
import mca.core.MCA;
import mca.core.minecraft.ItemsMCA;
import mca.data.NBTPlayerData;
import mca.data.PlayerMemory;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumBabyState;
import mca.enums.EnumMarriageState;
import mca.enums.EnumProfession;
import mca.enums.EnumProgressionStep;
import mca.inventory.VillagerInventory;
import mca.util.Either;
import mca.util.TutorialManager;
import mca.util.Utilities;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import radixcore.math.Point3D;
import radixcore.modules.RadixLogic;
import radixcore.modules.RadixMath;
import radixcore.modules.net.AbstractPacket;

public class PacketGift
extends AbstractPacket<PacketGift> {
    private int entityId;
    private int slot;

    public PacketGift() {
    }

    public PacketGift(EntityVillagerMCA human, int slot) {
        this.entityId = human.func_145782_y();
        this.slot = slot;
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.entityId = byteBuf.readInt();
        this.slot = byteBuf.readInt();
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.entityId);
        byteBuf.writeInt(this.slot);
    }

    private boolean handleWeddingRing(EntityPlayer player, EntityVillagerMCA human) {
        NBTPlayerData data = MCA.getPlayerData(player);
        PlayerMemory memory = human.attributes.getPlayerMemory(player);
        if (human.attributes.getIsChild() || !human.attributes.allowsIntimateInteractions(player)) {
            human.say("interaction.give.invalid", player);
        } else {
            if (data.getSpouseUUID() == human.getPersistentID() && human.attributes.getMarriageState() == EnumMarriageState.ENGAGED) {
                human.say("interaction.marry.success", player);
                human.startMarriage(Either.withR(player));
                memory.setIsHiredBy(false, 0);
                human.getBehavior(ActionUpdateMood.class).modifyMoodLevel(3.0f);
                Utilities.spawnParticlesAroundEntityS(EnumParticleTypes.HEART, (Entity)human, 16);
                TutorialManager.sendMessageToPlayer(player, "You are now married. You can have", "children by using the 'Procreate' button.");
                List nearbyVillagers = RadixLogic.getEntitiesWithinDistance(EntityVillagerMCA.class, (Entity)player, (int)30);
                for (EntityVillagerMCA villager : nearbyVillagers) {
                    PlayerMemory otherVillagerMemory = villager.attributes.getPlayerMemory(player);
                    otherVillagerMemory.setHasGift(true);
                }
                return true;
            }
            if (data.getSpouseUUID() == human.getPersistentID()) {
                human.say("interaction.marry.fail.marriedtogiver", player);
            } else if (human.attributes.getMarriageState() != EnumMarriageState.NOT_MARRIED) {
                human.say("interaction.marry.fail.marriedtoother", player);
            } else if (human.attributes.getMarriageState() == EnumMarriageState.ENGAGED && human.attributes.getSpouseUUID() != data.getUUID()) {
                human.say("interaction.engage.fail.engagedtoother", player);
            } else if (data.getMarriageState() != EnumMarriageState.NOT_MARRIED) {
                human.say("interaction.marry.fail.playermarried", player);
            } else if (memory.getHearts() < 95) {
                human.say("interaction.marry.fail.lowhearts", player);
                TutorialManager.sendMessageToPlayer(player, "You must have 5 golden hearts with", "a villager before marrying them.");
            } else {
                human.say("interaction.marry.success", player);
                human.startMarriage(Either.withR(player));
                memory.setIsHiredBy(false, 0);
                human.getBehavior(ActionUpdateMood.class).modifyMoodLevel(3.0f);
                Utilities.spawnParticlesAroundEntityS(EnumParticleTypes.HEART, (Entity)human, 16);
                TutorialManager.sendMessageToPlayer(player, "You are now married. You can have", "children by using the 'Procreate' button.");
                return true;
            }
        }
        return false;
    }

    private boolean handleMatchmakersRing(EntityPlayer player, EntityVillagerMCA human, ItemStack stack) {
        EntityVillagerMCA partner = (EntityVillagerMCA)RadixLogic.getClosestEntity((Point3D)Point3D.fromEntityPosition((Entity)human), (World)human.field_70170_p, (int)5, EntityVillagerMCA.class, (Entity)human);
        if (human.attributes.getIsChild()) {
            human.say("interaction.give.invalid", player);
        } else if (human.attributes.getMarriageState() == EnumMarriageState.MARRIED_TO_PLAYER || human.attributes.getMarriageState() == EnumMarriageState.MARRIED_TO_VILLAGER) {
            human.say("interaction.matchmaker.fail.married", player);
        } else if (human.attributes.getMarriageState() == EnumMarriageState.ENGAGED) {
            human.say("interaction.matchmaker.fail.engaged", player);
        } else if (stack.func_190916_E() < 2) {
            human.say("interaction.matchmaker.fail.needtwo", player);
            TutorialManager.sendMessageToPlayer(player, "You must have two matchmaker's rings", "in a stack to arrange a marriage.");
        } else {
            boolean partnerIsValid;
            boolean bl = partnerIsValid = !(partner == null || partner.attributes.getMarriageState() != EnumMarriageState.NOT_MARRIED || partner.attributes.getIsChild() || partner.attributes.getFatherUUID() != Constants.EMPTY_UUID && partner.attributes.getFatherUUID() == human.attributes.getFatherUUID() || partner.attributes.getMotherUUID() != Constants.EMPTY_UUID && partner.attributes.getMotherUUID() == human.attributes.getMotherUUID());
            if (partner == null) {
                human.say("interaction.matchmaker.fail.novillagers", player);
                TutorialManager.sendMessageToPlayer(player, "To arrange a marriage, have two rings in a stack and ", "make sure another marriable villager is nearby.");
            } else if (!partnerIsValid) {
                human.say("interaction.matchmaker.fail.invalid", player, new Object[]{partner});
                TutorialManager.sendMessageToPlayer(player, "A married villager, relative, or child was too close to this", "villager. Move this villager away from anyone not marriable.");
            } else {
                human.startMarriage(Either.withL(partner));
                Utilities.spawnParticlesAroundEntityS(EnumParticleTypes.HEART, (Entity)human, 16);
                Utilities.spawnParticlesAroundEntityS(EnumParticleTypes.HEART, (Entity)partner, 16);
                for (Object obj : human.field_70170_p.field_73010_i) {
                    EntityPlayer onlinePlayer = (EntityPlayer)obj;
                    if (!human.attributes.isPlayerAParent(onlinePlayer) && !partner.attributes.isPlayerAParent(onlinePlayer)) continue;
                }
                TutorialManager.sendMessageToPlayer(player, "These villagers are now married.", "They will have children in the near future.");
                return true;
            }
        }
        return false;
    }

    private boolean handleEngagementRing(EntityPlayer player, EntityVillagerMCA human) {
        NBTPlayerData data = MCA.getPlayerData(player);
        PlayerMemory memory = human.attributes.getPlayerMemory(player);
        if (human.attributes.getIsChild() || !human.attributes.allowsIntimateInteractions(player)) {
            human.say("interaction.give.invalid", player);
        } else if (data.getSpouseUUID() == human.getPersistentID()) {
            human.say("interaction.marry.fail.marriedtogiver", player);
        } else if (human.attributes.getMarriageState() == EnumMarriageState.MARRIED_TO_PLAYER || human.attributes.getMarriageState() == EnumMarriageState.MARRIED_TO_VILLAGER) {
            human.say("interaction.marry.fail.marriedtoother", player);
        } else if (human.attributes.getMarriageState() == EnumMarriageState.ENGAGED) {
            human.say("interaction.engage.fail.engagedtoother", player);
        } else if (data.getSpouseUUID() != Constants.EMPTY_UUID) {
            human.say("interaction.marry.fail.playermarried", player);
        } else if (memory.getHearts() < 95) {
            human.say("interaction.marry.fail.lowhearts", player);
            TutorialManager.sendMessageToPlayer(player, "You must have 5 golden hearts with", "a villager before proposing.");
        } else {
            human.say("interaction.engage.success", player);
            human.attributes.setFiancee(player);
            memory.setIsHiredBy(false, 0);
            human.getBehavior(ActionUpdateMood.class).modifyMoodLevel(3.0f);
            Utilities.spawnParticlesAroundEntityS(EnumParticleTypes.HEART, (Entity)human, 16);
            TutorialManager.sendMessageToPlayer(player, "You are now engaged. Now gift a wedding ring", "to get gifts from other villagers.");
            return true;
        }
        return false;
    }

    private boolean handleDivorcePapers(EntityPlayer player, EntityVillagerMCA human) {
        NBTPlayerData data = MCA.getPlayerData(player);
        PlayerMemory memory = human.attributes.getPlayerMemory(player);
        if (human.attributes.getIsChild()) {
            human.say("interaction.give.invalid", player);
        } else if (human.attributes.getMarriageState() == EnumMarriageState.NOT_MARRIED) {
            human.say("interaction.divorce.notmarried", player);
        } else if (human.attributes.isMarriedToAPlayer() && data.getSpouseUUID() != human.getPersistentID()) {
            human.say("interaction.divorce.notmarriedtoplayer", player);
        } else {
            if (human.attributes.isMarriedToAPlayer()) {
                memory.setHearts(-100);
                human.say("interaction.divorce.success", player);
                human.endMarriage();
                data.setSpouse(null);
                human.getBehavior(ActionUpdateMood.class).modifyMoodLevel(-10.0f);
                Utilities.spawnParticlesAroundEntityS(EnumParticleTypes.VILLAGER_ANGRY, (Entity)human, 16);
            } else {
                EntityVillagerMCA partner = human.attributes.getVillagerSpouseInstance();
                if (partner != null) {
                    partner.endMarriage();
                }
                human.endMarriage();
            }
            return true;
        }
        return false;
    }

    private boolean handleStandardGift(EntityPlayer player, EntityVillagerMCA human, int slot1, ItemStack stack) {
        int heartsModify;
        int giftValue;
        PlayerMemory memory = human.attributes.getPlayerMemory(player);
        Item queryObject = stack.func_77973_b() instanceof ItemBlock ? Block.func_149634_a((Item)stack.func_77973_b()) : stack.func_77973_b();
        int n = giftValue = RegistryMCA.getGiftMap().containsKey(queryObject) ? RegistryMCA.getGiftMap().get(queryObject) : -5;
        if (giftValue == -5 && stack.func_77973_b() instanceof IGiftableItem) {
            IGiftableItem item = (IGiftableItem)stack.func_77973_b();
            giftValue = item.getGiftValue();
        }
        String giftType = (heartsModify = RadixMath.clamp((int)(giftValue - memory.getInteractionFatigue() * 4), (int)-5, (int)Integer.MAX_VALUE)) <= 0 ? "bad" : (heartsModify <= 5 ? "good" : (heartsModify <= 10 ? "better" : "best"));
        memory.setHearts(memory.getHearts() + heartsModify);
        memory.increaseInteractionFatigue();
        human.say(memory.getDialogueType().toString() + ".gift." + giftType, player);
        if (giftValue > 0 && heartsModify <= 0) {
            TutorialManager.sendMessageToPlayer(player, "You have interacted with this villager too much.", "Wait before interacting again.");
        } else if (giftValue <= 0) {
            TutorialManager.sendMessageToPlayer(player, "This villager did not like your gift.", "Try a different item next time.");
        }
        if (heartsModify > 0) {
            human.getBehavior(ActionUpdateMood.class).modifyMoodLevel(1.0f);
            return true;
        }
        human.getBehavior(ActionUpdateMood.class).modifyMoodLevel(-1.0f);
        return false;
    }

    public void processOnGameThread(PacketGift packet, MessageContext context) {
        EntityVillagerMCA human = null;
        EntityPlayer player = null;
        for (WorldServer world : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
            player = this.getPlayer(context);
            human = (EntityVillagerMCA)world.func_73045_a(packet.entityId);
            if (player != null && human != null) break;
        }
        if (player != null && human != null) {
            ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(packet.slot);
            Item item = stack.func_77973_b();
            boolean removeItem = false;
            int removeCount = 1;
            if (item == ItemsMCA.WEDDING_RING || item == ItemsMCA.WEDDING_RING_RG) {
                removeItem = this.handleWeddingRing(player, human);
            } else if (item == ItemsMCA.MATCHMAKERS_RING) {
                removeItem = this.handleMatchmakersRing(player, human, stack);
                removeCount = 2;
            } else if (item == ItemsMCA.ENGAGEMENT_RING || item == ItemsMCA.ENGAGEMENT_RING_RG) {
                removeItem = this.handleEngagementRing(player, human);
            } else if (item == ItemsMCA.DIVORCE_PAPERS) {
                removeItem = this.handleDivorcePapers(player, human);
            } else if (item == ItemsMCA.BOOK_ROSE_GOLD && human.func_70005_c_().equals("William") && human.attributes.getProfessionEnum() == EnumProfession.Miner) {
                removeItem = true;
                human.sayRaw("Oh, thank you for returning this to me! My company secrets could have been lost forever!", player);
            } else if (human.attributes.getIsInfected() && human.func_70660_b(MobEffects.field_76437_t) != null && stack.func_77973_b() == Items.field_151153_ao) {
                removeItem = true;
                removeCount = 1;
                human.cureInfection();
            } else if (item == Items.field_151153_ao && human.attributes.getIsChild() && human.attributes.isPlayerAParent(player)) {
                removeItem = true;
                removeCount = 1;
                human.getBehavior(ActionGrow.class).accelerate();
            } else if ((item == ItemsMCA.BABY_BOY || item == ItemsMCA.BABY_GIRL) && human.attributes.getPlayerSpouseInstance() == player) {
                removeItem = true;
                removeCount = 1;
                human.attributes.getInventory().func_174894_a(stack);
            } else if (item == Items.field_151105_aU || Block.func_149634_a((Item)item) == Blocks.field_150414_aQ) {
                EnumProgressionStep step = human.getBehavior(ActionStoryProgression.class).getProgressionStep();
                if (human.attributes.isMarriedToAVillager() && human.attributes.getVillagerSpouseInstance() != null && RadixMath.getDistanceToEntity((Entity)human, (Entity)human.attributes.getVillagerSpouseInstance()) <= 8.5) {
                    EntityVillagerMCA spouse = human.attributes.getVillagerSpouseInstance();
                    removeItem = true;
                    removeCount = 1;
                    if (human.attributes.getBabyState() == EnumBabyState.NONE && spouse.attributes.getBabyState() == EnumBabyState.NONE) {
                        human.say("gift.cake" + RadixMath.getNumberInRange((int)1, (int)3), player);
                        EntityVillagerMCA progressor = !human.attributes.getIsMale() ? human : (!spouse.attributes.getIsMale() ? spouse : human);
                        human.getBehavior(ActionStoryProgression.class).setProgressionStep(EnumProgressionStep.HAD_BABY);
                        spouse.getBehavior(ActionStoryProgression.class).setProgressionStep(EnumProgressionStep.HAD_BABY);
                        Utilities.spawnParticlesAroundEntityS(EnumParticleTypes.HEART, (Entity)human, 16);
                        Utilities.spawnParticlesAroundEntityS(EnumParticleTypes.HEART, (Entity)spouse, 16);
                        progressor.attributes.setBabyState(EnumBabyState.getRandomGender());
                    } else {
                        human.sayRaw("We already have a baby.", player);
                    }
                    TutorialManager.sendMessageToPlayer(player, "Cake can influence villagers to have children.", "");
                } else if (human.attributes.isMarriedToAVillager() && human.attributes.getVillagerSpouseInstance() == null) {
                    human.sayRaw("I don't see my spouse anywhere...", player);
                } else {
                    removeCount = 1;
                    removeItem = this.handleStandardGift(player, human, packet.slot, stack);
                }
            } else if (item == ItemsMCA.NEW_OUTFIT && human.attributes.allowsControllingInteractions(player)) {
                Utilities.spawnParticlesAroundEntityS(EnumParticleTypes.VILLAGER_HAPPY, (Entity)human, 16);
                human.attributes.setClothesTexture(human.attributes.getProfessionSkinGroup().getRandomMaleSkin());
                removeItem = true;
                removeCount = 1;
            } else if (item instanceof ItemArmor) {
                removeItem = true;
                removeCount = 1;
                VillagerInventory inventory = human.attributes.getInventory();
                ItemArmor armor = (ItemArmor)item;
                int inventorySlot = 0;
                switch (armor.field_77881_a.func_188454_b()) {
                    case 3: {
                        inventorySlot = 36;
                        break;
                    }
                    case 2: {
                        inventorySlot = 37;
                        break;
                    }
                    case 1: {
                        inventorySlot = 38;
                        break;
                    }
                    case 0: {
                        inventorySlot = 39;
                    }
                }
                ItemStack stackInArmorSlot = inventory.func_70301_a(inventorySlot);
                if (stackInArmorSlot != null) {
                    human.func_70099_a(stackInArmorSlot, 1.0f);
                }
                inventory.func_70299_a(inventorySlot, new ItemStack(stack.func_77973_b(), 1, stack.func_77952_i()));
            } else {
                removeItem = this.handleStandardGift(player, human, packet.slot, stack);
            }
            if (removeItem && !player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(removeCount);
                if (stack.func_190916_E() > 0) {
                    player.field_71071_by.func_70299_a(packet.slot, stack);
                } else {
                    player.field_71071_by.func_70299_a(packet.slot, ItemStack.field_190927_a);
                }
            }
        }
    }
}

