/*
 * Decompiled with CFR 0.152.
 */
package mca.packets;

import io.netty.buffer.ByteBuf;
import java.util.Random;
import mca.core.Constants;
import mca.core.MCA;
import mca.core.minecraft.ItemsMCA;
import mca.data.NBTPlayerData;
import mca.enums.EnumInteraction;
import mca.enums.EnumMarriageState;
import mca.packets.PacketOpenBabyNameGUI;
import mca.packets.PacketOpenPrompt;
import mca.util.Either;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import radixcore.modules.net.AbstractPacket;

public class PacketInteractWithPlayerS
extends AbstractPacket<PacketInteractWithPlayerS> {
    private int interactionId;
    private int entityId;

    public PacketInteractWithPlayerS() {
    }

    public PacketInteractWithPlayerS(int interactionId, int entityId) {
        this.interactionId = interactionId;
        this.entityId = entityId;
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.interactionId = byteBuf.readInt();
        this.entityId = byteBuf.readInt();
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.interactionId);
        byteBuf.writeInt(this.entityId);
    }

    public void processOnGameThread(PacketInteractWithPlayerS packet, MessageContext context) {
        ItemStack stack2;
        EntityPlayer sender = this.getPlayer(context);
        EntityPlayer target = (EntityPlayer)sender.field_70170_p.func_73045_a(packet.entityId);
        NBTPlayerData senderData = MCA.getPlayerData(sender);
        NBTPlayerData targetData = MCA.getPlayerData(target);
        EnumInteraction interaction = EnumInteraction.fromId(packet.interactionId);
        boolean senderHasWeddingRing = false;
        for (ItemStack stack2 : sender.field_71071_by.field_70462_a) {
            Item item;
            if (stack2 == null || (item = stack2.func_77973_b()) != ItemsMCA.WEDDING_RING && item != ItemsMCA.WEDDING_RING_RG) continue;
            senderHasWeddingRing = true;
        }
        block0 : switch (interaction) {
            case ASKTOMARRY: {
                if (targetData.getSpouseUUID() != Constants.EMPTY_UUID || senderData.getMarriageState() != EnumMarriageState.NOT_MARRIED) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(MCA.getLocalizer().getString("interactionp.marry.fail.targetalreadymarried", target.func_70005_c_())));
                    break;
                }
                if (senderData.getSpouseUUID() != Constants.EMPTY_UUID || senderData.getMarriageState() != EnumMarriageState.NOT_MARRIED) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(MCA.getLocalizer().getString("interactionp.marry.fail.alreadymarried")));
                    break;
                }
                if (!senderHasWeddingRing) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(MCA.getLocalizer().getString("interactionp.marry.fail.noweddingring")));
                    break;
                }
                sender.func_145747_a((ITextComponent)new TextComponentString(MCA.getLocalizer().getString("interactionp.marry.sent", target.func_70005_c_())));
                MCA.getPacketHandler().sendPacketToPlayer((IMessage)new PacketOpenPrompt(sender, target, interaction), (EntityPlayer)((EntityPlayerMP)target));
                break;
            }
            case DIVORCE: {
                senderData.setSpouse(null);
                targetData.setSpouse(null);
                sender.func_145747_a((ITextComponent)new TextComponentString(MCA.getLocalizer().getString("\u00a7C" + MCA.getLocalizer().getString("interactionp.divorce.notify", target.func_70005_c_()))));
                target.func_145747_a((ITextComponent)new TextComponentString(MCA.getLocalizer().getString("\u00a7C" + MCA.getLocalizer().getString("interactionp.divorce.notify", sender.func_70005_c_()))));
                break;
            }
            case HAVEBABY: {
                if (senderData.getOwnsBaby()) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(MCA.getLocalizer().getString("interactionp.havebaby.fail.alreadyexists", target.func_70005_c_())));
                    break;
                }
                sender.func_145747_a((ITextComponent)new TextComponentString(MCA.getLocalizer().getString("interactionp.havebaby.sent", target.func_70005_c_())));
                MCA.getPacketHandler().sendPacketToPlayer((IMessage)new PacketOpenPrompt(sender, target, interaction), (EntityPlayer)((EntityPlayerMP)target));
                break;
            }
            case ASKTOMARRY_ACCEPT: {
                sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7A" + MCA.getLocalizer().getString("interactionp.marry.success", target.func_70005_c_())));
                target.func_145747_a((ITextComponent)new TextComponentString("\u00a7A" + MCA.getLocalizer().getString("interactionp.marry.success", sender.func_70005_c_())));
                senderData.setSpouse(Either.withR(target));
                for (int i = 0; i < target.field_71071_by.func_70302_i_(); ++i) {
                    stack2 = target.field_71071_by.func_70301_a(i);
                    if (stack2 == null || stack2.func_77973_b() != ItemsMCA.WEDDING_RING && stack2.func_77973_b() != ItemsMCA.WEDDING_RING_RG) continue;
                    target.field_71071_by.func_184437_d(stack2);
                    break block0;
                }
                break;
            }
            case HAVEBABY_ACCEPT: {
                senderData.setOwnsBaby(true);
                targetData.setOwnsBaby(true);
                boolean isMale = new Random().nextBoolean();
                stack2 = new ItemStack((Item)(isMale ? ItemsMCA.BABY_BOY : ItemsMCA.BABY_GIRL));
                target.field_71071_by.func_70441_a(stack2);
                MCA.getPacketHandler().sendPacketToPlayer((IMessage)new PacketOpenBabyNameGUI(isMale), (EntityPlayer)((EntityPlayerMP)target));
            }
        }
    }
}

