/*
 * Decompiled with CFR 0.152.
 */
package mca.tile;

import java.util.UUID;
import mca.core.MCA;
import mca.data.PlayerMemory;
import mca.data.TransitiveVillagerData;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumDialogueType;
import mca.enums.EnumGender;
import mca.enums.EnumMemorialType;
import mca.enums.EnumRelation;
import mca.packets.PacketMemorialUpdateGet;
import mca.util.Either;
import mca.util.Utilities;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import radixcore.modules.RadixBlocks;

public class TileMemorial
extends TileEntity
implements ITickable {
    private EnumMemorialType type;
    private TransitiveVillagerData data;
    private String ownerName;
    private EnumRelation ownerRelation;
    private UUID ownerUUID;
    private int revivalTicks;
    private EntityPlayer player;
    private boolean hasSynced;

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K && !this.hasSynced) {
            this.hasSynced = true;
            MCA.getPacketHandler().sendPacketToServer((IMessage)new PacketMemorialUpdateGet(this));
        }
        if (!this.field_145850_b.field_72995_K) {
            int x = this.field_174879_c.func_177958_n();
            int y = this.field_174879_c.func_177956_o();
            int z = this.field_174879_c.func_177952_p();
            if (this.player == null || this.player.field_70128_L) {
                this.revivalTicks = 0;
            }
            if (this.revivalTicks == 1) {
                EntityVillagerMCA human = new EntityVillagerMCA(this.field_145850_b);
                human.attributes.copyFrom(this.data);
                human.func_70107_b((double)x + 0.5, y, (double)z + 0.5);
                this.field_145850_b.func_72838_d((Entity)human);
                RadixBlocks.setBlock((World)this.field_145850_b, (int)x, (int)y, (int)z, (Block)Blocks.field_150350_a);
                Utilities.spawnParticlesAroundEntityS(EnumParticleTypes.VILLAGER_HAPPY, (Entity)human, 32);
                Utilities.spawnParticlesAroundPointS(EnumParticleTypes.FIREWORKS_SPARK, this.field_145850_b, (double)x + 0.5, y, (double)z + 0.5, 16);
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187625_bm, SoundCategory.AMBIENT, 3.0f, 1.0f);
                if (this.ownerRelation == EnumRelation.NONE) {
                    return;
                }
                if (this.getType() == EnumMemorialType.BROKEN_RING) {
                    PlayerMemory memory = human.attributes.getPlayerMemory(this.player);
                    human.startMarriage(Either.withR(this.player));
                    memory.setHearts(100);
                    memory.setDialogueType(EnumDialogueType.SPOUSE);
                    memory.setRelation(human.attributes.getGender() == EnumGender.MALE ? EnumRelation.HUSBAND : EnumRelation.WIFE);
                } else {
                    PlayerMemory memory = human.attributes.getPlayerMemory(this.player);
                    memory.setHearts(100);
                    memory.setDialogueType(EnumDialogueType.CHILDP);
                    memory.setRelation(human.attributes.getGender() == EnumGender.MALE ? EnumRelation.SON : EnumRelation.DAUGHTER);
                }
            } else if (this.revivalTicks > 0) {
                --this.revivalTicks;
                Utilities.spawnParticlesAroundPointS(EnumParticleTypes.SPELL_INSTANT, this.field_145850_b, (double)x + 0.5, y, (double)z + 0.5, 2);
                if (this.revivalTicks == 40 || this.revivalTicks == 20) {
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187625_bm, SoundCategory.AMBIENT, 3.0f, 1.0f);
                    Utilities.spawnParticlesAroundPointS(EnumParticleTypes.FIREWORKS_SPARK, this.field_145850_b, (double)x + 0.5, y, (double)z + 0.5, 32);
                }
                if (this.revivalTicks < 40) {
                    Utilities.spawnParticlesAroundPointS(EnumParticleTypes.VILLAGER_HAPPY, this.field_145850_b, (double)x + 0.5, y, (double)z + 0.5, 2);
                }
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("type", this.type.getId());
        this.data.writeToNBT(nbt);
        nbt.func_74778_a("ownerName", this.ownerName);
        nbt.func_74768_a("relation", this.ownerRelation.getId());
        nbt.func_186854_a("ownerUUID", this.ownerUUID);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.data = new TransitiveVillagerData(nbt);
        this.type = EnumMemorialType.fromId(nbt.func_74762_e("type"));
        this.ownerName = nbt.func_74779_i("ownerName");
        this.ownerRelation = EnumRelation.getById(nbt.func_74762_e("relation"));
        this.ownerUUID = nbt.func_186857_a("ownerUUID");
    }

    public void setType(EnumMemorialType type) {
        this.type = type;
    }

    public EnumMemorialType getType() {
        return this.type;
    }

    public TransitiveVillagerData getTransitiveVillagerData() {
        return this.data;
    }

    public void setTransitiveVillagerData(TransitiveVillagerData data) {
        this.data = data;
    }

    public void setRevivalTicks(int value) {
        this.revivalTicks = value;
    }

    public void setPlayer(EntityPlayer player) {
        this.player = player;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public void setRelation(EnumRelation relation) {
        this.ownerRelation = relation;
    }

    public EnumRelation getRelation() {
        return this.ownerRelation;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public int getRevivalTicks() {
        return this.revivalTicks;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwnerUUID(UUID uuid) {
        this.ownerUUID = uuid;
    }
}

