/*
 * Decompiled with CFR 0.152.
 */
package mca.util;

import mca.actions.ActionStoryProgression;
import mca.core.Constants;
import mca.core.MCA;
import mca.data.NBTPlayerData;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumBabyState;
import mca.enums.EnumGender;
import mca.enums.EnumMarriageState;
import mca.enums.EnumProfession;
import mca.enums.EnumProgressionStep;
import mca.util.Either;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class IngameTester {
    private IngameTester() {
    }

    public static void run(EntityPlayer player) {
        EntityVillagerMCA adam = new EntityVillagerMCA(player.field_70170_p);
        EntityVillagerMCA eve = new EntityVillagerMCA(player.field_70170_p);
        adam.func_70107_b(player.field_70165_t + 2.0, player.field_70163_u, player.field_70161_v);
        eve.func_70107_b(player.field_70165_t + 1.0, player.field_70163_u, player.field_70161_v);
        player.field_70170_p.func_72838_d((Entity)adam);
        player.field_70170_p.func_72838_d((Entity)eve);
        for (int i = 0; i < 5000; ++i) {
            adam.attributes.assignRandomGender();
            adam.attributes.assignRandomName();
            adam.attributes.assignRandomPersonality();
            adam.attributes.assignRandomScale();
            adam.attributes.assignRandomSkin();
            try {
                IngameTester.assertTrue(!adam.attributes.getName().isEmpty());
                IngameTester.assertTrue(adam.attributes.getGender() != EnumGender.UNASSIGNED);
                IngameTester.assertTrue(adam.attributes.getProfessionEnum() != EnumProfession.Unassigned);
                IngameTester.assertTrue(!adam.attributes.getClothesTexture().isEmpty());
                IngameTester.assertTrue(!adam.attributes.getHeadTexture().isEmpty());
                continue;
            }
            catch (AssertionError e) {
                ((Throwable)((Object)e)).printStackTrace();
                IngameTester.failTest("Villager creation", player);
                adam.func_70106_y();
                eve.func_70106_y();
                return;
            }
        }
        adam.attributes.setGender(EnumGender.MALE);
        eve.attributes.setGender(EnumGender.FEMALE);
        adam.attributes.setName("Adam");
        eve.attributes.setName("Eve");
        adam.attributes.assignRandomSkin();
        eve.attributes.assignRandomPersonality();
        eve.attributes.assignRandomProfession();
        eve.attributes.assignRandomSkin();
        IngameTester.passTest("Villager creation", player);
        try {
            adam.startMarriage(Either.withL(eve));
            IngameTester.assertTrue(adam.attributes.getMarriageState() == EnumMarriageState.MARRIED_TO_VILLAGER);
            IngameTester.assertTrue(adam.attributes.getSpouseGender() == eve.attributes.getGender());
            IngameTester.assertTrue(adam.attributes.getSpouseName().equals(eve.attributes.getName()));
            IngameTester.assertTrue(adam.attributes.getSpouseUUID() == eve.getPersistentID());
            IngameTester.assertTrue(eve.attributes.getMarriageState() == EnumMarriageState.MARRIED_TO_VILLAGER);
            IngameTester.assertTrue(eve.attributes.getSpouseGender() == adam.attributes.getGender());
            IngameTester.assertTrue(eve.attributes.getSpouseName().equals(adam.attributes.getName()));
            IngameTester.assertTrue(eve.attributes.getSpouseUUID() == adam.getPersistentID());
            IngameTester.assertTrue(adam.getBehavior(ActionStoryProgression.class).getIsDominant());
            IngameTester.assertTrue(!eve.getBehavior(ActionStoryProgression.class).getIsDominant());
            IngameTester.assertTrue(adam.getBehaviors().getAction(ActionStoryProgression.class).getProgressionStep() == EnumProgressionStep.TRY_FOR_BABY);
            IngameTester.assertTrue(eve.getBehaviors().getAction(ActionStoryProgression.class).getProgressionStep() == EnumProgressionStep.TRY_FOR_BABY);
            adam.attributes.setTicksAlive(MCA.getConfig().storyProgressionThreshold * 1200);
            eve.attributes.setTicksAlive(MCA.getConfig().storyProgressionThreshold * 1200);
            boolean success = false;
            ActionStoryProgression story = adam.getBehavior(ActionStoryProgression.class);
            for (int i = 0; i < 50000; ++i) {
                adam.getBehaviors().onUpdate();
                if (story.getProgressionStep() != EnumProgressionStep.HAD_BABY) continue;
                success = true;
                break;
            }
            IngameTester.assertTrue(success);
            story = eve.getBehavior(ActionStoryProgression.class);
            IngameTester.assertTrue(story.getProgressionStep() == EnumProgressionStep.HAD_BABY);
            IngameTester.assertTrue(eve.attributes.getBabyState() != EnumBabyState.NONE);
            adam.endMarriage();
            eve.endMarriage();
            IngameTester.assertTrue(story.getProgressionStep() == EnumProgressionStep.HAD_BABY);
            IngameTester.assertTrue(eve.attributes.getBabyState() != EnumBabyState.NONE);
            IngameTester.assertTrue(adam.getBehavior(ActionStoryProgression.class).getProgressionStep() == EnumProgressionStep.SEARCH_FOR_PARTNER);
            eve.attributes.setBabyState(EnumBabyState.NONE);
        }
        catch (AssertionError e) {
            ((Throwable)((Object)e)).printStackTrace();
            IngameTester.failTest("Villager marriage and story simulation", player);
            return;
        }
        IngameTester.passTest("Villager marriage and story simulation", player);
        try {
            NBTPlayerData playerData = MCA.getPlayerData(player);
            playerData.setSpouse(Either.withL(eve));
            IngameTester.assertTrue(eve.attributes.getMarriageState() == EnumMarriageState.MARRIED_TO_PLAYER);
            IngameTester.assertTrue(eve.getBehavior(ActionStoryProgression.class).getProgressionStep() == EnumProgressionStep.FINISHED);
            IngameTester.assertTrue(eve.attributes.getSpouseGender() == playerData.getGender());
            IngameTester.assertTrue(eve.attributes.getSpouseName().equals(player.func_70005_c_()));
            IngameTester.assertTrue(eve.attributes.getSpouseUUID().equals(playerData.getUUID()));
            IngameTester.assertTrue(playerData.getSpouseGender() == eve.attributes.getGender());
            IngameTester.assertTrue(playerData.getSpouseUUID().equals(eve.getPersistentID()));
            IngameTester.assertTrue(playerData.getSpouseName().equals(eve.attributes.getName()));
            eve.endMarriage();
            playerData.setSpouse(null);
            IngameTester.assertTrue(eve.attributes.getMarriageState() == EnumMarriageState.NOT_MARRIED);
            IngameTester.assertTrue(eve.getBehavior(ActionStoryProgression.class).getProgressionStep() == EnumProgressionStep.SEARCH_FOR_PARTNER);
            IngameTester.assertTrue(eve.attributes.getSpouseGender() == EnumGender.UNASSIGNED);
            IngameTester.assertTrue(eve.attributes.getSpouseUUID() == Constants.EMPTY_UUID);
            IngameTester.assertTrue(eve.attributes.getSpouseName().isEmpty());
            IngameTester.assertTrue(playerData.getSpouseGender() == EnumGender.UNASSIGNED);
            IngameTester.assertTrue(playerData.getSpouseUUID().equals(Constants.EMPTY_UUID));
            IngameTester.assertTrue(playerData.getSpouseName().isEmpty());
        }
        catch (AssertionError e) {
            ((Throwable)((Object)e)).printStackTrace();
            IngameTester.failTest("Player marriage", player);
            return;
        }
        IngameTester.passTest("Player marriage", player);
    }

    private static void addMessage(String message, EntityPlayer player) {
        player.func_145747_a((ITextComponent)new TextComponentString("\u00a76[\u00a74MCA\u00a76] \u00a7r" + message));
    }

    private static void passTest(String testName, EntityPlayer player) {
        IngameTester.addMessage("- " + testName + ": " + "\u00a7A" + "[PASS]", player);
    }

    private static void failTest(String testName, EntityPlayer player) {
        IngameTester.addMessage("- " + testName + ": " + "\u00a7C" + "[FAIL]", player);
    }

    private static void assertTrue(boolean expression) throws AssertionError {
        if (!expression) {
            throw new AssertionError();
        }
    }

    private static void assertFalse(boolean expression) throws AssertionError {
        if (expression) {
            throw new AssertionError();
        }
    }
}

