/*
 * Decompiled with CFR 0.152.
 */
package mca.util;

import mca.core.MCA;
import mca.packets.PacketSetTutorialMessage;
import mca.util.TutorialMessage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class TutorialManager {
    private static boolean firstMessageShown;
    private static boolean turnOffMessageShown;
    private static int timeSinceFirstMessage;
    private static TutorialMessage currentMessage;
    private static TutorialMessage prevMessage;
    private static int prevAnimationProgress;
    private static int animationProgress;
    private static int timeAnimationHeld;
    private static int yMax;
    private static int state;

    private TutorialManager() {
    }

    public static void onUpdate() {
        if (MCA.getConfig().inTutorialMode) {
            if (firstMessageShown && !turnOffMessageShown && ++timeSinceFirstMessage >= 500) {
                TutorialManager.setTutorialMessage(new TutorialMessage("You can turn off these messages at the Main Menu.", "Select Mods->Minecraft Comes Alive->Config->Tutorial mode->false."));
                turnOffMessageShown = true;
            }
            if (currentMessage != null) {
                if (state == 0) {
                    if (++animationProgress >= yMax) {
                        state = 1;
                    }
                } else if (state == 1) {
                    if (++timeAnimationHeld >= 400) {
                        state = 2;
                    }
                } else if (state == 2 && --animationProgress <= 0) {
                    currentMessage = null;
                    return;
                }
                currentMessage.draw(animationProgress);
            }
            if (prevMessage != null) {
                if (--prevAnimationProgress <= 0) {
                    prevMessage = null;
                    return;
                }
                prevMessage.draw(prevAnimationProgress);
            }
        }
    }

    public static void setTutorialMessage(TutorialMessage message) {
        firstMessageShown = true;
        if (currentMessage != null) {
            prevMessage = currentMessage;
            prevAnimationProgress = animationProgress;
        }
        animationProgress = 0;
        timeAnimationHeld = 0;
        state = 0;
        currentMessage = message;
    }

    public static void forceState(int newState) {
        state = newState;
    }

    public static TutorialMessage getCurrentMessage() {
        return currentMessage;
    }

    public static void sendMessageToPlayer(EntityPlayer player, String line1, String line2) {
        MCA.getPacketHandler().sendPacketToPlayer((IMessage)new PacketSetTutorialMessage(new TutorialMessage(line1, line2)), (EntityPlayer)((EntityPlayerMP)player));
    }

    static {
        prevAnimationProgress = 0;
        animationProgress = 0;
        timeAnimationHeld = 0;
        yMax = 24;
        state = 0;
    }
}

