/*
 * Decompiled with CFR 0.152.
 */
package mca.actions;

import mca.actions.AbstractAction;
import mca.core.MCA;
import mca.data.PlayerMemory;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumPersonality;
import mca.enums.EnumProfessionSkinGroup;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.util.FakePlayer;
import radixcore.modules.RadixMath;

public class ActionAttackResponse
extends AbstractAction {
    private String targetPlayerName;
    private Entity target;
    private boolean isRetaliating;

    public ActionAttackResponse(EntityVillagerMCA entityHuman) {
        super(entityHuman);
    }

    @Override
    public void onUpdateServer() {
        if (!this.actor.attributes.getIsChild() && this.isRetaliating && this.actor.func_110143_aJ() > 0.0f && !this.actor.attributes.getIsInfected()) {
            if (this.target instanceof EntityPlayerMP && !this.target.func_70005_c_().equals("[CoFH]") && !(this.target instanceof FakePlayer)) {
                EntityPlayer targetPlayer = (EntityPlayer)this.target;
                if (targetPlayer != null) {
                    double distanceToPlayer = RadixMath.getDistanceToEntity((Entity)this.actor, (Entity)targetPlayer);
                    if (distanceToPlayer >= 10.0) {
                        this.actor.say("behavior.retaliate.distanced", targetPlayer);
                        this.reset();
                    } else if (this.playerHasWeapon(targetPlayer)) {
                        this.handlePlayerWithWeapon();
                    } else if (this.actor.func_70661_as().func_75500_f()) {
                        this.actor.func_70661_as().func_75497_a((Entity)targetPlayer, (double)0.7f);
                    } else if (distanceToPlayer <= 1.8) {
                        this.actor.swingItem();
                        targetPlayer.func_70097_a(DamageSource.field_76377_j, 1.0f);
                        this.reset();
                    }
                } else {
                    this.target = this.actor.field_70170_p.func_72924_a(this.targetPlayerName);
                    if (this.target == null) {
                        this.reset();
                    }
                }
            } else if (this.target != null) {
                double distanceToTarget = RadixMath.getDistanceToEntity((Entity)this.actor, (Entity)this.target);
                if (distanceToTarget >= 10.0) {
                    this.reset();
                } else if (this.actor.func_70661_as().func_75500_f()) {
                    this.actor.func_70661_as().func_75497_a(this.target, (double)0.7f);
                } else if (distanceToTarget <= 1.8) {
                    float attackDamage = this.actor.attributes.getProfessionSkinGroup() == EnumProfessionSkinGroup.Guard ? (float)MCA.getConfig().guardAttackDamage : (float)MCA.getConfig().villagerAttackDamage;
                    this.actor.swingItem();
                    this.target.func_70097_a(DamageSource.field_76377_j, attackDamage);
                    this.reset();
                }
            }
        }
    }

    @Override
    public void reset() {
        this.isRetaliating = false;
        this.targetPlayerName = null;
        this.actor.func_70661_as().func_75499_g();
    }

    public void startResponse(Entity entity) {
        if (this.getIsRetaliating()) {
            return;
        }
        if (this.actor.attributes.getPersonality() == EnumPersonality.PEACEFUL) {
            return;
        }
        if (entity instanceof EntityPlayerMP && !entity.func_70005_c_().equals("[CoFH]") && !(entity instanceof FakePlayer)) {
            EntityPlayer player = (EntityPlayer)entity;
            this.target = player;
            if (this.playerHasWeapon(player)) {
                this.handlePlayerWithWeapon();
            } else {
                this.actor.say("behavior.retaliate.begin", player);
                this.isRetaliating = true;
                this.targetPlayerName = player.func_70005_c_();
                PlayerMemory memory = this.actor.attributes.getPlayerMemory(player);
                memory.setHearts(memory.getHearts() - 5);
            }
        } else {
            this.target = entity;
            this.isRetaliating = true;
        }
    }

    private boolean playerHasWeapon(EntityPlayer player) {
        ItemStack heldItem = player.field_71071_by.func_70448_g();
        if (heldItem != null) {
            return heldItem.func_77973_b() instanceof ItemSword || heldItem.func_77973_b() instanceof ItemBow;
        }
        return false;
    }

    private void handlePlayerWithWeapon() {
        try {
            this.actor.say("behavior.retaliate.weapondrawn", (EntityPlayer)this.target);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.reset();
    }

    public boolean getIsRetaliating() {
        return this.isRetaliating;
    }
}

