/*
 * Decompiled with CFR 0.152.
 */
package mca.actions;

import java.util.List;
import mca.actions.AbstractAction;
import mca.actions.ActionSleep;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumCombatBehaviors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import radixcore.modules.RadixLogic;
import radixcore.modules.RadixMath;

public class ActionCombat
extends AbstractAction {
    private static final DataParameter<Integer> ATTACK_METHOD_ID = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ATTACK_TRIGGER_ID = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ATTACK_TARGET_ID = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187192_b);
    private EntityLivingBase attackTarget;
    private int rangedAttackTime;

    public ActionCombat(EntityVillagerMCA actor) {
        super(actor);
        this.setMethodBehavior(EnumCombatBehaviors.METHOD_DO_NOT_FIGHT);
        this.setTriggerBehavior(EnumCombatBehaviors.TRIGGER_PLAYER_TAKE_DAMAGE);
        this.setTargetBehavior(EnumCombatBehaviors.TARGET_HOSTILE_MOBS);
    }

    @Override
    public void onUpdateServer() {
        if (this.actor.getBehavior(ActionSleep.class).getIsSleeping()) {
            return;
        }
        if (this.attackTarget != null && this.getMethodBehavior() == EnumCombatBehaviors.METHOD_DO_NOT_FIGHT) {
            this.attackTarget = null;
            return;
        }
        if (this.attackTarget != null && (this.attackTarget.field_70128_L || this.attackTarget.func_110143_aJ() <= 0.0f)) {
            this.attackTarget = null;
        }
        if (this.attackTarget == null && this.getTriggerBehavior() == EnumCombatBehaviors.TRIGGER_ALWAYS) {
            this.findAttackTarget();
        } else if (this.attackTarget != null) {
            double distanceToTarget = RadixMath.getDistanceToEntity((Entity)this.actor, (Entity)this.attackTarget);
            if (this.getMethodBehavior() == EnumCombatBehaviors.METHOD_MELEE_ONLY || this.getMethodBehavior() == EnumCombatBehaviors.METHOD_MELEE_AND_RANGED && distanceToTarget < 5.0) {
                this.moveToAttackTarget();
                if (distanceToTarget < 1.5) {
                    this.actor.swingItem();
                    ItemStack heldItem = this.actor.func_184586_b(EnumHand.MAIN_HAND);
                    Item.ToolMaterial swordMaterial = null;
                    if (heldItem != null && heldItem.func_77973_b() instanceof ItemSword) {
                        ItemSword sword = (ItemSword)heldItem.func_77973_b();
                        swordMaterial = Item.ToolMaterial.valueOf((String)sword.func_150932_j());
                    }
                    float damage = swordMaterial != null ? 4.0f + swordMaterial.func_78000_c() : 0.5f;
                    this.attackTarget.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.actor), damage);
                }
            } else if (this.getMethodBehavior() == EnumCombatBehaviors.METHOD_RANGED_ONLY || this.getMethodBehavior() == EnumCombatBehaviors.METHOD_MELEE_AND_RANGED && distanceToTarget >= 5.0) {
                this.actor.func_70671_ap().func_75650_a(this.attackTarget.field_70165_t, this.attackTarget.field_70163_u + (double)this.attackTarget.func_70047_e(), this.attackTarget.field_70161_v, 10.0f, (float)this.actor.func_70646_bf());
                if (this.rangedAttackTime <= 0) {
                    EntityTippedArrow arrow = new EntityTippedArrow(this.actor.field_70170_p, (EntityLivingBase)this.actor);
                    double dX = this.attackTarget.field_70165_t - this.actor.field_70165_t;
                    double dY = this.attackTarget.func_174813_aQ().field_72338_b + (double)(this.attackTarget.field_70131_O / 3.0f) - arrow.field_70163_u;
                    double dZ = this.attackTarget.field_70161_v - this.actor.field_70161_v;
                    double d3 = MathHelper.func_76133_a((double)(dX * dX + dZ * dZ));
                    arrow.func_70186_c(dX, dY + d3 * (double)0.2f, dZ, 1.6f, (float)(14 - this.actor.field_70170_p.func_175659_aa().func_151525_a() * 4));
                    arrow.func_70239_b(5.0 + this.actor.func_70681_au().nextGaussian() * 0.25 + (double)((float)this.actor.field_70170_p.func_175659_aa().func_151525_a() * 0.11f));
                    this.actor.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.actor.func_70681_au().nextFloat() * 0.4f + 0.8f));
                    this.actor.field_70170_p.func_72838_d((Entity)arrow);
                    this.rangedAttackTime = 60;
                } else {
                    --this.rangedAttackTime;
                }
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("attackMethodId", ((Integer)this.actor.func_184212_Q().func_187225_a(ATTACK_METHOD_ID)).intValue());
        nbt.func_74768_a("attackTriggerId", ((Integer)this.actor.func_184212_Q().func_187225_a(ATTACK_TRIGGER_ID)).intValue());
        nbt.func_74768_a("attackTargetId", ((Integer)this.actor.func_184212_Q().func_187225_a(ATTACK_TARGET_ID)).intValue());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.setMethodBehavior(EnumCombatBehaviors.getById(nbt.func_74762_e("attackMethodId")));
        this.setTriggerBehavior(EnumCombatBehaviors.getById(nbt.func_74762_e("attackTriggerId")));
        this.setTargetBehavior(EnumCombatBehaviors.getById(nbt.func_74762_e("attackTargetId")));
    }

    public EnumCombatBehaviors getMethodBehavior() {
        return EnumCombatBehaviors.getById((Integer)this.actor.func_184212_Q().func_187225_a(ATTACK_METHOD_ID));
    }

    public EnumCombatBehaviors getTriggerBehavior() {
        return EnumCombatBehaviors.getById((Integer)this.actor.func_184212_Q().func_187225_a(ATTACK_TRIGGER_ID));
    }

    public EnumCombatBehaviors getTargetBehavior() {
        return EnumCombatBehaviors.getById((Integer)this.actor.func_184212_Q().func_187225_a(ATTACK_TARGET_ID));
    }

    public void setMethodBehavior(EnumCombatBehaviors value) {
        this.actor.func_184212_Q().func_187227_b(ATTACK_METHOD_ID, (Object)value.getNumericId());
    }

    public void setTriggerBehavior(EnumCombatBehaviors value) {
        this.actor.func_184212_Q().func_187227_b(ATTACK_TRIGGER_ID, (Object)value.getNumericId());
    }

    public void setTargetBehavior(EnumCombatBehaviors value) {
        this.actor.func_184212_Q().func_187227_b(ATTACK_TARGET_ID, (Object)value.getNumericId());
    }

    private void findAttackTarget() {
        List entitiesAroundMe = RadixLogic.getEntitiesWithinDistance(EntityLivingBase.class, (Entity)this.actor, (int)10);
        double distance = 100.0;
        EntityLivingBase target = null;
        for (EntityLivingBase livingBase : entitiesAroundMe) {
            double distanceTo = RadixMath.getDistanceToEntity((Entity)this.actor, (Entity)livingBase);
            if (!this.isEntityValidToAttack(livingBase) || !(distanceTo < distance)) continue;
            distance = RadixMath.getDistanceToEntity((Entity)this.actor, (Entity)livingBase);
            target = livingBase;
        }
        this.attackTarget = target;
    }

    private void moveToAttackTarget() {
        this.actor.func_70661_as().func_75497_a((Entity)this.attackTarget, (double)0.7f);
    }

    public boolean isEntityValidToAttack(EntityLivingBase entity) {
        if (entity instanceof EntityMob && (this.getTargetBehavior() == EnumCombatBehaviors.TARGET_HOSTILE_MOBS || this.getTargetBehavior() == EnumCombatBehaviors.TARGET_PASSIVE_OR_HOSTILE_MOBS)) {
            return true;
        }
        return entity instanceof EntityAnimal && (this.getTargetBehavior() == EnumCombatBehaviors.TARGET_PASSIVE_MOBS || this.getTargetBehavior() == EnumCombatBehaviors.TARGET_PASSIVE_OR_HOSTILE_MOBS);
    }

    public void setAttackTarget(EntityLivingBase entity) {
        if (entity != this.actor) {
            this.attackTarget = entity;
        }
    }

    public EntityLivingBase getAttackTarget() {
        return this.attackTarget;
    }

    @Override
    protected void registerDataParameters() {
        this.actor.func_184212_Q().func_187214_a(ATTACK_METHOD_ID, (Object)EnumCombatBehaviors.METHOD_DO_NOT_FIGHT.getNumericId());
        this.actor.func_184212_Q().func_187214_a(ATTACK_TRIGGER_ID, (Object)EnumCombatBehaviors.TRIGGER_PLAYER_DEAL_DAMAGE.getNumericId());
        this.actor.func_184212_Q().func_187214_a(ATTACK_TARGET_ID, (Object)EnumCombatBehaviors.TARGET_PASSIVE_MOBS.getNumericId());
    }

    public ItemStack getHeldItem() {
        if (this.getMethodBehavior() == EnumCombatBehaviors.METHOD_RANGED_ONLY) {
            return this.actor.attributes.getInventory().getBestItemOfType(ItemBow.class);
        }
        return this.actor.attributes.getInventory().getBestItemOfType(ItemSword.class);
    }
}

