/*
 * Decompiled with CFR 0.152.
 */
package mca.actions;

import java.util.List;
import mca.actions.AbstractAction;
import mca.actions.ActionSleep;
import mca.core.MCA;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumProfession;
import mca.enums.EnumProfessionSkinGroup;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import radixcore.modules.RadixLogic;
import radixcore.modules.RadixMath;

public class ActionDefend
extends AbstractAction {
    private static final int TARGET_SEARCH_INTERVAL = 20;
    private EntityLiving target;
    private int timeUntilTargetSearch;
    private int rangedAttackTime;

    public ActionDefend(EntityVillagerMCA actor) {
        super(actor);
    }

    @Override
    public void onUpdateServer() {
        if (this.actor.getBehavior(ActionSleep.class).getIsSleeping()) {
            return;
        }
        if (this.actor.attributes.getProfessionSkinGroup() == EnumProfessionSkinGroup.Guard && !this.actor.attributes.getIsInfected()) {
            if (this.target == null) {
                if (this.timeUntilTargetSearch <= 0) {
                    this.tryAssignTarget();
                    this.timeUntilTargetSearch = 20;
                } else {
                    --this.timeUntilTargetSearch;
                }
            } else if (this.target != null) {
                double distanceToTarget = RadixMath.getDistanceToEntity((Entity)this.actor, (Entity)this.target);
                if (this.target.field_70128_L || distanceToTarget >= 15.0) {
                    this.reset();
                    return;
                }
                if (this.actor.attributes.getProfessionEnum() == EnumProfession.Archer) {
                    this.actor.func_70671_ap().func_75650_a(this.target.field_70165_t, this.target.field_70163_u + (double)this.target.func_70047_e(), this.target.field_70161_v, 10.0f, (float)this.actor.func_70646_bf());
                    if (this.rangedAttackTime <= 0) {
                        this.attackTargetWithRangedAttack(this.actor, 3.0f);
                        this.actor.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.actor.func_70681_au().nextFloat() * 0.4f + 0.8f));
                        this.rangedAttackTime = 60;
                    } else {
                        --this.rangedAttackTime;
                    }
                } else if (distanceToTarget <= 2.0) {
                    this.actor.swingItem();
                    if (this.actor.field_70122_E) {
                        this.actor.field_70181_x += (double)0.45f;
                    }
                    try {
                        this.target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.actor), (float)MCA.getConfig().guardAttackDamage);
                    }
                    catch (NullPointerException e) {
                        this.reset();
                    }
                } else if (distanceToTarget > 2.0 && this.actor.func_70661_as().func_75500_f()) {
                    this.actor.func_70661_as().func_75497_a((Entity)this.target, (double)0.7f);
                }
            }
        }
    }

    @Override
    public void reset() {
        this.target = null;
        this.rangedAttackTime = 0;
    }

    private void tryAssignTarget() {
        List possibleTargets = RadixLogic.getEntitiesWithinDistance(EntityMob.class, (Entity)this.actor, (int)15);
        double closestDistance = 100.0;
        for (Entity entity : possibleTargets) {
            double distance;
            if (entity instanceof EntityCreeper || !this.actor.func_70685_l(entity) || !((distance = RadixMath.getDistanceToEntity((Entity)this.actor, (Entity)entity)) < closestDistance)) continue;
            closestDistance = distance;
            this.target = (EntityLiving)entity;
        }
    }

    private void attackTargetWithRangedAttack(EntityVillagerMCA shooter, float velocity) {
        EntityTippedArrow entityarrow = new EntityTippedArrow(shooter.field_70170_p, (EntityLivingBase)shooter);
        double d0 = this.target.field_70165_t - shooter.field_70165_t;
        double d1 = this.target.func_174813_aQ().field_72338_b + (double)(this.target.field_70131_O / 3.0f) - entityarrow.field_70163_u;
        double d2 = this.target.field_70161_v - shooter.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        entityarrow.func_70186_c(d0, d1 + d3 * 0.2, d2, 1.6f, (float)(14 - shooter.field_70170_p.func_175659_aa().func_151525_a() * 4));
        int i = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185309_u, (EntityLivingBase)shooter);
        int j = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185310_v, (EntityLivingBase)shooter);
        entityarrow.func_70239_b((double)(velocity * 2.0f) + shooter.func_70681_au().nextGaussian() * 0.25 + (double)((float)shooter.field_70170_p.func_175659_aa().func_151525_a() * 0.11f));
        if (i > 0) {
            entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)i * 0.5 + 0.5);
        }
        if (j > 0) {
            entityarrow.func_70240_a(j);
        }
        shooter.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (shooter.func_70681_au().nextFloat() * 0.4f + 0.8f));
        shooter.field_70170_p.func_72838_d((Entity)entityarrow);
    }
}

