/*
 * Decompiled with CFR 0.152.
 */
package mca.actions;

import java.util.List;
import java.util.UUID;
import mca.actions.AbstractToggleAction;
import mca.api.FishingEntry;
import mca.api.RegistryMCA;
import mca.core.MCA;
import mca.entity.EntityChoreFishHook;
import mca.entity.EntityVillagerMCA;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import radixcore.math.Point3D;
import radixcore.modules.RadixLogic;
import radixcore.modules.RadixMath;

public class ActionFish
extends AbstractToggleAction {
    private EntityChoreFishHook hook;
    private boolean hasWaterPoint;
    private boolean hasFishingTarget;
    private int waterCoordinatesX;
    private int waterCoordinatesY;
    private int waterCoordinatesZ;
    private int idleFishingTime;

    public ActionFish(EntityVillagerMCA actor) {
        super(actor);
        this.setIsActive(false);
    }

    public void startFishing(EntityPlayer player) {
        this.assigningPlayer = player != null ? player.func_110124_au() : new UUID(0L, 0L);
        this.setIsActive(true);
    }

    @Override
    public void onUpdateServer() {
        if (!MCA.getConfig().allowFishingChore) {
            this.notifyAssigningPlayer("\u00a7CThis chore is disabled.");
            this.reset();
            return;
        }
        try {
            this.doItemVerification();
            if (!this.hasWaterPoint) {
                this.trySetWaterCoordinates();
                return;
            }
            if (!this.canFishingBegin()) {
                this.actor.func_70661_as().func_75484_a(this.actor.func_70661_as().func_75488_a((double)this.waterCoordinatesX, (double)this.waterCoordinatesY, (double)this.waterCoordinatesZ), (double)0.6f);
                return;
            }
            this.actor.func_70661_as().func_75499_g();
            if (this.hasFishingTarget) {
                if (this.idleFishingTime < 20) {
                    this.doFishingIdleUpdate();
                } else {
                    if (this.hook == null || this.hook.field_70128_L) {
                        this.hook = new EntityChoreFishHook(this.actor.field_70170_p, this.actor);
                        this.actor.field_70170_p.func_72838_d((Entity)this.hook);
                        this.actor.swingItem();
                    }
                    this.doFaceFishEntity();
                    this.doFishingActiveUpdate();
                }
            } else {
                this.doSetFishingTarget();
            }
        }
        catch (Exception e) {
            this.reset();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("isFishingActive", this.getIsActive());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.setIsActive(nbt.func_74767_n("isFishingActive"));
    }

    @Override
    public String getName() {
        return "Fishing";
    }

    private boolean trySetWaterCoordinates() {
        Point3D waterCoordinates = RadixLogic.getNearestBlock((Entity)this.actor, (int)10, (Block)Blocks.field_150355_j);
        if (waterCoordinates == null) {
            this.actor.say(MCA.getLocalizer().getString("fishing.nowater"), this.getAssigningPlayer());
            this.reset();
            return false;
        }
        this.waterCoordinatesX = waterCoordinates.iX();
        this.waterCoordinatesY = waterCoordinates.iY();
        this.waterCoordinatesZ = waterCoordinates.iZ();
        this.hasWaterPoint = true;
        return true;
    }

    private boolean canFishingBegin() {
        return RadixLogic.getNearestBlock((Entity)this.actor, (int)1, (Block)Blocks.field_150355_j) != null;
    }

    private void doSetFishingTarget() {
        List nearbyWater = RadixLogic.getNearbyBlocks((Entity)this.actor, (Block)Blocks.field_150355_j, (int)10);
        Point3D randomNearbyWater = (Point3D)nearbyWater.get(RadixMath.getNumberInRange((int)0, (int)(nearbyWater.size() - 1)));
        this.waterCoordinatesX = randomNearbyWater.iX();
        this.waterCoordinatesY = randomNearbyWater.iY();
        this.waterCoordinatesZ = randomNearbyWater.iZ();
        this.hasFishingTarget = true;
    }

    private void doFishingIdleUpdate() {
        if (this.hook != null) {
            this.hook.func_70106_y();
        }
        this.actor.facePosition(new Point3D(this.waterCoordinatesX, this.waterCoordinatesY, this.waterCoordinatesZ));
        ++this.idleFishingTime;
    }

    public void doFishCatchAttempt() {
        int catchChance = this.getFishCatchChance();
        if (RadixLogic.getBooleanWithProbability((int)catchChance)) {
            try {
                FishingEntry entry = RegistryMCA.getRandomFishingEntry();
                int amountToAdd = this.getFishAmountToAdd();
                Item fishItem = entry.getFishItem();
                this.actor.attributes.getInventory().func_174894_a(new ItemStack(fishItem, amountToAdd, entry.getItemDamage()));
                this.actor.damageHeldItem(1);
                if (this.actor.attributes.getInventory().containsCountOf(Items.field_151115_aP, 64)) {
                    this.actor.say(MCA.getLocalizer().getString("notify.child.chore.finished.fishing"), this.getAssigningPlayer());
                    this.reset();
                    return;
                }
                this.idleFishingTime = 0;
                this.hasFishingTarget = false;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            this.hook = null;
            this.idleFishingTime = 0;
            this.hasFishingTarget = false;
        }
    }

    private void doFishingActiveUpdate() {
        if (this.hook == null || this.hook.field_70128_L) {
            this.idleFishingTime = 0;
            this.trySetWaterCoordinates();
        }
    }

    private void doFaceFishEntity() {
        if (this.hook != null) {
            this.actor.func_70671_ap().func_75651_a((Entity)this.hook, 16.0f, 2.0f);
        }
    }

    private void doItemVerification() {
        if (this.actor instanceof EntityVillagerMCA && !this.actor.attributes.getInventory().contains((Item)Items.field_151112_aM)) {
            this.actor.say("fishing.norod", this.getAssigningPlayer());
            this.reset();
            return;
        }
        this.actor.setHeldItem(this.actor.attributes.getInventory().func_70301_a(this.actor.attributes.getInventory().getFirstSlotContainingItem((Item)Items.field_151112_aM)).func_77973_b());
    }

    private int getFishCatchChance() {
        return 30;
    }

    private int getFishAmountToAdd() {
        return 1;
    }

    public void setHookEntity(EntityChoreFishHook hook) {
        this.hook = hook;
    }

    public void resetFishTargetPosition() {
        this.hasFishingTarget = false;
        this.idleFishingTime = 0;
    }
}

