/*
 * Decompiled with CFR 0.152.
 */
package mca.actions;

import com.google.common.base.Optional;
import java.util.UUID;
import mca.actions.AbstractAction;
import mca.core.Constants;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumMovementState;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import radixcore.modules.RadixMath;

public class ActionFollow
extends AbstractAction {
    private static final DataParameter<Optional<UUID>> FOLLOWING_UUID = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187203_m);

    public ActionFollow(EntityVillagerMCA entityHuman) {
        super(entityHuman);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_186854_a("followingUUID", this.getFollowingUUID());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.setFollowingUUID(nbt.func_186857_a("followingUUID"));
    }

    @Override
    public void onUpdateServer() {
        if (this.actor.attributes.getMovementState() == EnumMovementState.FOLLOW) {
            EntityHorse horse;
            EntityLiving entityPathController = (EntityLiving)(this.actor.func_184187_bx() instanceof EntityHorse ? this.actor.func_184187_bx() : this.actor);
            EntityPlayer entityFollowing = this.actor.field_70170_p.func_152378_a(this.getFollowingUUID());
            if (entityPathController instanceof EntityHorse && (horse = (EntityHorse)entityPathController).func_110257_ck()) {
                horse.func_110251_o(false);
            }
            if (entityFollowing != null) {
                entityPathController.func_70671_ap().func_75651_a((Entity)entityFollowing, 10.0f, (float)this.actor.func_70646_bf());
                double distanceToTarget = RadixMath.getDistanceToEntity((Entity)this.actor, (Entity)entityFollowing);
                if (distanceToTarget >= 15.0 && entityFollowing.func_174813_aQ() != null) {
                    int i = MathHelper.func_76128_c((double)entityFollowing.field_70165_t) - 2;
                    int j = MathHelper.func_76128_c((double)entityFollowing.field_70161_v) - 2;
                    int k = MathHelper.func_76128_c((double)entityFollowing.func_174813_aQ().field_72338_b);
                    for (int l = 0; l <= 4; ++l) {
                        for (int i1 = 0; i1 <= 4; ++i1) {
                            if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !entityFollowing.field_70170_p.func_180495_p(new BlockPos(i + l, k - 1, j + i1)).func_185917_h() || !this.isBlockSpawnable(new BlockPos(i + l, k, j + i1)) || !this.isBlockSpawnable(new BlockPos(i + l, k + 1, j + i1))) continue;
                            this.actor.func_70012_b((float)(i + l) + 0.5f, k, (float)(j + i1) + 0.5f, this.actor.field_70177_z, this.actor.field_70125_A);
                            this.actor.func_70661_as().func_75499_g();
                            return;
                        }
                    }
                } else if (distanceToTarget >= 4.5 && this.actor.func_70661_as().func_75500_f()) {
                    float speed = entityPathController instanceof EntityHorse ? 1.4f : (entityFollowing.func_70051_ag() ? 0.8f : this.actor.attributes.getSpeed());
                    entityPathController.func_70661_as().func_75497_a((Entity)entityFollowing, (double)speed);
                    entityPathController.func_70625_a((Entity)entityFollowing, 16.0f, 16.0f);
                } else if (distanceToTarget <= 2.0) {
                    entityPathController.func_70661_as().func_75499_g();
                }
            } else {
                this.actor.attributes.setMovementState(EnumMovementState.MOVE);
            }
        }
    }

    public UUID getFollowingUUID() {
        return (UUID)((Optional)this.actor.func_184212_Q().func_187225_a(FOLLOWING_UUID)).get();
    }

    public void setFollowingUUID(UUID value) {
        this.actor.func_184212_Q().func_187227_b(FOLLOWING_UUID, (Object)Optional.of((Object)value));
    }

    private boolean isBlockSpawnable(BlockPos pos) {
        IBlockState iblockstate = this.actor.field_70170_p.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        return block == Blocks.field_150350_a ? true : !iblockstate.func_185917_h();
    }

    @Override
    protected void registerDataParameters() {
        this.actor.func_184212_Q().func_187214_a(FOLLOWING_UUID, Constants.EMPTY_UUID_OPT);
    }
}

