/*
 * Decompiled with CFR 0.152.
 */
package mca.actions;

import mca.actions.AbstractAction;
import mca.core.MCA;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumBabyState;
import mca.enums.EnumGender;
import mca.enums.EnumMarriageState;
import mca.enums.EnumProgressionStep;
import mca.util.Either;
import mca.util.Utilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import radixcore.modules.RadixLogic;
import radixcore.modules.RadixMath;

public class ActionStoryProgression
extends AbstractAction {
    private int ticksUntilNextProgress;
    private int babyAge;
    private int numChildren;
    private boolean isDominant = true;
    private EnumProgressionStep progressionStep;
    private boolean forceNextProgress;

    public ActionStoryProgression(EntityVillagerMCA entityHuman) {
        super(entityHuman);
        this.ticksUntilNextProgress = MCA.getConfig() != null ? MCA.getConfig().storyProgressionRate : 20;
        this.setProgressionStep(EnumProgressionStep.SEARCH_FOR_PARTNER);
    }

    @Override
    public void onUpdateServer() {
        if (MCA.getConfig().storyProgression && this.actor.attributes.getTicksAlive() >= MCA.getConfig().storyProgressionThreshold * 1200 && this.isDominant && !this.actor.attributes.getIsChild() && !this.actor.attributes.getIsEngaged()) {
            if (this.ticksUntilNextProgress <= 0 || this.forceNextProgress) {
                this.ticksUntilNextProgress = MCA.getConfig().storyProgressionRate * 1200;
                if (RadixLogic.getBooleanWithProbability((int)75)) {
                    switch (this.progressionStep) {
                        case FINISHED: {
                            break;
                        }
                        case HAD_BABY: {
                            this.doAgeBaby();
                            break;
                        }
                        case TRY_FOR_BABY: {
                            this.doTryForBaby();
                            break;
                        }
                        case SEARCH_FOR_PARTNER: {
                            this.doPartnerSearch();
                            break;
                        }
                        case UNKNOWN: {
                            break;
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else {
                --this.ticksUntilNextProgress;
            }
        }
    }

    @Override
    public void reset() {
        if (this.actor.attributes.getBabyState() == EnumBabyState.NONE) {
            this.actor.attributes.setTicksAlive(0);
            this.ticksUntilNextProgress = MCA.getConfig().storyProgressionRate;
            this.setProgressionStep(EnumProgressionStep.SEARCH_FOR_PARTNER);
            this.isDominant = true;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("ticksUntilNextProgress", this.ticksUntilNextProgress);
        nbt.func_74768_a("babyAge", this.babyAge);
        nbt.func_74757_a("isDominant", this.isDominant);
        nbt.func_74768_a("numChildren", this.numChildren);
        nbt.func_74768_a("progressionStep", this.progressionStep.getId());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.ticksUntilNextProgress = nbt.func_74762_e("ticksUntilNextProgress");
        this.babyAge = nbt.func_74762_e("babyAge");
        this.isDominant = nbt.func_74767_n("isDominant");
        this.numChildren = nbt.func_74762_e("numChildren");
        this.setProgressionStep(EnumProgressionStep.getFromId(nbt.func_74762_e("progressionStep")));
    }

    private void doPartnerSearch() {
        boolean partnerIsValid;
        EntityVillagerMCA partner = (EntityVillagerMCA)RadixLogic.getClosestEntityExclusive((Entity)this.actor, (int)15, EntityVillagerMCA.class);
        boolean bl = partnerIsValid = partner != null && partner.attributes.getGender() != this.actor.attributes.getGender() && partner.attributes.getMarriageState() == EnumMarriageState.NOT_MARRIED && !partner.attributes.getIsChild() && partner.attributes.getFatherUUID() != this.actor.attributes.getFatherUUID() && partner.attributes.getMotherUUID() != this.actor.attributes.getMotherUUID();
        if (partnerIsValid) {
            this.actor.startMarriage(Either.withL(partner));
        }
    }

    private void doTryForBaby() {
        EntityVillagerMCA mate = this.actor.attributes.getVillagerSpouseInstance();
        int villagersInArea = RadixLogic.getEntitiesWithinDistance(EntityVillagerMCA.class, (Entity)this.actor, (int)32).size();
        if (villagersInArea >= MCA.getConfig().storyProgressionCap && MCA.getConfig().storyProgressionCap != -1 && !this.forceNextProgress) {
            return;
        }
        if (RadixLogic.getBooleanWithProbability((int)50) && mate != null && RadixMath.getDistanceToEntity((Entity)this.actor, (Entity)mate) <= 8.5) {
            ActionStoryProgression mateAI = this.getMateAI(this.actor.attributes.getVillagerSpouseInstance());
            this.setProgressionStep(EnumProgressionStep.HAD_BABY);
            mateAI.setProgressionStep(EnumProgressionStep.HAD_BABY);
            Utilities.spawnParticlesAroundEntityS(EnumParticleTypes.HEART, (Entity)this.actor, 16);
            Utilities.spawnParticlesAroundEntityS(EnumParticleTypes.HEART, (Entity)mate, 16);
            this.isDominant = false;
            mateAI.isDominant = true;
            mate.attributes.setBabyState(EnumBabyState.getRandomGender());
            ++this.numChildren;
            ++mateAI.numChildren;
            for (Object obj : this.actor.field_70170_p.field_73010_i) {
                EntityPlayer onlinePlayer = (EntityPlayer)obj;
                if (!this.actor.attributes.isPlayerAParent(onlinePlayer) && !mate.attributes.isPlayerAParent(onlinePlayer)) continue;
            }
        }
    }

    private void doAgeBaby() {
        EntityVillagerMCA mate = this.actor.attributes.getVillagerSpouseInstance();
        ++this.babyAge;
        if (this.babyAge <= MCA.getConfig().babyGrowUpTime) {
            boolean actorIsMother;
            EntityVillagerMCA child = new EntityVillagerMCA(this.actor.field_70170_p);
            child.attributes.setGender(this.actor.attributes.getBabyState().isMale() ? EnumGender.MALE : EnumGender.FEMALE);
            child.attributes.setIsChild(true);
            child.attributes.assignRandomPersonality();
            child.attributes.assignRandomProfession();
            child.attributes.assignRandomScale();
            child.attributes.assignRandomName();
            child.attributes.assignRandomSkin();
            boolean bl = actorIsMother = this.actor.attributes.getGender() == EnumGender.FEMALE;
            if (actorIsMother) {
                child.attributes.setMother(Either.withL(this.actor));
                child.attributes.setFatherGender(this.actor.attributes.getSpouseGender());
                child.attributes.setFatherName(this.actor.attributes.getSpouseName());
                child.attributes.setFatherUUID(this.actor.attributes.getSpouseUUID());
            } else {
                child.attributes.setFather(Either.withL(this.actor));
                child.attributes.setMotherGender(this.actor.attributes.getSpouseGender());
                child.attributes.setMotherName(this.actor.attributes.getSpouseName());
                child.attributes.setMotherUUID(this.actor.attributes.getSpouseUUID());
            }
            child.func_70107_b(this.actor.field_70165_t, this.actor.field_70163_u, this.actor.field_70161_v);
            child.field_70170_p.func_72838_d((Entity)child);
            this.actor.attributes.setBabyState(EnumBabyState.NONE);
            this.babyAge = 0;
            this.setProgressionStep(EnumProgressionStep.FINISHED);
            if (mate != null) {
                ActionStoryProgression mateAI = this.getMateAI(mate);
                mateAI.setProgressionStep(EnumProgressionStep.FINISHED);
                mate.attributes.setBabyState(EnumBabyState.NONE);
                if (this.numChildren < 4 && RadixLogic.getBooleanWithProbability((int)50)) {
                    mateAI.setProgressionStep(EnumProgressionStep.TRY_FOR_BABY);
                    mateAI.isDominant = true;
                    this.isDominant = false;
                    this.setProgressionStep(EnumProgressionStep.TRY_FOR_BABY);
                }
            } else if (this.actor.attributes.getMarriageState() == EnumMarriageState.NOT_MARRIED) {
                this.reset();
            }
        }
    }

    private ActionStoryProgression getMateAI(EntityVillagerMCA human) {
        return human.getBehavior(ActionStoryProgression.class);
    }

    public void setTicksUntilNextProgress(int value) {
        this.ticksUntilNextProgress = value;
    }

    public void setProgressionStep(EnumProgressionStep step) {
        this.progressionStep = step;
        this.forceNextProgress = false;
    }

    public EnumProgressionStep getProgressionStep() {
        return this.progressionStep;
    }

    public void setDominant(boolean value) {
        this.isDominant = value;
    }

    public void setForceNextProgress(boolean value) {
        this.forceNextProgress = value;
    }

    public boolean getIsDominant() {
        return this.isDominant;
    }
}

