/*
 * Decompiled with CFR 0.152.
 */
package mca.actions;

import java.util.Random;
import mca.actions.AbstractAction;
import mca.core.MCA;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumMood;
import mca.enums.EnumPersonality;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import radixcore.modules.RadixMath;

public class ActionUpdateMood
extends AbstractAction {
    private static final DataParameter<Float> MOOD_VALUE = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187193_c);
    @SideOnly(value=Side.CLIENT)
    private int particleSpawnInterval;
    @SideOnly(value=Side.CLIENT)
    private int particleSpawnCounter;
    private int counter;

    public ActionUpdateMood(EntityVillagerMCA entityHuman) {
        super(entityHuman);
    }

    @Override
    public void onUpdateClient() {
        if (MCA.getConfig().showMoodParticles && this.getMoodLevel() != 0) {
            int moodLevel = this.getMoodLevel();
            EnumParticleTypes particles = null;
            switch (this.actor.attributes.getPersonality().getMoodGroup()) {
                case GENERAL: {
                    particles = moodLevel > 0 ? EnumParticleTypes.VILLAGER_HAPPY : EnumParticleTypes.WATER_SPLASH;
                    break;
                }
                case PLAYFUL: {
                    particles = moodLevel > 0 ? EnumParticleTypes.VILLAGER_HAPPY : EnumParticleTypes.SPELL_MOB;
                    break;
                }
                case SERIOUS: {
                    EnumParticleTypes enumParticleTypes = particles = moodLevel > 0 ? EnumParticleTypes.VILLAGER_HAPPY : EnumParticleTypes.VILLAGER_ANGRY;
                }
            }
            if (particles != null) {
                switch (Math.abs(moodLevel)) {
                    case 1: {
                        this.particleSpawnInterval = 25;
                        break;
                    }
                    case 2: {
                        this.particleSpawnInterval = 15;
                        break;
                    }
                    case 3: {
                        this.particleSpawnInterval = 10;
                    }
                }
                if (this.particleSpawnCounter <= 0) {
                    Random rand = this.actor.field_70170_p.field_73012_v;
                    double velX = rand.nextGaussian() * 0.02;
                    double velY = rand.nextGaussian() * 0.02;
                    double velZ = rand.nextGaussian() * 0.02;
                    this.actor.field_70170_p.func_175688_a(particles, this.actor.field_70165_t + (double)(rand.nextFloat() * this.actor.field_70130_N * 2.0f) - (double)this.actor.field_70130_N, this.actor.field_70163_u + 0.5 + (double)(rand.nextFloat() * this.actor.field_70131_O), this.actor.field_70161_v + (double)(rand.nextFloat() * this.actor.field_70130_N * 2.0f) - (double)this.actor.field_70130_N, velX, velY, velZ, new int[0]);
                    this.particleSpawnCounter = this.particleSpawnInterval;
                } else {
                    --this.particleSpawnCounter;
                }
            }
        }
    }

    @Override
    public void onUpdateServer() {
        if (this.counter <= 0) {
            if (this.getMoodLevel() > 0) {
                this.modifyMoodLevel(-1.0f);
            } else if (this.getMoodLevel() < 0) {
                this.modifyMoodLevel(1.0f);
            }
            this.counter = 900;
        }
        --this.counter;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74776_a("moodValue", this.getMoodValue());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.setMoodValue(nbt.func_74760_g("moodValue"));
    }

    public void setMoodValue(float value) {
        this.actor.func_184212_Q().func_187227_b(MOOD_VALUE, (Object)Float.valueOf(value));
    }

    public void modifyMoodLevel(float amount) {
        this.actor.func_184212_Q().func_187227_b(MOOD_VALUE, (Object)Float.valueOf(RadixMath.clamp((float)(this.getMoodValue() + amount), (float)0.0f, (float)10.0f)));
    }

    public EnumMood getMood(EnumPersonality personality) {
        return personality.getMoodGroup().getMood(this.getMoodLevel());
    }

    private float getMoodValue() {
        return ((Float)this.actor.func_184212_Q().func_187225_a(MOOD_VALUE)).floatValue();
    }

    private int getMoodLevel() {
        int level = 0;
        switch (Math.round(this.getMoodValue())) {
            case 0: {
                level = -3;
                break;
            }
            case 1: {
                level = -2;
                break;
            }
            case 2: {
                level = -2;
                break;
            }
            case 3: {
                level = -1;
                break;
            }
            case 4: {
                level = -1;
                break;
            }
            case 5: {
                level = 0;
                break;
            }
            case 6: {
                level = 1;
                break;
            }
            case 7: {
                level = 1;
                break;
            }
            case 8: {
                level = 2;
                break;
            }
            case 9: {
                level = 2;
                break;
            }
            case 10: {
                level = 3;
            }
        }
        return level;
    }

    @Override
    protected void registerDataParameters() {
        this.actor.func_184212_Q().func_187214_a(MOOD_VALUE, (Object)Float.valueOf(5.0f));
    }
}

