/*
 * Decompiled with CFR 0.152.
 */
package mca.actions;

import java.util.List;
import mca.actions.AbstractAction;
import mca.actions.ActionSleep;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumMovementState;
import mca.enums.EnumWorkdayState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import radixcore.modules.RadixLogic;
import radixcore.modules.RadixMath;

public class ActionWander
extends AbstractAction {
    private EnumWorkdayState state = EnumWorkdayState.IDLE;
    private Vec3d vecTarget;
    private EntityLivingBase lookTarget;
    private int ticksActive;

    public ActionWander(EntityVillagerMCA actor) {
        super(actor);
    }

    @Override
    public void onUpdateServer() {
        if (this.actor.attributes.getMovementState() == EnumMovementState.STAY || this.actor.attributes.getMovementState() == EnumMovementState.FOLLOW || this.actor.getBehavior(ActionSleep.class).getIsSleeping() || this.actor.getBehaviors().isToggleActionActive()) {
            if (this.actor.attributes.getMovementState() == EnumMovementState.STAY) {
                this.handleWatchClosestPlayer();
            }
            return;
        }
        switch (this.state) {
            case MOVE_INDOORS: {
                this.handleMoveIndoors();
                break;
            }
            case WANDER: {
                this.handleWander();
                break;
            }
            case WATCH_CLOSEST_ANYTHING: {
                this.handleWatchClosestAnything();
                break;
            }
            case WATCH_CLOSEST_PLAYER: {
                this.handleWatchClosestPlayer();
                break;
            }
            case IDLE: {
                this.handleIdle();
            }
        }
        ++this.ticksActive;
        if (this.ticksActive % 300 == 0 && RadixLogic.getBooleanWithProbability((int)30)) {
            this.ticksActive = 0;
            this.state = EnumWorkdayState.getRandom();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("state", this.state.getId());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.state = EnumWorkdayState.getById(nbt.func_74762_e("state"));
    }

    private void handleMoveIndoors() {
        this.handleLook();
        this.handleWander();
    }

    private void handleWander() {
        this.handleLook();
        if (this.vecTarget == null && this.ticksActive % (20 * (this.actor.func_70681_au().nextInt(5) + 5)) == 0) {
            this.vecTarget = RandomPositionGenerator.func_75463_a((EntityCreature)this.actor, (int)7, (int)5);
            this.actor.func_70661_as().func_75484_a(null, 0.0);
        } else if (this.vecTarget != null) {
            if (this.actor.func_70661_as().func_75500_f()) {
                this.actor.func_70661_as().func_75492_a(this.vecTarget.field_72450_a, this.vecTarget.field_72448_b, this.vecTarget.field_72449_c, 0.5);
            }
            if (this.ticksActive % 200 == 0) {
                this.vecTarget = null;
            }
        }
    }

    private void handleWatchClosestAnything() {
        this.efficientGetLookTarget(false);
        this.lookAtLookTarget();
    }

    private void handleWatchClosestPlayer() {
        this.efficientGetLookTarget(true);
        this.lookAtLookTarget();
    }

    private void handleIdle() {
        this.handleLook();
    }

    private void handleLook() {
        this.efficientGetLookTarget(true);
        if (this.lookTarget instanceof EntityPlayer) {
            this.lookAtLookTarget();
        }
    }

    private void efficientGetLookTarget(boolean playerOnly) {
        if (this.ticksActive % 20 / 2 == 0) {
            if (this.lookTarget != null && RadixMath.getDistanceToEntity((Entity)this.actor, (Entity)this.lookTarget) > 3.0) {
                this.lookTarget = null;
            }
            this.getLookTarget(playerOnly);
        }
    }

    private void getLookTarget(boolean playerOnly) {
        Class entityClass = playerOnly ? EntityPlayer.class : EntityLivingBase.class;
        int maxDistanceAway = 3;
        List entitiesAroundMe = this.actor.field_70170_p.func_72872_a(entityClass, new AxisAlignedBB(this.actor.field_70165_t - 3.0, this.actor.field_70163_u - 3.0, this.actor.field_70161_v - 3.0, this.actor.field_70165_t + 3.0, this.actor.field_70163_u + 3.0, this.actor.field_70161_v + 3.0));
        double lastDistance = 100.0;
        Entity target = null;
        for (Entity entity : entitiesAroundMe) {
            double dist;
            if (entity == this.actor || !((dist = RadixMath.getDistanceToEntity((Entity)this.actor, (Entity)entity)) < lastDistance)) continue;
            lastDistance = dist;
            target = entity;
        }
        this.lookTarget = (EntityLivingBase)target;
    }

    private void lookAtLookTarget() {
        if (this.lookTarget != null) {
            this.actor.func_70671_ap().func_75651_a((Entity)this.lookTarget, 9.0f, 3.0f);
        }
    }
}

