/*
 * Decompiled with CFR 0.152.
 */
package mca.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import mca.actions.ActionCombat;
import mca.actions.ActionFollow;
import mca.actions.ActionIdle;
import mca.actions.ActionUpdateMood;
import mca.api.CropEntry;
import mca.api.RegistryMCA;
import mca.api.WoodcuttingEntry;
import mca.api.exception.MappingNotFoundException;
import mca.core.Constants;
import mca.core.MCA;
import mca.data.NBTPlayerData;
import mca.data.PlayerMemory;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumCombatBehaviors;
import mca.enums.EnumGender;
import mca.enums.EnumInteraction;
import mca.enums.EnumMarriageState;
import mca.enums.EnumMovementState;
import mca.enums.EnumProfessionSkinGroup;
import mca.packets.PacketGift;
import mca.packets.PacketInteract;
import mca.packets.PacketToggleAI;
import mca.util.TutorialManager;
import mca.util.TutorialMessage;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import radixcore.datastructures.CyclicIntList;
import radixcore.modules.client.RadixRender;

@SideOnly(value=Side.CLIENT)
public class GuiInteraction
extends GuiScreen {
    private static boolean displaySuccessChance;
    private final EntityVillagerMCA villager;
    private final EntityPlayer player;
    private final PlayerMemory memory;
    private final NBTPlayerData playerData;
    private boolean displayMarriageInfo;
    private boolean displayParentsInfo;
    private boolean displayGiftInfo;
    private boolean inGiftMode;
    private int timeSinceLastClick;
    private int currentPage;
    private CyclicIntList radiusMappings;
    private CyclicIntList farmingMappings;
    private CyclicIntList woodcuttingMappings;
    private CyclicIntList miningMappings;
    private CyclicIntList hireLengths;
    private CyclicIntList combatMethods;
    private CyclicIntList combatTriggers;
    private CyclicIntList combatTargets;
    private boolean farmingModeFlag;
    private boolean miningModeFlag;
    private boolean huntingModeFlag;
    private boolean woodcuttingReplantFlag;

    public GuiInteraction(EntityVillagerMCA villager, EntityPlayer player) {
        this.villager = villager;
        this.player = player;
        this.playerData = MCA.getPlayerData(player);
        this.memory = villager.attributes.getPlayerMemory(player);
        this.radiusMappings = CyclicIntList.fromIntegers((Integer[])new Integer[]{5, 10, 15, 20, 25});
        this.farmingMappings = CyclicIntList.fromList(RegistryMCA.getCropEntryIDs());
        this.woodcuttingMappings = CyclicIntList.fromList(RegistryMCA.getWoodcuttingBlockIDs());
        this.miningMappings = CyclicIntList.fromList(RegistryMCA.getMiningEntryIDs());
        this.hireLengths = CyclicIntList.fromIntegers((Integer[])new Integer[]{1, 2, 3});
        this.combatMethods = CyclicIntList.fromIntegers((Integer[])new Integer[]{EnumCombatBehaviors.METHOD_DO_NOT_FIGHT.getNumericId(), EnumCombatBehaviors.METHOD_MELEE_ONLY.getNumericId(), EnumCombatBehaviors.METHOD_RANGED_ONLY.getNumericId(), EnumCombatBehaviors.METHOD_MELEE_AND_RANGED.getNumericId()});
        this.combatTriggers = CyclicIntList.fromIntegers((Integer[])new Integer[]{EnumCombatBehaviors.TRIGGER_PLAYER_TAKE_DAMAGE.getNumericId(), EnumCombatBehaviors.TRIGGER_PLAYER_DEAL_DAMAGE.getNumericId(), EnumCombatBehaviors.TRIGGER_ALWAYS.getNumericId()});
        this.combatTargets = CyclicIntList.fromIntegers((Integer[])new Integer[]{EnumCombatBehaviors.TARGET_HOSTILE_MOBS.getNumericId(), EnumCombatBehaviors.TARGET_PASSIVE_MOBS.getNumericId(), EnumCombatBehaviors.TARGET_PASSIVE_OR_HOSTILE_MOBS.getNumericId()});
    }

    public void func_73866_w_() {
        this.drawGui();
        try {
            this.villager.isInteractionGuiOpen = true;
            this.drawMainButtonMenu();
        }
        catch (NullPointerException e) {
            Minecraft.func_71410_x().func_147108_a(null);
        }
    }

    public void func_146281_b() {
        try {
            this.villager.isInteractionGuiOpen = false;
            if (this.villager.attributes.getIsInfected()) {
                TutorialManager.setTutorialMessage(new TutorialMessage("Infected villagers cannot do chores, have an inventory,", "and they may bite. Surely there's a cure?"));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73876_c() {
        if (this.timeSinceLastClick < 100) {
            ++this.timeSinceLastClick;
        }
    }

    public void func_73863_a(int i, int j, float f) {
        int marriageIconU = this.villager.attributes.getMarriageState() == EnumMarriageState.MARRIED_TO_PLAYER || this.villager.attributes.getMarriageState() == EnumMarriageState.MARRIED_TO_VILLAGER ? 0 : (this.villager.attributes.getMarriageState() == EnumMarriageState.ENGAGED ? 64 : 16);
        int parentsIconU = 32;
        int giftIconU = 48;
        GL11.glPushMatrix();
        GL11.glColor3f((float)255.0f, (float)255.0f, (float)255.0f);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
        RadixRender.drawTexturedRectangle((ResourceLocation)new ResourceLocation("mca:textures/gui.png"), (int)5, (int)30, (int)marriageIconU, (int)0, (int)16, (int)16);
        if (this.doDrawParentsIcon()) {
            RadixRender.drawTexturedRectangle((ResourceLocation)new ResourceLocation("mca:textures/gui.png"), (int)5, (int)45, (int)parentsIconU, (int)0, (int)16, (int)16);
        }
        if (this.doDrawGiftIcon()) {
            RadixRender.drawTexturedRectangle((ResourceLocation)new ResourceLocation("mca:textures/gui.png"), (int)5, (int)60, (int)giftIconU, (int)0, (int)16, (int)16);
        }
        GL11.glPopMatrix();
        if (this.playerData.getIsSuperUser()) {
            RadixRender.drawTextPopup((String)"\u00a7FYou are a superuser.", (int)10, (int)(this.field_146295_m - 16));
        }
        if (this.villager.attributes.getIsInfected()) {
            int xLoc = this.villager.attributes.getProfessionSkinGroup() == EnumProfessionSkinGroup.Child ? (this.villager.attributes.getIsChild() ? 62 : 80) : 18;
            RadixRender.drawTextPopup((String)"\u00a7A\u00a7lINFECTED!", (int)xLoc, (int)11);
        }
        if (this.displayMarriageInfo) {
            String phraseId = this.villager.attributes.getSpouseName().equals(this.player.func_70005_c_()) && this.villager.attributes.getMarriageState() == EnumMarriageState.ENGAGED ? "gui.info.family.engagedtoplayer" : (this.villager.attributes.getSpouseName().equals(this.player.func_70005_c_()) ? "gui.info.family.marriedtoplayer" : (this.villager.attributes.getMarriageState() == EnumMarriageState.MARRIED_TO_PLAYER || this.villager.attributes.getMarriageState() == EnumMarriageState.MARRIED_TO_VILLAGER ? "gui.info.family.married" : (this.villager.attributes.getMarriageState() == EnumMarriageState.ENGAGED ? "gui.info.family.engaged" : "gui.info.family.notmarried")));
            RadixRender.drawTextPopup((String)MCA.getLocalizer().getString(phraseId, this.villager.attributes.getSpouseName()), (int)49, (int)73);
        }
        if (this.displayParentsInfo) {
            String motherString;
            ArrayList<String> displayList = new ArrayList<String>();
            EnumGender fatherGender = this.villager.attributes.getFatherGender();
            String fatherString = fatherGender == EnumGender.MALE || fatherGender == EnumGender.UNASSIGNED ? "gui.info.family.father" : "gui.info.family.mother";
            String string = motherString = this.villager.attributes.getMotherGender() == EnumGender.MALE ? "gui.info.family.father" : "gui.info.family.mother";
            if (this.villager.attributes.getFatherName().equals(this.player.func_70005_c_())) {
                fatherString = fatherString + ".you";
            } else if (this.villager.attributes.getMotherName().equals(this.player.func_70005_c_())) {
                motherString = motherString + ".you";
            }
            String fatherName = this.villager.attributes.getFatherName();
            String motherName = this.villager.attributes.getMotherName();
            if (fatherName.isEmpty()) {
                fatherName = "?";
            }
            if (motherName.isEmpty()) {
                motherName = "?";
            }
            displayList.add(MCA.getLocalizer().getString(fatherString, fatherName));
            displayList.add(MCA.getLocalizer().getString(motherString, motherName));
            RadixRender.drawTextPopup(displayList, (int)49, (int)97);
        }
        if (this.displayGiftInfo) {
            ArrayList<String> displayList = new ArrayList<String>();
            displayList.add(MCA.getLocalizer().getString("gui.info.gift.line1"));
            displayList.add(MCA.getLocalizer().getString("gui.info.gift.line2"));
            RadixRender.drawTextPopup(displayList, (int)49, (int)129);
        }
        String moodString = MCA.getLocalizer().getString("gui.info.mood", this.villager.getBehavior(ActionUpdateMood.class).getMood(this.villager.attributes.getPersonality()).getFriendlyName());
        String personalityString = MCA.getLocalizer().getString("gui.info.personality", this.villager.attributes.getPersonality().getFriendlyName());
        RadixRender.drawTextPopup((String)moodString, (int)18, (int)29);
        RadixRender.drawTextPopup((String)personalityString, (int)18, (int)46);
        if (this.villager.attributes.getProfessionSkinGroup() == EnumProfessionSkinGroup.Child) {
            if (this.villager.attributes.getIsChild()) {
                int age = (int)(0.37f / (float)MCA.getConfig().childGrowUpTime * (float)this.villager.attributes.getAge() / 0.02f);
                if (age < 4) {
                    age = 4;
                }
                RadixRender.drawTextPopup((String)("Age: " + age), (int)18, (int)11);
            } else {
                RadixRender.drawTextPopup((String)"Age: Adult", (int)18, (int)11);
            }
        }
        if (displaySuccessChance) {
            for (Object obj : this.field_146292_n) {
                try {
                    GuiButton button = (GuiButton)obj;
                    EnumInteraction interaction = EnumInteraction.fromId(button.field_146127_k);
                    int successChance = interaction.getSuccessChance(this.villager, this.memory);
                    int n = successChance = successChance < 0 ? 0 : successChance;
                    if (interaction.getBaseChance() == 0) continue;
                    RadixRender.drawTextPopup((String)(successChance + "%"), (int)(button.field_146128_h - 30), (int)(button.field_146129_i + 6));
                }
                catch (Exception e) {}
            }
        }
        if (this.memory.getIsHiredBy()) {
            int days = this.memory.getHireTimeLeft() / 1440;
            int hours = this.memory.getHireTimeLeft() / 60 - (days > 0 ? days * 24 : 0);
            int minute = this.memory.getHireTimeLeft() % 60;
            if (days > 0) {
                RadixRender.drawTextPopup((String)("Hired: " + days + "d " + hours + "h " + minute + "m left."), (int)18, (int)140);
            } else {
                RadixRender.drawTextPopup((String)("Hired: " + hours + "h " + minute + "m left."), (int)18, (int)140);
            }
        }
        super.func_73863_a(i, j, f);
    }

    private boolean doDrawParentsIcon() {
        return this.villager.attributes.getFatherUUID() != Constants.EMPTY_UUID || this.villager.attributes.getMotherUUID() != Constants.EMPTY_UUID;
    }

    private boolean doDrawGiftIcon() {
        return this.villager.attributes.getPlayerMemory(this.player).getHasGift();
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        if (x <= 38 && x >= 16 && y <= 86 && y >= 69) {
            this.displayMarriageInfo = true;
        } else if (this.doDrawParentsIcon() && x <= 38 && x >= 16 && y <= 114 && y >= 97) {
            this.displayParentsInfo = true;
        } else if (this.doDrawGiftIcon() && x <= 38 && x >= 16 && y <= 147 && y >= 120) {
            this.displayGiftInfo = true;
        } else {
            this.displayMarriageInfo = false;
            this.displayParentsInfo = false;
            this.displayGiftInfo = false;
        }
        if (Mouse.getEventDWheel() < 0) {
            this.player.field_71071_by.field_70461_c = this.player.field_71071_by.field_70461_c == 8 ? 0 : this.player.field_71071_by.field_70461_c + 1;
        } else if (Mouse.getEventDWheel() > 0) {
            this.player.field_71071_by.field_70461_c = this.player.field_71071_by.field_70461_c == 0 ? 8 : this.player.field_71071_by.field_70461_c - 1;
        }
    }

    protected void func_73864_a(int posX, int posY, int button) throws IOException {
        super.func_73864_a(posX, posY, button);
        if (this.inGiftMode && button == 1) {
            ItemStack heldItem = this.player.field_71071_by.func_70448_g();
            if (heldItem != null) {
                MCA.getPacketHandler().sendPacketToServer((IMessage)new PacketGift(this.villager, this.player.field_71071_by.field_70461_c));
            }
        } else if (!this.inGiftMode && button == 0 && this.doDrawGiftIcon() && posX <= 38 && posX >= 16 && posY <= 147 && posY >= 120) {
            MCA.getPacketHandler().sendPacketToServer((IMessage)new PacketInteract(EnumInteraction.TAKE_GIFT.getId(), this.villager.func_145782_y()));
        }
    }

    protected void func_73869_a(char keyChar, int keyCode) {
        if (keyCode == 1) {
            if (this.inGiftMode) {
                this.inGiftMode = false;
                for (Object obj : this.field_146292_n) {
                    GuiButton displayedButton = (GuiButton)obj;
                    displayedButton.field_146124_l = true;
                }
                TutorialManager.forceState(2);
            } else {
                Minecraft.func_71410_x().func_147108_a(null);
            }
        } else if (keyCode == 34) {
            ItemStack heldItem;
            if (this.inGiftMode && (heldItem = this.player.field_71071_by.func_70448_g()) != null) {
                MCA.getPacketHandler().sendPacketToServer((IMessage)new PacketGift(this.villager, this.player.field_71071_by.field_70461_c));
            }
        } else if (keyCode == 29) {
            displaySuccessChance = !displaySuccessChance;
        } else {
            try {
                int numberInput = Integer.parseInt(String.valueOf(keyChar));
                if (numberInput > 0) {
                    this.player.field_71071_by.field_70461_c = numberInput - 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected void drawGui() {
    }

    protected void func_146284_a(GuiButton button) {
        if (this.timeSinceLastClick <= 2) {
            return;
        }
        this.timeSinceLastClick = 0;
        EnumInteraction interaction = EnumInteraction.fromId(button.field_146127_k);
        ActionCombat combatAI = this.villager.getBehavior(ActionCombat.class);
        this.villager.getBehavior(ActionIdle.class).reset();
        if (interaction != null) {
            block0 : switch (interaction) {
                case INTERACT: {
                    this.drawInteractButtonMenu();
                    break;
                }
                case WORK: {
                    this.drawWorkButtonMenu();
                    break;
                }
                case FARMING: {
                    this.drawFarmingControlMenu();
                    break;
                }
                case FARMING_MODE: {
                    this.farmingModeFlag = !this.farmingModeFlag;
                    this.drawFarmingControlMenu();
                    break;
                }
                case FARMING_TARGET: {
                    this.farmingMappings.next();
                    this.drawFarmingControlMenu();
                    break;
                }
                case FARMING_RADIUS: {
                    this.radiusMappings.next();
                    this.drawFarmingControlMenu();
                    break;
                }
                case HUNTING: {
                    this.drawHuntingControlMenu();
                    break;
                }
                case HUNTING_MODE: {
                    this.huntingModeFlag = !this.huntingModeFlag;
                    this.drawHuntingControlMenu();
                    break;
                }
                case WOODCUTTING: {
                    this.drawWoodcuttingControlMenu();
                    break;
                }
                case WOODCUTTING_TREE: {
                    this.woodcuttingMappings.next();
                    this.drawWoodcuttingControlMenu();
                    break;
                }
                case WOODCUTTING_REPLANT: {
                    this.woodcuttingReplantFlag = !this.woodcuttingReplantFlag;
                    this.drawWoodcuttingControlMenu();
                    break;
                }
                case MINING: {
                    this.drawMiningControlMenu();
                    break;
                }
                case MINING_MODE: {
                    this.miningModeFlag = !this.miningModeFlag;
                    this.drawMiningControlMenu();
                    break;
                }
                case MINING_TARGET: {
                    this.miningMappings.next();
                    this.drawMiningControlMenu();
                    break;
                }
                case FISHING: {
                    this.drawFishingControlMenu();
                    break;
                }
                case COOKING: {
                    this.drawCookingControlMenu();
                    break;
                }
                case COMBAT: {
                    this.drawCombatControlMenu();
                    break;
                }
                case ATTACK_METHOD: {
                    this.combatMethods.next();
                    combatAI.setMethodBehavior(EnumCombatBehaviors.getById(this.combatMethods.get()));
                    this.drawCombatControlMenu();
                    break;
                }
                case ATTACK_TRIGGER: {
                    this.combatTriggers.next();
                    combatAI.setTriggerBehavior(EnumCombatBehaviors.getById(this.combatTriggers.get()));
                    this.drawCombatControlMenu();
                    break;
                }
                case ATTACK_TARGET: {
                    this.combatTargets.next();
                    combatAI.setTargetBehavior(EnumCombatBehaviors.getById(this.combatTargets.get()));
                    this.drawCombatControlMenu();
                    break;
                }
                case SPECIAL: {
                    this.drawSpecialButtonMenu();
                    break;
                }
                case ACCEPT: {
                    boolean hasGold = false;
                    for (int i = 0; i < this.player.field_71071_by.func_70302_i_(); ++i) {
                        ItemStack stack = this.player.field_71071_by.func_70301_a(i);
                        if (stack == null || stack.func_77973_b() != Items.field_151043_k || stack.func_190916_E() < this.hireLengths.get()) continue;
                        hasGold = true;
                        break;
                    }
                    if (!hasGold) {
                        this.player.func_145747_a((ITextComponent)new TextComponentString(MCA.getLocalizer().getString("interaction.hire.fail.notenoughgold", this.hireLengths.get())));
                    } else {
                        this.villager.say("interaction.hire.success", this.player);
                        MCA.getPacketHandler().sendPacketToServer((IMessage)new PacketInteract(interaction.getId(), this.villager.func_145782_y(), new Integer(this.hireLengths.get()), this.currentPage == EnumInteraction.EXTEND.getId()));
                    }
                    Minecraft.func_71410_x().func_147108_a(null);
                    break;
                }
                case LENGTH: {
                    this.hireLengths.next();
                    if (this.currentPage == EnumInteraction.EXTEND.getId()) {
                        this.drawExtendButtonMenu();
                        break;
                    }
                    this.drawHireButtonMenu();
                    break;
                }
                case HIRE: {
                    this.drawHireButtonMenu();
                    break;
                }
                case EXTEND: {
                    this.drawExtendButtonMenu();
                    break;
                }
                case PICK_UP: {
                    TutorialManager.setTutorialMessage(new TutorialMessage("You can drop your child by right-clicking the ground.", ""));
                    this.villager.func_184205_a((Entity)this.player, true);
                    MCA.getPacketHandler().sendPacketToServer((IMessage)new PacketInteract(interaction.getId(), this.villager.func_145782_y()));
                    this.close();
                    break;
                }
                case GIFT: {
                    if (this.inGiftMode) {
                        this.inGiftMode = false;
                        for (Object obj : this.field_146292_n) {
                            GuiButton displayedButton = (GuiButton)obj;
                            displayedButton.field_146124_l = true;
                        }
                        TutorialManager.forceState(2);
                        break;
                    }
                    this.inGiftMode = true;
                    for (Object obj : this.field_146292_n) {
                        GuiButton displayedButton = (GuiButton)obj;
                        displayedButton.field_146124_l = displayedButton.field_146127_k == 13;
                    }
                    TutorialManager.setTutorialMessage(new TutorialMessage("Give a gift by right-clicking while it's selected,", "or press 'G'. Press Esc to exit gift mode."));
                    break;
                }
                case CHAT: 
                case JOKE: 
                case SHAKE_HAND: 
                case TELL_STORY: 
                case FLIRT: 
                case HUG: 
                case KISS: 
                case FOLLOW: 
                case STAY: 
                case MOVE: 
                case TRADE: 
                case SET_HOME: 
                case RIDE_HORSE: 
                case RESETBABY: 
                case DIVORCE: 
                case PROCREATE: 
                case ADOPTBABY: 
                case DISMISS: 
                case TAXES: 
                case CHECKHAPPINESS: 
                case INVENTORY: 
                case STOP: {
                    MCA.getPacketHandler().sendPacketToServer((IMessage)new PacketInteract(interaction.getId(), this.villager.func_145782_y()));
                    this.close();
                    break;
                }
                case NOBILITY: {
                    this.drawNobilityControlMenu();
                    break;
                }
                case START: {
                    switch (EnumInteraction.fromId(this.currentPage)) {
                        case FARMING: {
                            MCA.getPacketHandler().sendPacketToServer((IMessage)new PacketToggleAI(this.villager, EnumInteraction.FARMING, this.farmingModeFlag, this.farmingMappings.get(), this.radiusMappings.get()));
                            break;
                        }
                        case MINING: {
                            MCA.getPacketHandler().sendPacketToServer((IMessage)new PacketToggleAI(this.villager, EnumInteraction.MINING, this.miningModeFlag, this.miningMappings.get()));
                            break;
                        }
                        case WOODCUTTING: {
                            MCA.getPacketHandler().sendPacketToServer((IMessage)new PacketToggleAI(this.villager, EnumInteraction.WOODCUTTING, this.woodcuttingReplantFlag, this.woodcuttingMappings.get()));
                            break;
                        }
                        case HUNTING: {
                            MCA.getPacketHandler().sendPacketToServer((IMessage)new PacketToggleAI(this.villager, EnumInteraction.HUNTING, this.huntingModeFlag));
                            break;
                        }
                        case FISHING: {
                            MCA.getPacketHandler().sendPacketToServer((IMessage)new PacketToggleAI(this.villager, EnumInteraction.FISHING, new Object[0]));
                            break;
                        }
                        case COOKING: {
                            MCA.getPacketHandler().sendPacketToServer((IMessage)new PacketToggleAI(this.villager, EnumInteraction.COOKING, new Object[0]));
                        }
                    }
                    this.close();
                    break;
                }
                case BACK: {
                    switch (EnumInteraction.fromId(this.currentPage)) {
                        case FARMING: 
                        case MINING: 
                        case WOODCUTTING: 
                        case HUNTING: 
                        case FISHING: {
                            this.drawWorkButtonMenu();
                            break block0;
                        }
                        case COOKING: {
                            if (this.villager.attributes.getPlayerSpouseInstance() == this.player) {
                                this.drawSpecialButtonMenu();
                                break block0;
                            }
                            this.drawWorkButtonMenu();
                            break block0;
                        }
                        case SPECIAL: 
                        case WORK: 
                        case INTERACT: {
                            this.drawMainButtonMenu();
                            break block0;
                        }
                        case EXTEND: 
                        case HIRE: {
                            this.drawSpecialButtonMenu();
                            break block0;
                        }
                        case COMBAT: {
                            this.drawWorkButtonMenu();
                            break block0;
                        }
                        case NOBILITY: {
                            this.drawMainButtonMenu();
                        }
                    }
                }
            }
        }
    }

    private void drawMainButtonMenu() {
        int xLoc;
        this.field_146292_n.clear();
        int n = xLoc = this.field_146294_l == 480 ? 170 : 145;
        int yLoc = this.field_146295_m == 240 ? 115 : (this.field_146295_m == 255 ? 125 : 132);
        int yInt = 22;
        this.field_146292_n.add(new GuiButton(EnumInteraction.INTERACT.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - yLoc, 65, 20, MCA.getLocalizer().getString("gui.button.interact")));
        yLoc -= yInt;
        if (this.villager.attributes.allowsControllingInteractions(this.player)) {
            boolean stayButtonEnabled;
            boolean followButtonEnabled;
            this.field_146292_n.add(new GuiButton(EnumInteraction.FOLLOW.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - yLoc, 65, 20, MCA.getLocalizer().getString("gui.button.follow")));
            this.field_146292_n.add(new GuiButton(EnumInteraction.STAY.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - (yLoc -= yInt), 65, 20, MCA.getLocalizer().getString("gui.button.stay")));
            this.field_146292_n.add(new GuiButton(EnumInteraction.MOVE.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - (yLoc -= yInt), 65, 20, MCA.getLocalizer().getString("gui.button.move")));
            yLoc -= yInt;
            ((GuiButton)this.field_146292_n.get((int)1)).field_146124_l = followButtonEnabled = this.villager.attributes.getMovementState() != EnumMovementState.FOLLOW || !this.villager.getBehavior(ActionFollow.class).getFollowingUUID().equals(this.player.func_110124_au());
            ((GuiButton)this.field_146292_n.get((int)2)).field_146124_l = stayButtonEnabled = this.villager.attributes.getMovementState() != EnumMovementState.STAY;
            boolean bl = ((GuiButton)this.field_146292_n.get((int)3)).field_146124_l = !stayButtonEnabled || this.villager.attributes.getMovementState() == EnumMovementState.FOLLOW;
        }
        if (!this.villager.attributes.getIsChild() && MCA.getConfig().allowTrading) {
            this.field_146292_n.add(new GuiButton(EnumInteraction.TRADE.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - yLoc, 65, 20, MCA.getLocalizer().getString("gui.button.trade")));
            yLoc -= yInt;
        }
        if (this.villager.attributes.allowsControllingInteractions(this.player)) {
            this.field_146292_n.add(new GuiButton(EnumInteraction.SET_HOME.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - yLoc, 65, 20, MCA.getLocalizer().getString("gui.button.sethome")));
            this.field_146292_n.add(new GuiButton(EnumInteraction.RIDE_HORSE.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - (yLoc -= yInt), 65, 20, MCA.getLocalizer().getString("gui.button.ridehorse")));
            yLoc -= yInt;
        }
        if (this.villager.attributes.getPlayerSpouseInstance() == this.player) {
            this.field_146292_n.add(new GuiButton(EnumInteraction.WORK.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - yLoc, 65, 20, MCA.getLocalizer().getString("gui.button.work")));
            yLoc -= yInt;
        } else if (!this.villager.attributes.getIsChild()) {
            this.field_146292_n.add(new GuiButton(EnumInteraction.SPECIAL.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - yLoc, 65, 20, MCA.getLocalizer().getString("gui.button.special")));
            yLoc -= yInt;
        }
        if (this.villager.attributes.getSpouseName().equals(this.player.func_70005_c_()) || this.villager.attributes.getPlayerSpouseInstance() == this.player) {
            this.field_146292_n.add(new GuiButton(EnumInteraction.PROCREATE.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - yLoc, 65, 20, MCA.getLocalizer().getString("gui.button.procreate")));
            this.field_146292_n.add(new GuiButton(EnumInteraction.INVENTORY.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - (yLoc -= yInt), 65, 20, MCA.getLocalizer().getString("gui.button.inventory")));
            yLoc -= yInt;
        }
        if (this.villager.attributes.isPlayerAParent(this.player) && this.villager.attributes.getIsChild()) {
            this.field_146292_n.add(new GuiButton(EnumInteraction.PICK_UP.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - yLoc, 65, 20, MCA.getLocalizer().getString("gui.button.pickup")));
            yLoc -= yInt;
        }
        if (this.villager.attributes.allowsWorkInteractions(this.player)) {
            this.field_146292_n.add(new GuiButton(EnumInteraction.INVENTORY.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - yLoc, 65, 20, MCA.getLocalizer().getString("gui.button.inventory")));
            this.field_146292_n.add(new GuiButton(EnumInteraction.WORK.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - (yLoc -= yInt), 65, 20, MCA.getLocalizer().getString("gui.button.work")));
            yLoc -= yInt;
            if (this.villager.attributes.isPlayerAParent(this.player) && !this.villager.attributes.getIsChild()) {
                for (Object obj : this.field_146292_n) {
                    GuiButton button = (GuiButton)obj;
                    if (button.field_146127_k != EnumInteraction.WORK.getId()) continue;
                    button.field_146124_l = false;
                    break;
                }
            }
        }
        if (this.playerData.getIsNobility() && !this.villager.attributes.isPlayerAParent(this.player) && this.villager.attributes.getPlayerSpouseInstance() != this.player) {
            String nobilityString = this.playerData.getGender() == EnumGender.MALE ? "gui.button.baron" : "gui.button.baroness";
            this.field_146292_n.add(new GuiButton(EnumInteraction.NOBILITY.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - yLoc, 65, 20, MCA.getLocalizer().getString(nobilityString)));
            yLoc -= yInt;
        }
    }

    private void drawInteractButtonMenu() {
        int xLoc;
        this.field_146292_n.clear();
        this.currentPage = EnumInteraction.INTERACT.getId();
        int n = xLoc = this.field_146294_l == 480 ? 170 : 145;
        int yLoc = this.field_146295_m == 240 ? 115 : (this.field_146295_m == 255 ? 125 : 132);
        int yInt = 22;
        this.field_146292_n.add(new GuiButton(EnumInteraction.BACK.getId(), this.field_146294_l / 2 + xLoc - 32, this.field_146295_m / 2 - yLoc, 14, 20, "<<"));
        this.field_146292_n.add(new GuiButton(-1, this.field_146294_l / 2 + xLoc - 16, this.field_146295_m / 2 - yLoc, 80, 20, "\u00a7E" + MCA.getLocalizer().getString("gui.button.interact")));
        this.field_146292_n.add(new GuiButton(EnumInteraction.CHAT.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - (yLoc -= yInt), 65, 20, MCA.getLocalizer().getString("gui.button.chat")));
        this.field_146292_n.add(new GuiButton(EnumInteraction.JOKE.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - (yLoc -= yInt), 65, 20, MCA.getLocalizer().getString("gui.button.joke")));
        this.field_146292_n.add(new GuiButton(EnumInteraction.GIFT.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - (yLoc -= yInt), 65, 20, MCA.getLocalizer().getString("gui.button.gift")));
        this.field_146292_n.add(new GuiButton(EnumInteraction.SHAKE_HAND.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - (yLoc -= yInt), 65, 20, MCA.getLocalizer().getString("gui.button.shakehand")));
        this.field_146292_n.add(new GuiButton(EnumInteraction.TELL_STORY.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - (yLoc -= yInt), 65, 20, MCA.getLocalizer().getString("gui.button.tellstory")));
        yLoc -= yInt;
        if (this.villager.attributes.allowsIntimateInteractions(this.player)) {
            this.field_146292_n.add(new GuiButton(EnumInteraction.FLIRT.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - yLoc, 65, 20, MCA.getLocalizer().getString("gui.button.flirt")));
            this.field_146292_n.add(new GuiButton(EnumInteraction.HUG.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - (yLoc -= yInt), 65, 20, MCA.getLocalizer().getString("gui.button.hug")));
            this.field_146292_n.add(new GuiButton(EnumInteraction.KISS.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - (yLoc -= yInt), 65, 20, MCA.getLocalizer().getString("gui.button.kiss")));
            yLoc -= yInt;
        }
    }

    private void drawWorkButtonMenu() {
        int xLoc;
        this.currentPage = EnumInteraction.WORK.getId();
        this.field_146292_n.clear();
        int n = xLoc = this.field_146294_l == 480 ? 170 : 145;
        int yLoc = this.field_146295_m == 240 ? 115 : (this.field_146295_m == 255 ? 125 : 132);
        int yInt = 22;
        this.field_146292_n.add(new GuiButton(EnumInteraction.BACK.getId(), this.field_146294_l / 2 + xLoc - 32, this.field_146295_m / 2 - yLoc, 14, 20, "<<"));
        this.field_146292_n.add(new GuiButton(-1, this.field_146294_l / 2 + xLoc - 16, this.field_146295_m / 2 - yLoc, 80, 20, "\u00a7E" + MCA.getLocalizer().getString("gui.button.work")));
        this.field_146292_n.add(new GuiButton(EnumInteraction.FARMING.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - (yLoc -= yInt), 65, 20, MCA.getLocalizer().getString("gui.button.farming")));
        this.field_146292_n.add(new GuiButton(EnumInteraction.WOODCUTTING.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - (yLoc -= yInt), 65, 20, MCA.getLocalizer().getString("gui.button.woodcutting")));
        this.field_146292_n.add(new GuiButton(EnumInteraction.MINING.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - (yLoc -= yInt), 65, 20, MCA.getLocalizer().getString("gui.button.mining")));
        this.field_146292_n.add(new GuiButton(EnumInteraction.HUNTING.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - (yLoc -= yInt), 65, 20, MCA.getLocalizer().getString("gui.button.hunting")));
        this.field_146292_n.add(new GuiButton(EnumInteraction.FISHING.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - (yLoc -= yInt), 65, 20, MCA.getLocalizer().getString("gui.button.fishing")));
        this.field_146292_n.add(new GuiButton(EnumInteraction.COOKING.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - (yLoc -= yInt), 65, 20, MCA.getLocalizer().getString("gui.button.cooking")));
        this.field_146292_n.add(new GuiButton(EnumInteraction.COMBAT.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - (yLoc -= yInt), 65, 20, MCA.getLocalizer().getString("gui.button.combat")));
        this.field_146292_n.add(new GuiButton(EnumInteraction.STOP.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - (yLoc -= yInt), 65, 20, "\u00a74" + MCA.getLocalizer().getString("gui.button.stop")));
        yLoc -= yInt;
        if (this.villager.getBehaviors().isToggleActionActive()) {
            block9: for (Object obj : this.field_146292_n) {
                GuiButton button = (GuiButton)obj;
                if (button.field_146127_k == -1) continue;
                switch (EnumInteraction.fromId(button.field_146127_k)) {
                    case BACK: {
                        continue block9;
                    }
                    case STOP: {
                        continue block9;
                    }
                }
                button.field_146124_l = false;
            }
        } else {
            ((GuiButton)this.field_146292_n.get((int)9)).field_146124_l = false;
        }
        if (this.memory.getIsHiredBy()) {
            EnumProfessionSkinGroup profession = this.villager.attributes.getProfessionSkinGroup();
            EnumInteraction validChore = null;
            switch (profession) {
                case Farmer: {
                    validChore = EnumInteraction.FARMING;
                    break;
                }
                case Miner: {
                    validChore = EnumInteraction.MINING;
                    break;
                }
                case Warrior: {
                    validChore = EnumInteraction.COMBAT;
                }
            }
            if (validChore != null) {
                for (Object obj : this.field_146292_n) {
                    GuiButton button = (GuiButton)obj;
                    if (button.field_146127_k == -1 || button.field_146127_k == EnumInteraction.BACK.getId() || button.field_146127_k == EnumInteraction.STOP.getId() || button.field_146127_k == validChore.getId()) continue;
                    button.field_146124_l = false;
                }
            }
        }
        if (this.villager.attributes.getIsChild()) {
            ((GuiButton)this.field_146292_n.get((int)7)).field_146124_l = false;
        }
        if (this.villager.attributes.getPlayerSpouseInstance() == this.player) {
            for (int i = 2; i < 7; ++i) {
                ((GuiButton)this.field_146292_n.get((int)i)).field_146124_l = false;
            }
        }
    }

    private void drawSpecialButtonMenu() {
        int xLoc;
        this.field_146292_n.clear();
        this.currentPage = EnumInteraction.SPECIAL.getId();
        int n = xLoc = this.field_146294_l == 480 ? 170 : 145;
        int yLoc = this.field_146295_m == 240 ? 115 : (this.field_146295_m == 255 ? 125 : 132);
        int yInt = 22;
        this.field_146292_n.add(new GuiButton(EnumInteraction.BACK.getId(), this.field_146294_l / 2 + xLoc - 32, this.field_146295_m / 2 - yLoc, 14, 20, "<<"));
        this.field_146292_n.add(new GuiButton(-1, this.field_146294_l / 2 + xLoc - 16, this.field_146295_m / 2 - yLoc, 80, 20, "\u00a7E" + MCA.getLocalizer().getString("gui.button.special")));
        yLoc -= yInt;
        if (this.villager.attributes.getCanBeHired(this.player)) {
            boolean isHired = this.memory.getIsHiredBy();
            boolean reachedHeartLevel = MCA.getConfig().hiringHeartsRequirement == -1 ? true : this.memory.getHearts() >= MCA.getConfig().hiringHeartsRequirement;
            String hireButtonText = isHired ? "gui.button.hired" : "gui.button.hire";
            this.field_146292_n.add(new GuiButton(EnumInteraction.HIRE.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - yLoc, 65, 20, MCA.getLocalizer().getString(hireButtonText)));
            this.field_146292_n.add(new GuiButton(EnumInteraction.EXTEND.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - (yLoc -= yInt), 65, 20, MCA.getLocalizer().getString("gui.button.extend")));
            this.field_146292_n.add(new GuiButton(EnumInteraction.DISMISS.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - (yLoc -= yInt), 65, 20, MCA.getLocalizer().getString("gui.button.dismiss")));
            yLoc -= yInt;
            if (isHired || !reachedHeartLevel) {
                ((GuiButton)this.field_146292_n.get((int)2)).field_146124_l = false;
            } else {
                ((GuiButton)this.field_146292_n.get((int)3)).field_146124_l = false;
                ((GuiButton)this.field_146292_n.get((int)4)).field_146124_l = false;
            }
        } else if (this.villager.attributes.getProfessionSkinGroup() == EnumProfessionSkinGroup.Priest && this.villager.attributes.getPlayerSpouseInstance() != this.player) {
            this.field_146292_n.add(new GuiButton(EnumInteraction.DIVORCE.getId(), this.field_146294_l / 2 + xLoc - 20, this.field_146295_m / 2 - yLoc, 85, 20, MCA.getLocalizer().getString("gui.button.divorcespouse")));
            this.field_146292_n.add(new GuiButton(EnumInteraction.ADOPTBABY.getId(), this.field_146294_l / 2 + xLoc - 20, this.field_146295_m / 2 - (yLoc -= yInt), 85, 20, MCA.getLocalizer().getString("gui.button.adoptbaby")));
            this.field_146292_n.add(new GuiButton(EnumInteraction.RESETBABY.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - (yLoc -= yInt), 65, 20, MCA.getLocalizer().getString("gui.button.resetbaby")));
            yLoc -= yInt;
        } else if (this.villager.attributes.getProfessionSkinGroup() == EnumProfessionSkinGroup.Librarian && this.villager.attributes.getPlayerSpouseInstance() != this.player) {
            this.field_146292_n.add(new GuiButton(EnumInteraction.CHECKHAPPINESS.getId(), this.field_146294_l / 2 + xLoc - 20, this.field_146295_m / 2 - yLoc, 85, 20, MCA.getLocalizer().getString("gui.button.checkhappiness")));
            yLoc -= yInt;
        }
        if (this.villager.attributes.getPlayerSpouseInstance() == this.player) {
            if (!this.villager.getBehaviors().isToggleActionActive()) {
                this.field_146292_n.add(new GuiButton(EnumInteraction.COOKING.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - yLoc, 65, 20, MCA.getLocalizer().getString("gui.button.cooking")));
                yLoc -= yInt;
            } else {
                this.field_146292_n.add(new GuiButton(EnumInteraction.STOP.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - yLoc, 65, 20, "\u00a74" + MCA.getLocalizer().getString("gui.button.stop")));
                yLoc -= yInt;
            }
        }
    }

    private void drawHireButtonMenu() {
        int xLoc;
        this.field_146292_n.clear();
        this.currentPage = EnumInteraction.HIRE.getId();
        int n = xLoc = this.field_146294_l == 480 ? 170 : 145;
        int yLoc = this.field_146295_m == 240 ? 115 : (this.field_146295_m == 255 ? 125 : 132);
        int yInt = 22;
        this.field_146292_n.add(new GuiButton(EnumInteraction.BACK.getId(), this.field_146294_l / 2 + xLoc - 32, this.field_146295_m / 2 - yLoc, 14, 20, "<<"));
        this.field_146292_n.add(new GuiButton(-1, this.field_146294_l / 2 + xLoc - 16, this.field_146295_m / 2 - yLoc, 80, 20, "\u00a7E" + MCA.getLocalizer().getString("gui.button.hire")));
        this.field_146292_n.add(new GuiButton(EnumInteraction.LENGTH.getId(), this.field_146294_l / 2 + xLoc - 35, this.field_146295_m / 2 - (yLoc -= yInt), 100, 20, MCA.getLocalizer().getString("gui.button.length", this.hireLengths.get())));
        this.field_146292_n.add(new GuiButton(EnumInteraction.ACCEPT.getId(), this.field_146294_l / 2 + xLoc - 25, this.field_146295_m / 2 - (yLoc -= yInt), 90, 20, MCA.getLocalizer().getString("gui.button.accept")));
        yLoc -= yInt;
    }

    private void drawExtendButtonMenu() {
        int xLoc;
        this.field_146292_n.clear();
        this.currentPage = EnumInteraction.EXTEND.getId();
        int n = xLoc = this.field_146294_l == 480 ? 170 : 145;
        int yLoc = this.field_146295_m == 240 ? 115 : (this.field_146295_m == 255 ? 125 : 132);
        int yInt = 22;
        this.field_146292_n.add(new GuiButton(EnumInteraction.BACK.getId(), this.field_146294_l / 2 + xLoc - 32, this.field_146295_m / 2 - yLoc, 14, 20, "<<"));
        this.field_146292_n.add(new GuiButton(-1, this.field_146294_l / 2 + xLoc - 16, this.field_146295_m / 2 - yLoc, 80, 20, "\u00a7E" + MCA.getLocalizer().getString("gui.button.extend")));
        this.field_146292_n.add(new GuiButton(EnumInteraction.LENGTH.getId(), this.field_146294_l / 2 + xLoc - 35, this.field_146295_m / 2 - (yLoc -= yInt), 100, 20, MCA.getLocalizer().getString("gui.button.length", this.hireLengths.get())));
        this.field_146292_n.add(new GuiButton(EnumInteraction.ACCEPT.getId(), this.field_146294_l / 2 + xLoc - 25, this.field_146295_m / 2 - (yLoc -= yInt), 90, 20, MCA.getLocalizer().getString("gui.button.accept")));
        yLoc -= yInt;
    }

    private void drawFarmingControlMenu() {
        int xLoc;
        this.field_146292_n.clear();
        this.currentPage = EnumInteraction.FARMING.getId();
        int n = xLoc = this.field_146294_l == 480 ? 170 : 145;
        int yLoc = this.field_146295_m == 240 ? 115 : (this.field_146295_m == 255 ? 125 : 132);
        int yInt = 22;
        String modeText = "Mode: " + (this.farmingModeFlag ? "Create Farm" : "Harvest");
        CropEntry entry = null;
        try {
            entry = RegistryMCA.getCropEntryById(this.farmingMappings.get());
        }
        catch (MappingNotFoundException e) {
            entry = RegistryMCA.getDefaultCropEntry();
        }
        this.field_146292_n.add(new GuiButton(EnumInteraction.BACK.getId(), this.field_146294_l / 2 + xLoc - 32, this.field_146295_m / 2 - yLoc, 14, 20, "<<"));
        this.field_146292_n.add(new GuiButton(-1, this.field_146294_l / 2 + xLoc - 16, this.field_146295_m / 2 - yLoc, 80, 20, "\u00a7E" + MCA.getLocalizer().getString("gui.button.farming")));
        this.field_146292_n.add(new GuiButton(EnumInteraction.FARMING_MODE.getId(), this.field_146294_l / 2 + xLoc - 40, this.field_146295_m / 2 - (yLoc -= yInt), 105, 20, modeText));
        this.field_146292_n.add(new GuiButton(EnumInteraction.FARMING_RADIUS.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - (yLoc -= yInt), 65, 20, "Radius: " + this.radiusMappings.get()));
        this.field_146292_n.add(new GuiButton(EnumInteraction.FARMING_TARGET.getId(), this.field_146294_l / 2 + xLoc - 40, this.field_146295_m / 2 - (yLoc -= yInt), 105, 20, "Plant: " + entry.getCropName()));
        this.field_146292_n.add(new GuiButton(EnumInteraction.START.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - (yLoc -= yInt), 65, 20, "\u00a7A" + MCA.getLocalizer().getString("gui.button.start")));
        yLoc -= yInt;
        for (Object obj : this.field_146292_n) {
            GuiButton button = (GuiButton)obj;
            int searchId = this.farmingModeFlag ? EnumInteraction.FARMING_RADIUS.getId() : EnumInteraction.FARMING_TARGET.getId();
            if (button.field_146127_k != searchId) continue;
            button.field_146124_l = false;
            break;
        }
    }

    private void drawMiningControlMenu() {
        int xLoc;
        this.field_146292_n.clear();
        this.currentPage = EnumInteraction.MINING.getId();
        int n = xLoc = this.field_146294_l == 480 ? 170 : 145;
        int yLoc = this.field_146295_m == 240 ? 115 : (this.field_146295_m == 255 ? 125 : 132);
        int yInt = 22;
        Block block = null;
        try {
            block = RegistryMCA.getMiningEntryById(this.miningMappings.get()).getBlock();
        }
        catch (MappingNotFoundException e) {
            block = Blocks.field_150365_q;
        }
        this.field_146292_n.add(new GuiButton(EnumInteraction.BACK.getId(), this.field_146294_l / 2 + xLoc - 32, this.field_146295_m / 2 - yLoc, 14, 20, "<<"));
        this.field_146292_n.add(new GuiButton(-1, this.field_146294_l / 2 + xLoc - 16, this.field_146295_m / 2 - yLoc, 80, 20, "\u00a7EMining"));
        String modeText = "Mode: " + (this.miningModeFlag ? "Create Mine" : "Search");
        String targetText = "Target: " + block.func_149732_F();
        this.field_146292_n.add(new GuiButton(EnumInteraction.MINING_MODE.getId(), this.field_146294_l / 2 + xLoc - 40, this.field_146295_m / 2 - (yLoc -= yInt), 105, 20, modeText));
        this.field_146292_n.add(new GuiButton(EnumInteraction.MINING_TARGET.getId(), this.field_146294_l / 2 + xLoc - 80, this.field_146295_m / 2 - (yLoc -= yInt), 145, 20, targetText));
        this.field_146292_n.add(new GuiButton(EnumInteraction.START.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - (yLoc -= yInt), 65, 20, "\u00a7A" + MCA.getLocalizer().getString("gui.button.start")));
        yLoc -= yInt;
    }

    private void drawWoodcuttingControlMenu() {
        int xLoc;
        this.field_146292_n.clear();
        this.currentPage = EnumInteraction.WOODCUTTING.getId();
        int n = xLoc = this.field_146294_l == 480 ? 170 : 145;
        int yLoc = this.field_146295_m == 240 ? 115 : (this.field_146295_m == 255 ? 125 : 132);
        int yInt = 22;
        WoodcuttingEntry entry = null;
        try {
            entry = RegistryMCA.getWoodcuttingEntryById(this.woodcuttingMappings.get());
        }
        catch (MappingNotFoundException e) {
            entry = RegistryMCA.getDefaultWoodcuttingEntry();
        }
        String treeText = MCA.getLocalizer().getString("gui.button.woodcutting.logtype", new ItemStack(entry.getLogBlock(), 1, entry.getLogMeta()).func_82833_r());
        String replantText = MCA.getLocalizer().getString("gui.button.woodcutting.replant", MCA.getLocalizer().getString(this.woodcuttingReplantFlag ? "gui.button.yes" : "gui.button.no"));
        this.field_146292_n.add(new GuiButton(EnumInteraction.BACK.getId(), this.field_146294_l / 2 + xLoc - 32, this.field_146295_m / 2 - yLoc, 14, 20, "<<"));
        this.field_146292_n.add(new GuiButton(-1, this.field_146294_l / 2 + xLoc - 16, this.field_146295_m / 2 - yLoc, 80, 20, "\u00a7E" + MCA.getLocalizer().getString("gui.button.woodcutting")));
        this.field_146292_n.add(new GuiButton(EnumInteraction.WOODCUTTING_TREE.getId(), this.field_146294_l / 2 + xLoc - 66, this.field_146295_m / 2 - (yLoc -= yInt), 130, 20, treeText));
        this.field_146292_n.add(new GuiButton(EnumInteraction.WOODCUTTING_REPLANT.getId(), this.field_146294_l / 2 + xLoc - 10, this.field_146295_m / 2 - (yLoc -= yInt), 75, 20, replantText));
        this.field_146292_n.add(new GuiButton(EnumInteraction.START.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - (yLoc -= yInt), 65, 20, "\u00a7A" + MCA.getLocalizer().getString("gui.button.start")));
        yLoc -= yInt;
    }

    private void drawHuntingControlMenu() {
        int xLoc;
        this.field_146292_n.clear();
        this.currentPage = EnumInteraction.HUNTING.getId();
        int n = xLoc = this.field_146294_l == 480 ? 170 : 145;
        int yLoc = this.field_146295_m == 240 ? 115 : (this.field_146295_m == 255 ? 125 : 132);
        int yInt = 22;
        String modeText = MCA.getLocalizer().getString("gui.button.mode", this.huntingModeFlag ? MCA.getLocalizer().getString("gui.button.kill") : MCA.getLocalizer().getString("gui.button.tame"));
        this.field_146292_n.add(new GuiButton(EnumInteraction.BACK.getId(), this.field_146294_l / 2 + xLoc - 32, this.field_146295_m / 2 - yLoc, 14, 20, "<<"));
        this.field_146292_n.add(new GuiButton(-1, this.field_146294_l / 2 + xLoc - 16, this.field_146295_m / 2 - yLoc, 80, 20, "\u00a7E" + MCA.getLocalizer().getString("gui.button.hunting")));
        this.field_146292_n.add(new GuiButton(EnumInteraction.HUNTING_MODE.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - (yLoc -= yInt), 65, 20, modeText));
        this.field_146292_n.add(new GuiButton(EnumInteraction.START.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - (yLoc -= yInt), 65, 20, "\u00a7A" + MCA.getLocalizer().getString("gui.button.start")));
        yLoc -= yInt;
    }

    private void drawFishingControlMenu() {
        int xLoc;
        this.field_146292_n.clear();
        this.currentPage = EnumInteraction.FISHING.getId();
        int n = xLoc = this.field_146294_l == 480 ? 170 : 145;
        int yLoc = this.field_146295_m == 240 ? 115 : (this.field_146295_m == 255 ? 125 : 132);
        int yInt = 22;
        this.field_146292_n.add(new GuiButton(EnumInteraction.BACK.getId(), this.field_146294_l / 2 + xLoc - 32, this.field_146295_m / 2 - yLoc, 14, 20, "<<"));
        this.field_146292_n.add(new GuiButton(-1, this.field_146294_l / 2 + xLoc - 16, this.field_146295_m / 2 - yLoc, 80, 20, "\u00a7E" + MCA.getLocalizer().getString("gui.button.fishing")));
        this.field_146292_n.add(new GuiButton(EnumInteraction.START.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - (yLoc -= yInt), 65, 20, "\u00a7A" + MCA.getLocalizer().getString("gui.button.start")));
        yLoc -= yInt;
    }

    private void drawCookingControlMenu() {
        int xLoc;
        this.field_146292_n.clear();
        this.currentPage = EnumInteraction.COOKING.getId();
        int n = xLoc = this.field_146294_l == 480 ? 170 : 145;
        int yLoc = this.field_146295_m == 240 ? 115 : (this.field_146295_m == 255 ? 125 : 132);
        int yInt = 22;
        this.field_146292_n.add(new GuiButton(EnumInteraction.BACK.getId(), this.field_146294_l / 2 + xLoc - 32, this.field_146295_m / 2 - yLoc, 14, 20, "<<"));
        this.field_146292_n.add(new GuiButton(-1, this.field_146294_l / 2 + xLoc - 16, this.field_146295_m / 2 - yLoc, 80, 20, "\u00a7E" + MCA.getLocalizer().getString("gui.button.cooking")));
        this.field_146292_n.add(new GuiButton(EnumInteraction.START.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - (yLoc -= yInt), 65, 20, "\u00a7A" + MCA.getLocalizer().getString("gui.button.start")));
        yLoc -= yInt;
    }

    private void drawCombatControlMenu() {
        int xLoc;
        ActionCombat combatAI = this.villager.getBehaviors().getAction(ActionCombat.class);
        this.field_146292_n.clear();
        this.currentPage = EnumInteraction.COMBAT.getId();
        int n = xLoc = this.field_146294_l == 480 ? 170 : 145;
        int yLoc = this.field_146295_m == 240 ? 115 : (this.field_146295_m == 255 ? 125 : 132);
        int yInt = 22;
        this.field_146292_n.add(new GuiButton(EnumInteraction.BACK.getId(), this.field_146294_l / 2 + xLoc - 32, this.field_146295_m / 2 - yLoc, 14, 20, "<<"));
        this.field_146292_n.add(new GuiButton(-1, this.field_146294_l / 2 + xLoc - 16, this.field_146295_m / 2 - yLoc, 80, 20, "\u00a7E" + MCA.getLocalizer().getString("gui.button.combat")));
        this.field_146292_n.add(new GuiButton(EnumInteraction.ATTACK_METHOD.getId(), this.field_146294_l / 2 + (xLoc -= 95), this.field_146295_m / 2 - (yLoc -= yInt), 160, 20, MCA.getLocalizer().getString("combat.button.method") + combatAI.getMethodBehavior().getParsedText()));
        this.field_146292_n.add(new GuiButton(EnumInteraction.ATTACK_TRIGGER.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - (yLoc -= yInt), 160, 20, MCA.getLocalizer().getString("combat.button.trigger") + combatAI.getTriggerBehavior().getParsedText()));
        this.field_146292_n.add(new GuiButton(EnumInteraction.ATTACK_TARGET.getId(), this.field_146294_l / 2 + xLoc, this.field_146295_m / 2 - (yLoc -= yInt), 160, 20, MCA.getLocalizer().getString("combat.button.target") + combatAI.getTargetBehavior().getParsedText()));
        yLoc -= yInt;
        if (combatAI.getMethodBehavior() == EnumCombatBehaviors.METHOD_DO_NOT_FIGHT) {
            ((GuiButton)this.field_146292_n.get((int)3)).field_146124_l = false;
            ((GuiButton)this.field_146292_n.get((int)4)).field_146124_l = false;
        }
    }

    private void drawNobilityControlMenu() {
        int xLoc;
        this.field_146292_n.clear();
        this.currentPage = EnumInteraction.NOBILITY.getId();
        int n = xLoc = this.field_146294_l == 480 ? 170 : 145;
        int yLoc = this.field_146295_m == 240 ? 115 : (this.field_146295_m == 255 ? 125 : 132);
        int yInt = 22;
        String nobilityString = this.playerData.getGender() == EnumGender.MALE ? "gui.button.baron" : "gui.button.baroness";
        this.field_146292_n.add(new GuiButton(EnumInteraction.BACK.getId(), this.field_146294_l / 2 + xLoc - 32, this.field_146295_m / 2 - yLoc, 14, 20, "<<"));
        this.field_146292_n.add(new GuiButton(-1, this.field_146294_l / 2 + xLoc - 16, this.field_146295_m / 2 - yLoc, 80, 20, "\u00a7E" + MCA.getLocalizer().getString(nobilityString)));
        this.field_146292_n.add(new GuiButton(EnumInteraction.TAXES.getId(), this.field_146294_l / 2 + (xLoc -= 55), this.field_146295_m / 2 - (yLoc -= yInt), 120, 20, MCA.getLocalizer().getString("gui.button.taxes")));
        yLoc -= yInt;
        if (this.memory.getTaxResetCounter() > 0) {
            ((GuiButton)this.field_146292_n.get((int)2)).field_146124_l = false;
        }
        TutorialManager.setTutorialMessage(new TutorialMessage("Taxing will result in a small contribution of items possible", "every 20 minutes. It also decreases hearts of all nearby villagers."));
    }

    private void close() {
        Minecraft.func_71410_x().func_147108_a(null);
    }
}

