/*
 * Decompiled with CFR 0.152.
 */
package mca.core;

import java.util.UUID;
import mca.api.CookableFood;
import mca.api.CropEntry;
import mca.api.FishingEntry;
import mca.api.MiningEntry;
import mca.api.RegistryMCA;
import mca.api.WeddingGift;
import mca.api.WoodcuttingEntry;
import mca.api.enums.EnumCropCategory;
import mca.api.enums.EnumGiftCategory;
import mca.command.CommandMCA;
import mca.core.Config;
import mca.core.Localizer;
import mca.core.forge.EventHooksFML;
import mca.core.forge.EventHooksForge;
import mca.core.forge.GuiHandler;
import mca.core.forge.ServerProxy;
import mca.core.minecraft.BlocksMCA;
import mca.core.minecraft.ItemsMCA;
import mca.core.radix.CrashWatcher;
import mca.data.NBTPlayerData;
import mca.data.PlayerDataCollection;
import mca.entity.EntityChoreFishHook;
import mca.entity.EntityGrimReaper;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumGender;
import mca.enums.EnumProfession;
import mca.network.PacketHandlerMCA;
import mca.tile.TileMemorial;
import mca.tile.TileTombstone;
import mca.util.Either;
import mca.util.SkinLoader;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Logger;
import radixcore.core.ModMetadataEx;
import radixcore.core.RadixCore;
import radixcore.math.Point3D;
import radixcore.modules.RadixLogic;
import radixcore.modules.gen.SimpleOreGenerator;
import radixcore.modules.updates.NoUpdateProtocol;
import radixcore.modules.updates.RDXUpdateProtocol;

@Mod(modid="mca", name="Minecraft Comes Alive", version="1.12.2-5.3.1", dependencies="required-after:radixcore@[1.12.x-2.2.1,)", acceptedMinecraftVersions="[1.12,1.12.2]", guiFactory="mca.core.forge.client.MCAGuiFactory")
public class MCA {
    public static final String ID = "mca";
    public static final String NAME = "Minecraft Comes Alive";
    public static final String VERSION = "1.12.2-5.3.1";
    @Mod.Instance(value="mca")
    private static MCA instance;
    private static ModMetadata metadata;
    private static CreativeTabs creativeTab;
    private static Config clientConfig;
    private static Config config;
    private static Localizer localizer;
    private static PacketHandlerMCA packetHandler;
    private static CrashWatcher crashWatcher;
    private static Logger logger;
    @SidedProxy(clientSide="mca.core.forge.ClientProxy", serverSide="mca.core.forge.ServerProxy")
    public static ServerProxy proxy;
    @SideOnly(value=Side.CLIENT)
    public static NBTPlayerData myPlayerData;
    @SideOnly(value=Side.CLIENT)
    public static Point3D destinyCenterPoint;
    @SideOnly(value=Side.CLIENT)
    public static boolean destinySpawnFlag;
    @SideOnly(value=Side.CLIENT)
    public static boolean reloadLanguage;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        instance = this;
        metadata = event.getModMetadata();
        logger = event.getModLog();
        clientConfig = config = new Config(event);
        localizer = new Localizer(event);
        crashWatcher = new CrashWatcher();
        packetHandler = new PacketHandlerMCA(ID);
        proxy.registerEntityRenderers();
        proxy.registerEventHandlers();
        creativeTab = new CreativeTabs("MCA"){

            public ItemStack func_78016_d() {
                return new ItemStack(ItemsMCA.ENGAGEMENT_RING);
            }
        };
        ModMetadataEx exData = ModMetadataEx.getFromModMetadata((ModMetadata)metadata);
        exData.updateProtocol = MCA.config.allowUpdateChecking ? new RDXUpdateProtocol() : new NoUpdateProtocol();
        exData.packetHandler = packetHandler;
        RadixCore.registerMod((ModMetadataEx)exData);
        if (exData.updateProtocol == null) {
            logger.warn("Update checking is turned off. You will not be notified of any available updates for MCA.");
        }
        MinecraftForge.EVENT_BUS.register((Object)new EventHooksForge());
        MinecraftForge.EVENT_BUS.register((Object)new EventHooksFML());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.registerModelMeshers();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        SkinLoader.loadSkins();
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(ID, "VillagerMCA"), EntityVillagerMCA.class, (String)EntityVillagerMCA.class.getSimpleName(), (int)MCA.config.baseEntityId, (Object)this, (int)50, (int)2, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(ID, "FishHookMCA"), EntityChoreFishHook.class, (String)EntityChoreFishHook.class.getSimpleName(), (int)(MCA.config.baseEntityId + 1), (Object)this, (int)50, (int)2, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(ID, "GrimReaperMCA"), EntityGrimReaper.class, (String)EntityGrimReaper.class.getSimpleName(), (int)(MCA.config.baseEntityId + 2), (Object)this, (int)50, (int)2, (boolean)true);
        GameRegistry.registerTileEntity(TileTombstone.class, (String)TileTombstone.class.getSimpleName());
        GameRegistry.registerTileEntity(TileMemorial.class, (String)TileMemorial.class.getSimpleName());
        GameRegistry.addSmelting((Block)BlocksMCA.rose_gold_ore, (ItemStack)new ItemStack(ItemsMCA.ROSE_GOLD_INGOT), (float)5.0f);
        if (MCA.config.roseGoldSpawnWeight > 0) {
            SimpleOreGenerator.register((SimpleOreGenerator)new SimpleOreGenerator(BlocksMCA.rose_gold_ore, 6, 12, 40, true, false), (int)MCA.config.roseGoldSpawnWeight);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        RegistryMCA.addObjectAsGift(Items.field_151041_m, 3);
        RegistryMCA.addObjectAsGift(Items.field_151053_p, 3);
        RegistryMCA.addObjectAsGift(Items.field_151017_I, 3);
        RegistryMCA.addObjectAsGift(Items.field_151038_n, 3);
        RegistryMCA.addObjectAsGift(Items.field_151052_q, 5);
        RegistryMCA.addObjectAsGift(Items.field_151049_t, 5);
        RegistryMCA.addObjectAsGift(Items.field_151018_J, 5);
        RegistryMCA.addObjectAsGift(Items.field_151051_r, 5);
        RegistryMCA.addObjectAsGift(Items.field_151039_o, 3);
        RegistryMCA.addObjectAsGift(Items.field_151082_bd, 2);
        RegistryMCA.addObjectAsGift(Items.field_151076_bf, 2);
        RegistryMCA.addObjectAsGift(Items.field_151147_al, 2);
        RegistryMCA.addObjectAsGift(Items.field_151116_aA, 2);
        RegistryMCA.addObjectAsGift(Items.field_151027_R, 5);
        RegistryMCA.addObjectAsGift(Items.field_151024_Q, 5);
        RegistryMCA.addObjectAsGift(Items.field_151026_S, 5);
        RegistryMCA.addObjectAsGift(Items.field_151021_T, 5);
        RegistryMCA.addObjectAsGift(Items.field_151120_aE, 2);
        RegistryMCA.addObjectAsGift(Items.field_151014_N, 2);
        RegistryMCA.addObjectAsGift(Items.field_151015_O, 3);
        RegistryMCA.addObjectAsGift(Items.field_151025_P, 6);
        RegistryMCA.addObjectAsGift(Items.field_151044_h, 5);
        RegistryMCA.addObjectAsGift(Items.field_151102_aT, 5);
        RegistryMCA.addObjectAsGift(Items.field_151119_aD, 2);
        RegistryMCA.addObjectAsGift(Items.field_151100_aR, 1);
        RegistryMCA.addObjectAsGift(Items.field_151083_be, 7);
        RegistryMCA.addObjectAsGift(Items.field_151077_bg, 7);
        RegistryMCA.addObjectAsGift(Items.field_151157_am, 7);
        RegistryMCA.addObjectAsGift(Items.field_151106_aX, 10);
        RegistryMCA.addObjectAsGift(Items.field_151127_ba, 10);
        RegistryMCA.addObjectAsGift(Items.field_151081_bc, 5);
        RegistryMCA.addObjectAsGift(Items.field_151028_Y, 10);
        RegistryMCA.addObjectAsGift(Items.field_151030_Z, 10);
        RegistryMCA.addObjectAsGift(Items.field_151165_aa, 10);
        RegistryMCA.addObjectAsGift(Items.field_151167_ab, 10);
        RegistryMCA.addObjectAsGift(Items.field_151105_aU, 12);
        RegistryMCA.addObjectAsGift(Items.field_151040_l, 10);
        RegistryMCA.addObjectAsGift(Items.field_151036_c, 10);
        RegistryMCA.addObjectAsGift(Items.field_151019_K, 10);
        RegistryMCA.addObjectAsGift(Items.field_151035_b, 10);
        RegistryMCA.addObjectAsGift(Items.field_151037_a, 10);
        RegistryMCA.addObjectAsGift(Items.field_151112_aM, 3);
        RegistryMCA.addObjectAsGift(Items.field_151031_f, 5);
        RegistryMCA.addObjectAsGift(Items.field_151122_aG, 5);
        RegistryMCA.addObjectAsGift(Items.field_151133_ar, 3);
        RegistryMCA.addObjectAsGift(Items.field_151117_aB, 5);
        RegistryMCA.addObjectAsGift(Items.field_151131_as, 2);
        RegistryMCA.addObjectAsGift(Items.field_151129_at, 2);
        RegistryMCA.addObjectAsGift(Items.field_151009_A, 5);
        RegistryMCA.addObjectAsGift(Items.field_151080_bb, 8);
        RegistryMCA.addObjectAsGift(Items.field_151033_d, 4);
        RegistryMCA.addObjectAsGift(Items.field_151137_ax, 5);
        RegistryMCA.addObjectAsGift(Items.field_151124_az, 4);
        RegistryMCA.addObjectAsGift(Items.field_179570_aq, 4);
        RegistryMCA.addObjectAsGift(Items.field_151139_aw, 6);
        RegistryMCA.addObjectAsGift(Items.field_151143_au, 7);
        RegistryMCA.addObjectAsGift(Items.field_151145_ak, 2);
        RegistryMCA.addObjectAsGift(Items.field_151074_bl, 4);
        RegistryMCA.addObjectAsGift(Items.field_151043_k, 20);
        RegistryMCA.addObjectAsGift(Items.field_151042_j, 10);
        RegistryMCA.addObjectAsGift(Items.field_151045_i, 30);
        RegistryMCA.addObjectAsGift(Items.field_151148_bJ, 10);
        RegistryMCA.addObjectAsGift(Items.field_151113_aN, 5);
        RegistryMCA.addObjectAsGift(Items.field_151111_aL, 5);
        RegistryMCA.addObjectAsGift(Items.field_151072_bj, 10);
        RegistryMCA.addObjectAsGift(Items.field_151065_br, 5);
        RegistryMCA.addObjectAsGift(Items.field_151048_u, 15);
        RegistryMCA.addObjectAsGift(Items.field_151056_x, 15);
        RegistryMCA.addObjectAsGift(Items.field_151047_v, 15);
        RegistryMCA.addObjectAsGift(Items.field_151012_L, 15);
        RegistryMCA.addObjectAsGift(Items.field_151161_ac, 15);
        RegistryMCA.addObjectAsGift(Items.field_151163_ad, 15);
        RegistryMCA.addObjectAsGift(Items.field_151173_ae, 15);
        RegistryMCA.addObjectAsGift(Items.field_151175_af, 15);
        RegistryMCA.addObjectAsGift(Items.field_151159_an, 6);
        RegistryMCA.addObjectAsGift(Items.field_151079_bi, 5);
        RegistryMCA.addObjectAsGift(Items.field_151061_bv, 10);
        RegistryMCA.addObjectAsGift(Items.field_151068_bn, 3);
        RegistryMCA.addObjectAsGift(Items.field_151123_aH, 3);
        RegistryMCA.addObjectAsGift(Items.field_151141_av, 5);
        RegistryMCA.addObjectAsGift(Items.field_151016_H, 7);
        RegistryMCA.addObjectAsGift(Items.field_151153_ao, 25);
        RegistryMCA.addObjectAsGift(Items.field_151086_cn, 15);
        RegistryMCA.addObjectAsGift(Items.field_151096_cd, 15);
        RegistryMCA.addObjectAsGift(Items.field_151084_co, 15);
        RegistryMCA.addObjectAsGift(Items.field_151093_ce, 15);
        RegistryMCA.addObjectAsGift(Items.field_151091_cg, 15);
        RegistryMCA.addObjectAsGift(Items.field_151092_ch, 15);
        RegistryMCA.addObjectAsGift(Items.field_151089_ci, 15);
        RegistryMCA.addObjectAsGift(Items.field_151090_cj, 15);
        RegistryMCA.addObjectAsGift(Items.field_151087_ck, 15);
        RegistryMCA.addObjectAsGift(Items.field_151088_cl, 15);
        RegistryMCA.addObjectAsGift(Items.field_151085_cm, 15);
        RegistryMCA.addObjectAsGift(Items.field_151166_bC, 25);
        RegistryMCA.addObjectAsGift(Blocks.field_150328_O, 5);
        RegistryMCA.addObjectAsGift(Blocks.field_150327_N, 5);
        RegistryMCA.addObjectAsGift(Blocks.field_150344_f, 5);
        RegistryMCA.addObjectAsGift(Blocks.field_150364_r, 3);
        RegistryMCA.addObjectAsGift(Blocks.field_150423_aK, 3);
        RegistryMCA.addObjectAsGift(Blocks.field_150486_ae, 5);
        RegistryMCA.addObjectAsGift(Blocks.field_150325_L, 2);
        RegistryMCA.addObjectAsGift(Blocks.field_150366_p, 4);
        RegistryMCA.addObjectAsGift(Blocks.field_150352_o, 7);
        RegistryMCA.addObjectAsGift(Blocks.field_150450_ax, 3);
        RegistryMCA.addObjectAsGift(Blocks.field_150448_aq, 3);
        RegistryMCA.addObjectAsGift(Blocks.field_150319_E, 5);
        RegistryMCA.addObjectAsGift(Blocks.field_150408_cc, 5);
        RegistryMCA.addObjectAsGift(Blocks.field_150460_al, 5);
        RegistryMCA.addObjectAsGift(Blocks.field_150462_ai, 5);
        RegistryMCA.addObjectAsGift(Blocks.field_150368_y, 15);
        RegistryMCA.addObjectAsGift(Blocks.field_150342_X, 7);
        RegistryMCA.addObjectAsGift(Blocks.field_150340_R, 50);
        RegistryMCA.addObjectAsGift(Blocks.field_150339_S, 25);
        RegistryMCA.addObjectAsGift(Blocks.field_150484_ah, 100);
        RegistryMCA.addObjectAsGift(Blocks.field_150382_bo, 12);
        RegistryMCA.addObjectAsGift(Blocks.field_150381_bn, 25);
        RegistryMCA.addObjectAsGift(Blocks.field_150336_V, 15);
        RegistryMCA.addObjectAsGift(Blocks.field_150343_Z, 15);
        RegistryMCA.addObjectAsGift(Blocks.field_150331_J, 10);
        RegistryMCA.addObjectAsGift(Blocks.field_150426_aN, 10);
        RegistryMCA.addObjectAsGift(Blocks.field_150475_bE, 100);
        RegistryMCA.addObjectAsGift(BlocksMCA.rose_gold_block, 35);
        RegistryMCA.addObjectAsGift(BlocksMCA.rose_gold_ore, 7);
        RegistryMCA.addObjectAsGift(Blocks.field_150451_bX, 20);
        RegistryMCA.addFishingEntryToFishingAI(0, new FishingEntry(Items.field_151115_aP));
        RegistryMCA.addFishingEntryToFishingAI(1, new FishingEntry(Items.field_151115_aP, ItemFishFood.FishType.CLOWNFISH.func_150976_a()));
        RegistryMCA.addFishingEntryToFishingAI(2, new FishingEntry(Items.field_151115_aP, ItemFishFood.FishType.COD.func_150976_a()));
        RegistryMCA.addFishingEntryToFishingAI(3, new FishingEntry(Items.field_151115_aP, ItemFishFood.FishType.PUFFERFISH.func_150976_a()));
        RegistryMCA.addFishingEntryToFishingAI(4, new FishingEntry(Items.field_151115_aP, ItemFishFood.FishType.SALMON.func_150976_a()));
        if (MCA.getConfig().additionalGiftItems.length > 0) {
            for (String entry : MCA.getConfig().additionalGiftItems) {
                try {
                    Object addObject;
                    String[] split = entry.split("\\|");
                    int heartsValue = Integer.parseInt(split[1]);
                    String itemName = split[0];
                    if (itemName.startsWith("#")) continue;
                    Object item = Item.field_150901_e.func_82594_a((Object)new ResourceLocation(itemName));
                    Object block = Block.field_149771_c.func_82594_a((Object)new ResourceLocation(itemName));
                    Object object = item != null ? item : (addObject = block != null ? block : null);
                    if (addObject != null) {
                        RegistryMCA.addObjectAsGift(addObject, heartsValue);
                        logger.info("Successfully added " + itemName + " with hearts value of " + heartsValue + " to gift registry.");
                        continue;
                    }
                    logger.error("Failed to find item by name provided. Gift entry not created: " + entry);
                }
                catch (Exception e) {
                    logger.error("Failed to add additional gift due to error. Use <item name>|<hearts value>: " + entry);
                }
            }
        }
        RegistryMCA.addBlockToMiningAI(1, new MiningEntry(Blocks.field_150365_q, Items.field_151044_h, 0.45f));
        RegistryMCA.addBlockToMiningAI(2, new MiningEntry(Blocks.field_150366_p, 0.4f));
        RegistryMCA.addBlockToMiningAI(3, new MiningEntry(Blocks.field_150369_x, new ItemStack(Items.field_151100_aR, 1, 4), 0.3f));
        RegistryMCA.addBlockToMiningAI(4, new MiningEntry(Blocks.field_150352_o, 0.05f));
        RegistryMCA.addBlockToMiningAI(5, new MiningEntry(Blocks.field_150482_ag, Items.field_151045_i, 0.04f));
        RegistryMCA.addBlockToMiningAI(6, new MiningEntry(Blocks.field_150412_bA, Items.field_151166_bC, 0.03f));
        RegistryMCA.addBlockToMiningAI(7, new MiningEntry(Blocks.field_150449_bY, Items.field_151128_bU, 0.02f));
        RegistryMCA.addBlockToMiningAI(8, new MiningEntry(BlocksMCA.rose_gold_ore, 0.07f));
        RegistryMCA.addBlockToWoodcuttingAI(1, new WoodcuttingEntry(Blocks.field_150364_r, 0, Blocks.field_150345_g, 0));
        RegistryMCA.addBlockToWoodcuttingAI(2, new WoodcuttingEntry(Blocks.field_150364_r, 1, Blocks.field_150345_g, 1));
        RegistryMCA.addBlockToWoodcuttingAI(3, new WoodcuttingEntry(Blocks.field_150364_r, 2, Blocks.field_150345_g, 2));
        RegistryMCA.addBlockToWoodcuttingAI(4, new WoodcuttingEntry(Blocks.field_150364_r, 3, Blocks.field_150345_g, 3));
        RegistryMCA.addBlockToWoodcuttingAI(5, new WoodcuttingEntry(Blocks.field_150363_s, 0, Blocks.field_150345_g, 4));
        RegistryMCA.addBlockToWoodcuttingAI(6, new WoodcuttingEntry(Blocks.field_150363_s, 1, Blocks.field_150345_g, 5));
        RegistryMCA.addEntityToHuntingAI(EntitySheep.class);
        RegistryMCA.addEntityToHuntingAI(EntityCow.class);
        RegistryMCA.addEntityToHuntingAI(EntityPig.class);
        RegistryMCA.addEntityToHuntingAI(EntityChicken.class);
        RegistryMCA.addEntityToHuntingAI(EntityOcelot.class, false);
        RegistryMCA.addEntityToHuntingAI(EntityWolf.class, false);
        RegistryMCA.addFoodToCookingAI(new CookableFood(Items.field_151147_al, Items.field_151157_am));
        RegistryMCA.addFoodToCookingAI(new CookableFood(Items.field_151082_bd, Items.field_151083_be));
        RegistryMCA.addFoodToCookingAI(new CookableFood(Items.field_151076_bf, Items.field_151077_bg));
        RegistryMCA.addFoodToCookingAI(new CookableFood(Items.field_151115_aP, Items.field_179566_aV));
        RegistryMCA.addFoodToCookingAI(new CookableFood(Items.field_151174_bG, Items.field_151168_bH));
        RegistryMCA.addCropToFarmingAI(1, new CropEntry(EnumCropCategory.WHEAT, Blocks.field_150464_aj, Items.field_151014_N, Blocks.field_150464_aj, 7, Items.field_151015_O, 1, 4));
        RegistryMCA.addCropToFarmingAI(2, new CropEntry(EnumCropCategory.WHEAT, Blocks.field_150469_bN, Items.field_151174_bG, Blocks.field_150469_bN, 7, Items.field_151174_bG, 1, 4));
        RegistryMCA.addCropToFarmingAI(3, new CropEntry(EnumCropCategory.WHEAT, Blocks.field_150459_bM, Items.field_151172_bF, Blocks.field_150459_bM, 7, Items.field_151172_bF, 1, 4));
        RegistryMCA.addCropToFarmingAI(4, new CropEntry(EnumCropCategory.WHEAT, Blocks.field_185773_cZ, Items.field_185163_cU, Blocks.field_185773_cZ, 7, Items.field_185164_cV, 1, 4));
        RegistryMCA.addCropToFarmingAI(5, new CropEntry(EnumCropCategory.MELON, Blocks.field_150394_bc, Items.field_151081_bc, Blocks.field_150440_ba, 0, Items.field_151127_ba, 2, 6));
        RegistryMCA.addCropToFarmingAI(6, new CropEntry(EnumCropCategory.MELON, Blocks.field_150393_bb, Items.field_151080_bb, Blocks.field_150423_aK, 0, null, 1, 1));
        RegistryMCA.addCropToFarmingAI(7, new CropEntry(EnumCropCategory.SUGARCANE, (Block)Blocks.field_150436_aH, Items.field_151120_aE, (Block)Blocks.field_150436_aH, 0, Items.field_151120_aE, 1, 1));
        RegistryMCA.addWeddingGift(new WeddingGift(Blocks.field_150346_d, 1, 6), EnumGiftCategory.BAD);
        RegistryMCA.addWeddingGift(new WeddingGift((Block)Blocks.field_150330_I, 1, 1), EnumGiftCategory.BAD);
        RegistryMCA.addWeddingGift(new WeddingGift((Block)Blocks.field_150434_aF, 1, 3), EnumGiftCategory.BAD);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151055_y, 1, 4), EnumGiftCategory.BAD);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151078_bh, 1, 4), EnumGiftCategory.BAD);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151119_aD, 4, 16), EnumGiftCategory.GOOD);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151049_t, 1, 1), EnumGiftCategory.GOOD);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151052_q, 1, 1), EnumGiftCategory.GOOD);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151051_r, 1, 1), EnumGiftCategory.GOOD);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151034_e, 1, 4), EnumGiftCategory.GOOD);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151032_g, 8, 16), EnumGiftCategory.GOOD);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151050_s, 1, 1), EnumGiftCategory.GOOD);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151122_aG, 1, 2), EnumGiftCategory.GOOD);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151137_ax, 8, 32), EnumGiftCategory.GOOD);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151157_am, 3, 6), EnumGiftCategory.GOOD);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151083_be, 3, 6), EnumGiftCategory.GOOD);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151077_bg, 3, 6), EnumGiftCategory.GOOD);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151025_P, 1, 3), EnumGiftCategory.GOOD);
        RegistryMCA.addWeddingGift(new WeddingGift(Blocks.field_150344_f, 2, 16), EnumGiftCategory.GOOD);
        RegistryMCA.addWeddingGift(new WeddingGift(Blocks.field_150364_r, 2, 16), EnumGiftCategory.GOOD);
        RegistryMCA.addWeddingGift(new WeddingGift(Blocks.field_150347_e, 2, 16), EnumGiftCategory.GOOD);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151044_h, 2, 8), EnumGiftCategory.GOOD);
        RegistryMCA.addWeddingGift(new WeddingGift((Item)ItemsMCA.BOOK_ROSE_GOLD, 1, 1), EnumGiftCategory.BEST);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151119_aD, 16, 32), EnumGiftCategory.BETTER);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151036_c, 1, 1), EnumGiftCategory.BETTER);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151040_l, 1, 1), EnumGiftCategory.BETTER);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151037_a, 1, 1), EnumGiftCategory.BETTER);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151032_g, 16, 32), EnumGiftCategory.BETTER);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151035_b, 1, 1), EnumGiftCategory.BETTER);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151137_ax, 8, 32), EnumGiftCategory.BETTER);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151157_am, 6, 8), EnumGiftCategory.BETTER);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151083_be, 6, 8), EnumGiftCategory.BETTER);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151077_bg, 6, 8), EnumGiftCategory.BETTER);
        RegistryMCA.addWeddingGift(new WeddingGift(Blocks.field_150344_f, 16, 32), EnumGiftCategory.BETTER);
        RegistryMCA.addWeddingGift(new WeddingGift(Blocks.field_150364_r, 16, 32), EnumGiftCategory.BETTER);
        RegistryMCA.addWeddingGift(new WeddingGift(Blocks.field_150347_e, 16, 32), EnumGiftCategory.BETTER);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151044_h, 10, 16), EnumGiftCategory.BETTER);
        RegistryMCA.addWeddingGift(new WeddingGift((Item)Items.field_151028_Y, 1, 1), EnumGiftCategory.BETTER);
        RegistryMCA.addWeddingGift(new WeddingGift((Item)Items.field_151030_Z, 1, 1), EnumGiftCategory.BETTER);
        RegistryMCA.addWeddingGift(new WeddingGift((Item)Items.field_151167_ab, 1, 1), EnumGiftCategory.BETTER);
        RegistryMCA.addWeddingGift(new WeddingGift((Item)Items.field_151165_aa, 1, 1), EnumGiftCategory.BETTER);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151127_ba, 4, 8), EnumGiftCategory.BETTER);
        RegistryMCA.addWeddingGift(new WeddingGift(Blocks.field_150342_X, 2, 4), EnumGiftCategory.BETTER);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151042_j, 8, 16), EnumGiftCategory.BETTER);
        RegistryMCA.addWeddingGift(new WeddingGift((Item)ItemsMCA.BOOK_INFECTION, 1, 1), EnumGiftCategory.BETTER);
        RegistryMCA.addWeddingGift(new WeddingGift((Item)ItemsMCA.BOOK_ROMANCE, 1, 1), EnumGiftCategory.BETTER);
        RegistryMCA.addWeddingGift(new WeddingGift((Item)ItemsMCA.BOOK_FAMILY, 1, 1), EnumGiftCategory.BETTER);
        RegistryMCA.addWeddingGift(new WeddingGift(Blocks.field_150336_V, 32, 32), EnumGiftCategory.BEST);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151056_x, 1, 1), EnumGiftCategory.BEST);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151048_u, 1, 1), EnumGiftCategory.BEST);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151047_v, 1, 1), EnumGiftCategory.BEST);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151032_g, 64, 64), EnumGiftCategory.BEST);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151046_w, 1, 1), EnumGiftCategory.BEST);
        RegistryMCA.addWeddingGift(new WeddingGift(Blocks.field_150344_f, 32, 64), EnumGiftCategory.BEST);
        RegistryMCA.addWeddingGift(new WeddingGift(Blocks.field_150364_r, 32, 64), EnumGiftCategory.BEST);
        RegistryMCA.addWeddingGift(new WeddingGift(Blocks.field_150347_e, 32, 64), EnumGiftCategory.BEST);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151044_h, 32, 64), EnumGiftCategory.BEST);
        RegistryMCA.addWeddingGift(new WeddingGift((Item)Items.field_151173_ae, 1, 1), EnumGiftCategory.BEST);
        RegistryMCA.addWeddingGift(new WeddingGift((Item)Items.field_151161_ac, 1, 1), EnumGiftCategory.BEST);
        RegistryMCA.addWeddingGift(new WeddingGift((Item)Items.field_151175_af, 1, 1), EnumGiftCategory.BEST);
        RegistryMCA.addWeddingGift(new WeddingGift((Item)Items.field_151163_ad, 1, 1), EnumGiftCategory.BEST);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151061_bv, 4, 8), EnumGiftCategory.BEST);
        RegistryMCA.addWeddingGift(new WeddingGift(Blocks.field_150381_bn, 1, 1), EnumGiftCategory.BEST);
        RegistryMCA.addWeddingGift(new WeddingGift(Blocks.field_150341_Y, 32, 64), EnumGiftCategory.BEST);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151045_i, 8, 16), EnumGiftCategory.BEST);
        RegistryMCA.addWeddingGift(new WeddingGift(Blocks.field_150421_aI, 1, 1), EnumGiftCategory.BEST);
        RegistryMCA.addWeddingGift(new WeddingGift(Blocks.field_150484_ah, 1, 2), EnumGiftCategory.BEST);
        RegistryMCA.addWeddingGift(new WeddingGift(Blocks.field_150340_R, 1, 4), EnumGiftCategory.BEST);
        RegistryMCA.addWeddingGift(new WeddingGift(Blocks.field_150339_S, 1, 8), EnumGiftCategory.BEST);
        RegistryMCA.addWeddingGift(new WeddingGift(Blocks.field_150343_Z, 4, 8), EnumGiftCategory.BEST);
        RegistryMCA.addWeddingGift(new WeddingGift(Items.field_151166_bC, 4, 6), EnumGiftCategory.BEST);
        RegistryMCA.addWeddingGift(new WeddingGift((Item)ItemsMCA.BOOK_DEATH, 1, 1), EnumGiftCategory.BEST);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandMCA());
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
    }

    public static MCA getInstance() {
        return instance;
    }

    public static Logger getLog() {
        return logger;
    }

    public static Config getConfig() {
        return config;
    }

    public static void setConfig(Config configObj) {
        config = configObj;
    }

    public static void resetConfig() {
        if (config != clientConfig) {
            logger.info("Resetting config to client-side values...");
            config = clientConfig;
        }
    }

    public static ModMetadata getMetadata() {
        return metadata;
    }

    public static CreativeTabs getCreativeTab() {
        return creativeTab;
    }

    public static void setCreativeTab(CreativeTabs tab) {
        creativeTab = tab;
    }

    public static Localizer getLocalizer() {
        return localizer;
    }

    public static PacketHandlerMCA getPacketHandler() {
        return packetHandler;
    }

    public static NBTPlayerData getPlayerData(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            return PlayerDataCollection.get().getPlayerData(player.func_110124_au());
        }
        return myPlayerData;
    }

    public static NBTPlayerData getPlayerData(World world, UUID uuid) {
        return PlayerDataCollection.get().getPlayerData(uuid);
    }

    public static void naturallySpawnVillagers(Point3D pointOfSpawn, World world, int originalProfession) {
        boolean hasFamily = RadixLogic.getBooleanWithProbability((int)20);
        boolean adult1IsMale = RadixLogic.getBooleanWithProbability((int)50);
        EntityVillagerMCA adult1 = new EntityVillagerMCA(world);
        adult1.attributes.setGender(adult1IsMale ? EnumGender.MALE : EnumGender.FEMALE);
        adult1.attributes.setProfession(originalProfession != -1 ? EnumProfession.getProfessionById(originalProfession) : EnumProfession.getAtRandom());
        adult1.attributes.assignRandomName();
        adult1.attributes.assignRandomSkin();
        adult1.attributes.assignRandomPersonality();
        adult1.func_70107_b(pointOfSpawn.dX(), pointOfSpawn.dY(), pointOfSpawn.dZ());
        if (hasFamily) {
            EntityVillagerMCA adult2 = new EntityVillagerMCA(world);
            adult2.attributes.setGender(adult1IsMale ? EnumGender.FEMALE : EnumGender.MALE);
            adult2.attributes.assignRandomProfession();
            adult2.attributes.assignRandomName();
            adult2.attributes.assignRandomSkin();
            adult2.attributes.assignRandomPersonality();
            adult2.func_70107_b(adult1.field_70165_t, adult1.field_70163_u, adult1.field_70161_v - 1.0);
            world.func_72838_d((Entity)adult2);
            adult1.startMarriage(Either.withL(adult2));
            EntityVillagerMCA father = adult1IsMale ? adult1 : adult2;
            EntityVillagerMCA mother = father == adult1 ? adult2 : adult1;
            for (int i = 0; i < 2; ++i) {
                if (RadixLogic.getBooleanWithProbability((int)66)) continue;
                EntityVillagerMCA child = new EntityVillagerMCA(world);
                child.attributes.assignRandomGender();
                child.attributes.assignRandomName();
                child.attributes.assignRandomProfession();
                child.attributes.assignRandomSkin();
                child.attributes.assignRandomPersonality();
                child.attributes.setMother(Either.withL(mother));
                child.attributes.setFather(Either.withL(father));
                child.func_70107_b(pointOfSpawn.dX(), pointOfSpawn.dY(), pointOfSpawn.dZ() + 1.0);
                world.func_72838_d((Entity)child);
            }
        }
        world.func_72838_d((Entity)adult1);
    }

    public static CrashWatcher getCrashWatcher() {
        return crashWatcher;
    }

    public static Entity getEntityByUUID(World world, UUID uuid) {
        for (Entity entity : world.field_72996_f) {
            if (entity.func_110124_au() != uuid) continue;
            return entity;
        }
        return null;
    }
}

