/*
 * Decompiled with CFR 0.152.
 */
package mca.core.forge;

import java.lang.reflect.Field;
import java.util.List;
import mca.actions.ActionCombat;
import mca.core.Constants;
import mca.core.MCA;
import mca.core.forge.EventHooksFML;
import mca.core.minecraft.BlocksMCA;
import mca.core.minecraft.ItemsMCA;
import mca.core.minecraft.SoundsMCA;
import mca.data.PlayerMemory;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumCombatBehaviors;
import mca.enums.EnumProfession;
import mca.items.ItemBaby;
import mca.packets.PacketInteractWithPlayerC;
import mca.util.TutorialManager;
import mca.util.Utilities;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import radixcore.math.Point3D;
import radixcore.modules.RadixBlocks;
import radixcore.modules.RadixLogic;

public class EventHooksForge {
    @SubscribeEvent
    public void onRegisterItems(RegistryEvent.Register<Item> event) {
        ItemsMCA.register(event);
        BlocksMCA.registerItemBlocks(event);
    }

    @SubscribeEvent
    public void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        BlocksMCA.register(event);
    }

    @SubscribeEvent
    public void onRegisterSounds(RegistryEvent.Register<SoundEvent> event) {
        SoundsMCA.register(event);
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        if (event.getName().toString().equals("minecraft:chests/simple_dungeon") || event.getName().toString().equals("minecraft:chests/stronghold_library")) {
            LootPool main = event.getTable().getPool("main");
            main.addEntry((LootEntry)new LootEntryItem((Item)ItemsMCA.BOOK_DEATH, 20, 0, new LootFunction[0], new LootCondition[0], "mca:book_death"));
            main.addEntry((LootEntry)new LootEntryItem((Item)ItemsMCA.BOOK_FAMILY, 20, 0, new LootFunction[0], new LootCondition[0], "mca:book_family"));
            main.addEntry((LootEntry)new LootEntryItem((Item)ItemsMCA.BOOK_INFECTION, 20, 0, new LootFunction[0], new LootCondition[0], "mca:book_infection"));
            main.addEntry((LootEntry)new LootEntryItem((Item)ItemsMCA.BOOK_ROMANCE, 20, 0, new LootFunction[0], new LootCondition[0], "mca:book_romance"));
            main.addEntry((LootEntry)new LootEntryItem((Item)ItemsMCA.BOOK_ROSE_GOLD, 20, 0, new LootFunction[0], new LootCondition[0], "mca:book_rose_gold"));
        }
    }

    @SubscribeEvent
    public void entityJoinedWorldEventHandler(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K && MCA.getConfig().canSpawnInDimension(event.getWorld().field_73011_w.getDimension())) {
            if (event.getEntity() instanceof EntityMob) {
                this.doAddMobTasks((EntityMob)event.getEntity());
            }
            if (event.getEntity().getClass() == EntityVillager.class && MCA.getConfig().overwriteOriginalVillagers) {
                EntityVillager villager = (EntityVillager)event.getEntity();
                List zombiesAroundMe = RadixLogic.getEntitiesWithinDistance(EntityZombieVillager.class, (Entity)event.getEntity(), (int)3);
                for (EntityZombieVillager zombie : zombiesAroundMe) {
                    if (!zombie.func_82230_o()) continue;
                    boolean isMale = RadixLogic.getBooleanWithProbability((int)50);
                    EntityVillagerMCA human = new EntityVillagerMCA(zombie.field_70170_p);
                    human.func_70107_b(zombie.field_70165_t, zombie.field_70163_u, zombie.field_70161_v);
                    zombie.field_70170_p.func_72838_d((Entity)human);
                    event.getEntity().func_70106_y();
                    return;
                }
                if (villager.func_70946_n() >= 0 && villager.func_70946_n() <= 4) {
                    villager.func_184212_Q().func_187214_a(Constants.OVERWRITE_KEY, (Object)3577);
                }
            }
        }
    }

    @SubscribeEvent
    public void renderGameOverlayEventHandler(RenderGameOverlayEvent.Text event) {
        TutorialManager.onUpdate();
    }

    private void doAddMobTasks(EntityMob mob) {
        if (MCA.getConfig().allowMobAttacks) {
            if (mob instanceof EntityEnderman) {
                return;
            }
            if (mob instanceof EntityCreeper) {
                mob.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)mob, EntityVillagerMCA.class, 6.0f, 1.0, 1.2));
            } else {
                double moveSpeed = 0.7;
                if (mob instanceof EntitySpider) {
                    moveSpeed = 1.2;
                } else if (mob instanceof EntitySkeleton) {
                    moveSpeed = 1.1;
                } else if (mob instanceof EntityZombie) {
                    moveSpeed = 0.9;
                }
                mob.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)mob, EntityVillagerMCA.class, false));
            }
        } else if (mob.field_70714_bg != null && mob.field_70715_bh.field_75782_a != null) {
            for (int i = 0; i < mob.field_70715_bh.field_75782_a.size(); ++i) {
                try {
                    EntityAITasks.EntityAITaskEntry task = (EntityAITasks.EntityAITaskEntry)mob.field_70715_bh.field_75782_a.toArray()[i];
                    if (!(task.field_75733_a instanceof EntityAINearestAttackableTarget)) continue;
                    EntityAINearestAttackableTarget nat = (EntityAINearestAttackableTarget)task.field_75733_a;
                    for (Field f : nat.getClass().getDeclaredFields()) {
                        if (!f.getType().equals(Class.class)) continue;
                        f.setAccessible(true);
                        Class targetClass = (Class)f.get(nat);
                        f.setAccessible(false);
                        if (!targetClass.isAssignableFrom(EntityVillager.class)) continue;
                        mob.field_70715_bh.func_85156_a((EntityAIBase)nat);
                    }
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    @SubscribeEvent
    public void entityInteractEventHandler(PlayerInteractEvent.EntityInteract event) {
        if (!(event.getEntityPlayer() instanceof FakePlayer)) {
            if (event.getTarget() instanceof EntityHorse) {
                EntityHorse entityHorse = (EntityHorse)event.getTarget();
                if (entityHorse.func_184207_aI()) {
                    try {
                        EntityVillagerMCA entity = (EntityVillagerMCA)((Object)entityHorse.func_184188_bt().get(0));
                        entity.func_184645_a(event.getEntityPlayer(), event.getEntityPlayer().func_184600_cs());
                    }
                    catch (Exception exception) {}
                }
            } else if (event.getTarget() instanceof EntityPlayerMP && !event.getEntityPlayer().field_70170_p.field_72995_K && !event.getEntityPlayer().func_70005_c_().contains("[CoFH]")) {
                MCA.getPacketHandler().sendPacketToPlayer((IMessage)new PacketInteractWithPlayerC(event.getEntityPlayer(), (EntityPlayer)event.getTarget()), (EntityPlayer)((EntityPlayerMP)event.getEntityPlayer()));
            }
        }
    }

    @SubscribeEvent
    public void worldSaveEventHandler(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K && event.getWorld().field_73011_w.getDimension() == 0) {
            MCA.getCrashWatcher().checkForCrashReports();
        }
    }

    @SubscribeEvent
    public void rightClickBlockEventHandler(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntityPlayer().func_184179_bs() instanceof EntityVillagerMCA) {
            event.getEntityPlayer().func_184179_bs().func_184210_p();
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        PlayerMemory memory;
        ActionCombat combat;
        Object human;
        List entityList;
        if (event.getEntityLiving() instanceof FakePlayer) {
            return;
        }
        if (event.getEntityLiving() instanceof EntityPlayer && event.getSource().func_76346_g() instanceof EntityLivingBase) {
            entityList = RadixLogic.getEntitiesWithinDistance(EntityVillagerMCA.class, (Entity)event.getEntityLiving(), (int)15);
            for (Entity entity : entityList) {
                human = (EntityVillagerMCA)entity;
                combat = ((EntityVillagerMCA)((Object)human)).getBehavior(ActionCombat.class);
                memory = ((EntityVillagerMCA)((Object)human)).attributes.getPlayerMemory((EntityPlayer)event.getEntityLiving());
                if (!memory.getIsHiredBy() || ((EntityVillagerMCA)((Object)human)).attributes.getProfessionEnum() != EnumProfession.Warrior || combat.getMethodBehavior() == EnumCombatBehaviors.METHOD_DO_NOT_FIGHT || combat.getTriggerBehavior() != EnumCombatBehaviors.TRIGGER_PLAYER_TAKE_DAMAGE) continue;
                combat.setAttackTarget((EntityLivingBase)event.getSource().func_76346_g());
            }
        } else if (event.getSource().func_76346_g() instanceof EntityPlayer && event.getEntityLiving() != null) {
            entityList = RadixLogic.getEntitiesWithinDistance(EntityVillagerMCA.class, (Entity)event.getSource().func_76346_g(), (int)15);
            for (Entity entity : entityList) {
                human = (EntityVillagerMCA)entity;
                combat = ((EntityVillagerMCA)((Object)human)).getBehavior(ActionCombat.class);
                memory = ((EntityVillagerMCA)((Object)human)).attributes.getPlayerMemory((EntityPlayer)event.getSource().func_76346_g());
                if (!memory.getIsHiredBy() || ((EntityVillagerMCA)((Object)human)).attributes.getProfessionEnum() != EnumProfession.Warrior || combat.getMethodBehavior() == EnumCombatBehaviors.METHOD_DO_NOT_FIGHT || combat.getTriggerBehavior() != EnumCombatBehaviors.TRIGGER_PLAYER_DEAL_DAMAGE) continue;
                combat.setAttackTarget(event.getEntityLiving());
            }
        }
        if (MCA.getConfig().enableInfection && event.getSource() != null && event.getSource().func_76346_g() instanceof EntityZombie) {
            EntityZombie zombie = (EntityZombie)event.getSource().func_76346_g();
            boolean flag = RadixLogic.getBooleanWithProbability((int)3);
            if (event.getEntityLiving() instanceof EntityPlayer && flag) {
                EntityPlayer player = (EntityPlayer)event.getEntityLiving();
                for (ItemStack stack : player.field_71071_by.field_70462_a) {
                    if (stack == null || !(stack.func_77973_b() instanceof ItemBaby)) continue;
                    stack.func_77978_p().func_74757_a("isInfected", true);
                    player.func_145747_a((ITextComponent)new TextComponentString("\u00a7C" + stack.func_77978_p().func_74779_i("name") + " has been " + "\u00a7A" + "\u00a7l" + "infected" + "\u00a7C" + "!"));
                    player.field_70170_p.func_184133_a(null, new BlockPos(zombie.field_70165_t, zombie.field_70163_u, zombie.field_70161_v), SoundEvents.field_187925_gy, SoundCategory.HOSTILE, 0.5f, 1.0f);
                    Utilities.spawnParticlesAroundEntityS(EnumParticleTypes.SPELL_WITCH, (Entity)player, 32);
                }
            } else if (event.getEntityLiving() instanceof EntityVillagerMCA && flag) {
                EntityVillagerMCA human2 = (EntityVillagerMCA)event.getEntityLiving();
                if (human2.attributes.getProfessionEnum() == EnumProfession.Warrior) {
                    return;
                }
                for (ItemStack stack : human2.func_184209_aF()) {
                    if (stack == null) continue;
                    return;
                }
                human2.attributes.setIsInfected(true);
                human2.func_70606_j(human2.func_110138_aP());
                zombie.func_70624_b(null);
                human2.func_184185_a(SoundEvents.field_187925_gy, 0.5f, 1.0f);
                Utilities.spawnParticlesAroundEntityS(EnumParticleTypes.SPELL_WITCH, (Entity)human2, 32);
            } else if (event.getEntityLiving() instanceof EntityVillagerMCA && ((EntityVillagerMCA)event.getEntityLiving()).attributes.getIsInfected()) {
                event.setCanceled(true);
                zombie.func_70624_b(null);
            }
        }
    }

    @SubscribeEvent
    public void onLivingSetTarget(LivingSetAttackTargetEvent event) {
        if (event.getEntityLiving() instanceof EntityMob && event.getTarget() instanceof EntityVillagerMCA) {
            EntityMob mob = (EntityMob)event.getEntityLiving();
            EntityVillagerMCA target = (EntityVillagerMCA)event.getTarget();
            if (target.attributes.getIsInfected()) {
                mob.func_70624_b(null);
            }
        }
    }

    @SubscribeEvent
    public void onPlaceEvent(BlockEvent.PlaceEvent event) {
        int x = event.getPos().func_177958_n();
        int y = event.getPos().func_177956_o();
        int z = event.getPos().func_177952_p();
        Block placedBlock = event.getPlacedBlock().func_177230_c();
        if (placedBlock == Blocks.field_150480_ab && RadixBlocks.getBlock((World)event.getWorld(), (int)x, (int)(y - 1), (int)z) == Blocks.field_150475_bE) {
            int totemsFound = 0;
            for (int i = 0; i < 4; ++i) {
                Block block;
                int dX = 0;
                int dZ = 0;
                switch (i) {
                    case 0: {
                        dX = -3;
                        break;
                    }
                    case 1: {
                        dX = 3;
                        break;
                    }
                    case 2: {
                        dZ = -3;
                        break;
                    }
                    case 3: {
                        dZ = 3;
                    }
                }
                for (int j = -1; j < 2 && ((block = RadixBlocks.getBlock((World)event.getWorld(), (int)(x + dX), (int)(y + j), (int)(z + dZ))) == Blocks.field_150343_Z || block == Blocks.field_150480_ab); ++j) {
                    if (j != 1 || block != Blocks.field_150480_ab) continue;
                    ++totemsFound;
                }
            }
            if (totemsFound >= 3 && !event.getWorld().func_72935_r()) {
                Point3D summonPoint = new Point3D(x, y + 5, z);
                NetworkRegistry.TargetPoint summonTarget = new NetworkRegistry.TargetPoint(event.getWorld().field_73011_w.getDimension(), (double)summonPoint.iX(), (double)(summonPoint.iY() + 5), (double)summonPoint.iZ(), 32.0);
                EventHooksFML.setReaperSummonPoint(event.getWorld(), new Point3D((double)x + 1.0, (double)(y + 5), (double)z + 1.0));
                for (int i = 0; i < 2; ++i) {
                    Utilities.spawnParticlesAroundPointS(EnumParticleTypes.FLAME, event.getWorld(), x, y - i, z, 32);
                    RadixBlocks.setBlock((World)event.getWorld(), (int)x, (int)(y - i), (int)z, (Block)Blocks.field_150350_a);
                }
            } else if (totemsFound >= 3 && event.getWorld().func_72935_r()) {
                TutorialManager.sendMessageToPlayer(event.getPlayer(), "The Grim Reaper must be summoned at night.", "");
            }
        }
    }

    public static boolean isHorseRiddenByHuman(EntityHorse horse) {
        List passengers = horse.func_184188_bt();
        for (Entity passenger : passengers) {
            if (!(passenger instanceof EntityVillagerMCA)) continue;
            return true;
        }
        return false;
    }
}

