/*
 * Decompiled with CFR 0.152.
 */
package mca.data;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mca.core.MCA;
import mca.data.NBTPlayerData;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class PlayerDataCollection
extends WorldSavedData {
    private static final String ID = "MinecraftComesAlive";
    private Map<UUID, NBTPlayerData> playerDataMap = new HashMap<UUID, NBTPlayerData>();

    public static PlayerDataCollection get() {
        World world = FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_();
        PlayerDataCollection data = (PlayerDataCollection)world.func_72943_a(PlayerDataCollection.class, ID);
        if (data == null) {
            data = new PlayerDataCollection();
            world.func_72823_a(ID, (WorldSavedData)data);
        }
        return data;
    }

    public PlayerDataCollection() {
        this(ID);
    }

    public PlayerDataCollection(String id) {
        super(id);
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        for (Map.Entry<UUID, NBTPlayerData> entry : this.playerDataMap.entrySet()) {
            UUID uuid = entry.getKey();
            NBTPlayerData playerData = entry.getValue();
            NBTTagCompound playerDataTags = new NBTTagCompound();
            try {
                playerData.writeToNBT(playerDataTags);
                nbt.func_74782_a("PlayerData-" + uuid.toString(), (NBTBase)playerDataTags);
            }
            catch (Exception e) {
                MCA.getLog().error("Error writing player data to NBT for UUID " + uuid.toString() + ". Progress may be corrupted or lost.");
            }
        }
        return nbt;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        for (Object tagKey : nbt.func_150296_c()) {
            try {
                String tagName = (String)tagKey;
                UUID uuid = UUID.fromString(tagName.replace("PlayerData-", ""));
                NBTTagCompound playerDataTags = nbt.func_74775_l(tagName);
                NBTPlayerData data = new NBTPlayerData();
                data.readFromNBT(playerDataTags);
                this.playerDataMap.put(uuid, data);
            }
            catch (Exception e) {
                MCA.getLog().error("Error reading player data from NBT tag: " + (String)tagKey + ". Progress may be corrupted or lost.");
            }
        }
        this.func_76185_a();
    }

    public NBTPlayerData getPlayerData(UUID uuid) {
        return this.playerDataMap.get(uuid);
    }

    public void putPlayerData(UUID uuid, NBTPlayerData data) {
        this.playerDataMap.put(uuid, data);
        this.func_76185_a();
    }

    public UUID getUUIDByReference(NBTPlayerData data) {
        for (Map.Entry<UUID, NBTPlayerData> entry : this.playerDataMap.entrySet()) {
            if (entry.getValue() != data) continue;
            return entry.getKey();
        }
        return null;
    }
}

