/*
 * Decompiled with CFR 0.152.
 */
package mca.data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mca.core.Constants;
import mca.data.PlayerMemory;
import mca.entity.VillagerAttributes;
import mca.enums.EnumBabyState;
import mca.enums.EnumGender;
import mca.enums.EnumMarriageState;
import mca.enums.EnumMovementState;
import mca.enums.EnumPersonality;
import mca.enums.EnumProfession;
import net.minecraft.nbt.NBTTagCompound;

public class TransitiveVillagerData
implements Serializable {
    private final UUID uuid;
    private final String name;
    private final String headTexture;
    private final String clothesTexture;
    private final Integer profession;
    private final Integer personality;
    private final Integer gender;
    private final String spouseName;
    private final UUID spouseUUID;
    private final Integer spouseGender;
    private final String motherName;
    private final UUID motherUUID;
    private final Integer motherGender;
    private final String fatherName;
    private final UUID fatherUUID;
    private final Integer fatherGender;
    private final Integer babyState;
    private final Integer movementState;
    private final Boolean isChild;
    private final Integer age;
    private final Float scaleHeight;
    private final Float scaleWidth;
    private final Boolean doDisplay;
    private final Boolean isSwinging;
    private final Integer heldItemSlot;
    private final Boolean isInfected;
    private final Boolean doOpenInventory;
    private final Integer marriageState;
    private final Map<UUID, PlayerMemory> playerMemories;

    public TransitiveVillagerData(VillagerAttributes attributes) {
        this.uuid = attributes.getVillagerUUID();
        this.name = attributes.getName();
        this.headTexture = attributes.getHeadTexture();
        this.clothesTexture = attributes.getClothesTexture();
        this.profession = attributes.getProfessionEnum().getId();
        this.personality = attributes.getPersonality().getId();
        this.gender = attributes.getGender().getId();
        this.spouseUUID = attributes.getSpouseUUID();
        this.spouseGender = attributes.getSpouseGender().getId();
        this.spouseName = attributes.getSpouseName();
        this.motherName = attributes.getMotherName();
        this.motherUUID = attributes.getMotherUUID();
        this.motherGender = attributes.getMotherGender().getId();
        this.fatherName = attributes.getFatherName();
        this.fatherUUID = attributes.getFatherUUID();
        this.fatherGender = attributes.getFatherGender().getId();
        this.babyState = attributes.getBabyState().getId();
        this.movementState = attributes.getMovementState().getId();
        this.isChild = attributes.getIsChild();
        this.age = attributes.getAge();
        this.scaleHeight = Float.valueOf(attributes.getScaleHeight());
        this.scaleWidth = Float.valueOf(attributes.getScaleWidth());
        this.doDisplay = attributes.getDoDisplay();
        this.isSwinging = attributes.getIsSwinging();
        this.heldItemSlot = attributes.getHeldItemSlot();
        this.isInfected = attributes.getIsInfected();
        this.doOpenInventory = attributes.getDoOpenInventory();
        this.marriageState = attributes.getMarriageState().getId();
        this.playerMemories = attributes.getPlayerMemories();
    }

    public TransitiveVillagerData(NBTTagCompound nbt) {
        UUID playerUUID;
        this.uuid = nbt.func_186857_a("uuid");
        this.name = nbt.func_74779_i("name");
        this.headTexture = nbt.func_74779_i("headTexture");
        this.clothesTexture = nbt.func_74779_i("clothesTexture");
        this.profession = nbt.func_74762_e("profession");
        this.personality = nbt.func_74762_e("personality");
        this.gender = nbt.func_74762_e("gender");
        this.spouseUUID = nbt.func_186857_a("spouseUUID");
        this.spouseGender = nbt.func_74762_e("spouseGender");
        this.spouseName = nbt.func_74779_i("spouseName");
        this.motherUUID = nbt.func_186857_a("motherUUID");
        this.motherGender = nbt.func_74762_e("motherGender");
        this.motherName = nbt.func_74779_i("motherName");
        this.fatherUUID = nbt.func_186857_a("fatherUUID");
        this.fatherGender = nbt.func_74762_e("fatherGender");
        this.fatherName = nbt.func_74779_i("fatherName");
        this.babyState = nbt.func_74762_e("babyState");
        this.movementState = nbt.func_74762_e("movementState");
        this.isChild = nbt.func_74767_n("isChild");
        this.age = nbt.func_74762_e("age");
        this.scaleHeight = Float.valueOf(nbt.func_74760_g("scaleHeight"));
        this.scaleWidth = Float.valueOf(nbt.func_74760_g("scaleWidth"));
        this.doDisplay = nbt.func_74767_n("doDisplay");
        this.isSwinging = nbt.func_74767_n("isSwinging");
        this.heldItemSlot = nbt.func_74762_e("heldItemSlot");
        this.isInfected = nbt.func_74767_n("isInfected");
        this.doOpenInventory = nbt.func_74767_n("doOpenInventory");
        this.marriageState = nbt.func_74762_e("marriageState");
        this.playerMemories = new HashMap<UUID, PlayerMemory>();
        int counter = 0;
        while ((playerUUID = nbt.func_186857_a("playerMemoryKey" + counter)) != null && !playerUUID.equals(Constants.EMPTY_UUID)) {
            PlayerMemory playerMemory = new PlayerMemory(null, playerUUID);
            playerMemory.readPlayerMemoryFromNBT(nbt);
            this.playerMemories.put(playerUUID, playerMemory);
            ++counter;
        }
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public String getHeadTexture() {
        return this.headTexture;
    }

    public String getClothesTexture() {
        return this.clothesTexture;
    }

    public EnumProfession getProfession() {
        return EnumProfession.getProfessionById(this.profession);
    }

    public EnumPersonality getPersonality() {
        return EnumPersonality.getById(this.personality);
    }

    public EnumGender getGender() {
        return EnumGender.byId(this.gender);
    }

    public String getSpouseName() {
        return this.spouseName;
    }

    public UUID getSpouseUUID() {
        return this.spouseUUID;
    }

    public EnumGender getSpouseGender() {
        return EnumGender.byId(this.spouseGender);
    }

    public String getMotherName() {
        return this.motherName;
    }

    public UUID getMotherUUID() {
        return this.motherUUID;
    }

    public EnumGender getMotherGender() {
        return EnumGender.byId(this.motherGender);
    }

    public String getFatherName() {
        return this.fatherName;
    }

    public UUID getFatherUUID() {
        return this.fatherUUID;
    }

    public EnumGender getFatherGender() {
        return EnumGender.byId(this.fatherGender);
    }

    public EnumBabyState getBabyState() {
        return EnumBabyState.fromId(this.babyState);
    }

    public EnumMovementState getMovementState() {
        return EnumMovementState.fromId(this.movementState);
    }

    public Boolean getIsChild() {
        return this.isChild;
    }

    public Integer getAge() {
        return this.age;
    }

    public Float getScaleHeight() {
        return this.scaleHeight;
    }

    public Float getScaleWidth() {
        return this.scaleWidth;
    }

    public Boolean getDoDisplay() {
        return this.doDisplay;
    }

    public Boolean getIsSwinging() {
        return this.isSwinging;
    }

    public Integer getHeldItemSlot() {
        return this.heldItemSlot;
    }

    public Boolean getIsInfected() {
        return this.isInfected;
    }

    public Boolean getDoOpenInventory() {
        return this.doOpenInventory;
    }

    public EnumMarriageState getMarriageState() {
        return EnumMarriageState.byId(this.marriageState);
    }

    public Map<UUID, PlayerMemory> getPlayerMemories() {
        return this.playerMemories;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_186854_a("uuid", this.uuid);
        nbt.func_74778_a("name", this.name);
        nbt.func_74778_a("headTexture", this.headTexture);
        nbt.func_74778_a("clothesTexture", this.clothesTexture);
        nbt.func_74768_a("profession", this.profession.intValue());
        nbt.func_74768_a("personality", this.personality.intValue());
        nbt.func_74768_a("gender", this.gender.intValue());
        nbt.func_186854_a("spouseUUID", this.spouseUUID);
        nbt.func_74768_a("spouseGender", this.spouseGender.intValue());
        nbt.func_74778_a("spouseName", this.spouseName);
        nbt.func_186854_a("motherUUID", this.motherUUID);
        nbt.func_74768_a("motherGender", this.motherGender.intValue());
        nbt.func_74778_a("motherName", this.motherName);
        nbt.func_186854_a("fatherUUID", this.fatherUUID);
        nbt.func_74768_a("fatherGender", this.fatherGender.intValue());
        nbt.func_74778_a("fatherName", this.fatherName);
        nbt.func_74768_a("babyState", this.babyState.intValue());
        nbt.func_74768_a("movementState", this.movementState.intValue());
        nbt.func_74757_a("isChild", this.isChild.booleanValue());
        nbt.func_74768_a("age", this.age.intValue());
        nbt.func_74776_a("scaleHeight", this.scaleHeight.floatValue());
        nbt.func_74776_a("scaleWidth", this.scaleWidth.floatValue());
        nbt.func_74757_a("doDisplay", this.doDisplay.booleanValue());
        nbt.func_74757_a("isSwinging", this.isSwinging.booleanValue());
        nbt.func_74768_a("heldItemSlot", this.heldItemSlot.intValue());
        nbt.func_74757_a("isInfected", this.isInfected.booleanValue());
        nbt.func_74757_a("doOpenInventory", this.doOpenInventory.booleanValue());
        nbt.func_74768_a("marriageState", this.marriageState.intValue());
        int counter = 0;
        for (Map.Entry<UUID, PlayerMemory> pair : this.playerMemories.entrySet()) {
            nbt.func_186854_a("playerMemoryKey" + counter, pair.getKey());
            pair.getValue().writePlayerMemoryToNBT(nbt);
            ++counter;
        }
    }
}

