/*
 * Decompiled with CFR 0.152.
 */
package mca.entity;

import java.util.List;
import mca.core.MCA;
import mca.core.minecraft.ItemsMCA;
import mca.core.minecraft.SoundsMCA;
import mca.enums.EnumReaperAttackState;
import mca.packets.PacketSpawnLightning;
import mca.util.Utilities;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import radixcore.math.Point3D;
import radixcore.modules.RadixBlocks;
import radixcore.modules.RadixLogic;
import radixcore.modules.RadixMath;

public class EntityGrimReaper
extends EntityMob {
    private static final DataParameter<Integer> ATTACK_STATE = EntityDataManager.func_187226_a(EntityGrimReaper.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> STATE_TRANSITION_COOLDOWN = EntityDataManager.func_187226_a(EntityGrimReaper.class, (DataSerializer)DataSerializers.field_187192_b);
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS).func_186741_a(true);
    private EntityAINearestAttackableTarget aiNearestAttackableTarget = new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true);
    private int healingCooldown;
    private int timesHealed;
    private float floatingTicks;

    public EntityGrimReaper(World world) {
        super(world);
        this.func_70105_a(1.0f, 2.6f);
        this.field_70728_aV = 100;
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)this.aiNearestAttackableTarget);
    }

    protected final void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(12.5);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(225.0);
    }

    protected void func_70628_a(boolean hitByPlayer, int lootingLvl) {
        this.func_145779_a(ItemsMCA.STAFF_OF_LIFE, 1);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACK_STATE, (Object)0);
        this.field_70180_af.func_187214_a(STATE_TRANSITION_COOLDOWN, (Object)0);
    }

    public void setAttackState(EnumReaperAttackState state) {
        if (((Integer)this.field_70180_af.func_187225_a(ATTACK_STATE)).intValue() != state.getId()) {
            this.field_70180_af.func_187227_b(ATTACK_STATE, (Object)state.getId());
            switch (state) {
                case PRE: {
                    this.func_184185_a(SoundsMCA.reaper_scythe_out, 1.0f, 1.0f);
                    break;
                }
                case POST: {
                    this.func_184185_a(SoundsMCA.reaper_scythe_swing, 1.0f, 1.0f);
                }
            }
        }
    }

    public EnumReaperAttackState getAttackState() {
        return EnumReaperAttackState.fromId((Integer)this.field_70180_af.func_187225_a(ATTACK_STATE));
    }

    public boolean hasEntityToAttack() {
        return this.func_70638_az() != null;
    }

    public void func_70077_a(EntityLightningBolt entity) {
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (source == DamageSource.field_76368_d || source == DamageSource.field_76370_b || source.func_94541_c() || source == DamageSource.field_76372_a) {
            if (source == DamageSource.field_76368_d) {
                this.teleportTo(this.field_70165_t, this.field_70163_u + 3.0, this.field_70161_v);
            }
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.getAttackState() == EnumReaperAttackState.BLOCK && source.func_76364_f() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)source.func_76364_f();
            double deltaX = this.field_70165_t - player.field_70165_t;
            double deltaZ = this.field_70161_v - player.field_70161_v;
            this.func_184185_a(SoundsMCA.reaper_block, 1.0f, 1.0f);
            this.teleportTo(player.field_70165_t - deltaX * 2.0, player.field_70163_u + 2.0, this.field_70161_v - deltaZ * 2.0);
            this.setStateTransitionCooldown(0);
            return false;
        }
        if (!this.field_70170_p.field_72995_K && source.func_76364_f() instanceof EntityPlayer && RadixLogic.getBooleanWithProbability((int)30)) {
            EntityPlayer player = (EntityPlayer)source.func_76364_f();
            double deltaX = this.field_70165_t - player.field_70165_t;
            double deltaZ = this.field_70161_v - player.field_70161_v;
            this.teleportTo(player.field_70165_t - deltaX * 2.0, player.field_70163_u + 2.0, this.field_70161_v - deltaZ * 2.0);
        } else {
            if (source.func_76364_f() instanceof EntityArrow) {
                EntityArrow arrow = (EntityArrow)source.func_76364_f();
                if (arrow.field_70250_c instanceof EntityPlayer && this.getAttackState() != EnumReaperAttackState.REST) {
                    EntityPlayer player = (EntityPlayer)arrow.field_70250_c;
                    double newX = player.field_70165_t + (double)(RadixLogic.getBooleanWithProbability((int)50) ? 2 : -2);
                    double newZ = player.field_70161_v + (double)(RadixLogic.getBooleanWithProbability((int)50) ? 2 : -2);
                    this.teleportTo(newX, player.field_70163_u, newZ);
                }
                arrow.func_70106_y();
                return false;
            }
            if (this.getAttackState() == EnumReaperAttackState.REST) {
                damage /= 3.0f;
            }
        }
        super.func_70097_a(source, damage);
        if (!this.field_70170_p.field_72995_K && (double)this.func_110143_aJ() <= this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() / 2.0 && this.healingCooldown == 0) {
            this.setAttackState(EnumReaperAttackState.REST);
            this.healingCooldown = 4200;
            this.teleportTo(this.field_70165_t, this.field_70163_u + 8.0, this.field_70161_v);
            this.setStateTransitionCooldown(1200);
        }
        return true;
    }

    protected void attackEntity(Entity entity, float damage) {
        EntityLivingBase entityToAttack = this.func_70638_az();
        if (RadixMath.getDistanceToEntity((Entity)entityToAttack, (Entity)this) <= 1.2 && this.getAttackState() == EnumReaperAttackState.PRE) {
            if (this.getAttackState() == EnumReaperAttackState.BLOCK) {
                int rX = this.func_70681_au().nextInt(10);
                int rZ = this.func_70681_au().nextInt(10);
                this.teleportTo(this.field_70165_t + 5.0 + (double)rX, this.field_70163_u, this.field_70161_v + (double)rZ);
            } else {
                entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.field_70170_p.func_175659_aa().func_151525_a() * 5.75f);
                if (entity instanceof EntityLivingBase) {
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_82731_v, this.field_70170_p.func_175659_aa().func_151525_a() * 20, 1));
                }
                this.setAttackState(EnumReaperAttackState.POST);
                this.setStateTransitionCooldown(10);
            }
        }
        if (this.getStateTransitionCooldown() == 0) {
            if (RadixMath.getDistanceToEntity((Entity)entityToAttack, (Entity)this) <= 3.5) {
                if (entityToAttack instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)entityToAttack;
                    if (player.func_184585_cz()) {
                        double dX = this.field_70165_t - player.field_70165_t;
                        double dZ = this.field_70161_v - player.field_70161_v;
                        this.teleportTo(player.field_70165_t - dX * 2.0, player.field_70163_u + 2.0, this.field_70161_v - dZ * 2.0);
                        if (!this.field_70170_p.field_72995_K && RadixLogic.getBooleanWithProbability((int)20)) {
                            int currentItem = player.field_71071_by.field_70461_c;
                            int randomItem = this.field_70146_Z.nextInt(InventoryPlayer.func_70451_h());
                            ItemStack currentItemStack = (ItemStack)player.field_71071_by.field_70462_a.get(currentItem);
                            ItemStack randomItemStack = (ItemStack)player.field_71071_by.field_70462_a.get(randomItem);
                            player.field_71071_by.field_70462_a.set(currentItem, (Object)randomItemStack);
                            player.field_71071_by.field_70462_a.set(randomItem, (Object)currentItemStack);
                            player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, this.field_70170_p.func_175659_aa().func_151525_a() * 40, 1));
                        }
                    } else if (RadixLogic.getBooleanWithProbability((int)40) && this.getAttackState() != EnumReaperAttackState.PRE) {
                        this.setStateTransitionCooldown(20);
                        this.setAttackState(EnumReaperAttackState.BLOCK);
                    } else {
                        this.setAttackState(EnumReaperAttackState.PRE);
                        this.setStateTransitionCooldown(20);
                    }
                }
            } else {
                this.setAttackState(EnumReaperAttackState.IDLE);
            }
        }
    }

    protected Entity findPlayerToAttack() {
        return this.field_70170_p.func_72890_a((Entity)this, 48.0);
    }

    public int func_70627_aG() {
        return 300;
    }

    protected SoundEvent func_184639_G() {
        return SoundsMCA.reaper_idle;
    }

    protected SoundEvent func_184615_bR() {
        return SoundsMCA.reaper_death;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187851_gB;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_70066_B();
        EntityLivingBase entityToAttack = this.func_70638_az();
        if (entityToAttack != null && this.getAttackState() != EnumReaperAttackState.REST) {
            this.attackEntity((Entity)entityToAttack, 5.0f);
            this.func_70605_aq().func_75642_a(entityToAttack.field_70165_t, entityToAttack.field_70163_u, entityToAttack.field_70161_v, 6.0);
        }
        if (this.field_70170_p.field_72995_K && this.getAttackState() == EnumReaperAttackState.REST) {
            this.floatingTicks += 0.1f;
            Utilities.spawnParticlesAroundEntityC(EnumParticleTypes.SUSPENDED_DEPTH, (Entity)this, 1);
            Utilities.spawnParticlesAroundEntityC(EnumParticleTypes.CRIT_MAGIC, (Entity)this, 1);
        }
        if (this.getAttackState() == EnumReaperAttackState.REST) {
            if (!this.field_70170_p.field_72995_K && this.getStateTransitionCooldown() == 1) {
                this.setAttackState(EnumReaperAttackState.IDLE);
                ++this.timesHealed;
            } else if (!this.field_70170_p.field_72995_K && this.getStateTransitionCooldown() % 100 == 0) {
                this.func_70606_j(this.func_110143_aJ() + MathHelper.func_76131_a((float)(10.5f - (float)this.timesHealed * 3.5f), (float)3.0f, (float)10.5f));
                int dX = this.field_70146_Z.nextInt(8) + 4 * (RadixLogic.getBooleanWithProbability((int)50) ? 1 : -1);
                int dZ = this.field_70146_Z.nextInt(8) + 4 * (RadixLogic.getBooleanWithProbability((int)50) ? 1 : -1);
                int y = RadixLogic.getSpawnSafeTopLevel((World)this.field_70170_p, (int)((int)this.field_70165_t + dX), (int)((int)this.field_70161_v + dZ));
                MCA.getPacketHandler().sendPacketToAllPlayers((IMessage)new PacketSpawnLightning(new Point3D(this.field_70165_t + (double)dX, (double)y, this.field_70161_v + (double)dZ)));
                if (!this.field_70170_p.field_72995_K) {
                    EntityZombie mob = RadixLogic.getBooleanWithProbability((int)50) ? new EntityZombie(this.field_70170_p) : new EntitySkeleton(this.field_70170_p);
                    mob.func_70107_b(this.field_70165_t + (double)dX + 4.0, (double)y, this.field_70161_v + (double)dZ + 4.0);
                    if (mob instanceof EntitySkeleton) {
                        mob.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
                    }
                    this.field_70170_p.func_72838_d((Entity)mob);
                }
            }
        }
        if (this.func_110143_aJ() <= 0.0f) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            return;
        }
        if (this.getAttackState() == EnumReaperAttackState.REST) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        }
        this.field_70143_R = 0.0f;
        if (this.field_70181_x > 0.0) {
            this.field_70181_x *= (double)1.04f;
        } else {
            double yMod = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
            this.field_70181_x = this.field_70181_x * (double)0.6f + yMod * (double)0.3f;
        }
        if (this.getStateTransitionCooldown() > 0) {
            this.setStateTransitionCooldown(this.getStateTransitionCooldown() - 1);
        }
        if (this.healingCooldown > 0) {
            --this.healingCooldown;
        }
        if (entityToAttack != null && entityToAttack.field_70128_L) {
            this.func_70624_b(null);
            this.setAttackState(EnumReaperAttackState.IDLE);
        }
        if (entityToAttack != null && this.getAttackState() != EnumReaperAttackState.REST) {
            double sqDistanceTo = Math.sqrt(Math.pow(entityToAttack.field_70165_t - this.field_70165_t, 2.0) + Math.pow(entityToAttack.field_70161_v - this.field_70161_v, 2.0));
            float moveAmount = 0.0f;
            if (sqDistanceTo < 8.0) {
                moveAmount = MathHelper.func_76131_a((float)((8.0f - (float)sqDistanceTo) / 8.0f * 4.0f), (float)0.0f, (float)2.5f);
            }
            if (entityToAttack.field_70163_u + (double)0.2f < this.field_70163_u) {
                this.field_70181_x -= (double)(0.05f * moveAmount);
            }
            if (entityToAttack.field_70163_u - 0.5 > this.field_70163_u) {
                this.field_70181_x += (double)(0.01f * moveAmount);
            }
            if (this.getAttackState() == EnumReaperAttackState.PRE) {
                this.field_70159_w *= (double)1.1f;
                this.field_70179_y *= (double)1.1f;
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            List grassBlocks = RadixLogic.getNearbyBlocks((Entity)this, (Block)Blocks.field_150349_c, (int)1);
            for (Point3D point : grassBlocks) {
                IBlockState state;
                RadixBlocks.setBlock((World)this.field_70170_p, (Point3D)point, (Block)Blocks.field_150346_d);
                Block blockAbove = RadixBlocks.getBlock((World)this.field_70170_p, (int)point.iX(), (int)(point.iY() + 1), (int)point.iZ());
                if (blockAbove.func_149688_o(state = blockAbove.func_176223_P()) != Material.field_151585_k && blockAbove.func_149688_o(state) != Material.field_151582_l) continue;
                Block blockAbovePlant = RadixBlocks.getBlock((World)this.field_70170_p, (int)point.iX(), (int)(point.iY() + 2), (int)point.iZ());
                if (blockAbovePlant == Blocks.field_150398_cm) {
                    RadixBlocks.setBlock((World)this.field_70170_p, (int)point.iX(), (int)(point.iY() + 2), (int)point.iZ(), (Block)Blocks.field_150350_a);
                }
                RadixBlocks.setBlock((World)this.field_70170_p, (int)point.iX(), (int)(point.iY() + 1), (int)point.iZ(), (Block)Blocks.field_150350_a);
            }
        }
    }

    public void func_70645_a(DamageSource source) {
        super.func_70645_a(source);
    }

    public String func_70005_c_() {
        return "Grim Reaper";
    }

    protected boolean func_70692_ba() {
        return true;
    }

    public void setStateTransitionCooldown(int value) {
        this.field_70180_af.func_187227_b(STATE_TRANSITION_COOLDOWN, (Object)value);
    }

    public int getStateTransitionCooldown() {
        return (Integer)this.field_70180_af.func_187225_a(STATE_TRANSITION_COOLDOWN);
    }

    public float getFloatingTicks() {
        return this.floatingTicks;
    }

    private void teleportTo(double x, double y, double z) {
        if (!this.field_70170_p.field_72995_K) {
            Utilities.spawnParticlesAroundEntityS(EnumParticleTypes.PORTAL, (Entity)this, 16);
            this.func_184185_a(SoundEvents.field_187534_aX, 2.0f, 1.0f);
            this.func_70107_b(x, y, z);
            this.func_184185_a(SoundEvents.field_187534_aX, 2.0f, 1.0f);
            Utilities.spawnParticlesAroundEntityS(EnumParticleTypes.PORTAL, (Entity)this, 16);
        }
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }
}

