/*
 * Decompiled with CFR 0.152.
 */
package mca.entity;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mca.actions.AbstractAction;
import mca.actions.ActionAttackResponse;
import mca.actions.ActionCombat;
import mca.actions.ActionSleep;
import mca.actions.ActionUpdateMood;
import mca.core.Constants;
import mca.core.MCA;
import mca.core.minecraft.ItemsMCA;
import mca.data.NBTPlayerData;
import mca.data.PlayerMemory;
import mca.data.TransitiveVillagerData;
import mca.entity.VillagerAttributes;
import mca.entity.VillagerBehaviors;
import mca.enums.EnumBabyState;
import mca.enums.EnumDialogueType;
import mca.enums.EnumGender;
import mca.enums.EnumMarriageState;
import mca.enums.EnumMovementState;
import mca.enums.EnumProfession;
import mca.enums.EnumProfessionSkinGroup;
import mca.enums.EnumRelation;
import mca.items.ItemBaby;
import mca.items.ItemMemorial;
import mca.items.ItemVillagerEditor;
import mca.packets.PacketOpenGUIOnEntity;
import mca.util.Either;
import mca.util.Utilities;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveIndoors;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import radixcore.math.Point3D;
import radixcore.modules.RadixLogic;

public class EntityVillagerMCA
extends EntityVillager
implements IEntityAdditionalSpawnData {
    @SideOnly(value=Side.CLIENT)
    public boolean isInteractionGuiOpen;
    private int swingProgressTicks;
    public final VillagerAttributes attributes;
    private final VillagerBehaviors behaviors;
    private final Profiler profiler;
    private int vanillaProfessionId;
    private static final int FIELD_INDEX_BUYING_PLAYER = 6;
    private static final int FIELD_INDEX_TIME_UNTIL_RESET = 8;
    private static final int FIELD_INDEX_NEEDS_INITIALIZATION = 9;
    private static final int FIELD_INDEX_IS_WILLING_TO_MATE = 10;
    private static final int FIELD_INDEX_WEALTH = 11;
    private static final int FIELD_INDEX_LAST_BUYING_PLAYER = 12;

    public EntityVillagerMCA(World world) {
        super(world);
        this.profiler = world.field_72984_F;
        this.attributes = new VillagerAttributes(this);
        this.attributes.initialize();
        this.behaviors = new VillagerBehaviors(this);
        this.addAI();
    }

    public void addAI() {
        this.field_70714_bg.field_75782_a.clear();
        ((PathNavigateGround)this.func_70661_as()).func_179693_d(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        int maxHealth = this.attributes.getProfessionSkinGroup() == EnumProfessionSkinGroup.Guard ? MCA.getConfig().guardMaxHealth : MCA.getConfig().villagerMaxHealth;
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)maxHealth);
        if (this.func_110143_aJ() > (float)maxHealth || this.attributes.getProfessionSkinGroup() == EnumProfessionSkinGroup.Guard) {
            this.func_70606_j(maxHealth);
        }
        if (this.attributes.getProfessionSkinGroup() != EnumProfessionSkinGroup.Guard) {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveIndoors((EntityCreature)this));
        }
    }

    private void updateSwinging() {
        if (this.attributes.getIsSwinging()) {
            ++this.swingProgressTicks;
            if (this.swingProgressTicks >= 8) {
                this.swingProgressTicks = 0;
                this.attributes.setIsSwinging(false);
            }
        } else {
            this.swingProgressTicks = 0;
        }
        this.field_70733_aJ = (float)this.swingProgressTicks / 8.0f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.profiler.func_76320_a("MCA Villager Update");
        this.behaviors.onUpdate();
        this.updateSwinging();
        if (!this.field_70170_p.field_72995_K) {
            this.attributes.incrementTicksAlive();
            for (PlayerMemory memory : this.attributes.getPlayerMemories().values()) {
                memory.doTick();
            }
            for (int i = 0; i < this.attributes.getInventory().func_70302_i_(); ++i) {
                ItemStack stack = this.attributes.getInventory().func_70301_a(i);
                if (!(stack.func_77973_b() instanceof ItemBaby)) continue;
                ItemBaby item = (ItemBaby)stack.func_77973_b();
                item.func_77663_a(stack, this.field_70170_p, (Entity)this, 1, false);
            }
            if (this.attributes.getDoOpenInventory()) {
                EntityPlayer player = this.field_70170_p.func_72890_a((Entity)this, 10.0);
                if (player != null) {
                    player.openGui((Object)MCA.getInstance(), 5, this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
                }
                this.attributes.setDoOpenInventory(false);
            }
        }
        this.profiler.func_76319_b();
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.func_184187_bx() == player) {
            this.func_184210_p();
            this.func_110145_l((Entity)player);
            return true;
        }
        if (!this.field_70170_p.field_72995_K) {
            ItemStack heldItem = player.func_184586_b(hand);
            Item item = heldItem.func_77973_b();
            if (player.field_71075_bZ.field_75098_d && item instanceof ItemMemorial && !heldItem.func_77942_o()) {
                TransitiveVillagerData transitiveData = new TransitiveVillagerData(this.attributes);
                NBTTagCompound stackNBT = new NBTTagCompound();
                stackNBT.func_186854_a("ownerUUID", player.func_110124_au());
                stackNBT.func_74778_a("ownerName", player.func_70005_c_());
                stackNBT.func_74768_a("relation", this.attributes.getPlayerMemory(player).getRelation().getId());
                transitiveData.writeToNBT(stackNBT);
                heldItem.func_77982_d(stackNBT);
                this.func_70106_y();
            } else {
                int guiId = item instanceof ItemVillagerEditor ? 6 : 7;
                MCA.getPacketHandler().sendPacketToPlayer((IMessage)new PacketOpenGUIOnEntity(this.func_145782_y(), guiId), (EntityPlayer)((EntityPlayerMP)player));
            }
        }
        return true;
    }

    public void func_70645_a(DamageSource damageSource) {
        super.func_70645_a(damageSource);
        if (!this.field_70170_p.field_72995_K) {
            EntityVillagerMCA partner;
            this.behaviors.disableAllToggleActions();
            this.getBehavior(ActionSleep.class).transitionSkinState(true);
            for (EntityVillagerMCA human : RadixLogic.getEntitiesWithinDistance(EntityVillagerMCA.class, (Entity)this, (int)20)) {
                human.getBehavior(ActionUpdateMood.class).modifyMoodLevel(-2.0f);
            }
            for (int i = 0; i < this.attributes.getInventory().func_70302_i_(); ++i) {
                ItemStack stack = this.attributes.getInventory().func_70301_a(i);
                if (stack == null) continue;
                this.func_70099_a(stack, 1.0f);
            }
            boolean memorialDropped = false;
            if (this.attributes.isMarriedToAPlayer()) {
                NBTPlayerData playerData = MCA.getPlayerData(this.field_70170_p, this.attributes.getSpouseUUID());
                playerData.setMarriageState(EnumMarriageState.NOT_MARRIED);
                playerData.setSpouseName("");
                playerData.setSpouseUUID(Constants.EMPTY_UUID);
                if (!memorialDropped) {
                    this.createMemorialChest(this.attributes.getPlayerMemoryWithoutCreating(this.attributes.getSpouseUUID()), ItemsMCA.BROKEN_RING);
                    memorialDropped = true;
                }
            } else if (this.attributes.isMarriedToAVillager() && (partner = this.attributes.getVillagerSpouseInstance()) != null) {
                partner.endMarriage();
            }
            for (PlayerMemory memory : this.attributes.getPlayerMemories().values()) {
                if (!memory.getUUID().equals(this.attributes.getSpouseUUID()) && !this.attributes.isPlayerAParent(memory.getUUID())) continue;
                EntityPlayer player = this.field_70170_p.func_152378_a(memory.getUUID());
                if (this.attributes.isPlayerAParent(memory.getUUID()) && !memorialDropped) {
                    this.createMemorialChest(memory, this.attributes.getGender() == EnumGender.MALE ? ItemsMCA.TOY_TRAIN : ItemsMCA.CHILDS_DOLL);
                    memorialDropped = true;
                }
                if (player == null) continue;
                player.func_145747_a((ITextComponent)new TextComponentString("\u00a7C" + this.attributes.getTitle(player) + " has died."));
            }
        }
    }

    private void createMemorialChest(PlayerMemory memory, ItemMemorial memorialItem) {
        Point3D nearestAir = RadixLogic.getNearestBlock((Entity)this, (int)3, (Block)Blocks.field_150350_a);
        if (nearestAir == null) {
            MCA.getLog().warn("No available location to spawn villager death chest for " + this.func_70005_c_());
        } else {
            int y = nearestAir.iY();
            Block block = Blocks.field_150350_a;
            while (block == Blocks.field_150350_a) {
                block = this.field_70170_p.func_180495_p(new BlockPos(nearestAir.iX(), --y, nearestAir.iZ())).func_177230_c();
            }
            this.field_70170_p.func_175656_a(new BlockPos(nearestAir.iX(), ++y, nearestAir.iZ()), Blocks.field_150486_ae.func_176223_P());
            try {
                TileEntityChest chest = (TileEntityChest)this.field_70170_p.func_175625_s(nearestAir.toBlockPos());
                TransitiveVillagerData data = new TransitiveVillagerData(this.attributes);
                ItemStack memorialStack = new ItemStack((Item)memorialItem);
                NBTTagCompound stackNBT = new NBTTagCompound();
                stackNBT.func_74778_a("ownerName", memory.getPlayerName());
                stackNBT.func_186854_a("ownerUUID", memory.getUUID());
                stackNBT.func_74768_a("ownerRelation", memory.getRelation().getId());
                data.writeToNBT(stackNBT);
                memorialStack.func_77982_d(stackNBT);
                chest.func_70299_a(0, memorialStack);
                MCA.getLog().info("Spawned villager death chest at: " + nearestAir.iX() + ", " + y + ", " + nearestAir.iZ());
            }
            catch (Exception e) {
                MCA.getLog().error("Error spawning villager death chest: " + e.getMessage());
                return;
            }
        }
    }

    protected void func_70619_bc() {
        ActionSleep sleepAI = this.getBehavior(ActionSleep.class);
        EnumMovementState moveState = this.attributes.getMovementState();
        boolean isSleeping = sleepAI.getIsSleeping();
        if (isSleeping) {
            ObfuscationReflectionHelper.setPrivateValue(EntityAITasks.class, (Object)this.field_70714_bg, (Object)1, (int)4);
        }
        if (!(isSleeping || moveState != EnumMovementState.MOVE && moveState != EnumMovementState.FOLLOW)) {
            super.func_70619_bc();
        }
        if (moveState == EnumMovementState.STAY && !isSleeping) {
            this.field_70714_bg.func_75774_a();
            this.func_70671_ap().func_75649_a();
        }
        if (moveState == EnumMovementState.STAY || isSleeping) {
            this.func_70661_as().func_75499_g();
        }
    }

    protected void func_70665_d(DamageSource damageSource, float damageAmount) {
        super.func_70665_d(damageSource, damageAmount);
        this.behaviors.getAction(ActionAttackResponse.class).startResponse(damageSource.func_76364_f());
        this.behaviors.getAction(ActionSleep.class).onDamage();
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        this.behaviors.writeToNBT(nbt);
        this.attributes.writeToNBT(nbt);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.behaviors.readFromNBT(nbt);
        this.attributes.readFromNBT(nbt);
        this.addAI();
    }

    public void writeSpawnData(ByteBuf buffer) {
        this.attributes.writeSpawnData(buffer);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.attributes.readSpawnData(buffer);
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return this.attributes.getIsInfected() ? SoundEvents.field_187934_hh : null;
    }

    protected SoundEvent func_184615_bR() {
        return this.attributes.getIsInfected() ? SoundEvents.field_187930_hd : null;
    }

    public boolean func_70104_M() {
        ActionSleep sleepAI = this.behaviors.getAction(ActionSleep.class);
        return !sleepAI.getIsSleeping();
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void sayRaw(String text, EntityPlayer target) {
        StringBuilder sb = new StringBuilder();
        if (MCA.getConfig().villagerChatPrefix != null && !MCA.getConfig().villagerChatPrefix.equals("null")) {
            sb.append(MCA.getConfig().villagerChatPrefix);
        }
        sb.append(this.attributes.getTitle(target));
        sb.append(": ");
        sb.append(text);
        if (target != null) {
            target.func_145747_a((ITextComponent)new TextComponentString(sb.toString()));
        }
        this.behaviors.onSay();
    }

    public void say(String phraseId, EntityPlayer target, Object ... arguments) {
        if (target == null) {
            return;
        }
        if (this.attributes.getIsInfected()) {
            String zombieMoan = RadixLogic.getBooleanWithProbability((int)33) ? "Raagh..." : (RadixLogic.getBooleanWithProbability((int)33) ? "Ughh..." : "Argh-gur...");
            target.func_145747_a((ITextComponent)new TextComponentString(this.attributes.getTitle(target) + ": " + zombieMoan));
            this.func_184185_a(SoundEvents.field_187899_gZ, 0.5f, this.field_70146_Z.nextFloat() + 0.5f);
        } else {
            StringBuilder sb = new StringBuilder();
            if (MCA.getConfig().villagerChatPrefix != null && !MCA.getConfig().villagerChatPrefix.equals("null")) {
                sb.append(MCA.getConfig().villagerChatPrefix);
            }
            sb.append(this.attributes.getTitle(target));
            sb.append(": ");
            sb.append(MCA.getLocalizer().getString(phraseId, arguments));
            target.func_145747_a((ITextComponent)new TextComponentString(sb.toString()));
            this.behaviors.onSay();
        }
    }

    public void say(String phraseId, EntityPlayer target) {
        this.say(phraseId, target, new Object[]{this, target});
    }

    public void startMarriage(Either<EntityVillagerMCA, EntityPlayer> either) {
        if (either.getLeft() != null) {
            EntityVillagerMCA spouse = either.getLeft();
            this.attributes.setSpouseName(spouse.attributes.getName());
            this.attributes.setSpouseUUID(spouse.func_110124_au());
            this.attributes.setSpouseGender(spouse.attributes.getGender());
            this.attributes.setMarriageState(EnumMarriageState.MARRIED_TO_VILLAGER);
            spouse.attributes.setSpouseName(this.attributes.getName());
            spouse.attributes.setSpouseUUID(this.func_110124_au());
            spouse.attributes.setSpouseGender(this.attributes.getGender());
            spouse.attributes.setMarriageState(EnumMarriageState.MARRIED_TO_VILLAGER);
            this.getBehaviors().onMarriageToVillager();
        } else if (either.getRight() != null) {
            EntityPlayer player = either.getRight();
            NBTPlayerData playerData = MCA.getPlayerData(player);
            PlayerMemory memory = this.attributes.getPlayerMemory(player);
            this.attributes.setSpouseName(player.func_70005_c_());
            this.attributes.setSpouseUUID(player.func_110124_au());
            this.attributes.setSpouseGender(playerData.getGender());
            this.attributes.setMarriageState(EnumMarriageState.MARRIED_TO_PLAYER);
            memory.setDialogueType(EnumDialogueType.SPOUSE);
            memory.setRelation(this.attributes.getGender() == EnumGender.MALE ? EnumRelation.HUSBAND : EnumRelation.WIFE);
            playerData.setSpouseName(this.func_70005_c_());
            playerData.setSpouseGender(this.attributes.getGender());
            playerData.setSpouseUUID(this.func_110124_au());
            playerData.setMarriageState(EnumMarriageState.MARRIED_TO_VILLAGER);
            this.getBehaviors().onMarriageToPlayer();
        } else {
            throw new IllegalArgumentException("Marriage target cannot be null");
        }
    }

    public void endMarriage() {
        this.attributes.setSpouseName("");
        this.attributes.setSpouseUUID(Constants.EMPTY_UUID);
        this.attributes.setSpouseGender(EnumGender.UNASSIGNED);
        this.attributes.setMarriageState(EnumMarriageState.NOT_MARRIED);
        this.getBehaviors().onMarriageEnded();
    }

    public void halt() {
        this.func_70661_as().func_75499_g();
        this.field_191988_bg = 0.0f;
        this.field_70702_br = 0.0f;
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
    }

    public void facePosition(Point3D position) {
        double midX = position.dX() - this.field_70165_t;
        double midZ = position.dZ() - this.field_70161_v;
        double d1 = 0.0;
        double d3 = MathHelper.func_76133_a((double)(midX * midX + midZ * midZ));
        float f2 = (float)(Math.atan2(midZ, midX) * 180.0 / Math.PI) - 90.0f;
        float f3 = (float)(-(Math.atan2(d1, d3) * 180.0 / Math.PI));
        this.field_70125_A = this.updateRotation(this.field_70125_A, f3, 16.0f);
        this.field_70177_z = this.updateRotation(this.field_70177_z, f2, 16.0f);
    }

    private float updateRotation(float p_70663_1_, float p_70663_2_, float p_70663_3_) {
        float f3 = MathHelper.func_76142_g((float)(p_70663_2_ - p_70663_1_));
        if (f3 > p_70663_3_) {
            f3 = p_70663_3_;
        }
        if (f3 < -p_70663_3_) {
            f3 = -p_70663_3_;
        }
        return p_70663_1_ + f3;
    }

    public VillagerBehaviors getBehaviors() {
        return this.behaviors;
    }

    public <T extends AbstractAction> T getBehavior(Class<T> clazz) {
        return this.behaviors.getAction(clazz);
    }

    public ItemStack func_184586_b(EnumHand hand) {
        EnumBabyState babyState = this.attributes.getBabyState();
        EnumProfession profession = this.attributes.getProfessionEnum();
        if (this.attributes.getIsInfected()) {
            return ItemStack.field_190927_a;
        }
        if (babyState != EnumBabyState.NONE) {
            return new ItemStack((Item)(babyState == EnumBabyState.MALE ? ItemsMCA.BABY_BOY : ItemsMCA.BABY_GIRL));
        }
        if (profession == EnumProfession.Guard) {
            return new ItemStack(Items.field_151040_l);
        }
        if (profession == EnumProfession.Archer) {
            return new ItemStack((Item)Items.field_151031_f);
        }
        if (this.attributes.getHeldItemSlot() != -1 && this.behaviors.isToggleActionActive()) {
            return this.attributes.getInventory().func_70301_a(this.attributes.getHeldItemSlot());
        }
        if (this.attributes.getInventory().contains(ItemsMCA.BABY_BOY) || this.attributes.getInventory().contains(ItemsMCA.BABY_GIRL)) {
            int slot = this.attributes.getInventory().getFirstSlotContainingItem(ItemsMCA.BABY_BOY);
            int n = slot = slot == -1 ? this.attributes.getInventory().getFirstSlotContainingItem(ItemsMCA.BABY_GIRL) : slot;
            if (slot != -1) {
                return this.attributes.getInventory().func_70301_a(slot);
            }
        } else if (profession == EnumProfession.Warrior || this.attributes.isMarriedToAPlayer() || profession == EnumProfession.Child) {
            return this.getBehavior(ActionCombat.class).getHeldItem();
        }
        return ItemStack.field_190927_a;
    }

    public void setHeldItem(Item item) {
        this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(item));
    }

    public boolean damageHeldItem(int amount) {
        try {
            ItemStack heldItem = this.func_184586_b(EnumHand.MAIN_HAND);
            if (heldItem != null) {
                Item item = heldItem.func_77973_b();
                int slot = this.attributes.getInventory().getFirstSlotContainingItem(item);
                ItemStack itemInSlot = this.attributes.getInventory().func_70301_a(slot);
                if (itemInSlot != null) {
                    itemInSlot.func_77972_a(amount, (EntityLivingBase)this);
                    if (itemInSlot.func_190916_E() == 0) {
                        this.behaviors.disableAllToggleActions();
                        this.attributes.getInventory().func_70299_a(slot, ItemStack.field_190927_a);
                        return true;
                    }
                    this.attributes.getInventory().func_70299_a(slot, itemInSlot);
                    return false;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public Iterable<ItemStack> func_184214_aD() {
        ArrayList<ItemStack> heldEquipment = new ArrayList<ItemStack>();
        heldEquipment.add(this.func_184586_b(EnumHand.MAIN_HAND));
        return heldEquipment;
    }

    public Iterable<ItemStack> func_184193_aE() {
        ArrayList<ItemStack> armorInventory = new ArrayList<ItemStack>();
        armorInventory.add(this.attributes.getInventory().func_70301_a(39));
        armorInventory.add(this.attributes.getInventory().func_70301_a(38));
        armorInventory.add(this.attributes.getInventory().func_70301_a(37));
        armorInventory.add(this.attributes.getInventory().func_70301_a(36));
        return armorInventory;
    }

    public ItemStack func_184582_a(EntityEquipmentSlot slotIn) {
        switch (slotIn) {
            case HEAD: {
                return this.attributes.getInventory().func_70301_a(36);
            }
            case CHEST: {
                return this.attributes.getInventory().func_70301_a(37);
            }
            case LEGS: {
                return this.attributes.getInventory().func_70301_a(38);
            }
            case FEET: {
                return this.attributes.getInventory().func_70301_a(39);
            }
            case MAINHAND: {
                return this.func_184586_b(EnumHand.MAIN_HAND);
            }
            case OFFHAND: {
                return ItemStack.field_190927_a;
            }
        }
        return ItemStack.field_190927_a;
    }

    public int func_70658_aO() {
        int value = 0;
        for (int i = 36; i < 40; ++i) {
            ItemStack stack = this.attributes.getInventory().func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof ItemArmor)) continue;
            value += ((ItemArmor)stack.func_77973_b()).field_77879_b;
        }
        return value;
    }

    public void func_70675_k(float amount) {
        for (int i = 36; i < 40; ++i) {
            ItemStack stack = this.attributes.getInventory().func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof ItemArmor)) continue;
            stack.func_77972_a((int)amount, (EntityLivingBase)this);
        }
    }

    public void swingItem() {
        this.func_184609_a(EnumHand.MAIN_HAND);
    }

    public void func_184609_a(EnumHand hand) {
        if (!this.attributes.getIsSwinging() || this.swingProgressTicks >= 4 || this.swingProgressTicks < 0) {
            this.swingProgressTicks = -1;
            this.attributes.setIsSwinging(true);
        }
    }

    public void cureInfection() {
        this.attributes.setIsInfected(false);
        this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 200, 0));
        this.field_70170_p.func_180498_a((EntityPlayer)null, 1027, new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v), 0);
        Utilities.spawnParticlesAroundEntityS(EnumParticleTypes.VILLAGER_HAPPY, (Entity)this, 16);
    }

    public boolean isInOverworld() {
        return this.field_70170_p.field_73011_w.getDimension() == 0;
    }

    public Profiler getProfiler() {
        return this.profiler;
    }

    public void setHitboxSize(float width, float height) {
        this.func_70105_a(width, height);
    }

    public String func_70005_c_() {
        return this.attributes.getName();
    }

    public void func_70938_b(int professionId) {
        this.vanillaProfessionId = professionId;
    }

    @Deprecated
    public int func_70946_n() {
        return this.vanillaProfessionId;
    }

    public void setProfession(VillagerRegistry.VillagerProfession prof) {
        this.vanillaProfessionId = VillagerRegistry.getId((VillagerRegistry.VillagerProfession)prof);
    }

    public VillagerRegistry.VillagerProfession getProfessionForge() {
        VillagerRegistry.VillagerProfession profession = VillagerRegistry.getById((int)this.vanillaProfessionId);
        if (profession == null) {
            return VillagerRegistry.getById((int)0);
        }
        return profession;
    }

    public void func_70933_a(MerchantRecipe recipe) {
        recipe.func_77399_f();
        int i = 3 + this.field_70146_Z.nextInt(4);
        EntityPlayer buyingPlayer = (EntityPlayer)ObfuscationReflectionHelper.getPrivateValue(EntityVillager.class, (Object)((Object)this), (int)6);
        if (recipe.func_180321_e() == 1 || this.field_70146_Z.nextInt(5) == 0) {
            this.setEntityVillagerField(8, 40);
            this.setEntityVillagerField(9, true);
            this.setEntityVillagerField(10, false);
            if (buyingPlayer != null) {
                this.setEntityVillagerField(12, buyingPlayer.func_110124_au());
            } else {
                this.setEntityVillagerField(12, null);
            }
            i += 5;
        }
        if (recipe.func_77394_a().func_77973_b() == Items.field_151166_bC) {
            int wealth = (Integer)this.getEntityVillagerField(11);
            this.setEntityVillagerField(11, wealth + recipe.func_77394_a().func_190916_E());
        }
        if (recipe.func_180322_j()) {
            this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, i));
        }
        if (buyingPlayer instanceof EntityPlayerMP) {
            CriteriaTriggers.field_192138_r.func_192234_a((EntityPlayerMP)buyingPlayer, (EntityVillager)this, recipe.func_77397_d());
        }
    }

    private <T, E> void setEntityVillagerField(int fieldIndex, Object value) {
        ObfuscationReflectionHelper.setPrivateValue(EntityVillager.class, (Object)((Object)this), (Object)value, (int)fieldIndex);
    }

    private <T, E> T getEntityVillagerField(int fieldIndex) {
        return (T)ObfuscationReflectionHelper.getPrivateValue(EntityVillager.class, (Object)((Object)this), (int)fieldIndex);
    }
}

