/*
 * Decompiled with CFR 0.152.
 */
package mca.entity;

import com.google.common.base.Optional;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mca.actions.ActionStoryProgression;
import mca.core.Constants;
import mca.core.MCA;
import mca.data.NBTPlayerData;
import mca.data.PlayerMemory;
import mca.data.TransitiveVillagerData;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumBabyState;
import mca.enums.EnumDialogueType;
import mca.enums.EnumGender;
import mca.enums.EnumMarriageState;
import mca.enums.EnumMovementState;
import mca.enums.EnumPersonality;
import mca.enums.EnumProfession;
import mca.enums.EnumProfessionSkinGroup;
import mca.enums.EnumProgressionStep;
import mca.inventory.VillagerInventory;
import mca.packets.PacketSetSize;
import mca.util.Either;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import radixcore.modules.RadixNettyIO;

public class VillagerAttributes {
    private final EntityVillagerMCA villager;
    private final EntityDataManager dataManager;
    private static final DataParameter<String> NAME = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> HEAD_TEXTURE = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> CLOTHES_TEXTURE = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> PROFESSION = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> PERSONALITY = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> GENDER = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> SPOUSE_NAME = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Optional<UUID>> SPOUSE_UUID = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Integer> SPOUSE_GENDER = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> MOTHER_NAME = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Optional<UUID>> MOTHER_UUID = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Integer> MOTHER_GENDER = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> FATHER_NAME = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Optional<UUID>> FATHER_UUID = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Integer> FATHER_GENDER = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> BABY_STATE = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> MOVEMENT_STATE = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IS_CHILD = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> SCALE_HEIGHT = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SCALE_WIDTH = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> DO_DISPLAY = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_SWINGING = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> HELD_ITEM_SLOT = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IS_INFECTED = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DO_OPEN_INVENTORY = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> MARRIAGE_STATE = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187192_b);
    private int timesWarnedForLowHearts;
    private int ticksAlive;
    private Map<UUID, PlayerMemory> playerMemories;
    private final VillagerInventory inventory;

    public VillagerAttributes(EntityVillagerMCA villager) {
        this.villager = villager;
        this.dataManager = villager.func_184212_Q();
        this.playerMemories = new HashMap<UUID, PlayerMemory>();
        this.inventory = new VillagerInventory();
    }

    public VillagerAttributes(NBTTagCompound nbt) {
        this.villager = null;
        this.dataManager = null;
        this.inventory = null;
        this.playerMemories = new HashMap<UUID, PlayerMemory>();
        this.readFromNBT(nbt);
    }

    public void initialize() {
        this.dataManager.func_187214_a(NAME, (Object)"Steve");
        this.dataManager.func_187214_a(HEAD_TEXTURE, (Object)"");
        this.dataManager.func_187214_a(CLOTHES_TEXTURE, (Object)"");
        this.dataManager.func_187214_a(PROFESSION, (Object)EnumProfession.Farmer.getId());
        this.dataManager.func_187214_a(PERSONALITY, (Object)EnumPersonality.FRIENDLY.getId());
        this.dataManager.func_187214_a(GENDER, (Object)EnumGender.MALE.getId());
        this.dataManager.func_187214_a(SPOUSE_NAME, (Object)"N/A");
        this.dataManager.func_187214_a(SPOUSE_UUID, Constants.EMPTY_UUID_OPT);
        this.dataManager.func_187214_a(SPOUSE_GENDER, (Object)EnumGender.UNASSIGNED.getId());
        this.dataManager.func_187214_a(MOTHER_NAME, (Object)"N/A");
        this.dataManager.func_187214_a(MOTHER_UUID, Constants.EMPTY_UUID_OPT);
        this.dataManager.func_187214_a(MOTHER_GENDER, (Object)EnumGender.UNASSIGNED.getId());
        this.dataManager.func_187214_a(FATHER_NAME, (Object)"N/A");
        this.dataManager.func_187214_a(FATHER_UUID, Constants.EMPTY_UUID_OPT);
        this.dataManager.func_187214_a(FATHER_GENDER, (Object)EnumGender.UNASSIGNED.getId());
        this.dataManager.func_187214_a(BABY_STATE, (Object)EnumBabyState.NONE.getId());
        this.dataManager.func_187214_a(MOVEMENT_STATE, (Object)EnumMovementState.MOVE.getId());
        this.dataManager.func_187214_a(IS_CHILD, (Object)false);
        this.dataManager.func_187214_a(AGE, (Object)0);
        this.dataManager.func_187214_a(SCALE_HEIGHT, (Object)Float.valueOf(0.0f));
        this.dataManager.func_187214_a(SCALE_WIDTH, (Object)Float.valueOf(0.0f));
        this.dataManager.func_187214_a(DO_DISPLAY, (Object)false);
        this.dataManager.func_187214_a(IS_SWINGING, (Object)false);
        this.dataManager.func_187214_a(HELD_ITEM_SLOT, (Object)0);
        this.dataManager.func_187214_a(IS_INFECTED, (Object)false);
        this.dataManager.func_187214_a(DO_OPEN_INVENTORY, (Object)false);
        this.dataManager.func_187214_a(MARRIAGE_STATE, (Object)0);
    }

    public void copyFrom(TransitiveVillagerData data) {
        this.setName(data.getName());
        this.setHeadTexture(data.getHeadTexture());
        this.setClothesTexture(data.getClothesTexture());
        this.setProfession(data.getProfession());
        this.setPersonality(data.getPersonality());
        this.setGender(data.getGender());
        this.setSpouseUUID(data.getSpouseUUID());
        this.setSpouseGender(data.getSpouseGender());
        this.setSpouseName(data.getSpouseName());
        this.setMotherUUID(data.getMotherUUID());
        this.setMotherGender(data.getMotherGender());
        this.setMotherName(data.getMotherName());
        this.setFatherUUID(data.getFatherUUID());
        this.setFatherGender(data.getFatherGender());
        this.setFatherName(data.getFatherName());
        this.setBabyState(data.getBabyState());
        this.setMovementState(data.getMovementState());
        this.setIsChild(data.getIsChild());
        this.setAge(data.getAge());
        this.setScaleHeight(data.getScaleHeight().floatValue());
        this.setScaleWidth(data.getScaleWidth().floatValue());
        this.setDoDisplay(data.getDoDisplay());
        this.setIsSwinging(data.getIsSwinging());
        this.setHeldItemSlot(data.getHeldItemSlot());
        this.setIsInfected(data.getIsInfected());
        this.setDoOpenInventory(data.getDoOpenInventory());
        this.setMarriageState(data.getMarriageState());
    }

    public String getName() {
        return (String)this.dataManager.func_187225_a(NAME);
    }

    public void setName(String name) {
        this.dataManager.func_187227_b(NAME, (Object)name);
    }

    public String getHeadTexture() {
        return (String)this.dataManager.func_187225_a(HEAD_TEXTURE);
    }

    public void setHeadTexture(String texture) {
        this.dataManager.func_187227_b(HEAD_TEXTURE, (Object)texture);
    }

    public String getClothesTexture() {
        return (String)this.dataManager.func_187225_a(CLOTHES_TEXTURE);
    }

    public void setClothesTexture(String texture) {
        this.dataManager.func_187227_b(CLOTHES_TEXTURE, (Object)texture);
    }

    public void assignRandomSkin() {
        if (this.getGender() == EnumGender.UNASSIGNED) {
            Throwable t = new Throwable();
            MCA.getLog().error("Attempted to randomize skin on unassigned gender villager.");
            MCA.getLog().error((Object)t);
        } else {
            EnumProfessionSkinGroup skinGroup = this.getProfessionSkinGroup();
            String skin = this.getGender() == EnumGender.MALE ? skinGroup.getRandomMaleSkin() : skinGroup.getRandomFemaleSkin();
            this.setHeadTexture(skin);
            this.setClothesTexture(skin);
        }
    }

    public void assignRandomScale() {
    }

    public EnumProfession getProfessionEnum() {
        return EnumProfession.getProfessionById((Integer)this.dataManager.func_187225_a(PROFESSION));
    }

    public EnumProfessionSkinGroup getProfessionSkinGroup() {
        return EnumProfession.getProfessionById((Integer)this.dataManager.func_187225_a(PROFESSION)).getSkinGroup();
    }

    public void setProfession(EnumProfession profession) {
        this.dataManager.func_187227_b(PROFESSION, (Object)profession.getId());
        this.villager.func_70938_b(profession.getId());
    }

    public EnumPersonality getPersonality() {
        return EnumPersonality.getById((Integer)this.dataManager.func_187225_a(PERSONALITY));
    }

    public void setPersonality(EnumPersonality personality) {
        this.dataManager.func_187227_b(PERSONALITY, (Object)personality.getId());
    }

    public EnumGender getGender() {
        return EnumGender.byId((Integer)this.dataManager.func_187225_a(GENDER));
    }

    public void setGender(EnumGender gender) {
        this.dataManager.func_187227_b(GENDER, (Object)gender.getId());
    }

    public String getSpouseName() {
        return (String)this.dataManager.func_187225_a(SPOUSE_NAME);
    }

    public UUID getSpouseUUID() {
        return (UUID)((Optional)this.dataManager.func_187225_a(SPOUSE_UUID)).or((Object)Constants.EMPTY_UUID);
    }

    public EnumGender getSpouseGender() {
        return EnumGender.byId((Integer)this.dataManager.func_187225_a(SPOUSE_GENDER));
    }

    public void setFiancee(EntityPlayer player) {
        if (player == null) {
            throw new Error("Engagement player cannot be null");
        }
        NBTPlayerData playerData = MCA.getPlayerData(player);
        this.dataManager.func_187227_b(SPOUSE_NAME, (Object)player.func_70005_c_());
        this.dataManager.func_187227_b(SPOUSE_UUID, (Object)Optional.of((Object)player.func_110124_au()));
        this.dataManager.func_187227_b(SPOUSE_GENDER, (Object)playerData.getGender().getId());
        this.setMarriageState(EnumMarriageState.ENGAGED);
        playerData.setSpouseName(this.getName());
        playerData.setSpouseGender(this.getGender());
        playerData.setSpouseUUID(this.villager.func_110124_au());
        playerData.setMarriageState(EnumMarriageState.ENGAGED);
        this.villager.getBehavior(ActionStoryProgression.class).setProgressionStep(EnumProgressionStep.FINISHED);
    }

    public EntityVillagerMCA getVillagerSpouseInstance() {
        for (Object obj : this.villager.field_70170_p.field_72996_f) {
            EntityVillagerMCA villager;
            if (!(obj instanceof EntityVillagerMCA) || !(villager = (EntityVillagerMCA)((Object)obj)).func_110124_au().equals(this.getSpouseUUID())) continue;
            return villager;
        }
        return null;
    }

    public EntityPlayer getPlayerSpouseInstance() {
        for (Object obj : this.villager.field_70170_p.field_73010_i) {
            EntityPlayer player = (EntityPlayer)obj;
            if (!player.func_110124_au().equals(this.getSpouseUUID())) continue;
            return player;
        }
        return null;
    }

    public String getMotherName() {
        return (String)this.dataManager.func_187225_a(MOTHER_NAME);
    }

    public UUID getMotherUUID() {
        return (UUID)((Optional)this.dataManager.func_187225_a(MOTHER_UUID)).or((Object)Constants.EMPTY_UUID);
    }

    public EnumGender getMotherGender() {
        return EnumGender.byId((Integer)this.dataManager.func_187225_a(MOTHER_GENDER));
    }

    public void setMotherName(String name) {
        if (name == null) {
            name = "N/A";
        }
        this.dataManager.func_187227_b(MOTHER_NAME, (Object)name);
    }

    public void setMotherUUID(UUID uuid) {
        this.dataManager.func_187227_b(MOTHER_UUID, (Object)Optional.of((Object)uuid));
    }

    public void setMotherGender(EnumGender gender) {
        this.dataManager.func_187227_b(MOTHER_GENDER, (Object)gender.getId());
    }

    public void setMother(Either<EntityVillagerMCA, EntityPlayer> either) {
        if (either == null) {
            this.dataManager.func_187227_b(MOTHER_NAME, (Object)"");
            this.dataManager.func_187227_b(MOTHER_UUID, Constants.EMPTY_UUID_OPT);
            this.dataManager.func_187227_b(MOTHER_GENDER, (Object)EnumGender.UNASSIGNED.getId());
        } else if (either.getLeft() != null) {
            EntityVillagerMCA mother = either.getLeft();
            this.dataManager.func_187227_b(MOTHER_NAME, (Object)mother.attributes.getName());
            this.dataManager.func_187227_b(MOTHER_UUID, (Object)Optional.of((Object)mother.func_110124_au()));
            this.dataManager.func_187227_b(MOTHER_GENDER, (Object)mother.attributes.getGender().getId());
        } else if (either.getRight() != null) {
            EntityPlayer player = either.getRight();
            NBTPlayerData data = MCA.getPlayerData(player);
            this.dataManager.func_187227_b(MOTHER_NAME, (Object)player.func_70005_c_());
            this.dataManager.func_187227_b(MOTHER_UUID, (Object)Optional.of((Object)player.func_110124_au()));
            this.dataManager.func_187227_b(MOTHER_GENDER, (Object)data.getGender().getId());
        }
    }

    public String getFatherName() {
        return (String)this.dataManager.func_187225_a(FATHER_NAME);
    }

    public UUID getFatherUUID() {
        return (UUID)((Optional)this.dataManager.func_187225_a(FATHER_UUID)).or((Object)Constants.EMPTY_UUID);
    }

    public EnumGender getFatherGender() {
        return EnumGender.byId((Integer)this.dataManager.func_187225_a(FATHER_GENDER));
    }

    public void setFatherName(String name) {
        if (name == null) {
            name = "N/A";
        }
        this.dataManager.func_187227_b(FATHER_NAME, (Object)name);
    }

    public void setFatherUUID(UUID uuid) {
        this.dataManager.func_187227_b(FATHER_UUID, (Object)Optional.of((Object)uuid));
    }

    public void setFatherGender(EnumGender gender) {
        this.dataManager.func_187227_b(FATHER_GENDER, (Object)gender.getId());
    }

    public void setFather(Either<EntityVillagerMCA, EntityPlayer> either) {
        if (either == null) {
            this.dataManager.func_187227_b(FATHER_NAME, (Object)"");
            this.dataManager.func_187227_b(FATHER_UUID, Constants.EMPTY_UUID_OPT);
            this.dataManager.func_187227_b(FATHER_GENDER, (Object)EnumGender.UNASSIGNED.getId());
        } else if (either.getLeft() != null) {
            EntityVillagerMCA father = either.getLeft();
            this.dataManager.func_187227_b(FATHER_NAME, (Object)father.attributes.getName());
            this.dataManager.func_187227_b(FATHER_UUID, (Object)Optional.of((Object)father.func_110124_au()));
            this.dataManager.func_187227_b(FATHER_GENDER, (Object)father.attributes.getGender().getId());
        } else if (either.getRight() != null) {
            EntityPlayer player = either.getRight();
            NBTPlayerData data = MCA.getPlayerData(player);
            this.dataManager.func_187227_b(FATHER_NAME, (Object)player.func_70005_c_());
            this.dataManager.func_187227_b(FATHER_UUID, (Object)Optional.of((Object)player.func_110124_au()));
            this.dataManager.func_187227_b(FATHER_GENDER, (Object)data.getGender().getId());
        }
    }

    public EnumBabyState getBabyState() {
        return EnumBabyState.fromId((Integer)this.dataManager.func_187225_a(BABY_STATE));
    }

    public void setBabyState(EnumBabyState state) {
        this.dataManager.func_187227_b(BABY_STATE, (Object)state.getId());
    }

    public EnumMovementState getMovementState() {
        return EnumMovementState.fromId((Integer)this.dataManager.func_187225_a(MOVEMENT_STATE));
    }

    public void setMovementState(EnumMovementState state) {
        this.dataManager.func_187227_b(MOVEMENT_STATE, (Object)state.getId());
    }

    public boolean getIsChild() {
        return (Boolean)this.dataManager.func_187225_a(IS_CHILD);
    }

    public void setIsChild(boolean isChild) {
        this.dataManager.func_187227_b(IS_CHILD, (Object)isChild);
        EnumDialogueType newDialogueType = isChild ? EnumDialogueType.CHILD : EnumDialogueType.ADULT;
        EnumDialogueType targetReplacementType = isChild ? EnumDialogueType.ADULT : EnumDialogueType.CHILD;
        for (PlayerMemory memory : this.playerMemories.values()) {
            if (memory.getDialogueType() != targetReplacementType) continue;
            memory.setDialogueType(newDialogueType);
        }
    }

    public boolean isChildOfAVillager() {
        NBTPlayerData motherData = MCA.getPlayerData(this.villager.field_70170_p, this.getMotherUUID());
        NBTPlayerData fatherData = MCA.getPlayerData(this.villager.field_70170_p, this.getFatherUUID());
        return motherData == null && fatherData == null;
    }

    public int getAge() {
        return (Integer)this.dataManager.func_187225_a(AGE);
    }

    public void setAge(int age) {
        this.dataManager.func_187227_b(AGE, (Object)age);
    }

    public float getScaleHeight() {
        return ((Float)this.dataManager.func_187225_a(SCALE_HEIGHT)).floatValue();
    }

    public void setScaleHeight(float value) {
        this.dataManager.func_187227_b(SCALE_HEIGHT, (Object)Float.valueOf(value));
    }

    public float getScaleWidth() {
        return ((Float)this.dataManager.func_187225_a(SCALE_WIDTH)).floatValue();
    }

    public void setScaleWidth(float value) {
        this.dataManager.func_187227_b(SCALE_WIDTH, (Object)Float.valueOf(value));
    }

    public boolean getDoDisplay() {
        return (Boolean)this.dataManager.func_187225_a(DO_DISPLAY);
    }

    public void setDoDisplay(boolean value) {
        this.dataManager.func_187227_b(DO_DISPLAY, (Object)value);
    }

    public boolean getIsSwinging() {
        return (Boolean)this.dataManager.func_187225_a(IS_SWINGING);
    }

    public void setIsSwinging(boolean value) {
        this.dataManager.func_187227_b(IS_SWINGING, (Object)value);
    }

    @Deprecated
    public boolean getIsMale() {
        return this.getGender() == EnumGender.MALE;
    }

    @Deprecated
    public String getParentNames() {
        return this.getMotherName() + "|" + this.getFatherName();
    }

    @Deprecated
    public boolean getIsMarried() {
        return this.getMarriageState() == EnumMarriageState.MARRIED_TO_VILLAGER || this.getMarriageState() == EnumMarriageState.MARRIED_TO_PLAYER;
    }

    public boolean getCanBeHired(EntityPlayer player) {
        return this.getPlayerSpouseInstance() != player && (this.getProfessionSkinGroup() == EnumProfessionSkinGroup.Farmer || this.getProfessionSkinGroup() == EnumProfessionSkinGroup.Miner || this.getProfessionSkinGroup() == EnumProfessionSkinGroup.Warrior);
    }

    public boolean getDoOpenInventory() {
        return (Boolean)this.dataManager.func_187225_a(DO_OPEN_INVENTORY);
    }

    public void setDoOpenInventory(boolean value) {
        this.dataManager.func_187227_b(DO_OPEN_INVENTORY, (Object)value);
    }

    public EnumMarriageState getMarriageState() {
        return EnumMarriageState.byId((Integer)this.dataManager.func_187225_a(MARRIAGE_STATE));
    }

    void setSpouseUUID(UUID uuid) {
        this.dataManager.func_187227_b(SPOUSE_UUID, (Object)Optional.of((Object)uuid));
    }

    void setSpouseName(String value) {
        this.dataManager.func_187227_b(SPOUSE_NAME, (Object)value);
    }

    void setSpouseGender(EnumGender gender) {
        this.dataManager.func_187227_b(SPOUSE_GENDER, (Object)gender.getId());
    }

    void setParentName(boolean mother, String value) {
        DataParameter<String> field = mother ? MOTHER_NAME : FATHER_NAME;
        this.dataManager.func_187227_b(field, (Object)value);
    }

    void setParentUUID(boolean mother, UUID uuid) {
        DataParameter<Optional<UUID>> field = mother ? MOTHER_UUID : FATHER_UUID;
        this.dataManager.func_187227_b(field, (Object)Optional.of((Object)uuid));
    }

    void setParentGender(boolean mother, EnumGender gender) {
        DataParameter<Integer> field = mother ? MOTHER_GENDER : FATHER_GENDER;
        this.dataManager.func_187227_b(field, (Object)gender.getId());
    }

    void setMarriageState(EnumMarriageState state) {
        this.dataManager.func_187227_b(MARRIAGE_STATE, (Object)state.getId());
    }

    public int getHeldItemSlot() {
        return (Integer)this.dataManager.func_187225_a(HELD_ITEM_SLOT);
    }

    public void setHeldItemSlot(int value) {
        this.dataManager.func_187227_b(HELD_ITEM_SLOT, (Object)value);
    }

    public boolean getIsInfected() {
        return (Boolean)this.dataManager.func_187225_a(IS_INFECTED);
    }

    public void setIsInfected(boolean value) {
        this.dataManager.func_187227_b(IS_INFECTED, (Object)value);
    }

    public double getBaseAttackDamage() {
        switch (this.getPersonality()) {
            case STRONG: {
                return 2.0;
            }
            case CONFIDENT: {
                return 1.0;
            }
        }
        if (this.getProfessionSkinGroup() == EnumProfessionSkinGroup.Guard) {
            return 5.0;
        }
        return 0.5;
    }

    public void assignRandomName() {
        if (this.getGender() == EnumGender.MALE) {
            this.setName(MCA.getLocalizer().getString("name.male"));
        } else {
            this.setName(MCA.getLocalizer().getString("name.female"));
        }
    }

    public void assignRandomGender() {
        this.setGender(this.villager.field_70170_p.field_73012_v.nextBoolean() ? EnumGender.MALE : EnumGender.FEMALE);
    }

    public void assignRandomProfession() {
        this.setProfession(EnumProfession.getAtRandom());
    }

    public void assignRandomPersonality() {
        this.setPersonality(EnumPersonality.getAtRandom());
    }

    public boolean isMarriedToAPlayer() {
        return this.getMarriageState() == EnumMarriageState.MARRIED_TO_PLAYER;
    }

    public boolean isMarriedToAVillager() {
        return this.getMarriageState() == EnumMarriageState.MARRIED_TO_VILLAGER;
    }

    public boolean getIsEngaged() {
        return this.getMarriageState() == EnumMarriageState.ENGAGED;
    }

    public boolean isPlayerAParent(EntityPlayer player) {
        NBTPlayerData data = MCA.getPlayerData(player);
        if (data != null) {
            boolean result = this.getMotherUUID().equals(data.getUUID()) || this.getFatherUUID().equals(data.getUUID());
            return result;
        }
        return false;
    }

    public boolean isPlayerAParent(UUID uuid) {
        NBTPlayerData data = MCA.getPlayerData(this.villager.field_70170_p, uuid);
        if (data != null) {
            return this.getMotherUUID() == data.getUUID() || this.getFatherUUID() == data.getUUID();
        }
        return false;
    }

    public float getSpeed() {
        return this.getPersonality() == EnumPersonality.ATHLETIC ? 0.7f : 0.6f;
    }

    public boolean allowsHiring(EntityPlayer player) {
        return this.getPlayerSpouseInstance() != player && (this.getProfessionSkinGroup() == EnumProfessionSkinGroup.Farmer || this.getProfessionSkinGroup() == EnumProfessionSkinGroup.Miner || this.getProfessionSkinGroup() == EnumProfessionSkinGroup.Warrior);
    }

    public boolean allowsWorkInteractions(EntityPlayer player) {
        NBTPlayerData data = MCA.getPlayerData(player);
        PlayerMemory memory = this.getPlayerMemory(player);
        if (data.getIsSuperUser()) {
            return true;
        }
        if (this.getIsInfected()) {
            return false;
        }
        if (memory.getIsHiredBy()) {
            return true;
        }
        return this.isPlayerAParent(player);
    }

    public boolean allowsControllingInteractions(EntityPlayer player) {
        NBTPlayerData data = MCA.getPlayerData(player);
        if (data.getIsSuperUser()) {
            return true;
        }
        if (this.isMarriedToAPlayer() && !this.getSpouseUUID().equals(data.getUUID())) {
            return false;
        }
        if (this.getIsChild()) {
            if (this.isPlayerAParent(player)) {
                return true;
            }
            return this.isChildOfAVillager();
        }
        return true;
    }

    public boolean allowsIntimateInteractions(EntityPlayer player) {
        return !this.getIsChild() && !this.isPlayerAParent(player);
    }

    public int getTicksAlive() {
        return this.ticksAlive;
    }

    public void setTicksAlive(int value) {
        this.ticksAlive = value;
    }

    public int getLowHeartWarnings() {
        return this.timesWarnedForLowHearts;
    }

    public void incrementLowHeartWarnings() {
        ++this.timesWarnedForLowHearts;
    }

    public void resetLowHeartWarnings() {
        this.timesWarnedForLowHearts = 0;
    }

    public void setPlayerMemory(EntityPlayer player, PlayerMemory memory) {
        this.playerMemories.put(player.getPersistentID(), memory);
    }

    public PlayerMemory getPlayerMemory(EntityPlayer player) {
        UUID playerUUID = player.getPersistentID();
        PlayerMemory returnMemory = this.playerMemories.get(playerUUID);
        if (returnMemory == null) {
            returnMemory = new PlayerMemory(this.villager, player);
            this.playerMemories.put(playerUUID, returnMemory);
        }
        return returnMemory;
    }

    public PlayerMemory getPlayerMemoryWithoutCreating(EntityPlayer player) {
        return this.getPlayerMemoryWithoutCreating(player.func_110124_au());
    }

    public PlayerMemory getPlayerMemoryWithoutCreating(UUID playerUUID) {
        return this.playerMemories.get(playerUUID);
    }

    public Map<UUID, PlayerMemory> getPlayerMemories() {
        return this.playerMemories;
    }

    public boolean hasMemoryOfPlayer(EntityPlayer player) {
        return this.playerMemories.containsKey(player.func_70005_c_());
    }

    public String getTitle(EntityPlayer player) {
        PlayerMemory memory = this.getPlayerMemory(player);
        if (memory.isRelatedToPlayer()) {
            return MCA.getLocalizer().getString(this.getGender() == EnumGender.MALE ? "title.relative.male" : "title.relative.female", new Object[]{this.villager, player});
        }
        return MCA.getLocalizer().getString(this.getGender() == EnumGender.MALE ? "title.nonrelative.male" : "title.nonrelative.female", new Object[]{this.villager, player});
    }

    public void writeToNBT(NBTTagCompound nbt) {
        for (Field f : this.getClass().getDeclaredFields()) {
            try {
                if (f.getType() != DataParameter.class) continue;
                Type genericType = f.getGenericType();
                String typeName = genericType.getTypeName();
                DataParameter param = (DataParameter)f.get(this);
                String paramName = f.getName();
                if (typeName.contains("Boolean")) {
                    DataParameter bParam = param;
                    nbt.func_74757_a(paramName, ((Boolean)this.dataManager.func_187225_a(bParam)).booleanValue());
                    continue;
                }
                if (typeName.contains("Integer")) {
                    DataParameter iParam = param;
                    nbt.func_74768_a(paramName, ((Integer)this.dataManager.func_187225_a(iParam)).intValue());
                    continue;
                }
                if (typeName.contains("String")) {
                    DataParameter sParam = param;
                    nbt.func_74778_a(paramName, (String)this.dataManager.func_187225_a(sParam));
                    continue;
                }
                if (typeName.contains("Float")) {
                    DataParameter fParam = param;
                    nbt.func_74776_a(paramName, ((Float)this.dataManager.func_187225_a(fParam)).floatValue());
                    continue;
                }
                if (typeName.contains("Optional<java.util.UUID>")) {
                    DataParameter uuParam = param;
                    nbt.func_186854_a(paramName, (UUID)((Optional)this.dataManager.func_187225_a(uuParam)).get());
                    continue;
                }
                throw new RuntimeException("Field type not handled while saving to NBT: " + f.getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        nbt.func_74768_a("ticksAlive", this.ticksAlive);
        nbt.func_74768_a("timesWarnedForLowHearts", this.timesWarnedForLowHearts);
        nbt.func_74782_a("inventory", (NBTBase)this.inventory.writeInventoryToNBT());
        int counter = 0;
        for (Map.Entry<UUID, PlayerMemory> pair : this.playerMemories.entrySet()) {
            nbt.func_186854_a("playerMemoryKey" + counter, pair.getKey());
            pair.getValue().writePlayerMemoryToNBT(nbt);
            ++counter;
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        UUID playerUUID;
        for (Field f : this.getClass().getDeclaredFields()) {
            try {
                if (f.getType() != DataParameter.class) continue;
                Type genericType = f.getGenericType();
                String typeName = genericType.getTypeName();
                DataParameter param = (DataParameter)f.get(this);
                String paramName = f.getName();
                if (typeName.contains("Boolean")) {
                    DataParameter bParam = param;
                    this.dataManager.func_187227_b(bParam, (Object)nbt.func_74767_n(paramName));
                    continue;
                }
                if (typeName.contains("Integer")) {
                    DataParameter iParam = param;
                    this.dataManager.func_187227_b(iParam, (Object)nbt.func_74762_e(paramName));
                    continue;
                }
                if (typeName.contains("String")) {
                    DataParameter sParam = param;
                    this.dataManager.func_187227_b(sParam, (Object)nbt.func_74779_i(paramName));
                    continue;
                }
                if (typeName.contains("Float")) {
                    DataParameter fParam = param;
                    this.dataManager.func_187227_b(fParam, (Object)Float.valueOf(nbt.func_74760_g(paramName)));
                    continue;
                }
                if (typeName.contains("Optional<java.util.UUID>")) {
                    DataParameter uuParam = param;
                    this.dataManager.func_187227_b(uuParam, (Object)Optional.of((Object)nbt.func_186857_a(paramName)));
                    continue;
                }
                throw new RuntimeException("Field type not handled while saving to NBT: " + f.getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.ticksAlive = nbt.func_74762_e("ticksAlive");
        this.timesWarnedForLowHearts = nbt.func_74762_e("timesWarnedForLowHearts");
        this.inventory.readInventoryFromNBT(nbt.func_150295_c("inventory", 10));
        int counter = 0;
        while ((playerUUID = nbt.func_186857_a("playerMemoryKey" + counter)) != null && !playerUUID.equals(Constants.EMPTY_UUID)) {
            PlayerMemory playerMemory = new PlayerMemory(this.villager, playerUUID);
            playerMemory.readPlayerMemoryFromNBT(nbt);
            this.playerMemories.put(playerUUID, playerMemory);
            ++counter;
        }
    }

    public VillagerInventory getInventory() {
        return this.inventory;
    }

    public void incrementTicksAlive() {
        ++this.ticksAlive;
    }

    public void writeSpawnData(ByteBuf buffer) {
        RadixNettyIO.writeObject((ByteBuf)buffer, this.playerMemories);
    }

    public void readSpawnData(ByteBuf buffer) {
        Map recvMemories;
        this.playerMemories = recvMemories = (Map)RadixNettyIO.readObject((ByteBuf)buffer);
        this.setDoDisplay(true);
    }

    public void setSize(float width, float height) {
        this.villager.setHitboxSize(width, height);
        if (!this.villager.field_70170_p.field_72995_K) {
            MCA.getPacketHandler().sendPacketToAllPlayers((IMessage)new PacketSetSize(this.villager, width, height));
        }
    }

    public UUID getVillagerUUID() {
        return this.villager.getPersistentID();
    }
}

