/*
 * Decompiled with CFR 0.152.
 */
package mca.enums;

import java.util.ArrayList;
import java.util.List;
import mca.core.MCA;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumProfessionSkinGroup;
import radixcore.modules.RadixMath;

public enum EnumProfession {
    Unassigned(-1, EnumProfessionSkinGroup.Unassigned, -1),
    Farmer(0, EnumProfessionSkinGroup.Farmer, 1),
    Fisherman(1, EnumProfessionSkinGroup.Farmer, 2),
    Shepherd(2, EnumProfessionSkinGroup.Farmer, 3),
    Fletcher(3, EnumProfessionSkinGroup.Farmer, 4),
    Librarian(4, EnumProfessionSkinGroup.Librarian, 1),
    Cleric(5, EnumProfessionSkinGroup.Priest, 1),
    Armorer(6, EnumProfessionSkinGroup.Smith, 1),
    WeaponSmith(7, EnumProfessionSkinGroup.Smith, 2),
    ToolSmith(8, EnumProfessionSkinGroup.Smith, 3),
    Butcher(9, EnumProfessionSkinGroup.Butcher, 1),
    Baker(10, EnumProfessionSkinGroup.Baker, 1),
    Leatherworker(11, EnumProfessionSkinGroup.Butcher, 2),
    Guard(12, EnumProfessionSkinGroup.Guard, 1),
    Archer(13, EnumProfessionSkinGroup.Guard, 1),
    Miner(14, EnumProfessionSkinGroup.Miner, 1),
    Mason(15, EnumProfessionSkinGroup.Miner, 1),
    Child(16, EnumProfessionSkinGroup.Child, 1),
    Warrior(17, EnumProfessionSkinGroup.Warrior, 3);

    private int id;
    private int vanillaCareerId;
    private EnumProfessionSkinGroup skinGroup;

    private EnumProfession(int id, EnumProfessionSkinGroup skinGroup, int vanillaCareerId) {
        this.id = id;
        this.vanillaCareerId = vanillaCareerId;
        this.skinGroup = skinGroup;
    }

    public int getId() {
        return this.id;
    }

    public static EnumProfession getNewProfessionFromVanilla(int id) {
        switch (id) {
            case 0: {
                return EnumProfession.getRandomByGroup(EnumProfessionSkinGroup.Farmer, EnumProfessionSkinGroup.Miner);
            }
            case 1: {
                return EnumProfession.getRandomByGroup(EnumProfessionSkinGroup.Librarian);
            }
            case 2: {
                return EnumProfession.getRandomByGroup(EnumProfessionSkinGroup.Priest);
            }
            case 3: {
                return EnumProfession.getRandomByGroup(EnumProfessionSkinGroup.Smith);
            }
            case 4: {
                return EnumProfession.getRandomByGroup(EnumProfessionSkinGroup.Butcher, EnumProfessionSkinGroup.Baker);
            }
        }
        return EnumProfession.getRandomByGroup(EnumProfessionSkinGroup.Farmer);
    }

    public static EnumProfession getRandomByGroup(EnumProfessionSkinGroup ... groups) {
        ArrayList<EnumProfession> groupProfessions = new ArrayList<EnumProfession>();
        for (EnumProfession profession : EnumProfession.values()) {
            for (EnumProfessionSkinGroup group : groups) {
                if (profession.skinGroup != group) continue;
                groupProfessions.add(profession);
            }
        }
        return (EnumProfession)((Object)groupProfessions.get(RadixMath.getNumberInRange((int)0, (int)(groupProfessions.size() - 1))));
    }

    public static EnumProfession getProfessionById(int id) {
        for (EnumProfession profession : EnumProfession.values()) {
            if (profession.getId() != id) continue;
            return profession;
        }
        return null;
    }

    public static EnumProfession getAtRandom() {
        EnumProfession returnValue = Unassigned;
        while (returnValue == Unassigned) {
            EnumProfession[] values = EnumProfession.values();
            int returnIndex = RadixMath.getNumberInRange((int)0, (int)(values.length - 1));
            returnValue = values[returnIndex];
        }
        return returnValue;
    }

    public String getUserFriendlyForm(EntityVillagerMCA human) {
        if (this == Child && !human.attributes.getIsChild()) {
            return MCA.getLocalizer().getString("profession.villager");
        }
        if (human.attributes.getIsChild()) {
            return MCA.getLocalizer().getString("profession.child");
        }
        return MCA.getLocalizer().getString(this.getLocalizationId());
    }

    public EnumProfessionSkinGroup getSkinGroup() {
        return this.skinGroup;
    }

    public static List<Integer> getListOfIds() {
        ArrayList<Integer> returnList = new ArrayList<Integer>();
        for (EnumProfession profession : EnumProfession.values()) {
            if (profession == Unassigned) continue;
            returnList.add(profession.id);
        }
        return returnList;
    }

    public String getLocalizationId() {
        switch (this) {
            case Archer: {
                return "profession.archer";
            }
            case Armorer: {
                return "profession.armorer";
            }
            case Butcher: {
                return "profession.butcher";
            }
            case Cleric: {
                return "profession.cleric";
            }
            case Farmer: {
                return "profession.farmer";
            }
            case Fisherman: {
                return "profession.fisherman";
            }
            case Fletcher: {
                return "profession.fletcher";
            }
            case Guard: {
                return "profession.guard";
            }
            case Leatherworker: {
                return "profession.leatherworker";
            }
            case Librarian: {
                return "profession.librarian";
            }
            case Shepherd: {
                return "profession.shepherd";
            }
            case ToolSmith: {
                return "profession.toolsmith";
            }
            case WeaponSmith: {
                return "profession.weaponsmith";
            }
            case Miner: {
                return "profession.miner";
            }
            case Mason: {
                return "profession.mason";
            }
            case Baker: {
                return "profession.baker";
            }
            case Child: {
                return "profession.child";
            }
            case Warrior: {
                return "profession.warrior";
            }
        }
        return "";
    }

    public int getVanillaCareerId() {
        return this.vanillaCareerId;
    }
}

