/*
 * Decompiled with CFR 0.152.
 */
package mca.items;

import java.util.List;
import java.util.UUID;
import mca.core.Constants;
import mca.core.MCA;
import mca.data.NBTPlayerData;
import mca.data.PlayerMemory;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumDialogueType;
import mca.enums.EnumGender;
import mca.enums.EnumProfession;
import mca.enums.EnumRelation;
import mca.packets.PacketOpenBabyNameGUI;
import mca.util.TutorialManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ItemBaby
extends Item {
    private final boolean isBoy;

    public ItemBaby(boolean isBoy) {
        this.isBoy = isBoy;
        this.func_77625_d(1);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int unknownInt, boolean unknownBoolean) {
        super.func_77663_a(itemStack, world, entity, unknownInt, unknownBoolean);
        if (!world.field_72995_K) {
            if (!itemStack.func_77942_o()) {
                String ownerName = entity instanceof EntityPlayer ? entity.func_70005_c_() : (entity instanceof EntityVillagerMCA ? ((EntityVillagerMCA)entity).attributes.getSpouseName() : "Unknown");
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74778_a("name", "Unnamed");
                compound.func_74768_a("age", 0);
                compound.func_74778_a("owner", ownerName);
                compound.func_74757_a("isInfected", false);
                itemStack.func_77982_d(compound);
                if (entity instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)entity;
                    if (player.field_71075_bZ.field_75098_d) {
                        TutorialManager.sendMessageToPlayer(player, "You can name a baby retrieved from", "creative mode by right-clicking the air.");
                    }
                }
            } else {
                this.updateBabyGrowth(itemStack);
            }
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.OFF_HAND) {
            return EnumActionResult.FAIL;
        }
        ItemStack stack = player.func_184586_b(hand);
        int posX = pos.func_177958_n();
        int posY = pos.func_177956_o();
        int posZ = pos.func_177952_p();
        if (!world.field_72995_K && this.isReadyToGrowUp(stack)) {
            ItemBaby baby = (ItemBaby)stack.func_77973_b();
            NBTPlayerData data = MCA.getPlayerData(player);
            boolean isPlayerMale = data.getGender() == EnumGender.MALE;
            String motherName = "N/A";
            UUID motherId = Constants.EMPTY_UUID;
            EnumGender motherGender = EnumGender.UNASSIGNED;
            String fatherName = "N/A";
            UUID fatherId = Constants.EMPTY_UUID;
            EnumGender fatherGender = EnumGender.UNASSIGNED;
            if (isPlayerMale) {
                motherName = data.getSpouseName();
                motherId = data.getSpouseUUID();
                motherGender = data.getSpouseGender();
                fatherName = player.func_70005_c_();
                fatherId = data.getUUID();
                fatherGender = data.getGender();
            } else {
                fatherName = data.getSpouseName();
                fatherId = data.getSpouseUUID();
                fatherGender = data.getSpouseGender();
                motherName = player.func_70005_c_();
                motherId = data.getUUID();
                motherGender = data.getGender();
            }
            if (motherId == null) {
                motherId = Constants.EMPTY_UUID;
                motherName = "N/A";
                motherGender = EnumGender.UNASSIGNED;
            }
            if (fatherId == null) {
                fatherId = Constants.EMPTY_UUID;
                fatherName = "N/A";
                fatherGender = EnumGender.UNASSIGNED;
            }
            EntityVillagerMCA child = new EntityVillagerMCA(world);
            child.attributes.setGender(baby.isBoy ? EnumGender.MALE : EnumGender.FEMALE);
            child.attributes.setIsChild(true);
            child.attributes.setName(stack.func_77978_p().func_74779_i("name"));
            child.attributes.setProfession(EnumProfession.Child);
            child.attributes.assignRandomSkin();
            child.attributes.assignRandomScale();
            child.attributes.setMotherGender(motherGender);
            child.attributes.setMotherName(motherName);
            child.attributes.setMotherUUID(motherId);
            child.attributes.setFatherGender(fatherGender);
            child.attributes.setFatherName(fatherName);
            child.attributes.setFatherUUID(fatherId);
            child.func_70107_b(posX, posY + 1, posZ);
            if (stack.func_77978_p().func_74767_n("isInfected")) {
                child.attributes.setIsInfected(true);
            }
            world.func_72838_d((Entity)child);
            PlayerMemory childMemory = child.attributes.getPlayerMemory(player);
            childMemory.setHearts(100);
            childMemory.setDialogueType(EnumDialogueType.CHILDP);
            childMemory.setRelation(child.attributes.getGender() == EnumGender.MALE ? EnumRelation.SON : EnumRelation.DAUGHTER);
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
            data.setOwnsBaby(false);
        }
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && stack.func_77978_p().func_74779_i("name").equals("Unnamed")) {
            ItemBaby baby = (ItemBaby)stack.func_77973_b();
            MCA.getPacketHandler().sendPacketToPlayer((IMessage)new PacketOpenBabyNameGUI(baby.isBoy), (EntityPlayer)((EntityPlayerMP)player));
        }
        return super.func_77659_a(world, player, hand);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (entityItem.func_92059_d() != null && !entityItem.field_70170_p.field_72995_K) {
            this.updateBabyGrowth(entityItem.func_92059_d());
        }
        return super.onEntityItemUpdate(entityItem);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77942_o()) {
            String textColor = ((ItemBaby)stack.func_77973_b()).isBoy ? "\u00a7B" : "\u00a7D";
            int ageInMinutes = stack.func_77978_p().func_74762_e("age");
            String ownerName = stack.func_77978_p().func_74779_i("owner");
            ownerName = ownerName.equals(Minecraft.func_71410_x().field_71439_g.func_70005_c_()) ? "You" : ownerName;
            tooltip.add(textColor + "Name: " + "\u00a7r" + stack.func_77978_p().func_74779_i("name"));
            tooltip.add(textColor + "Age: " + "\u00a7r" + ageInMinutes + (ageInMinutes == 1 ? " minute" : " minutes"));
            tooltip.add(textColor + "Parent: " + "\u00a7r" + ownerName);
            if (stack.func_77978_p().func_74767_n("isInfected")) {
                tooltip.add("\u00a7AInfected!");
            }
            if (this.isReadyToGrowUp(stack)) {
                tooltip.add("\u00a7AReady to grow up!");
            }
        }
    }

    private void updateBabyGrowth(ItemStack itemStack) {
        if (itemStack != null && itemStack.func_77942_o() && FMLCommonHandler.instance().getMinecraftServerInstance().func_71259_af() % 1200 == 0) {
            int age = itemStack.func_77978_p().func_74762_e("age");
            itemStack.func_77978_p().func_74768_a("age", ++age);
        }
    }

    private boolean isReadyToGrowUp(ItemStack itemStack) {
        if (itemStack != null && itemStack.func_77942_o()) {
            int ageInMinutes = itemStack.func_77978_p().func_74762_e("age");
            return ageInMinutes >= MCA.getConfig().babyGrowUpTime;
        }
        return false;
    }

    public boolean getIsBoy() {
        return this.isBoy;
    }
}

