/*
 * Decompiled with CFR 0.152.
 */
package mca.packets;

import io.netty.buffer.ByteBuf;
import mca.core.MCA;
import mca.core.minecraft.BlocksMCA;
import mca.core.minecraft.ItemsMCA;
import mca.data.NBTPlayerData;
import mca.data.PlayerMemory;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumDestinyChoice;
import mca.enums.EnumDialogueType;
import mca.enums.EnumGender;
import mca.enums.EnumProfession;
import mca.tile.TileTombstone;
import mca.util.Either;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import radixcore.math.Point3D;
import radixcore.modules.RadixBlocks;
import radixcore.modules.RadixLogic;
import radixcore.modules.RadixMath;
import radixcore.modules.net.AbstractPacket;
import radixcore.modules.schematics.RadixSchematics;

public class PacketDestinyChoice
extends AbstractPacket<PacketDestinyChoice> {
    private EnumDestinyChoice choice;

    public PacketDestinyChoice() {
    }

    public PacketDestinyChoice(EnumDestinyChoice choice) {
        this.choice = choice;
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.choice = EnumDestinyChoice.fromId(byteBuf.readInt());
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.choice.getId());
    }

    public void processOnGameThread(PacketDestinyChoice packet, MessageContext context) {
        block15: {
            WorldServer world;
            NBTPlayerData data;
            EntityPlayerMP player;
            block14: {
                player = (EntityPlayerMP)this.getPlayer(context);
                data = MCA.getPlayerData((EntityPlayer)player);
                world = (WorldServer)player.field_70170_p;
                if (packet.choice != EnumDestinyChoice.NONE && packet.choice != EnumDestinyChoice.CANCEL) break block14;
                PlayerChunkMap manager = world.func_184164_w();
                for (int x = -20; x < 20; ++x) {
                    for (int z = -20; z < 20; ++z) {
                        for (int y = -5; y < 10; ++y) {
                            manager.func_180244_a(new BlockPos((int)player.field_70165_t + x, (int)player.field_70163_u + y, (int)player.field_70161_v + z));
                        }
                    }
                }
                if (packet.choice != EnumDestinyChoice.CANCEL) break block15;
                player.field_71071_by.func_70441_a(new ItemStack((Item)ItemsMCA.CRYSTAL_BALL));
                break block15;
            }
            if (FMLCommonHandler.instance().getMinecraftServerInstance().func_71262_S() && !MCA.getConfig().serverEnableStructureSpawning) {
                return;
            }
            if (packet.choice == EnumDestinyChoice.FAMILY) {
                RadixSchematics.spawnStructureRelativeToPlayer((String)"/assets/mca/schematic/family.schematic", (EntityPlayer)player);
                boolean isSpouseMale = data.getGenderPreference() == EnumGender.MALE ? true : (data.getGenderPreference() == EnumGender.FEMALE ? false : world.field_73012_v.nextBoolean());
                EntityVillagerMCA spouse = new EntityVillagerMCA((World)world);
                spouse.attributes.setGender(isSpouseMale ? EnumGender.MALE : EnumGender.FEMALE);
                spouse.attributes.assignRandomName();
                spouse.attributes.assignRandomProfession();
                spouse.attributes.assignRandomPersonality();
                spouse.attributes.assignRandomSkin();
                spouse.func_70107_b(player.field_70165_t - 2.0, player.field_70163_u, player.field_70161_v);
                world.func_72838_d((Entity)spouse);
                PlayerMemory spouseMemory = spouse.attributes.getPlayerMemory((EntityPlayer)player);
                spouse.startMarriage(Either.withR(player));
                spouseMemory.setHearts(100);
                spouseMemory.setDialogueType(EnumDialogueType.SPOUSE);
                for (int numChildren = RadixMath.getNumberInRange((int)0, (int)2); numChildren > 0; --numChildren) {
                    boolean isPlayerMale = data.getGender() == EnumGender.MALE;
                    Object father = isPlayerMale ? player : spouse;
                    EntityVillagerMCA mother = father == player ? spouse : player;
                    EntityVillagerMCA child = new EntityVillagerMCA((World)world);
                    child.attributes.assignRandomGender();
                    child.attributes.assignRandomName();
                    child.attributes.assignRandomPersonality();
                    child.attributes.setProfession(EnumProfession.Child);
                    child.attributes.setIsChild(true);
                    if (father instanceof EntityPlayer) {
                        child.attributes.setFather(Either.withR((EntityPlayer)father));
                        child.attributes.setMother(Either.withL(mother));
                    } else {
                        child.attributes.setFather(Either.withL((EntityVillagerMCA)((Object)father)));
                        child.attributes.setMother(Either.withR((EntityPlayer)mother));
                    }
                    child.func_70107_b(player.field_70165_t + (double)RadixMath.getNumberInRange((int)1, (int)3), player.field_70163_u, player.field_70161_v);
                    world.func_72838_d((Entity)child);
                    PlayerMemory childMemory = child.attributes.getPlayerMemory((EntityPlayer)player);
                    childMemory.setHearts(100);
                    childMemory.setDialogueType(EnumDialogueType.CHILDP);
                }
            } else if (packet.choice == EnumDestinyChoice.ALONE) {
                RadixSchematics.spawnStructureRelativeToPlayer((String)"/assets/mca/schematic/bachelor.schematic", (EntityPlayer)player);
            } else if (packet.choice == EnumDestinyChoice.VILLAGE) {
                RadixSchematics.spawnStructureRelativeToPlayer((String)"/assets/mca/schematic/village1.schematic", (EntityPlayer)player);
                for (Point3D point : RadixLogic.getNearbyBlocks((Entity)player, (Block)Blocks.field_150474_ac, (int)70)) {
                    RadixBlocks.setBlock((World)player.field_70170_p, (Point3D)point, (Block)Blocks.field_150350_a);
                    MCA.naturallySpawnVillagers(new Point3D(point.iX(), point.iY(), point.iZ()), (World)world, -1);
                }
                for (Point3D point : RadixLogic.getNearbyBlocks((Entity)player, (Block)Blocks.field_150357_h, (int)70)) {
                    RadixBlocks.setBlock((World)player.field_70170_p, (Point3D)point, (Block)BlocksMCA.tombstone);
                    TileTombstone tile = (TileTombstone)player.field_70170_p.func_175625_s(point.toBlockPos());
                    if (tile == null) continue;
                    tile.field_145915_a[1] = new TextComponentString(RadixLogic.getBooleanWithProbability((int)50) ? MCA.getLocalizer().getString("name.male") : MCA.getLocalizer().getString("name.female"));
                    tile.field_145915_a[2] = new TextComponentString("RIP");
                }
            }
        }
    }
}

