/*
 * Decompiled with CFR 0.152.
 */
package mca.packets;

import io.netty.buffer.ByteBuf;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumEditAction;
import mca.enums.EnumGender;
import mca.enums.EnumPersonality;
import mca.enums.EnumProfession;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import radixcore.datastructures.CyclicIntList;
import radixcore.modules.RadixNettyIO;
import radixcore.modules.net.AbstractPacket;

public class PacketEditVillager
extends AbstractPacket<PacketEditVillager> {
    private int entityId;
    private EnumEditAction editAction;
    private Object editData;
    private CyclicIntList jobs;
    private CyclicIntList personalities;
    private CyclicIntList textures;

    public PacketEditVillager() {
    }

    public PacketEditVillager(int entityId, EnumEditAction editAction, Object editData) {
        this.entityId = entityId;
        this.editAction = editAction;
        this.editData = editData;
    }

    public PacketEditVillager(int entityId, EnumEditAction editAction) {
        this.entityId = entityId;
        this.editAction = editAction;
        this.editData = null;
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.entityId = byteBuf.readInt();
        this.editAction = EnumEditAction.byId(byteBuf.readInt());
        boolean hasEditData = byteBuf.readBoolean();
        if (hasEditData) {
            this.editData = RadixNettyIO.readObject((ByteBuf)byteBuf);
        }
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.entityId);
        byteBuf.writeInt(this.editAction.getId());
        if (this.editData != null) {
            byteBuf.writeBoolean(true);
            RadixNettyIO.writeObject((ByteBuf)byteBuf, (Object)this.editData);
        } else {
            byteBuf.writeBoolean(false);
        }
    }

    public void processOnGameThread(PacketEditVillager message, MessageContext context) {
        PacketEditVillager packet = message;
        EntityVillagerMCA villager = null;
        EntityPlayer player = null;
        for (WorldServer world : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
            player = this.getPlayer(context);
            villager = (EntityVillagerMCA)world.func_73045_a(packet.entityId);
            if (player != null && villager != null) break;
        }
        if (player != null && villager != null) {
            EnumEditAction action = packet.editAction;
            this.jobs = CyclicIntList.fromList(EnumProfession.getListOfIds());
            this.jobs.setIndex(villager.attributes.getProfessionEnum().getId());
            this.personalities = CyclicIntList.fromList(EnumPersonality.getListOfIds());
            this.personalities.setIndex(0);
            for (int i = 0; i < this.personalities.size(); ++i) {
                if (((Integer)this.personalities.get(i)).intValue() != villager.attributes.getPersonality().getId()) continue;
                this.personalities.setIndex(i);
                break;
            }
            this.textures = villager.attributes.getProfessionSkinGroup().getListOfSkinIDs(villager.attributes.getGender() == EnumGender.MALE);
            this.textures.setIndex(Integer.valueOf(villager.attributes.getHeadTexture().replaceAll("[^0-9]", "")) - 1);
            switch (action) {
                case GIRTH_DOWN: {
                    villager.attributes.setScaleWidth(villager.attributes.getScaleWidth() - 0.01f);
                    break;
                }
                case GIRTH_UP: {
                    villager.attributes.setScaleWidth(villager.attributes.getScaleWidth() + 0.01f);
                    break;
                }
                case HEIGHT_DOWN: {
                    villager.attributes.setScaleHeight(villager.attributes.getScaleHeight() - 0.01f);
                    break;
                }
                case HEIGHT_UP: {
                    villager.attributes.setScaleHeight(villager.attributes.getScaleHeight() + 0.01f);
                    break;
                }
                case PROFESSION_DOWN: {
                    villager.attributes.setProfession(EnumProfession.getProfessionById(this.jobs.previous()));
                    villager.attributes.assignRandomSkin();
                    break;
                }
                case PROFESSION_UP: {
                    villager.attributes.setProfession(EnumProfession.getProfessionById(this.jobs.next()));
                    villager.attributes.assignRandomSkin();
                    break;
                }
                case RANDOM_NAME: {
                    villager.attributes.assignRandomName();
                    break;
                }
                case SET_NAME: {
                    villager.attributes.setName((String)packet.editData);
                    break;
                }
                case SWAP_GENDER: {
                    villager.attributes.setGender(villager.attributes.getGender() == EnumGender.MALE ? EnumGender.FEMALE : EnumGender.MALE);
                    villager.attributes.assignRandomSkin();
                    break;
                }
                case TEXTURE_DOWN: {
                    villager.attributes.setHeadTexture(villager.attributes.getHeadTexture().replaceAll("\\d+", String.valueOf(this.textures.previous())));
                    villager.attributes.setClothesTexture(villager.attributes.getHeadTexture());
                    break;
                }
                case TEXTURE_UP: {
                    villager.attributes.setHeadTexture(villager.attributes.getHeadTexture().replaceAll("\\d+", String.valueOf(this.textures.next())));
                    villager.attributes.setClothesTexture(villager.attributes.getHeadTexture());
                    break;
                }
                case TOGGLE_INFECTED: {
                    villager.attributes.setIsInfected(!villager.attributes.getIsInfected());
                    break;
                }
                case TRAIT_DOWN: {
                    villager.attributes.setPersonality(EnumPersonality.getById(this.personalities.previous()));
                    break;
                }
                case TRAIT_UP: {
                    villager.attributes.setPersonality(EnumPersonality.getById(this.personalities.next()));
                    break;
                }
            }
        }
    }
}

