/*
 * Decompiled with CFR 0.152.
 */
package mca.packets;

import io.netty.buffer.ByteBuf;
import mca.client.gui.GuiPlayerMenu;
import mca.core.Constants;
import mca.core.MCA;
import mca.data.NBTPlayerData;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumMarriageState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import radixcore.modules.RadixNettyIO;
import radixcore.modules.net.AbstractPacket;

public class PacketInteractWithPlayerC
extends AbstractPacket<PacketInteractWithPlayerC> {
    private int targetEntityId;
    private boolean targetIsMarried;
    private boolean targetIsEngaged;
    private boolean isMarriedToInitiator;
    private String targetSpouseName;

    public PacketInteractWithPlayerC() {
    }

    public PacketInteractWithPlayerC(EntityPlayer initiator, EntityPlayer target) {
        this.targetEntityId = target.func_145782_y();
        NBTPlayerData initData = MCA.getPlayerData(initiator);
        NBTPlayerData targetData = MCA.getPlayerData(target);
        this.targetIsMarried = targetData.getSpouseUUID() != Constants.EMPTY_UUID;
        this.targetIsEngaged = targetData.getMarriageState() == EnumMarriageState.ENGAGED;
        this.isMarriedToInitiator = targetData.getSpouseUUID() == initData.getUUID();
        for (Object obj : initiator.field_70170_p.field_72996_f) {
            if (!(obj instanceof EntityVillagerMCA)) continue;
            EntityVillagerMCA human = (EntityVillagerMCA)((Object)obj);
            if (human.attributes.getSpouseUUID() != targetData.getUUID()) continue;
            this.targetSpouseName = human.attributes.getName();
        }
        if (this.targetSpouseName == null || this.targetSpouseName.isEmpty()) {
            this.targetSpouseName = "?";
        }
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.targetEntityId = byteBuf.readInt();
        this.targetIsMarried = byteBuf.readBoolean();
        this.targetIsEngaged = byteBuf.readBoolean();
        this.isMarriedToInitiator = byteBuf.readBoolean();
        this.targetSpouseName = (String)RadixNettyIO.readObject((ByteBuf)byteBuf);
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.targetEntityId);
        byteBuf.writeBoolean(this.targetIsMarried);
        byteBuf.writeBoolean(this.targetIsEngaged);
        byteBuf.writeBoolean(this.isMarriedToInitiator);
        RadixNettyIO.writeObject((ByteBuf)byteBuf, (Object)this.targetSpouseName);
    }

    @SideOnly(value=Side.CLIENT)
    public void processOnGameThread(PacketInteractWithPlayerC packet, MessageContext context) {
        EntityPlayer recipient = this.getPlayerClient();
        EntityPlayer target = (EntityPlayer)recipient.field_70170_p.func_73045_a(packet.targetEntityId);
        if (target != null) {
            if (MCA.getConfig().shiftClickForPlayerMarriage && !Keyboard.isKeyDown((int)42)) {
                return;
            }
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiPlayerMenu(recipient, target, packet.targetIsMarried, packet.targetIsEngaged, packet.isMarriedToInitiator, packet.targetSpouseName));
        }
    }
}

