/*
 * Decompiled with CFR 0.152.
 */
package mca.packets;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mca.actions.ActionCook;
import mca.actions.ActionFarm;
import mca.actions.ActionFish;
import mca.actions.ActionHunt;
import mca.actions.ActionMine;
import mca.actions.ActionWoodcut;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumInteraction;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import radixcore.modules.net.AbstractPacket;

public class PacketToggleAI
extends AbstractPacket<PacketToggleAI> {
    private int entityId;
    private int interactionId;
    private List<Boolean> booleans;
    private List<Integer> integers;

    public PacketToggleAI() {
    }

    public PacketToggleAI(EntityVillagerMCA human, EnumInteraction interaction, Object ... arguments) {
        this.entityId = human.func_145782_y();
        this.interactionId = interaction.getId();
        this.booleans = new ArrayList<Boolean>();
        this.integers = new ArrayList<Integer>();
        for (Object obj : arguments) {
            if (obj.getClass() == Integer.class) {
                this.integers.add((Integer)obj);
                continue;
            }
            if (obj.getClass() != Boolean.class) continue;
            this.booleans.add((Boolean)obj);
        }
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.booleans = new ArrayList<Boolean>();
        this.integers = new ArrayList<Integer>();
        this.entityId = byteBuf.readInt();
        this.interactionId = byteBuf.readInt();
        int numIntegers = byteBuf.readInt();
        for (int numBooleans = byteBuf.readInt(); numBooleans > 0; --numBooleans) {
            this.booleans.add(byteBuf.readBoolean());
        }
        while (numIntegers > 0) {
            this.integers.add(byteBuf.readInt());
            --numIntegers;
        }
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.entityId);
        byteBuf.writeInt(this.interactionId);
        byteBuf.writeInt(this.booleans.size());
        byteBuf.writeInt(this.integers.size());
        for (Boolean b : this.booleans) {
            byteBuf.writeBoolean(b.booleanValue());
        }
        for (Integer i : this.integers) {
            byteBuf.writeInt(i.intValue());
        }
    }

    public void processOnGameThread(PacketToggleAI packet, MessageContext context) {
        EntityPlayer player = this.getPlayer(context);
        EntityVillagerMCA human = (EntityVillagerMCA)player.field_70170_p.func_73045_a(packet.entityId);
        switch (EnumInteraction.fromId(packet.interactionId)) {
            case FARMING: {
                human.getBehavior(ActionFarm.class).startFarming(player, packet.integers.get(0), packet.integers.get(1), packet.booleans.get(0));
                break;
            }
            case MINING: {
                if (packet.booleans.get(0).booleanValue()) {
                    human.getBehavior(ActionMine.class).startGathering(player);
                    break;
                }
                human.getBehavior(ActionMine.class).startSearching(player, packet.integers.get(0));
                break;
            }
            case WOODCUTTING: {
                boolean doReplant = packet.booleans.get(0);
                int mappingId = packet.integers.get(0);
                human.getBehavior(ActionWoodcut.class).startWoodcutting(player, mappingId, doReplant);
                break;
            }
            case HUNTING: {
                boolean flag = packet.booleans.get(0);
                if (flag) {
                    human.getBehavior(ActionHunt.class).startKilling(player);
                    break;
                }
                human.getBehavior(ActionHunt.class).startTaming(player);
                break;
            }
            case COOKING: {
                human.getBehavior(ActionCook.class).startCooking(player);
                break;
            }
            case FISHING: {
                human.getBehavior(ActionFish.class).startFishing(player);
            }
        }
    }
}

