/*
 * Decompiled with CFR 0.152.
 */
package mca.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import mca.core.MCA;
import mca.enums.EnumProfessionSkinGroup;
import radixcore.core.RadixCore;

public final class SkinLoader {
    public static void loadSkins() {
        try {
            File modFile = SkinLoader.findModDataFile();
            if (modFile.isFile()) {
                SkinLoader.loadSkinsFromFile(modFile);
            } else {
                MCA.getLog().fatal((Object)new FileNotFoundException("Unable to locate MCA assets!"));
            }
        }
        catch (IOException e) {
            MCA.getLog().fatal((Object)e);
        }
        catch (NullPointerException e) {
            MCA.getLog().fatal((Object)e);
        }
    }

    private static File findModDataFile() throws ZipException, IOException {
        File modData = SkinLoader.findModAsArchive();
        if (modData == null) {
            MCA.getLog().fatal((Object)new FileNotFoundException("Unable to locate MCA assets! This may be due to an issue with your launcher (if made by a third party), or your MCA installation. Try reinstalling the mod, or try a different launcher."));
        }
        return modData;
    }

    private static File findModAsArchive() throws ZipException, IOException {
        File modsFolder = new File(RadixCore.getRunningDirectory() + "/mods");
        for (File fileInMods : modsFolder.listFiles()) {
            File modData;
            if (fileInMods.isFile() && fileInMods.getName().contains(".zip") || fileInMods.getName().contains(".jar")) {
                if (!SkinLoader.fileContainsModData(fileInMods)) continue;
                return fileInMods;
            }
            if (!fileInMods.isDirectory() || (modData = SkinLoader.getModFileFromNestedFolder(fileInMods)) == null) continue;
            return modData;
        }
        return null;
    }

    private static void loadSkinsFromFile(File modDataFile) throws ZipException, IOException {
        ZipFile modArchive = new ZipFile(modDataFile);
        Enumeration<? extends ZipEntry> enumerator = modArchive.entries();
        int counter = 0;
        while (enumerator.hasMoreElements()) {
            ZipEntry file = enumerator.nextElement();
            String archiveFilePath = "/" + file.getName();
            if (!archiveFilePath.contains("textures/skins") || archiveFilePath.contains("/sleeping/")) continue;
            for (EnumProfessionSkinGroup skinGroup : EnumProfessionSkinGroup.values()) {
                if (!file.getName().contains(skinGroup.toString().toLowerCase())) continue;
                skinGroup.addSkin(archiveFilePath);
                ++counter;
            }
        }
        modArchive.close();
        MCA.getLog().info("MCA has successfully loaded " + counter + " skins.");
    }

    private static File getModFileFromNestedFolder(File nestedFolder) throws IOException {
        File[] nestedFiles;
        for (File file : nestedFiles = nestedFolder.listFiles()) {
            if (file.isDirectory()) {
                SkinLoader.getModFileFromNestedFolder(file);
                continue;
            }
            if (!SkinLoader.fileContainsModData(file)) continue;
            return file;
        }
        return null;
    }

    private static boolean fileContainsModData(File fileToTest) throws IOException {
        if (fileToTest.getName().contains(".zip") || fileToTest.getName().contains(".jar")) {
            try {
                ZipFile archive = new ZipFile(fileToTest);
                Enumeration<? extends ZipEntry> enumerator = archive.entries();
                while (enumerator.hasMoreElements()) {
                    ZipEntry entry = enumerator.nextElement();
                    if (!entry.getName().contains("mca/core/MCA.class") && !entry.getName().contains("sleeping/ee1.png")) continue;
                    archive.close();
                    return true;
                }
                archive.close();
            }
            catch (ZipException e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

