/*
 * Decompiled with CFR 0.152.
 */
package radixcore.command;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.block.properties.IProperty;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryEnderChest;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import radixcore.core.RadixCore;
import radixcore.math.Point3D;
import radixcore.modules.RadixBlocks;
import radixcore.modules.RadixLogic;
import radixcore.modules.RadixMath;
import radixcore.modules.RadixReflect;
import radixcore.packets.PacketTest;

public class CommandRadixCore
extends CommandBase {
    public String func_71517_b() {
        return "radixcore";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/radixcore <subcommand> <arguments>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String subcommand = args[0];
        EntityPlayer player = null;
        if (!(sender instanceof EntityPlayer)) {
            throw new CommandException("RadixCore commands cannot be used through rcon or the server console.", new Object[0]);
        }
        player = (EntityPlayer)sender;
        if (subcommand == null || subcommand.isEmpty()) {
            throw new CommandException("An invalid argument was provided.", new Object[0]);
        }
        if (subcommand.equals("testing")) {
            if (args[1].equals("on")) {
                this.addMessage("Testing mode enabled.", player);
                RadixCore.isTesting = true;
            } else if (args[1].equals("off")) {
                this.addMessage("Testing mode disabled.", player);
                RadixCore.isTesting = false;
            } else if (args[1].equals("runIngameTests")) {
                try {
                    this.addMessage("Running in-game tests...", player);
                    Point3D testPoint = new Point3D(1.0, 1.1, 1.0);
                    this.assertTrue(testPoint.dX() == 1.0);
                    this.assertTrue(testPoint.dY() == 1.1);
                    this.assertTrue(testPoint.dZ() == 1.0);
                    this.assertTrue(testPoint.fX() == 1.0f);
                    this.assertTrue(testPoint.fY() == 1.1f);
                    this.assertTrue(testPoint.fZ() == 1.0f);
                    this.assertTrue(testPoint.iX() == 1);
                    this.assertTrue(testPoint.iY() == 1);
                    this.assertTrue(testPoint.iZ() == 1);
                    testPoint.set(3, 4, 5);
                    this.assertTrue(testPoint.iX() == 3);
                    this.assertTrue(testPoint.iY() == 4);
                    this.assertTrue(testPoint.iZ() == 5);
                    this.assertTrue(testPoint.fX() == 3.0f);
                    this.assertTrue(testPoint.fY() == 4.0f);
                    this.assertTrue(testPoint.fZ() == 5.0f);
                    this.assertTrue(testPoint.dX() == 3.0);
                    this.assertTrue(testPoint.dY() == 4.0);
                    this.assertTrue(testPoint.dZ() == 5.0);
                    BlockPos pos = testPoint.toBlockPos();
                    this.assertTrue(pos.func_177958_n() == 3);
                    this.assertTrue(pos.func_177956_o() == 4);
                    this.assertTrue(pos.func_177952_p() == 5);
                    Point3D convertedPos = Point3D.fromBlockPos(pos);
                    this.assertTrue(convertedPos.iX() == 3);
                    this.assertTrue(convertedPos.iY() == 4);
                    this.assertTrue(convertedPos.iZ() == 5);
                    NBTTagCompound nBTTagCompound = new NBTTagCompound();
                    testPoint.writeToNBT("TestPoint", nBTTagCompound);
                    Point3D readPoint = Point3D.readFromNBT("TestPoint", nBTTagCompound);
                    this.assertTrue(readPoint.equals(testPoint));
                    testPoint = Point3D.fromEntityPosition((Entity)player);
                    ArrayList testList = new ArrayList();
                    testList.add(testPoint.setNew(testPoint.iX() + 10, testPoint.iY(), testPoint.iZ()));
                    testList.add(testPoint.setNew(testPoint.iX(), testPoint.iY(), testPoint.iZ() + 5));
                    testList.add(testPoint.setNew(testPoint.iX(), testPoint.iY() + 3, testPoint.iZ()));
                    Point3D nearestPoint = Point3D.getNearestPointInList(testPoint, testList);
                    this.assertTrue(nearestPoint.iY() == testPoint.iY() + 3);
                    Point3D furthestPoint = Point3D.getFurthestPointInList(testPoint, testList);
                    this.assertTrue(furthestPoint.iX() == testPoint.iX() + 10);
                    this.passTest("3D Points", player);
                }
                catch (AssertionError e) {
                    ((Throwable)((Object)e)).printStackTrace();
                    this.failTest("3D Points", player);
                }
                try {
                    Point3D playerPos = Point3D.fromEntityPosition((Entity)player);
                    EntityPlayer testEntity = null;
                    testEntity = RadixLogic.getEntityOfTypeAtXYZ(EntityPlayer.class, player.field_70170_p, playerPos);
                    this.assertTrue(testEntity == player);
                    testEntity = (EntityPlayer)RadixLogic.getClosestEntityInclusive((Entity)player, 10, null);
                    this.assertTrue(testEntity == player);
                    testEntity = RadixLogic.getClosestEntityExclusive((Entity)player, 10, EntityPlayer.class);
                    this.assertTrue(testEntity == null);
                    testEntity = (EntityPlayer)RadixLogic.getClosestEntity(playerPos, player.field_70170_p, 10, null, null);
                    this.assertTrue(testEntity == player);
                    for (int i = 0; i < 1000; ++i) {
                        this.assertTrue(RadixLogic.getBooleanWithProbability(100));
                        this.assertFalse(RadixLogic.getBooleanWithProbability(0));
                    }
                    for (Point3D point3D : RadixLogic.getNearbyBlocks((Entity)player, Blocks.field_150343_Z, 10)) {
                        player.field_70170_p.func_175698_g(point3D.toBlockPos());
                    }
                    Point3D nearest = RadixLogic.getNearestBlock((Entity)player, 10, Blocks.field_150343_Z);
                    this.assertTrue(nearest.isNone());
                    player.field_70170_p.func_175656_a(player.func_180425_c().func_177982_a(5, 0, 0), Blocks.field_150343_Z.func_176223_P());
                    nearest = RadixLogic.getNearestBlock((Entity)player, 10, Blocks.field_150343_Z);
                    this.assertFalse(nearest.isNone());
                    for (Point3D point : RadixLogic.getNearbyBlocks((Entity)player, Blocks.field_150343_Z, 10)) {
                        player.field_70170_p.func_175698_g(point.toBlockPos());
                    }
                    BlockPos blockPos = player.func_180425_c();
                    player.field_70170_p.func_175656_a(blockPos.func_177982_a(4, 0, 0), Blocks.field_150343_Z.func_176223_P());
                    player.field_70170_p.func_175656_a(blockPos.func_177982_a(8, 0, 0), Blocks.field_150343_Z.func_176223_P());
                    player.field_70170_p.func_175656_a(blockPos.func_177982_a(9, 0, 0), Blocks.field_150343_Z.func_176223_P());
                    nearest = RadixLogic.getNearestBlock((Entity)player, 10, 3, Blocks.field_150343_Z);
                    Point3D farthest = RadixLogic.getFarthestBlock((Entity)player, 10, 3, Blocks.field_150343_Z);
                    this.assertTrue(nearest.dX() == (double)(blockPos.func_177958_n() + 4));
                    this.assertTrue(farthest.dX() == (double)(blockPos.func_177958_n() + 9));
                    for (Point3D point : RadixLogic.getNearbyBlocks((Entity)player, Blocks.field_150343_Z, 10)) {
                        player.field_70170_p.func_175698_g(point.toBlockPos());
                    }
                    for (int cubeSize = 1; cubeSize < 10; ++cubeSize) {
                        List<Point3D> blocks = RadixLogic.getNearbyBlocks((Entity)player, null, cubeSize, cubeSize);
                        this.assertTrue((double)blocks.size() == Math.pow(cubeSize + cubeSize + 1, 3.0));
                    }
                    EntityHorse newHorse = new EntityHorse(player.field_70170_p);
                    newHorse.func_70107_b(player.field_70165_t + 5.0, player.field_70163_u, player.field_70161_v);
                    player.field_70170_p.func_72838_d((Entity)newHorse);
                    List<EntityHorse> horses = RadixLogic.getEntitiesWithinDistance(EntityHorse.class, (Entity)player, 10);
                    this.assertTrue(horses.size() >= 1);
                    newHorse.func_70106_y();
                    this.passTest("Logic", player);
                }
                catch (AssertionError e) {
                    ((Throwable)((Object)e)).printStackTrace();
                    this.failTest("Logic", player);
                }
                try {
                    for (int i = 0; i < 1000; ++i) {
                        this.assertTrue(RadixMath.isWithinRange(i, 0, 1000));
                        this.assertTrue(RadixMath.isWithinRange(RadixMath.getNumberInRange(i, i * 2), i, i * 2));
                        this.assertTrue(RadixMath.isWithinRange(RadixMath.getNumberInRange(i, i * 2), i, i * 2));
                    }
                    this.assertTrue(RadixMath.getDistanceToXYZ(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70165_t + 2.0, player.field_70163_u + 2.0, player.field_70161_v + 3.5) == 4.5);
                    this.assertTrue(RadixMath.getHighestNumber(2.0f, 3.05f, 3.5f, 3.6f, 3.68f, 3.685f) == 3.685f);
                    this.assertTrue(RadixMath.getLowestNumber(2.005f, 2.0f, 1.98f, 1.987f, 1.9885f) == 1.98f);
                    this.passTest("Math", player);
                }
                catch (AssertionError e) {
                    this.failTest("Math", player);
                }
                try {
                    this.passTest("Reflection", player);
                    InventoryEnderChest enderChest = RadixReflect.getInstanceObjectOfTypeFromClass(InventoryEnderChest.class, EntityPlayer.class, player);
                    this.assertTrue(enderChest != null);
                    DataParameter absorptionParam = RadixReflect.getStaticObjectOfTypeFromClass(DataParameter.class, EntityPlayer.class);
                    this.assertTrue(absorptionParam != null);
                }
                catch (AssertionError e) {
                    this.failTest("Reflection", player);
                }
                try {
                    this.passTest("Blocks", player);
                    BlockPos testPos = new BlockPos(player.field_70165_t + 5.0, player.field_70163_u, player.field_70161_v);
                    RadixBlocks.setBlock(player.field_70170_p, testPos, Blocks.field_150357_h);
                    this.assertTrue(RadixBlocks.getBlock(player.field_70170_p, testPos) == Blocks.field_150357_h);
                    RadixBlocks.setBlock(player.field_70170_p, testPos, Blocks.field_150350_a);
                    this.assertTrue(RadixBlocks.getBlock(player.field_70170_p, testPos) == Blocks.field_150350_a);
                    RadixBlocks.setBlock(player.field_70170_p, testPos, Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.RED_SAND));
                    this.assertTrue(RadixBlocks.getBlock(player.field_70170_p, testPos) == Blocks.field_150354_m);
                    this.assertTrue(RadixBlocks.blockHasState(player.field_70170_p, testPos, BlockSand.field_176504_a, BlockSand.EnumType.RED_SAND));
                    this.assertFalse(RadixBlocks.blockHasState(player.field_70170_p, testPos, BlockSand.field_176504_a, BlockSand.EnumType.SAND));
                    RadixBlocks.setBlock(player.field_70170_p, testPos, (Block)Blocks.field_150354_m, BlockSand.field_176504_a, BlockSand.EnumType.RED_SAND);
                    this.assertTrue(RadixBlocks.getBlock(player.field_70170_p, testPos) == Blocks.field_150354_m);
                    this.assertFalse(RadixBlocks.blockHasState(player.field_70170_p, testPos, BlockSand.field_176504_a, BlockSand.EnumType.SAND));
                    this.assertTrue(RadixBlocks.blockHasState(player.field_70170_p, testPos, BlockSand.field_176504_a, BlockSand.EnumType.RED_SAND));
                    RadixBlocks.setBlock(player.field_70170_p, testPos, Blocks.field_150350_a);
                }
                catch (AssertionError e) {
                    this.failTest("Blocks", player);
                }
                RadixCore.getPacketHandler().sendPacketToPlayer(new PacketTest(PacketTest.Type.REQ), player);
            }
        }
    }

    private void addMessage(String message, EntityPlayer player) {
        player.func_145747_a((ITextComponent)new TextComponentString("\u00a76[\u00a74RadixCore\u00a76] \u00a7r" + message));
    }

    private void passTest(String testName, EntityPlayer player) {
        this.addMessage("- " + testName + ": " + "\u00a7A" + "[PASS]", player);
    }

    private void failTest(String testName, EntityPlayer player) {
        this.addMessage("- " + testName + ": " + "\u00a7C" + "[FAIL]", player);
    }

    private void assertTrue(boolean expression) throws AssertionError {
        if (!expression) {
            throw new AssertionError();
        }
    }

    private void assertFalse(boolean expression) throws AssertionError {
        if (expression) {
            throw new AssertionError();
        }
    }
}

