/*
 * Decompiled with CFR 0.152.
 */
package radixcore.datastructures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class CyclicIntList
extends ArrayList<Integer> {
    private int index;

    public static CyclicIntList fromIntegers(Integer ... integers) {
        return CyclicIntList.fromList(Arrays.asList(integers));
    }

    public static CyclicIntList fromList(List<Integer> list) {
        CyclicIntList returnList = new CyclicIntList();
        for (Integer i : list) {
            if (returnList.contains(i) || i == null) continue;
            returnList.add(i);
        }
        Collections.sort(returnList);
        return returnList;
    }

    public int next() {
        ++this.index;
        if (this.index > this.size() - 1) {
            this.index = 0;
        }
        return (Integer)this.get(this.index);
    }

    public int previous() {
        --this.index;
        if (this.index < 0) {
            this.index = this.size() - 1;
        } else if (this.index > this.size()) {
            this.index = 0;
        }
        return (Integer)this.get(this.index);
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int get() {
        return (Integer)this.get(this.index);
    }
}

