/*
 * Decompiled with CFR 0.152.
 */
package radixcore.modules;

import java.io.File;
import java.io.FileFilter;
import java.util.Date;
import radixcore.core.RadixCore;

public abstract class AbstractCrashWatcher {
    private final long startupTimestamp = new Date().getTime();

    public void checkForCrashReports() {
        File crashReportsFolder = new File(RadixCore.getRunningDirectory() + "/crash-reports/");
        File[] crashReportFiles = crashReportsFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile();
            }
        });
        if (crashReportFiles != null) {
            long lastModifiedTime = Long.MIN_VALUE;
            File lastModifiedFile = null;
            for (File file : crashReportFiles) {
                if (file.lastModified() <= lastModifiedTime) continue;
                lastModifiedFile = file;
                lastModifiedTime = file.lastModified();
            }
            if (lastModifiedTime > this.startupTimestamp) {
                this.onCrash(lastModifiedFile);
            }
        }
    }

    protected abstract void onCrash(File var1);
}

