/*
 * Decompiled with CFR 0.152.
 */
package radixcore.modules;

import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;

public final class RadixNettyIO {
    public static void writeObject(ByteBuf buffer, Object object) {
        RadixNettyIO.writeByteArray(buffer, RadixNettyIO.convertToByteArray(object));
    }

    public static Object readObject(ByteBuf buffer) {
        return RadixNettyIO.convertBytesToObject(RadixNettyIO.readByteArray(buffer));
    }

    public static byte[] convertToByteArray(Object obj) {
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutput = new ObjectOutputStream((OutputStream)byteOutput);
            objectOutput.writeObject(obj);
            objectOutput.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return byteOutput.toByteArray();
    }

    public static Object convertBytesToObject(byte[] byteArray) {
        ByteArrayInputStream byteInput = new ByteArrayInputStream(byteArray);
        Object returnObject = null;
        try {
            ObjectInputStream objectInput = new ObjectInputStream(byteInput);
            returnObject = objectInput.readObject();
            objectInput.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return returnObject;
    }

    public static byte[] compress(byte[] input) {
        return input;
    }

    public static byte[] decompress(byte[] input) {
        return input;
    }

    public static void writeByteArray(ByteBuf buffer, byte[] byteArray) {
        byte[] compressedArray = RadixNettyIO.compress(byteArray);
        buffer.writeInt(compressedArray.length);
        buffer.writeBytes(compressedArray);
    }

    public static byte[] readByteArray(ByteBuf buffer) {
        int arraySize = buffer.readInt();
        byte[] data = new byte[arraySize];
        buffer.getBytes(buffer.readerIndex(), data, 0, arraySize);
        buffer.readerIndex(buffer.readerIndex() + arraySize);
        return RadixNettyIO.decompress(data);
    }
}

