/*
 * Decompiled with CFR 0.152.
 */
package radixcore.modules.gen;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.GameRegistry;

public final class SimpleOreGenerator
implements IWorldGenerator {
    private final Block spawnBlock;
    private final int maximumVeinSize;
    private final int lowestSpawnLevel;
    private final int highestSpawnLevel;
    private final boolean canSpawnInNether;
    private final boolean canSpawnInOverworld;

    public SimpleOreGenerator(Block spawnBlock, int maxVeinSize, int lowestSpawnLevel, int highestSpawnLevel, boolean canSpawnInOverworld, boolean canSpawnInNether) {
        this.spawnBlock = spawnBlock;
        this.maximumVeinSize = maxVeinSize;
        this.lowestSpawnLevel = lowestSpawnLevel;
        this.highestSpawnLevel = highestSpawnLevel;
        this.canSpawnInOverworld = canSpawnInOverworld;
        this.canSpawnInNether = canSpawnInNether;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case -1: {
                this.generateNether(world, random, chunkX * 16, chunkZ * 16);
            }
            case 0: {
                this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    private void generateSurface(World world, Random random, int x, int z) {
        if (this.canSpawnInOverworld) {
            this.addOreSpawn(this.spawnBlock, world, random, x, z, 16, 16, this.maximumVeinSize, 5);
        }
    }

    private void generateNether(World world, Random random, int x, int z) {
        if (this.canSpawnInNether) {
            int xPos = x + random.nextInt(16);
            int yPos = 10 + random.nextInt(128);
            int zPos = z + random.nextInt(16);
            new WorldGenMinable(this.spawnBlock.func_176223_P(), 15, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL)).func_180709_b(world, random, new BlockPos(xPos, yPos, zPos));
        }
    }

    public void addOreSpawn(Block block, World world, Random random, int blockPosX, int blockPosZ, int maxX, int maxZ, int maxVeinSize, int chancesToSpawn) {
        int range = this.highestSpawnLevel - this.lowestSpawnLevel;
        for (int x = 0; x < chancesToSpawn; ++x) {
            int posX = blockPosX + random.nextInt(maxX);
            int posY = this.lowestSpawnLevel + random.nextInt(range);
            int posZ = blockPosZ + random.nextInt(maxZ);
            new WorldGenMinable(block.func_176223_P(), maxVeinSize).func_180709_b(world, random, new BlockPos(posX, posY, posZ));
        }
    }

    public static void register(SimpleOreGenerator generator, int weight) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)generator, (int)weight);
    }
}

